"use strict";
exports.id = 1493;
exports.ids = [1493];
exports.modules = {

/***/ 31956:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_ui_input__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(145);
/* harmony import */ var _components_ui_button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(39258);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(45641);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _contexts_checkout__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11458);
/* harmony import */ var jotai__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(82451);
/* harmony import */ var _data_coupon__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(95290);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_hook_form__WEBPACK_IMPORTED_MODULE_4__, _contexts_checkout__WEBPACK_IMPORTED_MODULE_6__, jotai__WEBPACK_IMPORTED_MODULE_7__, _data_coupon__WEBPACK_IMPORTED_MODULE_8__]);
([react_hook_form__WEBPACK_IMPORTED_MODULE_4__, _contexts_checkout__WEBPACK_IMPORTED_MODULE_6__, jotai__WEBPACK_IMPORTED_MODULE_7__, _data_coupon__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const Coupon = ({ subtotal  })=>{
    var ref;
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)('common');
    const { 0: hasCoupon , 1: setHasCoupon  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const [coupon, applyCoupon] = (0,jotai__WEBPACK_IMPORTED_MODULE_7__.useAtom)(_contexts_checkout__WEBPACK_IMPORTED_MODULE_6__/* .couponAtom */ .GO);
    const { register , handleSubmit , setError , formState: { errors  } ,  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_4__.useForm)({
        defaultValues: {
            code: ''
        }
    });
    const { mutate: verifyCoupon , isLoading: loading  } = (0,_data_coupon__WEBPACK_IMPORTED_MODULE_8__/* .useVerifyCouponMutation */ .Mu)();
    if (!hasCoupon && !coupon) {
        return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
            role: "button",
            className: "text-xs font-bold transition duration-200 text-body hover:text-accent",
            onClick: ()=>setHasCoupon(true)
            ,
            children: t('text-have-coupon')
        }));
    }
    function onSubmit({ code  }) {
        verifyCoupon({
            code: code,
            sub_total: subtotal
        }, {
            onSuccess: (data)=>{
                if (data === null || data === void 0 ? void 0 : data.is_valid) {
                    //@ts-ignore
                    applyCoupon(data === null || data === void 0 ? void 0 : data.coupon);
                    setHasCoupon(false);
                    return;
                }
                if (!(data === null || data === void 0 ? void 0 : data.is_valid)) {
                    setError('code', {
                        type: 'manual',
                        message: t(`common:${data === null || data === void 0 ? void 0 : data.message}`)
                    });
                }
            }
        });
    }
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("form", {
        onSubmit: handleSubmit(onSubmit),
        noValidate: true,
        className: "flex flex-col w-full pt-1 sm:flex-row",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                ...register('code', {
                    required: 'text-coupon-required'
                }),
                placeholder: t('text-enter-coupon'),
                variant: "outline",
                className: "flex-1 mb-4 sm:me-4 sm:mb-0",
                dimension: "small",
                showLabel: false,
                error: t(errors === null || errors === void 0 ? void 0 : (ref = errors.code) === null || ref === void 0 ? void 0 : ref.message)
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                loading: loading,
                disabled: loading,
                size: "small",
                className: "w-full sm:w-40 lg:w-auto mt-0.5",
                children: t('text-apply')
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Coupon);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1493:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_checkout_coupon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31956);
/* harmony import */ var _utils_use_price__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(86797);
/* harmony import */ var _components_icons_empty_cart__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(70465);
/* harmony import */ var _components_icons_close_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29581);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(40601);
/* harmony import */ var _contexts_quick_cart_cart_utils__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(85170);
/* harmony import */ var jotai__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(82451);
/* harmony import */ var _contexts_checkout__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(11458);
/* harmony import */ var _components_checkout_item_item_card__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(10431);
/* harmony import */ var _components_checkout_item_item_info_row__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(98856);
/* harmony import */ var _components_checkout_payment_payment_grid__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(95553);
/* harmony import */ var _components_checkout_place_order_action__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(29074);
/* harmony import */ var _components_checkout_wallet_wallet__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(86126);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(53139);
/* harmony import */ var _data_settings__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(50642);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_16__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_checkout_coupon__WEBPACK_IMPORTED_MODULE_1__, _utils_use_price__WEBPACK_IMPORTED_MODULE_2__, _contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_6__, jotai__WEBPACK_IMPORTED_MODULE_7__, _contexts_checkout__WEBPACK_IMPORTED_MODULE_8__, _components_checkout_item_item_card__WEBPACK_IMPORTED_MODULE_9__, _components_checkout_payment_payment_grid__WEBPACK_IMPORTED_MODULE_11__, _components_checkout_place_order_action__WEBPACK_IMPORTED_MODULE_12__, _components_checkout_wallet_wallet__WEBPACK_IMPORTED_MODULE_13__, _data_settings__WEBPACK_IMPORTED_MODULE_15__]);
([_components_checkout_coupon__WEBPACK_IMPORTED_MODULE_1__, _utils_use_price__WEBPACK_IMPORTED_MODULE_2__, _contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_6__, jotai__WEBPACK_IMPORTED_MODULE_7__, _contexts_checkout__WEBPACK_IMPORTED_MODULE_8__, _components_checkout_item_item_card__WEBPACK_IMPORTED_MODULE_9__, _components_checkout_payment_payment_grid__WEBPACK_IMPORTED_MODULE_11__, _components_checkout_place_order_action__WEBPACK_IMPORTED_MODULE_12__, _components_checkout_wallet_wallet__WEBPACK_IMPORTED_MODULE_13__, _data_settings__WEBPACK_IMPORTED_MODULE_15__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);


















const VerifiedItemList = ({ className  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)('common');
    const { locale  } = (0,next_router__WEBPACK_IMPORTED_MODULE_16__.useRouter)();
    const { items , isEmpty: isEmptyCart  } = (0,_contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_6__/* .useCart */ .jD)();
    const [verifiedResponse] = (0,jotai__WEBPACK_IMPORTED_MODULE_7__.useAtom)(_contexts_checkout__WEBPACK_IMPORTED_MODULE_8__/* .verifiedResponseAtom */ .Jb);
    const [coupon, setCoupon] = (0,jotai__WEBPACK_IMPORTED_MODULE_7__.useAtom)(_contexts_checkout__WEBPACK_IMPORTED_MODULE_8__/* .couponAtom */ .GO);
    const [discount] = (0,jotai__WEBPACK_IMPORTED_MODULE_7__.useAtom)(_contexts_checkout__WEBPACK_IMPORTED_MODULE_8__/* .discountAtom */ .yw);
    const [payableAmount] = (0,jotai__WEBPACK_IMPORTED_MODULE_7__.useAtom)(_contexts_checkout__WEBPACK_IMPORTED_MODULE_8__/* .payableAmountAtom */ .y2);
    const [use_wallet] = (0,jotai__WEBPACK_IMPORTED_MODULE_7__.useAtom)(_contexts_checkout__WEBPACK_IMPORTED_MODULE_8__/* .walletAtom */ .xc);
    const { // @ts-ignore
    settings: { options  }  } = (0,_data_settings__WEBPACK_IMPORTED_MODULE_15__/* .useSettingsQuery */ .n)({
        language: locale
    });
    const available_items = items === null || items === void 0 ? void 0 : items.filter((item)=>{
        var ref;
        return !(verifiedResponse === null || verifiedResponse === void 0 ? void 0 : (ref = verifiedResponse.unavailable_products) === null || ref === void 0 ? void 0 : ref.includes(item.id));
    });
    var _total_tax;
    const { price: tax  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP)(verifiedResponse && {
        amount: (_total_tax = verifiedResponse.total_tax) !== null && _total_tax !== void 0 ? _total_tax : 0
    });
    var _shipping_charge;
    const { price: shipping  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP)(verifiedResponse && {
        amount: (_shipping_charge = verifiedResponse.shipping_charge) !== null && _shipping_charge !== void 0 ? _shipping_charge : 0
    });
    const base_amount = (0,_contexts_quick_cart_cart_utils__WEBPACK_IMPORTED_MODULE_17__/* .calculateTotal */ .tf)(available_items);
    const { price: sub_total  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP)(verifiedResponse && {
        amount: base_amount
    });
    // Calculate Discount base on coupon type
    let calculateDiscount = 0;
    switch(coupon === null || coupon === void 0 ? void 0 : coupon.type){
        case _types__WEBPACK_IMPORTED_MODULE_14__/* .CouponType.PERCENTAGE */ .$i.PERCENTAGE:
            calculateDiscount = base_amount * Number(discount) / 100;
            break;
        case _types__WEBPACK_IMPORTED_MODULE_14__/* .CouponType.FREE_SHIPPING */ .$i.FREE_SHIPPING:
            calculateDiscount = verifiedResponse ? verifiedResponse.shipping_charge : 0;
            break;
        default:
            calculateDiscount = Number(discount);
    }
    const { price: discountPrice  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP)(//@ts-ignore
    discount && {
        amount: Number(calculateDiscount)
    });
    let freeShippings = (options === null || options === void 0 ? void 0 : options.freeShipping) && Number(options === null || options === void 0 ? void 0 : options.freeShippingAmount) <= base_amount;
    const totalPrice = verifiedResponse ? (0,_contexts_quick_cart_cart_utils__WEBPACK_IMPORTED_MODULE_17__/* .calculatePaidTotal */ .eA)({
        totalAmount: base_amount,
        tax: verifiedResponse === null || verifiedResponse === void 0 ? void 0 : verifiedResponse.total_tax,
        shipping_charge: verifiedResponse === null || verifiedResponse === void 0 ? void 0 : verifiedResponse.shipping_charge
    }, Number(calculateDiscount)) : 0;
    const { price: total  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP)(verifiedResponse && {
        amount: totalPrice <= 0 ? 0 : totalPrice
    });
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: className,
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "flex flex-col items-center mb-4 space-s-4",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "text-base font-bold text-heading",
                    children: t('text-your-order')
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "flex flex-col pb-2 border-b border-border-200",
                children: !isEmptyCart ? items === null || items === void 0 ? void 0 : items.map((item)=>{
                    var ref;
                    const notAvailable = verifiedResponse === null || verifiedResponse === void 0 ? void 0 : (ref = verifiedResponse.unavailable_products) === null || ref === void 0 ? void 0 : ref.find((d)=>d === item.id
                    );
                    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_checkout_item_item_card__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
                        item: item,
                        notAvailable: !!notAvailable
                    }, item.id));
                }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_empty_cart__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {})
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "mt-4 space-y-2",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_checkout_item_item_info_row__WEBPACK_IMPORTED_MODULE_10__/* .ItemInfoRow */ .m, {
                        title: t('text-sub-total'),
                        value: sub_total
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_checkout_item_item_info_row__WEBPACK_IMPORTED_MODULE_10__/* .ItemInfoRow */ .m, {
                        title: t('text-tax'),
                        value: tax
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                        className: "flex justify-between",
                        children: [
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("p", {
                                className: "text-sm text-body",
                                children: [
                                    t('text-shipping'),
                                    " ",
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                        className: "text-xs font-semibold text-accent",
                                        children: freeShippings && `(${t('text-free-shipping')})`
                                    })
                                ]
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                className: "text-sm text-body",
                                children: [
                                    " ",
                                    shipping
                                ]
                            })
                        ]
                    }),
                    discount && coupon ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                        className: "flex justify-between",
                        children: [
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("p", {
                                className: "flex items-center gap-1 text-sm text-body me-2",
                                children: [
                                    t('text-discount'),
                                    " ",
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                        className: "-mt-px text-xs font-semibold text-accent",
                                        children: (coupon === null || coupon === void 0 ? void 0 : coupon.type) === _types__WEBPACK_IMPORTED_MODULE_14__/* .CouponType.FREE_SHIPPING */ .$i.FREE_SHIPPING && `(${t('text-free-shipping')})`
                                    })
                                ]
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                className: "flex items-center text-xs font-semibold text-red-500 me-auto",
                                children: [
                                    "(",
                                    coupon === null || coupon === void 0 ? void 0 : coupon.code,
                                    ")",
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                                        onClick: ()=>setCoupon(null)
                                        ,
                                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_close_icon__WEBPACK_IMPORTED_MODULE_4__/* .CloseIcon */ .T, {
                                            className: "w-3 h-3 ms-2"
                                        })
                                    })
                                ]
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                className: "flex items-center gap-1 text-sm text-body",
                                children: [
                                    calculateDiscount > 0 ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                        className: "-mt-0.5",
                                        children: "-"
                                    }) : null,
                                    " ",
                                    discountPrice
                                ]
                            })
                        ]
                    }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "mt-5 !mb-4 flex justify-between",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_checkout_coupon__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                            subtotal: base_amount
                        })
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                        className: "flex justify-between pt-3 border-t-4 border-double border-border-200",
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                                className: "text-base font-semibold text-heading",
                                children: t('text-total')
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                className: "text-base font-semibold text-heading",
                                children: total
                            })
                        ]
                    })
                ]
            }),
            verifiedResponse && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_checkout_wallet_wallet__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z, {
                totalPrice: totalPrice,
                walletAmount: verifiedResponse.wallet_amount,
                walletCurrency: verifiedResponse.wallet_currency
            }),
            use_wallet && !Boolean(payableAmount) ? null : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_checkout_payment_payment_grid__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z, {
                className: "p-5 mt-10 border border-gray-200 bg-light"
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_checkout_place_order_action__WEBPACK_IMPORTED_MODULE_12__/* .PlaceOrderAction */ .T, {
                children: t('text-place-order')
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (VerifiedItemList);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 57322:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_1__);


const CashOnDelivery = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_1__.useTranslation)('common');
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
            className: "text-sm text-body block",
            children: t('text-cod-message')
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CashOnDelivery);


/***/ }),

/***/ 56749:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_1__);


const CashPayment = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_1__.useTranslation)('common');
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
            className: "text-sm text-body block",
            children: t('text-cash-message')
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CashPayment);


/***/ }),

/***/ 95553:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61185);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_ui_alert__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(58788);
/* harmony import */ var _components_checkout_payment_cash_on_delivery__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(57322);
/* harmony import */ var jotai__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(82451);
/* harmony import */ var _contexts_checkout__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(11458);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _cash__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(56749);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_headlessui_react__WEBPACK_IMPORTED_MODULE_1__, jotai__WEBPACK_IMPORTED_MODULE_6__, _contexts_checkout__WEBPACK_IMPORTED_MODULE_7__]);
([_headlessui_react__WEBPACK_IMPORTED_MODULE_1__, jotai__WEBPACK_IMPORTED_MODULE_6__, _contexts_checkout__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);










// Payment Methods Mapping Object
const AVAILABLE_PAYMENT_METHODS_MAP = {
    CASH: {
        name: 'Cash',
        value: 'CASH',
        icon: '',
        component: _cash__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z
    },
    CASH_ON_DELIVERY: {
        name: 'Cash On Delivery',
        value: 'CASH_ON_DELIVERY',
        icon: '',
        component: _components_checkout_payment_cash_on_delivery__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z
    }
};
const PaymentGrid = ({ className  })=>{
    const [gateway, setGateway] = (0,jotai__WEBPACK_IMPORTED_MODULE_6__.useAtom)(_contexts_checkout__WEBPACK_IMPORTED_MODULE_7__/* .paymentGatewayAtom */ .HA);
    const { 0: errorMessage , 1: setErrorMessage  } = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(null);
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)('common');
    const PaymentMethod = AVAILABLE_PAYMENT_METHODS_MAP[gateway];
    var ref;
    const Component = (ref = PaymentMethod === null || PaymentMethod === void 0 ? void 0 : PaymentMethod.component) !== null && ref !== void 0 ? ref : _components_checkout_payment_cash_on_delivery__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z;
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: className,
        children: [
            errorMessage ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_alert__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                message: t(`common:${errorMessage}`),
                variant: "error",
                closeable: true,
                className: "mt-5",
                onClose: ()=>setErrorMessage(null)
            }) : null,
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_1__.RadioGroup, {
                value: gateway,
                onChange: setGateway,
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_1__.RadioGroup.Label, {
                        className: "block mb-5 text-base font-semibold text-heading",
                        children: t('text-choose-payment')
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "grid grid-cols-2 gap-4 mb-8 md:grid-cols-3",
                        children: Object.values(AVAILABLE_PAYMENT_METHODS_MAP).map(({ name , icon , value  })=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_1__.RadioGroup.Option, {
                                value: value,
                                children: ({ checked  })=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                        className: classnames__WEBPACK_IMPORTED_MODULE_8___default()('relative flex h-full w-full cursor-pointer items-center justify-center rounded border py-3 text-center', checked ? 'shadow-600 border-accent bg-light' : 'border-gray-200 bg-light'),
                                        children: icon ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("img", {
                                                src: icon,
                                                alt: name,
                                                className: "h-[30px]"
                                            })
                                        }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                            className: "text-xs font-semibold text-heading",
                                            children: name
                                        })
                                    })
                            }, value)
                        )
                    })
                ]
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(Component, {})
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PaymentGrid);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 29074:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "T": () => (/* binding */ PlaceOrderAction)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_ui_validation_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(83957);
/* harmony import */ var _components_ui_button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(39258);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(89699);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _utils_format_ordered_product__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(77520);
/* harmony import */ var _contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(40601);
/* harmony import */ var jotai__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(82451);
/* harmony import */ var _contexts_checkout__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(11458);
/* harmony import */ var _contexts_quick_cart_cart_utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(85170);
/* harmony import */ var _data_order__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(5394);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(53139);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_6__, jotai__WEBPACK_IMPORTED_MODULE_7__, _contexts_checkout__WEBPACK_IMPORTED_MODULE_8__, _data_order__WEBPACK_IMPORTED_MODULE_9__]);
([_contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_6__, jotai__WEBPACK_IMPORTED_MODULE_7__, _contexts_checkout__WEBPACK_IMPORTED_MODULE_8__, _data_order__WEBPACK_IMPORTED_MODULE_9__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);













const PlaceOrderAction = (props)=>{
    const { locale , ...router } = (0,next_router__WEBPACK_IMPORTED_MODULE_2__.useRouter)();
    const { 0: errorMessage , 1: setErrorMessage  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const { createOrder , isLoading: loading  } = (0,_data_order__WEBPACK_IMPORTED_MODULE_9__/* .useCreateOrderMutation */ .kD)();
    const { items  } = (0,_contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_6__/* .useCart */ .jD)();
    const [{ billing_address , shipping_address , delivery_time , coupon , verified_response , customer_contact , customer , payment_gateway , token ,  }, ] = (0,jotai__WEBPACK_IMPORTED_MODULE_7__.useAtom)(_contexts_checkout__WEBPACK_IMPORTED_MODULE_8__/* .checkoutAtom */ .hq);
    const [discount] = (0,jotai__WEBPACK_IMPORTED_MODULE_7__.useAtom)(_contexts_checkout__WEBPACK_IMPORTED_MODULE_8__/* .discountAtom */ .yw);
    const [use_wallet_points] = (0,jotai__WEBPACK_IMPORTED_MODULE_7__.useAtom)(_contexts_checkout__WEBPACK_IMPORTED_MODULE_8__/* .walletAtom */ .xc);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        setErrorMessage(null);
    }, [
        payment_gateway
    ]);
    const available_items = items === null || items === void 0 ? void 0 : items.filter((item)=>{
        var ref;
        return !(verified_response === null || verified_response === void 0 ? void 0 : (ref = verified_response.unavailable_products) === null || ref === void 0 ? void 0 : ref.includes(item.id));
    });
    const subtotal = (0,_contexts_quick_cart_cart_utils__WEBPACK_IMPORTED_MODULE_11__/* .calculateTotal */ .tf)(available_items);
    const total = (0,_contexts_quick_cart_cart_utils__WEBPACK_IMPORTED_MODULE_11__/* .calculatePaidTotal */ .eA)({
        totalAmount: subtotal,
        tax: verified_response === null || verified_response === void 0 ? void 0 : verified_response.total_tax,
        shipping_charge: verified_response === null || verified_response === void 0 ? void 0 : verified_response.shipping_charge
    }, Number(discount));
    const handlePlaceOrder = ()=>{
        if (!customer_contact) {
            setErrorMessage('Contact Number Is Required');
            return;
        }
        if (!use_wallet_points && !payment_gateway) {
            setErrorMessage('Gateway Is Required');
            return;
        }
        // if (!use_wallet_points && payment_gateway === "STRIPE" && !token) {
        //   setErrorMessage("Please Pay First");
        //   return;
        // }
        let input = {
            language: locale,
            products: available_items === null || available_items === void 0 ? void 0 : available_items.map((item)=>(0,_utils_format_ordered_product__WEBPACK_IMPORTED_MODULE_12__/* .formatOrderedProduct */ .Y)(item)
            ),
            amount: subtotal,
            coupon_id: Number(coupon === null || coupon === void 0 ? void 0 : coupon.id),
            discount: discount !== null && discount !== void 0 ? discount : 0,
            paid_total: total,
            sales_tax: verified_response === null || verified_response === void 0 ? void 0 : verified_response.total_tax,
            delivery_fee: verified_response === null || verified_response === void 0 ? void 0 : verified_response.shipping_charge,
            total,
            delivery_time: delivery_time === null || delivery_time === void 0 ? void 0 : delivery_time.title,
            customer_contact,
            customer_id: customer === null || customer === void 0 ? void 0 : customer.value,
            use_wallet_points,
            payment_gateway: use_wallet_points ? _types__WEBPACK_IMPORTED_MODULE_10__/* .PaymentGateway.FULL_WALLET_PAYMENT */ .HY.FULL_WALLET_PAYMENT : payment_gateway,
            billing_address: {
                ...(billing_address === null || billing_address === void 0 ? void 0 : billing_address.address) && billing_address.address
            },
            shipping_address: {
                ...(shipping_address === null || shipping_address === void 0 ? void 0 : shipping_address.address) && shipping_address.address
            }
        };
        // if (payment_gateway === "STRIPE") {
        //   //@ts-ignore
        //   input.token = token;
        // }
        // delete input.billing_address.__typename;
        // delete input.shipping_address.__typename;
        createOrder(input);
    };
    const isAllRequiredFieldSelected = [
        customer,
        customer_contact,
        payment_gateway,
        billing_address,
        shipping_address,
        delivery_time,
        available_items, 
    ].every((item)=>!lodash_isEmpty__WEBPACK_IMPORTED_MODULE_5___default()(item)
    );
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                loading: loading,
                className: "mt-5 w-full",
                onClick: handlePlaceOrder,
                disabled: !isAllRequiredFieldSelected,
                ...props
            }),
            errorMessage && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "mt-3",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_validation_error__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                    message: errorMessage
                })
            })
        ]
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 86126:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_is_negative__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(91158);
/* harmony import */ var _utils_use_price__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(86797);
/* harmony import */ var jotai__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(82451);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _contexts_checkout__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11458);
/* harmony import */ var _components_ui_checkbox_checkbox__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(33785);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_utils_use_price__WEBPACK_IMPORTED_MODULE_1__, jotai__WEBPACK_IMPORTED_MODULE_2__, _contexts_checkout__WEBPACK_IMPORTED_MODULE_4__]);
([_utils_use_price__WEBPACK_IMPORTED_MODULE_1__, jotai__WEBPACK_IMPORTED_MODULE_2__, _contexts_checkout__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);








const Wallet = ({ totalPrice , walletAmount , walletCurrency  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_6__.useTranslation)('common');
    const [use_wallet, setUseWallet] = (0,jotai__WEBPACK_IMPORTED_MODULE_2__.useAtom)(_contexts_checkout__WEBPACK_IMPORTED_MODULE_4__/* .walletAtom */ .xc);
    const [calculatePayableAmount, setCalculatePayableAmount] = (0,jotai__WEBPACK_IMPORTED_MODULE_2__.useAtom)(_contexts_checkout__WEBPACK_IMPORTED_MODULE_4__/* .payableAmountAtom */ .y2);
    const { 0: calculateCurrentWalletCurrency , 1: setCalculateCurrentWalletCurrency  } = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(walletCurrency);
    const { price: currentWalletCurrency  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)({
        amount: Number(calculateCurrentWalletCurrency)
    });
    const { price: payableAmount  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)({
        amount: calculatePayableAmount
    });
    (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(()=>{
        if (use_wallet) {
            const calculatedCurrentWalletCurrencyAfterPayment = walletCurrency - totalPrice;
            if ((0,_utils_is_negative__WEBPACK_IMPORTED_MODULE_7__/* .isNegative */ .n)(calculatedCurrentWalletCurrencyAfterPayment)) {
                setCalculateCurrentWalletCurrency(0);
                setCalculatePayableAmount(Math.abs(calculatedCurrentWalletCurrencyAfterPayment));
            } else {
                setCalculateCurrentWalletCurrency(calculatedCurrentWalletCurrencyAfterPayment);
                setCalculatePayableAmount(0);
            }
        } else {
            setCalculateCurrentWalletCurrency(walletCurrency);
            setCalculatePayableAmount(0);
        }
    }, [
        setCalculatePayableAmount,
        totalPrice,
        use_wallet,
        walletCurrency
    ]);
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "mt-2 space-y-2",
                children: [
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                        className: "flex justify-between text-sm text-body",
                        children: [
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                children: [
                                    t('text-wallet'),
                                    ' ',
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                        className: "lowercase",
                                        children: t('text-points')
                                    })
                                ]
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                children: walletAmount
                            })
                        ]
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                        className: "flex justify-between text-sm text-body",
                        children: [
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                children: [
                                    t('text-wallet'),
                                    " ",
                                    t('text-currency')
                                ]
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                children: currentWalletCurrency
                            })
                        ]
                    })
                ]
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_checkbox_checkbox__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                name: "use_wallet",
                label: t('text-wallet-use'),
                className: "mt-3",
                onChange: setUseWallet,
                checked: use_wallet,
                disabled: !walletAmount
            }),
            use_wallet && /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "mt-4 flex justify-between border-t-4 border-double border-border-base pt-3",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                        className: "text-base font-semibold text-heading",
                        children: t('text-payable')
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                        className: "text-base font-semibold text-heading",
                        children: payableAmount
                    })
                ]
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Wallet);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 33785:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const Checkbox = /*#__PURE__*/ react__WEBPACK_IMPORTED_MODULE_1___default().forwardRef(({ className , label , name , error , ...rest }, ref)=>{
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: className,
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "flex items-center",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                        id: name,
                        name: name,
                        type: "checkbox",
                        ref: ref,
                        className: "pb-checkbox",
                        ...rest
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
                        htmlFor: name,
                        className: "text-body text-sm",
                        children: label
                    })
                ]
            }),
            error && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                className: "my-2 text-xs text-end text-red-500",
                children: error
            })
        ]
    }));
});
Checkbox.displayName = 'Checkbox';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Checkbox);


/***/ }),

/***/ 91158:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "n": () => (/* binding */ isNegative)
/* harmony export */ });
function isNegative(value) {
    return value < 0;
}


/***/ })

};
;