"use strict";
exports.id = 1632;
exports.ids = [1632];
exports.modules = {

/***/ 81258:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);


const Card = ({ className , ...props })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('p-5 md:p-8 bg-light shadow rounded', className),
        ...props
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Card);


/***/ }),

/***/ 73118:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "x": () => (/* binding */ BackIcon)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const BackIcon = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        stroke: "currentColor",
        fill: "currentColor",
        strokeWidth: "0",
        viewBox: "0 0 24 24",
        height: "1em",
        width: "1em",
        xmlns: "http://www.w3.org/2000/svg",
        ...props,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            d: "M21 11H6.414l5.293-5.293-1.414-1.414L2.586 12l7.707 7.707 1.414-1.414L6.414 13H21z"
        })
    })
;


/***/ }),

/***/ 44066:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "W": () => (/* binding */ SearchIcon)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SearchIcon = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        stroke: "currentColor",
        ...props,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeWidth: 2,
            d: "M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"
        })
    })
;


/***/ }),

/***/ 60985:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "U": () => (/* binding */ SendMessageIcon)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SendMessageIcon = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        width: "1em",
        height: "1em",
        ...props,
        fill: "none",
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            fill: "currentColor",
            d: "M17.592 8.827c0 .602-.388 1.139-1.064 1.477L2.975 17.081a2.14 2.14 0 0 1-.95.247c-.43 0-.808-.181-1.048-.502-.206-.282-.404-.769-.164-1.561l1.527-5.093c.05-.148.082-.33.099-.52h8.36a.828.828 0 0 0 .826-.825.828.828 0 0 0-.825-.825H2.439a2.426 2.426 0 0 0-.1-.52L.814 2.389C.573 1.597.77 1.109.978.829 1.382.284 2.15.161 2.975.573L16.528 7.35c.676.339 1.064.875 1.064 1.478Z"
        })
    })
;


/***/ }),

/***/ 82717:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_content_loader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38782);
/* harmony import */ var react_content_loader__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_content_loader__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_common_avatar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65204);
/* harmony import */ var _settings_site_settings__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37070);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_settings_site_settings__WEBPACK_IMPORTED_MODULE_3__]);
_settings_site_settings__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];





const rangeMap = (n, fn)=>{
    const arr = [];
    while(n > (arr === null || arr === void 0 ? void 0 : arr.length)){
        arr === null || arr === void 0 ? void 0 : arr.push(fn(arr === null || arr === void 0 ? void 0 : arr.length));
    }
    return arr;
};
const checkOddAdnEven = (number)=>{
    if (number % 2 == 0) {
        return true;
    } else {
        return false;
    }
};
const Loader = ({ props , backgroundColor , foregroundColor  })=>{
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)((react_content_loader__WEBPACK_IMPORTED_MODULE_1___default()), {
        speed: 2,
        width: '100%',
        height: '100%',
        viewBox: "0 0 241 18",
        backgroundColor: backgroundColor ? backgroundColor : '#E5E5E5',
        foregroundColor: foregroundColor ? foregroundColor : '#c0c0c0',
        ...props,
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("rect", {
                width: "241",
                height: "6",
                rx: "2"
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("rect", {
                y: "12",
                width: "120.5",
                height: "6",
                rx: "2"
            })
        ]
    }));
};
const MessageCardLoader = ({ classes , limit , ...rest })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        className: "space-y-3",
        ...rest,
        children: rangeMap(limit, (i)=>{
            var ref;
            /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                    className: `${checkOddAdnEven(i) ? 'space-x-3' : 'flex-row-reverse'} flex w-full`,
                    children: [
                        checkOddAdnEven(i) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                            className: "w-10",
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_avatar__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                                src: _settings_site_settings__WEBPACK_IMPORTED_MODULE_3__/* .siteSettings */ .U === null || _settings_site_settings__WEBPACK_IMPORTED_MODULE_3__/* .siteSettings */ .U === void 0 ? void 0 : (ref = _settings_site_settings__WEBPACK_IMPORTED_MODULE_3__/* .siteSettings.avatar */ .U.avatar) === null || ref === void 0 ? void 0 : ref.placeholder,
                                alt: "avatar"
                            })
                        }) : '',
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                            className: classnames__WEBPACK_IMPORTED_MODULE_4___default()(classes === null || classes === void 0 ? void 0 : classes.common, checkOddAdnEven(i) ? classes === null || classes === void 0 ? void 0 : classes.default : classes === null || classes === void 0 ? void 0 : classes.reverse),
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                className: "p-2",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(Loader, {
                                    backgroundColor: checkOddAdnEven(i) ? '#d7d7d7' : '#119278',
                                    foregroundColor: checkOddAdnEven(i) ? '#ECECEC' : '#21A087'
                                })
                            })
                        })
                    ]
                })
            });
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MessageCardLoader);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 71632:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ MessagePageIndex)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_message_user_list_index__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(75208);
/* harmony import */ var _components_message_user_message_index__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(29853);
/* harmony import */ var _components_common_card__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(81258);
/* harmony import */ var _utils_use_window_size__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(79560);
/* harmony import */ var _components_message_views_responsive_vew__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(92846);
/* harmony import */ var _utils_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(30957);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_message_user_list_index__WEBPACK_IMPORTED_MODULE_1__, _components_message_user_message_index__WEBPACK_IMPORTED_MODULE_2__, _components_message_views_responsive_vew__WEBPACK_IMPORTED_MODULE_5__]);
([_components_message_user_list_index__WEBPACK_IMPORTED_MODULE_1__, _components_message_user_message_index__WEBPACK_IMPORTED_MODULE_2__, _components_message_views_responsive_vew__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);







function MessagePageIndex() {
    const { width  } = (0,_utils_use_window_size__WEBPACK_IMPORTED_MODULE_4__/* .useWindowSize */ .i)();
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_card__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
            className: "h-full overflow-hidden !p-0 !shadow-chatBox",
            style: {
                maxHeight: 'calc(100% - 5px)'
            },
            children: width >= _utils_constants__WEBPACK_IMPORTED_MODULE_6__/* .RESPONSIVE_WIDTH */ .h2 ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "flex h-full flex-wrap overflow-hidden",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_message_user_list_index__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {}),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_message_user_message_index__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {})
                ]
            }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_message_views_responsive_vew__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {})
        })
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 54857:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(145);
/* harmony import */ var _components_icons_search_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(44066);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_icons_close_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29581);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_5__);






const UserBoxHeaderView = ({ className , onChange , value , clear , ...rest })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("form", {
            className: classnames__WEBPACK_IMPORTED_MODULE_3___default()('relative h-14 border-b border-solid border-b-[#E5E7EB] sm:h-20', className),
            ...rest,
            onSubmit: (e)=>e.preventDefault()
            ,
            onChange: onChange,
            children: [
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                    type: "text",
                    name: "search",
                    variant: "solid",
                    className: "h-full",
                    inputClassName: "!bg-white !pr-11 !border-0 !h-full",
                    showLabel: false,
                    onKeyUp: onChange,
                    value: value,
                    placeholder: t('text-input-search')
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                    className: "absolute top-0 right-0 flex h-full w-12 select-none",
                    children: !!value ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                        type: "button",
                        onClick: clear,
                        className: "my-auto ml-auto mr-3 text-[#9CA3AF] outline-none focus:outline-none active:outline-none",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_close_icon__WEBPACK_IMPORTED_MODULE_4__/* .CloseIcon */ .T, {
                            className: "h-4 w-4"
                        })
                    }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_search_icon__WEBPACK_IMPORTED_MODULE_2__/* .SearchIcon */ .W, {
                        height: 15,
                        width: 16,
                        className: "my-auto ml-auto mr-3 text-[#9CA3AF]"
                    })
                })
            ]
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserBoxHeaderView);


/***/ }),

/***/ 75208:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_message_user_box_header__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(54857);
/* harmony import */ var _components_message_user_list__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(83217);
/* harmony import */ var _components_ui_button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(39258);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _components_ui_modal_modal_context__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(44144);
/* harmony import */ var _utils_use_window_size__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(79560);
/* harmony import */ var _utils_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(30957);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _utils_auth_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(49239);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_message_user_list__WEBPACK_IMPORTED_MODULE_3__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_9__]);
([_components_message_user_list__WEBPACK_IMPORTED_MODULE_3__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_9__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);











const UserListIndex = ({ className , ...rest })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_1__.useTranslation)();
    const { openModal  } = (0,_components_ui_modal_modal_context__WEBPACK_IMPORTED_MODULE_6__/* .useModalAction */ .SO)();
    const { 0: text , 1: setText  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)('');
    const { width  } = (0,_utils_use_window_size__WEBPACK_IMPORTED_MODULE_7__/* .useWindowSize */ .i)();
    const { permissions  } = (0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_9__/* .getAuthCredentials */ .WA)();
    let adminPermission = (0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_9__/* .hasAccess */ .Ft)(_utils_auth_utils__WEBPACK_IMPORTED_MODULE_9__/* .adminOnly */ .M$, permissions);
    function handleComposeClick() {
        openModal('COMPOSE_MESSAGE');
    }
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
            className: classnames__WEBPACK_IMPORTED_MODULE_5___default()(width >= _utils_constants__WEBPACK_IMPORTED_MODULE_10__/* .RESPONSIVE_WIDTH */ .h2 ? 'max-w-[4rem] border-r border-solid border-r-[#E5E7EB] sm:max-w-xs 2xl:max-w-[26rem] ' : '', 'flex h-full flex-1 flex-col', adminPermission ? 'pb-6' : '', className),
            ...rest,
            children: [
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_message_user_box_header__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                    onChange: (event)=>{
                        var ref;
                        return setText(event === null || event === void 0 ? void 0 : (ref = event.target) === null || ref === void 0 ? void 0 : ref.value);
                    },
                    value: text,
                    clear: ()=>setText('')
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_message_user_list__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                    filterText: text,
                    permission: adminPermission
                }),
                adminPermission ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                    className: "mx-6 block",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                        onClick: handleComposeClick,
                        className: "w-full",
                        children: t('text-compose')
                    })
                }) : ''
            ]
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserListIndex);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 83217:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _data_conversations__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(84891);
/* harmony import */ var _components_ui_error_message__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(30110);
/* harmony import */ var _components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(47898);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(89699);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _components_message_views_list_view__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(7811);
/* harmony import */ var _components_ui_scrollbar__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(97046);
/* harmony import */ var _utils_constants__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(30957);
/* harmony import */ var _components_message_views_conversation_not_found__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(41401);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(53139);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_11__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_conversations__WEBPACK_IMPORTED_MODULE_1__, _components_message_views_list_view__WEBPACK_IMPORTED_MODULE_7__]);
([_data_conversations__WEBPACK_IMPORTED_MODULE_1__, _components_message_views_list_view__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);













const UserList = ({ className , filterText , permission , ...rest })=>{
    var ref;
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    const loadMoreRef = (0,react__WEBPACK_IMPORTED_MODULE_4__.useRef)(null);
    var ref1;
    let { conversations , loading , error , refetch , isSuccess , hasMore , loadMore , isLoadingMore ,  } = (0,_data_conversations__WEBPACK_IMPORTED_MODULE_1__/* .useConversationsQuery */ .sw)({
        search: (filterText === null || filterText === void 0 ? void 0 : filterText.length) >= 3 ? (ref1 = (ref = filterText === null || filterText === void 0 ? void 0 : filterText.trim()) === null || ref === void 0 ? void 0 : ref.toLowerCase()) !== null && ref1 !== void 0 ? ref1 : '' : null,
        limit: _utils_constants__WEBPACK_IMPORTED_MODULE_12__/* .LIMIT */ .VZ,
        sortedBy: _types__WEBPACK_IMPORTED_MODULE_10__/* .SortOrder.Desc */ .As.Desc,
        orderBy: 'updated_at'
    });
    let filterTimeout;
    (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(()=>{
        // filter text
        clearTimeout(filterTimeout);
        if (Boolean((filterText === null || filterText === void 0 ? void 0 : filterText.length) >= 3) && (filterText || lodash_isEmpty__WEBPACK_IMPORTED_MODULE_6___default()(filterText))) {
            filterTimeout = setTimeout(()=>{
                refetch();
            }, 500);
        }
        if (!hasMore) {
            return;
        }
        const option = {
            threshold: 0
        };
        const handleObserver = (entries)=>{
            return entries === null || entries === void 0 ? void 0 : entries.forEach((entry)=>{
                return (entry === null || entry === void 0 ? void 0 : entry.isIntersecting) && loadMore();
            });
        };
        const observer = new IntersectionObserver(handleObserver, option);
        const element = loadMoreRef && (loadMoreRef === null || loadMoreRef === void 0 ? void 0 : loadMoreRef.current);
        if (!element) {
            return;
        }
        observer === null || observer === void 0 ? void 0 : observer.observe(element);
    }, [
        loadMoreRef === null || loadMoreRef === void 0 ? void 0 : loadMoreRef.current,
        filterText,
        hasMore
    ]);
    // if (loading)
    //   return (
    //     <Loader
    //       className="!h-auto flex-grow"
    //       showText={false}
    //       text={t('common:text-loading')}
    //     />
    //   );
    if (loading && lodash_isEmpty__WEBPACK_IMPORTED_MODULE_6___default()(conversations)) {
        return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
            className: "!h-auto flex-grow",
            showText: false,
            text: t('common:text-loading')
        }));
    }
    if (!loading && lodash_isEmpty__WEBPACK_IMPORTED_MODULE_6___default()(conversations)) {
        return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_message_views_conversation_not_found__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {}));
    }
    if (error) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_error_message__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        message: error.message
    }));
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
            className: classnames__WEBPACK_IMPORTED_MODULE_11___default()('flex-auto', permission ? 'pb-6' : ''),
            ...rest,
            children: !lodash_isEmpty__WEBPACK_IMPORTED_MODULE_6___default()(conversations) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_ui_scrollbar__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                    className: "h-full w-full",
                    options: {
                        scrollbars: {
                            autoHide: 'never'
                        }
                    },
                    children: [
                        isSuccess && (conversations === null || conversations === void 0 ? void 0 : conversations.map((conversation, key)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_message_views_list_view__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                                conversation: conversation,
                                className: className
                            }, key)
                        )),
                        hasMore ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                            className: "loader",
                            ref: loadMoreRef,
                            children: isLoadingMore ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                                className: "mt-4 !h-auto",
                                showText: false
                            }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                className: "hidden",
                                children: "No search left"
                            })
                        }) : ''
                    ]
                })
            }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {})
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserList);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 29853:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(47898);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(89699);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _components_message_views_message_view__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(52371);
/* harmony import */ var _data_conversations__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(84891);
/* harmony import */ var _utils_constants__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(30957);
/* harmony import */ var _components_message_views_select_conversation__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(71246);
/* harmony import */ var _components_message_views_blocked_view__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(28192);
/* harmony import */ var _components_message_views_form_view__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(93454);
/* harmony import */ var _components_message_views_header_view__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(18735);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _components_message_content_loader__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(82717);
/* harmony import */ var _utils_use_window_size__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(79560);
/* harmony import */ var _components_ui_error_message__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(30110);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_message_views_message_view__WEBPACK_IMPORTED_MODULE_6__, _data_conversations__WEBPACK_IMPORTED_MODULE_7__, _components_message_views_form_view__WEBPACK_IMPORTED_MODULE_10__, _components_message_views_header_view__WEBPACK_IMPORTED_MODULE_11__, _components_message_content_loader__WEBPACK_IMPORTED_MODULE_13__]);
([_components_message_views_message_view__WEBPACK_IMPORTED_MODULE_6__, _data_conversations__WEBPACK_IMPORTED_MODULE_7__, _components_message_views_form_view__WEBPACK_IMPORTED_MODULE_10__, _components_message_views_header_view__WEBPACK_IMPORTED_MODULE_11__, _components_message_content_loader__WEBPACK_IMPORTED_MODULE_13__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




















const UserMessageIndex = ({ className , ...rest })=>{
    var ref, ref1;
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    const loadMoreRef = (0,react__WEBPACK_IMPORTED_MODULE_12__.useRef)(null);
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_3__.useRouter)();
    const { mutate: createSeenMessage  } = (0,_data_conversations__WEBPACK_IMPORTED_MODULE_7__/* .useMessageSeen */ .uX)();
    const { query  } = router;
    const { data , loading , error  } = (0,_data_conversations__WEBPACK_IMPORTED_MODULE_7__/* .useConversationQuery */ .Cq)({
        id: query.id
    });
    const { width  } = (0,_utils_use_window_size__WEBPACK_IMPORTED_MODULE_14__/* .useWindowSize */ .i)();
    let { error: messageError , messages , loading: messageLoading , isSuccess , hasMore , loadMore , isLoadingMore , isFetching ,  } = (0,_data_conversations__WEBPACK_IMPORTED_MODULE_7__/* .useMessagesQuery */ .kY)({
        slug: query === null || query === void 0 ? void 0 : query.id,
        limit: _utils_constants__WEBPACK_IMPORTED_MODULE_16__/* .LIMIT */ .VZ
    });
    (0,react__WEBPACK_IMPORTED_MODULE_12__.useEffect)(()=>{
        if (!hasMore) {
            return;
        }
        const option = {
            rootMargin: '-110px',
            threshold: [
                0,
                0.25,
                0.5,
                0.75,
                1
            ]
        };
        const handleObserver = (entries)=>{
            return entries === null || entries === void 0 ? void 0 : entries.forEach((entry)=>{
                return (entry === null || entry === void 0 ? void 0 : entry.isIntersecting) && loadMore();
            });
        };
        const observer = new IntersectionObserver(handleObserver, option);
        const element = loadMoreRef && (loadMoreRef === null || loadMoreRef === void 0 ? void 0 : loadMoreRef.current);
        if (!element) {
            return;
        }
        observer === null || observer === void 0 ? void 0 : observer.observe(element);
    }, [
        loadMoreRef === null || loadMoreRef === void 0 ? void 0 : loadMoreRef.current,
        hasMore
    ]);
    messages = [
        ...messages
    ].reverse();
    const classes = {
        common: 'inline-block rounded-[13.5px] px-4 py-2 shadow-chat break-all',
        default: 'bg-white text-left',
        reverse: 'bg-accent text-white'
    };
    if (!lodash_isEmpty__WEBPACK_IMPORTED_MODULE_5___default()(query === null || query === void 0 ? void 0 : query.id) && messageError) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        className: "flex !h-full flex-1 items-center justify-center bg-[#F3F4F6]",
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_error_message__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
            message: messageError === null || messageError === void 0 ? void 0 : messageError.message
        })
    }));
    const seenMessage = (unseen)=>{
        if (unseen) {
            createSeenMessage({
                id: query === null || query === void 0 ? void 0 : query.id
            });
        }
    };
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
            className: classnames__WEBPACK_IMPORTED_MODULE_4___default()('flex h-full flex-1 bg-[#F3F4F6] pb-7', width >= _utils_constants__WEBPACK_IMPORTED_MODULE_16__/* .RESPONSIVE_WIDTH */ .h2 ? '2xl:max-w-[calc(100% - 26rem)]' : '', className),
            ...rest,
            children: !lodash_isEmpty__WEBPACK_IMPORTED_MODULE_5___default()(query === null || query === void 0 ? void 0 : query.id) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                children: !loading || !messageLoading ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                    className: classnames__WEBPACK_IMPORTED_MODULE_4___default()('flex h-full w-full flex-col'),
                    onFocus: ()=>{
                        // @ts-ignore
                        seenMessage(Boolean(data === null || data === void 0 ? void 0 : data.unseen));
                    },
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_message_views_header_view__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z, {
                            shop: data === null || data === void 0 ? void 0 : data.shop
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_message_views_message_view__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                            messages: messages,
                            id: "chatBody",
                            error: messageError,
                            loading: messageLoading,
                            classes: classes,
                            isSuccess: isSuccess,
                            isLoadingMore: isLoadingMore,
                            isFetching: isFetching,
                            children: hasMore ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                ref: loadMoreRef,
                                className: "mb-4",
                                children: isLoadingMore ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_message_content_loader__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z, {
                                    classes: classes,
                                    limit: _utils_constants__WEBPACK_IMPORTED_MODULE_16__/* .LIMIT */ .VZ / 2
                                }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                    className: "hidden",
                                    children: "No search left"
                                })
                            }) : ''
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                            className: "relative mx-6",
                            children: Boolean(data === null || data === void 0 ? void 0 : (ref = data.shop) === null || ref === void 0 ? void 0 : ref.is_active) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_message_views_form_view__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z, {})
                            }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_message_views_blocked_view__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
                                    name: data === null || data === void 0 ? void 0 : (ref1 = data.shop) === null || ref1 === void 0 ? void 0 : ref1.name
                                })
                            })
                        })
                    ]
                }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                    className: "!h-full",
                    text: t('common:text-loading')
                })
            }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                children: width >= _utils_constants__WEBPACK_IMPORTED_MODULE_16__/* .RESPONSIVE_WIDTH */ .h2 ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_message_views_select_conversation__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {}) : ''
            })
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserMessageIndex);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 28192:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);



const BlockedView = ({ className , name , ...rest })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_1__.useTranslation)();
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
            className: classnames__WEBPACK_IMPORTED_MODULE_2___default()('space-y-3 rounded bg-[#ebebeb] px-4 py-5 text-center', className),
            ...rest,
            children: [
                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("p", {
                    className: "text-lg",
                    children: [
                        t('text-blocked-content-one'),
                        " ",
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("strong", {
                            children: name
                        }),
                        ' ',
                        t('text-account')
                    ]
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                    className: "text-sm",
                    children: t('text-blocked-content-two')
                })
            ]
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BlockedView);


/***/ }),

/***/ 41401:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ conversation_not_found)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
// EXTERNAL MODULE: external "next-i18next"
var external_next_i18next_ = __webpack_require__(11377);
;// CONCATENATED MODULE: ./src/components/icons/empty-inbox.tsx

const EmptyInbox = ({ width =75 , height =56 , ...props })=>{
    return(/*#__PURE__*/ (0,jsx_runtime_.jsxs)("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        width: width,
        height: height,
        ...props,
        fill: "none",
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#fff",
                stroke: "#DFDFDF",
                d: "m57.344 2.277.022.035.028.032 16.108 18.261V34.7H.902V20.607L17.011 2.342l.027-.031.023-.036C17.777 1.121 18.776.5 19.75.5h34.903c.975 0 1.972.62 2.69 1.777Z"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#F1F1F1",
                stroke: "#DFDFDF",
                d: "M53.083 25.49c0-1.185.368-2.249.94-3.006.573-.757 1.328-1.184 2.123-1.184h17.356v28.519c0 1.598-.497 3.035-1.28 4.061-.781 1.026-1.825 1.62-2.94 1.62H5.122c-1.114 0-2.158-.594-2.94-1.62-.782-1.027-1.28-2.464-1.28-4.061v-28.52h17.356c.796 0 1.55.426 2.123 1.182.573.756.94 1.82.94 3.004v.035c0 2.716 1.72 5.141 4.08 5.141h23.603c1.174 0 2.204-.624 2.925-1.562.721-.939 1.154-2.213 1.154-3.598v-.012Z"
            })
        ]
    }));
};

;// CONCATENATED MODULE: ./src/components/message/views/conversation-not-found.tsx



const UserListNotFound = ()=>{
    const { t  } = (0,external_next_i18next_.useTranslation)();
    return(/*#__PURE__*/ jsx_runtime_.jsx(jsx_runtime_.Fragment, {
        children: /*#__PURE__*/ jsx_runtime_.jsx("div", {
            className: "flex-auto pb-6",
            children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                className: "mt-24 px-5 text-center",
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        className: "mb-10",
                        children: /*#__PURE__*/ jsx_runtime_.jsx(EmptyInbox, {
                            className: "mx-auto"
                        })
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("p", {
                        className: "font-medium text-[#686D73]",
                        children: t('text-inbox-empty')
                    })
                ]
            })
        })
    }));
};
/* harmony default export */ const conversation_not_found = (UserListNotFound);


/***/ }),

/***/ 93454:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_ui_button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(39258);
/* harmony import */ var _components_icons_send_message__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(60985);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _data_conversations__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(84891);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _components_ui_text_area__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(83375);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(45641);
/* harmony import */ var _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(61908);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(46517);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_12__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_conversations__WEBPACK_IMPORTED_MODULE_6__, react_hook_form__WEBPACK_IMPORTED_MODULE_10__, _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_11__]);
([_data_conversations__WEBPACK_IMPORTED_MODULE_6__, react_hook_form__WEBPACK_IMPORTED_MODULE_10__, _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_11__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);













const messageSchema = yup__WEBPACK_IMPORTED_MODULE_7__.object().shape({
    message: yup__WEBPACK_IMPORTED_MODULE_7__.string().required('error-body-required')
});
const CreateMessageForm = ({ className , ...rest })=>{
    const { register , handleSubmit , getValues , setFocus , reset , formState: { errors  } ,  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_10__.useForm)({
        resolver: (0,_hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_11__.yupResolver)(messageSchema)
    });
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_1__.useTranslation)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_2__.useRouter)();
    const { query  } = router;
    const { mutate: createMessage , isLoading: creating  } = (0,_data_conversations__WEBPACK_IMPORTED_MODULE_6__/* .useSendMessage */ .$3)();
    (0,react__WEBPACK_IMPORTED_MODULE_9__.useEffect)(()=>{
        const listener = (event)=>{
            if (event.key === 'Enter' && event.shiftKey) {
                return false;
            }
            if (event.code === 'Enter' || event.code === 'NumpadEnter') {
                event.preventDefault();
                const values = getValues();
                onSubmit(values);
            }
        };
        document.addEventListener('keydown', listener);
        return ()=>{
            document.removeEventListener('keydown', listener);
        };
    }, [
        query === null || query === void 0 ? void 0 : query.id
    ]);
    const onSubmit = async (values)=>{
        if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isEmpty)(values.message)) {
            react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast === null || react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast === void 0 ? void 0 : react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast.error('Message is required');
            return;
        }
        createMessage({
            message: values === null || values === void 0 ? void 0 : values.message,
            id: query === null || query === void 0 ? void 0 : query.id
        }, {
            onError: (error)=>{
                react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast === null || react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast === void 0 ? void 0 : react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast.error(error === null || error === void 0 ? void 0 : error.message);
            },
            onSuccess: ()=>{
                const chatBody = document.getElementById('chatBody');
                chatBody === null || chatBody === void 0 ? void 0 : chatBody.scrollTo({
                    top: chatBody === null || chatBody === void 0 ? void 0 : chatBody.scrollHeight,
                    behavior: 'smooth'
                });
                reset();
            }
        });
    };
    (0,react__WEBPACK_IMPORTED_MODULE_9__.useEffect)(()=>{
        setFocus('message');
    }, [
        setFocus
    ]);
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("form", {
            noValidate: true,
            onSubmit: handleSubmit(onSubmit),
            children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "relative",
                children: [
                    !!creating ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "absolute top-0 left-0 z-50 flex h-full w-full cursor-not-allowed bg-[#EEF1F4]/50",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                            className: "m-auto h-5 w-4 animate-spin rounded-full border-2 border-t-2 border-transparent border-t-accent"
                        })
                    }) : '',
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_text_area__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                        className: "overflow-y-auto overflow-x-hidden shadow-chatBox",
                        placeholder: "Type your message here..",
                        ...register('message'),
                        variant: "solid",
                        inputClassName: "!border-0 bg-white pr-12 block !h-full",
                        rows: 3,
                        disabled: !!creating
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "absolute top-0 right-0 h-full",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                            className: "!h-full px-4 text-lg focus:!shadow-none focus:!ring-0",
                            variant: "custom",
                            disabled: !!creating,
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_send_message__WEBPACK_IMPORTED_MODULE_4__/* .SendMessageIcon */ .U, {})
                        })
                    })
                ]
            })
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CreateMessageForm);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 18735:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_common_avatar__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65204);
/* harmony import */ var _settings_site_settings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(37070);
/* harmony import */ var _utils_use_window_size__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(79560);
/* harmony import */ var _utils_auth_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(49239);
/* harmony import */ var _components_ui_link__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31434);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(28379);
/* harmony import */ var _components_icons_back_icon__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(73118);
/* harmony import */ var _utils_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(30957);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_settings_site_settings__WEBPACK_IMPORTED_MODULE_4__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_6__]);
([_settings_site_settings__WEBPACK_IMPORTED_MODULE_4__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_6__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);











const HeaderView = ({ className , shop , ...rest })=>{
    var ref, ref1;
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_1__.useRouter)();
    const { width  } = (0,_utils_use_window_size__WEBPACK_IMPORTED_MODULE_5__/* .useWindowSize */ .i)();
    const { permissions  } = (0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_6__/* .getAuthCredentials */ .WA)();
    let adminPermission = (0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_6__/* .hasAccess */ .Ft)(_utils_auth_utils__WEBPACK_IMPORTED_MODULE_6__/* .adminOnly */ .M$, permissions);
    const routes = adminPermission ? _config_routes__WEBPACK_IMPORTED_MODULE_8__/* .Routes.message.list */ .Z.message.list : `${_config_routes__WEBPACK_IMPORTED_MODULE_8__/* .Routes */ .Z === null || _config_routes__WEBPACK_IMPORTED_MODULE_8__/* .Routes */ .Z === void 0 ? void 0 : _config_routes__WEBPACK_IMPORTED_MODULE_8__/* .Routes.dashboard */ .Z.dashboard}?tab=1`;
    var ref2;
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
            className: classnames__WEBPACK_IMPORTED_MODULE_2___default()('relative flex shrink-0 items-center border-b border-solid border-b-[#E5E7EB] bg-white p-2 sm:h-20 sm:pl-6 sm:pr-9', width >= _utils_constants__WEBPACK_IMPORTED_MODULE_10__/* .RESPONSIVE_WIDTH */ .h2 ? 'justify-between' : '', className),
            ...rest,
            children: [
                width <= _utils_constants__WEBPACK_IMPORTED_MODULE_10__/* .RESPONSIVE_WIDTH */ .h2 ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_link__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                    href: routes,
                    className: "mr-1 inline-block p-1 pl-0 text-2xl transition-colors duration-300 hover:text-accent-hover",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_back_icon__WEBPACK_IMPORTED_MODULE_9__/* .BackIcon */ .x, {})
                }) : '',
                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                    className: `flex ${adminPermission ? 'cursor-pointer' : ''} items-center`,
                    onClick: ()=>{
                        return adminPermission ? router.push(`/${shop === null || shop === void 0 ? void 0 : shop.slug}`) : '';
                    },
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_avatar__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                            src: (ref2 = shop === null || shop === void 0 ? void 0 : (ref = shop.logo) === null || ref === void 0 ? void 0 : ref.thumbnail) !== null && ref2 !== void 0 ? ref2 : _settings_site_settings__WEBPACK_IMPORTED_MODULE_4__/* .siteSettings */ .U === null || _settings_site_settings__WEBPACK_IMPORTED_MODULE_4__/* .siteSettings */ .U === void 0 ? void 0 : (ref1 = _settings_site_settings__WEBPACK_IMPORTED_MODULE_4__/* .siteSettings.avatar */ .U.avatar) === null || ref1 === void 0 ? void 0 : ref1.placeholder,
                            ...rest,
                            alt: shop === null || shop === void 0 ? void 0 : shop.name
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h2", {
                            className: "ml-2 text-xs font-semibold text-[#64748B]",
                            children: shop === null || shop === void 0 ? void 0 : shop.name
                        })
                    ]
                })
            ]
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HeaderView);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7811:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(89699);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var next_image__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(38579);
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(1635);
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(dayjs__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(14195);
/* harmony import */ var dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(36619);
/* harmony import */ var dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(53291);
/* harmony import */ var dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(28379);
/* harmony import */ var _components_icons_message_avatar_placeholder_icon__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(36459);
/* harmony import */ var _utils_auth_utils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(49239);
/* harmony import */ var _data_conversations__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(84891);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_utils_auth_utils__WEBPACK_IMPORTED_MODULE_12__, _data_conversations__WEBPACK_IMPORTED_MODULE_13__]);
([_utils_auth_utils__WEBPACK_IMPORTED_MODULE_12__, _data_conversations__WEBPACK_IMPORTED_MODULE_13__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);














dayjs__WEBPACK_IMPORTED_MODULE_6___default().extend((dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_7___default()));
dayjs__WEBPACK_IMPORTED_MODULE_6___default().extend((dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_8___default()));
dayjs__WEBPACK_IMPORTED_MODULE_6___default().extend((dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_9___default()));
const UserListView = ({ conversation , className , ...rest })=>{
    var ref, ref1, ref2, ref3, ref4, ref5, ref6, ref7, ref8, ref9, ref10, ref11, ref12, ref13, ref14, ref15, ref16;
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_2__.useRouter)();
    const { mutate: createSeenMessage  } = (0,_data_conversations__WEBPACK_IMPORTED_MODULE_13__/* .useMessageSeen */ .uX)();
    const { permissions  } = (0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_12__/* .getAuthCredentials */ .WA)();
    let permission = (0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_12__/* .hasAccess */ .Ft)(_utils_auth_utils__WEBPACK_IMPORTED_MODULE_12__/* .adminOnly */ .M$, permissions);
    const routes = permission ? _config_routes__WEBPACK_IMPORTED_MODULE_10__/* .Routes */ .Z === null || _config_routes__WEBPACK_IMPORTED_MODULE_10__/* .Routes */ .Z === void 0 ? void 0 : (ref = _config_routes__WEBPACK_IMPORTED_MODULE_10__/* .Routes.message */ .Z.message) === null || ref === void 0 ? void 0 : ref.details(conversation === null || conversation === void 0 ? void 0 : conversation.id) : _config_routes__WEBPACK_IMPORTED_MODULE_10__/* .Routes */ .Z === null || _config_routes__WEBPACK_IMPORTED_MODULE_10__/* .Routes */ .Z === void 0 ? void 0 : (ref1 = _config_routes__WEBPACK_IMPORTED_MODULE_10__/* .Routes.shopMessage */ .Z.shopMessage) === null || ref1 === void 0 ? void 0 : ref1.details(conversation === null || conversation === void 0 ? void 0 : conversation.id);
    const seenMessage = (unseen)=>{
        if (unseen) {
            createSeenMessage({
                id: conversation === null || conversation === void 0 ? void 0 : conversation.id
            });
        }
    };
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
            className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('relative cursor-pointer border-b border-solid border-b-[#E5E7EB] transition-all duration-500 hover:bg-[#e4e5e7]', Number(router === null || router === void 0 ? void 0 : (ref2 = router.query) === null || ref2 === void 0 ? void 0 : ref2.id) === Number(conversation === null || conversation === void 0 ? void 0 : conversation.id) ? 'bg-[#F3F4F6]' : '', Boolean(conversation === null || conversation === void 0 ? void 0 : (ref3 = conversation.shop) === null || ref3 === void 0 ? void 0 : ref3.is_active) ? '' : 'bg-[#e6e7ea]', className),
            onClick: ()=>{
                router.push(`${routes}`);
                seenMessage(Boolean(conversation === null || conversation === void 0 ? void 0 : conversation.unseen));
            },
            ...rest,
            children: [
                Boolean(conversation === null || conversation === void 0 ? void 0 : conversation.unseen) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                    className: "absolute left-2 top-1/2 z-50 h-[.375rem] w-[.375rem] -translate-y-1/2 transform rounded-full bg-[#EF4444]"
                }) : '',
                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('flex w-full gap-x-3 p-3 sm:p-6', !lodash_isEmpty__WEBPACK_IMPORTED_MODULE_4___default()(conversation === null || conversation === void 0 ? void 0 : (ref4 = conversation.latest_message) === null || ref4 === void 0 ? void 0 : ref4.body) ? 'items-center' : ''),
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                            className: "relative h-8 w-8 overflow-hidden rounded-full 2xl:h-10 2xl:w-10",
                            children: !lodash_isEmpty__WEBPACK_IMPORTED_MODULE_4___default()(conversation === null || conversation === void 0 ? void 0 : (ref5 = conversation.shop) === null || ref5 === void 0 ? void 0 : (ref6 = ref5.logo) === null || ref6 === void 0 ? void 0 : ref6.thumbnail) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(next_image__WEBPACK_IMPORTED_MODULE_5__["default"], {
                                // @ts-ignore
                                src: conversation === null || conversation === void 0 ? void 0 : (ref7 = conversation.shop) === null || ref7 === void 0 ? void 0 : (ref8 = ref7.logo) === null || ref8 === void 0 ? void 0 : ref8.thumbnail,
                                alt: conversation === null || conversation === void 0 ? void 0 : (ref9 = conversation.shop) === null || ref9 === void 0 ? void 0 : ref9.name,
                                layout: "fill",
                                objectFit: "contain",
                                className: "product-image"
                            }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_message_avatar_placeholder_icon__WEBPACK_IMPORTED_MODULE_11__/* .MessageAvatarPlaceholderIcon */ .E, {
                                className: "text-[2rem] 2xl:text-[2.5rem]",
                                color: "#DDDDDD"
                            })
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                            className: "block w-10/12",
                            children: [
                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                    className: "flex items-center justify-between",
                                    children: [
                                        lodash_isEmpty__WEBPACK_IMPORTED_MODULE_4___default()(conversation === null || conversation === void 0 ? void 0 : (ref10 = conversation.latest_message) === null || ref10 === void 0 ? void 0 : ref10.body) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h2", {
                                            className: "mr-1 w-[70%] truncate text-sm font-semibold",
                                            children: conversation === null || conversation === void 0 ? void 0 : (ref11 = conversation.shop) === null || ref11 === void 0 ? void 0 : ref11.name
                                        }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h2", {
                                            className: "mr-1 w-[70%] truncate text-sm font-semibold",
                                            children: conversation === null || conversation === void 0 ? void 0 : (ref12 = conversation.latest_message) === null || ref12 === void 0 ? void 0 : ref12.body
                                        }),
                                        (conversation === null || conversation === void 0 ? void 0 : (ref13 = conversation.latest_message) === null || ref13 === void 0 ? void 0 : ref13.created_at) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                                            className: "truncate text-xs text-[#686D73]",
                                            children: dayjs__WEBPACK_IMPORTED_MODULE_6___default()().to(dayjs__WEBPACK_IMPORTED_MODULE_6___default().utc(conversation === null || conversation === void 0 ? void 0 : (ref14 = conversation.latest_message) === null || ref14 === void 0 ? void 0 : ref14.created_at))
                                        }) : ''
                                    ]
                                }),
                                !lodash_isEmpty__WEBPACK_IMPORTED_MODULE_4___default()(conversation === null || conversation === void 0 ? void 0 : (ref15 = conversation.latest_message) === null || ref15 === void 0 ? void 0 : ref15.body) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                                    className: "text-xs text-[#64748B]",
                                    children: conversation === null || conversation === void 0 ? void 0 : (ref16 = conversation.shop) === null || ref16 === void 0 ? void 0 : ref16.name
                                }) : ''
                            ]
                        })
                    ]
                })
            ]
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserListView);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 52371:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(89699);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1635);
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(dayjs__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(14195);
/* harmony import */ var dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(36619);
/* harmony import */ var dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(53291);
/* harmony import */ var dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _components_ui_error_message__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(30110);
/* harmony import */ var _components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(47898);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _components_common_avatar__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(65204);
/* harmony import */ var _settings_site_settings__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(37070);
/* harmony import */ var _components_message_views_no_message_found__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(67481);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _utils_use_window_size__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(79560);
/* harmony import */ var _utils_constants__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(30957);
/* harmony import */ var _floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(91017);
/* harmony import */ var _components_icons_arrow_down__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(99172);
/* harmony import */ var _data_user__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(93691);
/* harmony import */ var _utils_auth_utils__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(49239);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_settings_site_settings__WEBPACK_IMPORTED_MODULE_12__, _floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_16__, _data_user__WEBPACK_IMPORTED_MODULE_18__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_19__]);
([_settings_site_settings__WEBPACK_IMPORTED_MODULE_12__, _floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_16__, _data_user__WEBPACK_IMPORTED_MODULE_18__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_19__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






















dayjs__WEBPACK_IMPORTED_MODULE_4___default().extend((dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_5___default()));
dayjs__WEBPACK_IMPORTED_MODULE_4___default().extend((dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_6___default()));
dayjs__WEBPACK_IMPORTED_MODULE_4___default().extend((dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_7___default()));
const UserMessageView = ({ conversation: conversation1 , className , id , listen , messages =[] , error , loading , classes , isSuccess , children , isLoadingMore , isFetching , ...rest })=>{
    const { query  } = (0,next_router__WEBPACK_IMPORTED_MODULE_2__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_10__.useTranslation)();
    const { width  } = (0,_utils_use_window_size__WEBPACK_IMPORTED_MODULE_15__/* .useWindowSize */ .i)();
    const { 0: visible , 1: setVisible  } = (0,react__WEBPACK_IMPORTED_MODULE_14__.useState)(false);
    const { data , isLoading: meLoading , error: meError  } = (0,_data_user__WEBPACK_IMPORTED_MODULE_18__/* .useMeQuery */ .UE)();
    const { permissions  } = (0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_19__/* .getAuthCredentials */ .WA)();
    let permission = (0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_19__/* .hasAccess */ .Ft)(_utils_auth_utils__WEBPACK_IMPORTED_MODULE_19__/* .adminOnly */ .M$, permissions);
    const { x , y , reference , floating , strategy , update , refs  } = (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_16__.useFloating)({
        strategy: 'fixed',
        placement: 'bottom',
        middleware: [
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_16__.offset)(-80),
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_16__.flip)(),
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_16__.shift)()
        ]
    });
    // scroll to bottom
    (0,react__WEBPACK_IMPORTED_MODULE_14__.useEffect)(()=>{
        const chatBody = document.getElementById('chatBody');
        // @ts-ignore
        chatBody === null || chatBody === void 0 ? void 0 : chatBody.scrollTo({
            top: chatBody === null || chatBody === void 0 ? void 0 : chatBody.scrollHeight
        });
        if (!refs.reference.current || !refs.floating.current) {
            return;
        }
        return (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_16__.autoUpdate)(refs.reference.current, refs.floating.current, update);
    }, [
        query === null || query === void 0 ? void 0 : query.id,
        isSuccess,
        refs.reference,
        refs.floating,
        update
    ]);
    const chatBody1 = document.getElementById('chatBody');
    const scrollToBottom = ()=>{
        chatBody1 === null || chatBody1 === void 0 ? void 0 : chatBody1.scrollTo({
            top: chatBody1 === null || chatBody1 === void 0 ? void 0 : chatBody1.scrollHeight,
            behavior: 'smooth'
        });
    };
    (0,react__WEBPACK_IMPORTED_MODULE_14__.useEffect)(()=>{
        const chatBody = document.getElementById('chatBody');
        const toggleVisible = ()=>{
            if (Number(Number(chatBody === null || chatBody === void 0 ? void 0 : chatBody.scrollHeight) - Number(chatBody === null || chatBody === void 0 ? void 0 : chatBody.clientHeight)) !== Number(chatBody === null || chatBody === void 0 ? void 0 : chatBody.scrollTop) && Number(chatBody === null || chatBody === void 0 ? void 0 : chatBody.clientHeight) <= Number(chatBody === null || chatBody === void 0 ? void 0 : chatBody.scrollHeight)) {
                setVisible(true);
            } else {
                setVisible(false);
            }
        };
        chatBody === null || chatBody === void 0 ? void 0 : chatBody.addEventListener('scroll', toggleVisible);
        return ()=>{
            chatBody === null || chatBody === void 0 ? void 0 : chatBody.removeEventListener('scroll', toggleVisible);
        };
    }, [
        loading
    ]);
    if (loading || meLoading) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
        className: "!h-full flex-1",
        text: t('common:text-loading')
    }));
    if (meError) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        className: "!h-full flex-1",
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_error_message__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
            message: meError === null || meError === void 0 ? void 0 : meError.message
        })
    }));
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
            id: id,
            className: "relative flex-auto overflow-y-auto overflow-x-hidden px-6 pt-10 pb-14",
            style: {
                maxHeight: width >= _utils_constants__WEBPACK_IMPORTED_MODULE_20__/* .RESPONSIVE_WIDTH */ .h2 ? 'calc(100vh - 336px)' : 'calc(100vh - 300px)'
            },
            ref: reference,
            ...rest,
            children: [
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                    onClick: scrollToBottom,
                    className: `flex h-10 w-10 transform cursor-pointer rounded-full border border-solid border-[#F3F4F6] bg-[#F3F4F6] text-black shadow-lg transition-all duration-300 hover:border-accent-hover hover:bg-accent-hover hover:text-white ${visible ? 'visible translate-y-0 opacity-100' : 'invisible translate-y-1 opacity-0'}`,
                    ref: floating,
                    style: {
                        position: strategy,
                        top: y !== null && y !== void 0 ? y : '',
                        left: x !== null && x !== void 0 ? x : '',
                        zIndex: 50
                    },
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_arrow_down__WEBPACK_IMPORTED_MODULE_17__/* .ArrowDown */ .K, {
                        height: "14",
                        width: "14",
                        className: "m-auto"
                    })
                }),
                "\xa0",
                children,
                isSuccess ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                    children: !lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3___default()(messages) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "space-y-6",
                        children: messages === null || messages === void 0 ? void 0 : messages.map((item, key)=>{
                            var ref, ref1, ref2, ref3, ref4, ref5, ref6;
                            const { body , created_at , user_id , conversation  } = item;
                            const checkUser = Number(data === null || data === void 0 ? void 0 : data.id) === Number(user_id);
                            let avatarUrl = !permission ? conversation === null || conversation === void 0 ? void 0 : (ref = conversation.user) === null || ref === void 0 ? void 0 : (ref1 = ref.profile) === null || ref1 === void 0 ? void 0 : (ref2 = ref1.avatar) === null || ref2 === void 0 ? void 0 : ref2.thumbnail : item === null || item === void 0 ? void 0 : (ref3 = item.conversation) === null || ref3 === void 0 ? void 0 : (ref4 = ref3.shop) === null || ref4 === void 0 ? void 0 : (ref5 = ref4.logo) === null || ref5 === void 0 ? void 0 : ref5.thumbnail;
                            return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                className: `flex w-full gap-x-3 ${checkUser ? 'flex-row-reverse' : ''}`,
                                children: [
                                    checkUser ? null : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                        className: "w-10",
                                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_avatar__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z, {
                                            src: avatarUrl !== null && avatarUrl !== void 0 ? avatarUrl : _settings_site_settings__WEBPACK_IMPORTED_MODULE_12__/* .siteSettings */ .U === null || _settings_site_settings__WEBPACK_IMPORTED_MODULE_12__/* .siteSettings */ .U === void 0 ? void 0 : (ref6 = _settings_site_settings__WEBPACK_IMPORTED_MODULE_12__/* .siteSettings.avatar */ .U.avatar) === null || ref6 === void 0 ? void 0 : ref6.placeholder,
                                            ...rest,
                                            alt: "avatar"
                                        })
                                    }),
                                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                        className: `w-full sm:w-2/4 ${checkUser ? 'text-right' : 'text-left'}`,
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                className: "space-y-1",
                                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h2", {
                                                    className: `${classnames__WEBPACK_IMPORTED_MODULE_1___default()(classes === null || classes === void 0 ? void 0 : classes.common, checkUser ? classes === null || classes === void 0 ? void 0 : classes.default : classes === null || classes === void 0 ? void 0 : classes.reverse)}`,
                                                    children: body.replace(/['"]+/g, '')
                                                })
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                className: "mt-2 text-xs text-[#686D73]",
                                                children: dayjs__WEBPACK_IMPORTED_MODULE_4___default()().to(dayjs__WEBPACK_IMPORTED_MODULE_4___default().utc(created_at))
                                            })
                                        ]
                                    })
                                ]
                            }, key));
                        })
                    }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_message_views_no_message_found__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z, {})
                    })
                }) : ''
            ]
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserMessageView);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 67481:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ no_message_found)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(16689);
// EXTERNAL MODULE: external "next-i18next"
var external_next_i18next_ = __webpack_require__(11377);
;// CONCATENATED MODULE: ./src/components/icons/no-message-found.tsx

const NoMessageFound = (props)=>/*#__PURE__*/ (0,jsx_runtime_.jsxs)("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        ...props,
        viewBox: "0 0 169 160",
        fill: "none",
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#DFDFDF",
                d: "M71.73 160c39.615 0 71.729-6.001 71.729-13.403s-32.114-13.403-71.73-13.403C32.115 133.194 0 139.195 0 146.597S32.114 160 71.73 160Z"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#DFDFDF",
                fillRule: "evenodd",
                d: "m129.11 107.222-25.313-31.153c-1.215-1.466-2.99-2.354-4.86-2.354H44.515c-1.869 0-3.644.888-4.858 2.354l-25.312 31.153v16.275H129.11v-16.275h-.001Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#ECEBEB",
                fillRule: "evenodd",
                d: "m121.773 124.723-22.12-26.569c-1.059-1.277-2.652-1.975-4.283-1.975H47.91c-1.629 0-3.223.698-4.282 1.975l-22.12 26.569v14.592h100.265v-14.592Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#FAFAFA",
                fillRule: "evenodd",
                d: "M35.79 33.507h71.874a4.234 4.234 0 0 1 4.232 4.232v98.758a4.235 4.235 0 0 1-1.239 2.993 4.237 4.237 0 0 1-2.993 1.239H35.791a4.234 4.234 0 0 1-4.232-4.232V37.739a4.232 4.232 0 0 1 4.232-4.232Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#BBB",
                fillRule: "evenodd",
                d: "M45.152 44.037h53.15a2.116 2.116 0 0 1 2.117 2.116v26.405a2.115 2.115 0 0 1-2.116 2.116H45.152a2.116 2.116 0 0 1-2.116-2.116V46.153a2.116 2.116 0 0 1 2.116-2.116Zm.277 42.123h52.597a2.394 2.394 0 0 1 0 4.787H45.429a2.394 2.394 0 0 1 0-4.787Zm0 12.446h52.597a2.393 2.393 0 1 1 0 4.787H45.429a2.393 2.393 0 1 1 0-4.787Zm83.448 46.025c-.82 3.249-3.7 5.671-7.126 5.671H21.703c-3.426 0-6.305-2.423-7.124-5.671a7.73 7.73 0 0 1-.235-1.894v-35.514h27.844c3.076 0 5.555 2.59 5.555 5.735V113c0 3.143 2.507 5.681 5.583 5.681h36.803c3.075 0 5.583-2.561 5.583-5.705v-.013c0-3.144 2.479-5.741 5.554-5.741h27.845v35.516c0 .653-.082 1.287-.234 1.893ZM131.378 35.223l-7.226 2.804a1.057 1.057 0 0 1-1.393-1.302l2.049-6.567c-2.739-3.114-4.347-6.913-4.347-11.011C120.461 8.572 131.166 0 144.372 0c13.203 0 23.909 8.572 23.909 19.147s-10.705 19.146-23.91 19.146c-4.791 0-9.251-1.127-12.993-3.07Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#fff",
                d: "M153.788 22.604c1.664 0 3.014-1.333 3.014-2.978 0-1.645-1.35-2.979-3.014-2.979-1.665 0-3.015 1.334-3.015 2.979s1.35 2.978 3.015 2.978Z"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#fff",
                fillRule: "evenodd",
                d: "M137.966 22.231h-6.028l3.066-5.212 2.962 5.212Zm3.768-5.212h5.274v5.212h-5.274V17.02Z",
                clipRule: "evenodd"
            })
        ]
    })
;

;// CONCATENATED MODULE: ./src/components/message/views/no-message-found.tsx




const MessageNotFound = ({ ...rest })=>{
    const { t  } = (0,external_next_i18next_.useTranslation)();
    return(/*#__PURE__*/ jsx_runtime_.jsx(jsx_runtime_.Fragment, {
        children: /*#__PURE__*/ jsx_runtime_.jsx("div", {
            className: "flex h-full",
            ...rest,
            children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                className: "m-auto",
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        className: "mb-8",
                        children: /*#__PURE__*/ jsx_runtime_.jsx(NoMessageFound, {})
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("p", {
                        className: "font-semibold text-[#686D73]",
                        children: t('text-no-message-found')
                    })
                ]
            })
        })
    }));
};
/* harmony default export */ const no_message_found = (MessageNotFound);


/***/ }),

/***/ 92846:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ MessagePageIndex)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_message_user_list_index__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(75208);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_message_user_message_index__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(29853);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_message_user_list_index__WEBPACK_IMPORTED_MODULE_1__, _components_message_user_message_index__WEBPACK_IMPORTED_MODULE_3__]);
([_components_message_user_list_index__WEBPACK_IMPORTED_MODULE_1__, _components_message_user_message_index__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




function MessagePageIndex() {
    const { query  } = (0,next_router__WEBPACK_IMPORTED_MODULE_2__.useRouter)();
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: (query === null || query === void 0 ? void 0 : query.id) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_message_user_message_index__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {}) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_message_user_list_index__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {})
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 71246:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ select_conversation)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
// EXTERNAL MODULE: external "classnames"
var external_classnames_ = __webpack_require__(59003);
var external_classnames_default = /*#__PURE__*/__webpack_require__.n(external_classnames_);
;// CONCATENATED MODULE: ./src/components/icons/select-conversation.tsx

const SelectConversationIcon = ({ width ='291px' , height ='370px' , ...props })=>/*#__PURE__*/ (0,jsx_runtime_.jsxs)("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        width: width,
        height: height,
        ...props,
        fill: "none",
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#DFDFDF",
                fillRule: "evenodd",
                d: "M184.45 370c54.024 0 98.086-1.828 98.086-4.072 0-2.245-44.062-4.076-98.086-4.076-54.025 0-98.089 1.829-98.089 4.07 0 2.24 44.066 4.078 98.089 4.078Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#BBB",
                fillRule: "evenodd",
                d: "M282.464 155.17H143.192c-3.178 0-2.834 9.918-3.543 13.073L97.305 354.766c-.717 3.158 6.738 10.822 9.916 10.822h139.271c3.178 0 6.281-2.6 6.896-5.776l37.089-191.561c.606-3.186-4.833-13.081-8.013-13.081Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#C2C2C3",
                fillRule: "evenodd",
                d: "M282.464 154.866H143.192c-2.592 0-3.053 5.403-3.411 9.601-.129 1.519-.246 2.875-.436 3.709L97.009 354.708a2.421 2.421 0 0 0-.056.523c0 1.667 1.571 4.139 3.557 6.271 1.986 2.132 4.377 3.939 6.071 4.322.21.049.424.075.64.077h139.272a7.279 7.279 0 0 0 4.605-1.769 7.497 7.497 0 0 0 2.588-4.258l37.083-191.573c.036-.202.053-.407.052-.613 0-1.808-1.192-4.845-2.766-7.502-1.592-2.674-3.597-4.981-5.21-5.291a2.026 2.026 0 0 0-.381-.038v.009Zm-139.272.608h139.272c.09 0 .18.009.269.027 1.425.275 3.286 2.457 4.793 5.002 1.53 2.569 2.682 5.483 2.682 7.185.002.167-.011.334-.04.498L253.09 359.768a6.892 6.892 0 0 1-2.384 3.903 6.669 6.669 0 0 1-4.213 1.628H107.221a2.428 2.428 0 0 1-.509-.063c-1.565-.356-3.853-2.098-5.758-4.143-1.904-2.044-3.392-4.347-3.392-5.858-.001-.13.013-.26.041-.387l42.334-186.534c.209-.886.319-2.259.45-3.793.338-3.958.773-9.047 2.805-9.047Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#fff",
                fillRule: "evenodd",
                d: "M280.532 155.168H141.264c-3.178 0-6.281 2.601-6.896 5.779L97.293 352.522c-.626 3.178 1.481 5.777 4.657 5.777h139.274c3.178 0 6.281-2.599 6.896-5.777l37.072-191.565c.614-3.188-1.482-5.789-4.66-5.789Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#C2C2C3",
                fillRule: "evenodd",
                d: "M280.53 154.863H141.264a7.269 7.269 0 0 0-4.601 1.77 7.5 7.5 0 0 0-2.593 4.255L96.984 352.474a5.967 5.967 0 0 0-.112 1.152 5.023 5.023 0 0 0 1.091 3.191 4.881 4.881 0 0 0 2.885 1.692c.359.07.725.105 1.092.104h139.274a7.292 7.292 0 0 0 4.605-1.769 7.511 7.511 0 0 0 2.588-4.256l37.08-191.577c.076-.379.114-.764.115-1.15a5.003 5.003 0 0 0-1.094-3.191 4.852 4.852 0 0 0-2.882-1.694 5.838 5.838 0 0 0-1.096-.104v-.009Zm-139.266.609h139.272c.329-.001.658.029.982.091.99.178 1.886.703 2.525 1.48a4.41 4.41 0 0 1 .957 2.809c0 .35-.033.699-.1 1.042l-37.089 191.58a6.897 6.897 0 0 1-2.384 3.905 6.674 6.674 0 0 1-4.213 1.626H101.94a5.367 5.367 0 0 1-.98-.092 4.265 4.265 0 0 1-2.525-1.48 4.409 4.409 0 0 1-.957-2.807c0-.35.034-.699.102-1.042l37.08-191.581a6.913 6.913 0 0 1 2.384-3.906 6.67 6.67 0 0 1 4.22-1.625Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#E8E8E8",
                fillRule: "evenodd",
                d: "m276.755 163.052-36.265 187.37H105.718l36.265-187.37h134.772Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#C2C2C3",
                fillRule: "evenodd",
                d: "m276.386 163.354-7.479 38.657c.19.098.375.209.558.309l7.659-39.567h-24.339c.123.209.242.405.357.609l23.244-.008Zm-15.838 81.85L240.24 350.115h-35.605c-.016.208-.037.404-.062.608h36.167l20.408-105.449a9.323 9.323 0 0 1-.602-.077l.002.007Zm-85.601 104.911h-68.863l15.838-81.802a12.85 12.85 0 0 1-.552-.352l-16.021 82.762h69.761a9.853 9.853 0 0 1-.165-.608h.002Zm-44.276-127.029 2.903-15.004a12.23 12.23 0 0 1-.511-.554l-3.038 15.69c.208-.052.429-.098.646-.138v.006Zm6.95-35.911 4.612-23.821h34.892l.208-.609h-35.6l-4.793 24.774c.223-.121.45-.237.681-.344Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#9D9D9D",
                fillRule: "evenodd",
                d: "M223.602 121.128s3.83 24.939 4.52 34.712c.346 4.919.848 8.868-2.242 12.173 0 0 7.691.75 10.303-1.382 0 0-.515 1.042-.986 1.509 0 0 8.603.313 12.156-2.378 5.391-3.647 1.825-76.194-24.053-70.22 0 0-23.874-2.031-21.988 21.389-.4 27.823-2.637 51.822-4.498 56.665 2.685 1.536 9.17-3.516 9.974-5.733.709-1.963 1.101-4.247 1.305-4.829 0 0-.846 6.721-1.236 7.136 0 0 9.647-1.09 13.773-4.206 4.126-3.115 4.151-40.001 2.972-44.836Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#9D9D9D",
                fillRule: "evenodd",
                d: "M233.375 139.148c-.077-.281-.15-.55-.208-.817.742-2.43.996-5.21.642-8.242 2.334-2.055 7.377-.302 11.645 1 1.863 17.187 1.842 34.582.813 35.869-2.149 2.691-7.346 2.378-7.346 2.378.244-.483.443-.988.594-1.509-1.58 2.132-6.227 1.382-6.227 1.382 1.875-3.305 1.565-7.254 1.354-12.172-.177-4.208-.71-11.25-1.267-17.889Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#F3F4F6",
                fillRule: "evenodd",
                d: "M198.898 169.822h51.368c-3.676-9.209-8.94-15.868-12.935-16.684-2.128-.563-5.739-9.32-5.691-21.726l-.969 1.25-16.128 3.195s.36 5.081.375 9.864c.015 3.986-.208 8.04-1.109 8.515a23.4 23.4 0 0 0-2.219.317s-8.751 6.139-12.692 15.269Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#DBDDDF",
                fillRule: "evenodd",
                d: "M214.541 135.853s.363 5.079.377 9.861c9.03-.256 13.8-8.492 15.753-13.056l-16.13 3.195Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#F3F4F6",
                fillRule: "evenodd",
                d: "M232.896 127.43c.021-13.306 2.78-22.219-10.851-23.007-13.631-.787-16.29 4.287-17.378 8.726-.675 2.757-.684 13.444 1.25 20.479 4.729 17.205 26.969 2.459 26.979-6.198Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#999A9B",
                fillRule: "evenodd",
                d: "M210.014 350.417c6.804-15.171 15.004-31.647 20.075-47.01a357.127 357.127 0 0 0 4.032-13.019c5.419-18.791 6.975-31.124 8.417-44.309l-52.991.417s-4.168 43.822-17.611 103.911l38.078.01Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#E8E8E8",
                fillRule: "evenodd",
                d: "M196.968 216.057c.132 25.216-3.701 36.034-3.701 36.034s22.689 11.526 49.653 3.04c.238-.077 11.208-2.584 16.757-3.851l1.953-10.078c-.525-4.77-1.059-9.663-1.286-10.147-5.693-12.22-10.015-17.584-10.691-21.344-1.25-7.016-1.279-14.275-.656-21.123 1.644-18.13 5.491-29.628 5.491-29.628-7.348-1.667-13.181-8.158-20.827-11.026-1.759 2.19-7.136 4.483-11.8 4.376-5.372-.118-7.114-2.417-6.835-4.928-5.725 3.184-10.291 6.193-10.291 6.193-4.864 8.449-14.731 16.658-15.444 29.62-.179 3.186 7.671 32.153 7.677 32.862Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#DBDDDF",
                fillRule: "evenodd",
                d: "M234.937 149.166c-2.901 1.719-5.627 2.961-8.115 3.728-3.001.928-5.669 1.163-7.872.719-2.34-.475-4.168-1.696-5.316-3.651a9.004 9.004 0 0 1-.846-1.938l2.144-.657c.151.509.361.999.626 1.459.821 1.384 2.127 2.255 3.822 2.597 1.831.371 4.126.152 6.773-.667 2.309-.713 4.876-1.876 7.631-3.518l1.153 1.928Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#8B8B8B",
                fillRule: "evenodd",
                d: "M210.015 350.417c6.804-15.171 15.004-31.647 20.074-47.01a353.017 353.017 0 0 0 4.033-13.019l-7.805-5.92s-20.189 32.699-28.883 65.949h12.581Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#999A9B",
                fillRule: "evenodd",
                d: "m254.557 277.739-34.26-3.335c.452 23.897 3.451 57.726 4.683 76.021h15.511l14.066-72.686Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#8B8B8B",
                fillRule: "evenodd",
                d: "m251.126 295.473-2.003 1.177c.578.25 1.111.592 1.58 1.013l.423-2.19Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#BBB",
                fillRule: "evenodd",
                d: "M234.739 286.485s3.224 11.653 14.379 10.165a61.77 61.77 0 0 0 1.828-.271l11.003-56.846c-4.474-21.801-6.251-47.154-9.655-63.053-1.175-5.462-9.077-7.233-9.377-10.501l-9.257-17.959s-13.803 30.978-14.547 38.788c-.743 7.811 15.626 99.677 15.626 99.677Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#A7A8A9",
                fillRule: "evenodd",
                d: "M242.545 209.809c.444 11.281 4.009 29.653 17.382 40.221l2.032-10.503c-3.814-18.837-4.42-36.726-7.78-52.358-9.55-1.99-11.912 15.676-11.634 22.64Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#BBB",
                fillRule: "evenodd",
                d: "M174.287 212.543c2.52.605 4.447.938 5.175.778 3.069-.68 7.454-33.969 9.823-45.371 3.053-14.689 14.697-17.611 14.697-17.611l11.045-2.955s-12.648 31.243-13.019 37.565c-.371 6.323-1.488 103.399-1.488 103.399s.744 4.464-7.811 2.601c-8.554-1.864-10.784-3.72-10.784-3.72s3.705-27.136 5.447-51.226c-2.846-.486-7.762-2.332-13.085-4.598v-18.862Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#9D9D9D",
                fillRule: "evenodd",
                d: "M211.112 106.267c-11.345 6.655-7.775 11.187-10.711 17.229 0 0-3.406-11.689 1.919-18.131 5.648-6.846 8.792.902 8.792.902Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#9D9D9D",
                fillRule: "evenodd",
                d: "M209.862 103.604s4.483 17.564 16.649 23.184c0 0-12.166-10.791-13.202-22.386-1.036-11.595-3.447-.798-3.447-.798ZM205.438 103.748c1.507-.706 2.549-.559 3.126.44-.391 2.377-1.502 4.137-3.335 5.28.609-1.036.678-2.943.209-5.72ZM222.299 99.178c-1.988-.556-2.85-1.539-2.584-2.95 2.289-1.914 4.762-2.663 7.419-2.248-1.413.471-3.025 2.204-4.835 5.198Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#9D9D9D",
                fillRule: "evenodd",
                d: "M210.965 101.707s6.287 16.776 15.928 19.254c9.64 2.478 13.833-.102 13.833-.102s-7.398-5.881-8.93-16.134c0 0-16.094-11.004-20.831-3.018Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#9D9D9D",
                d: "M234.602 122.216a31.458 31.458 0 0 1-7.755-1.084c-9.617-2.474-15.984-19.193-16.046-19.362l-.03-.079.042-.073c1.178-1.986 3.141-2.993 5.835-2.993 6.461 0 15.161 5.893 15.247 5.954l.064.044v.075c1.505 10.063 8.795 15.963 8.867 16.021l.196.157-.208.133c-.075.048-1.999 1.207-6.212 1.207Zm-23.441-20.49c.486 1.25 6.669 16.724 15.776 19.064 2.5.676 5.075 1.036 7.665 1.073 3.315 0 5.199-.748 5.81-1.042-1.207-1.042-7.375-6.795-8.78-15.996-.798-.534-8.917-5.85-14.984-5.85-2.526.002-4.372.921-5.487 2.751Z"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#9D9D9D",
                fillRule: "evenodd",
                d: "M234.312 119.813c-2.271-2.33-4.28-2.781-6.029-1.355-.926 4.617-.1 8.604 2.478 11.96-.406-2.313.778-5.848 3.551-10.605ZM204.698 112.033c-1.229-4.584-2.507-5.934-3.832-4.049-1.146 7.49-1.06 14.437.258 20.84-.002-4.003 1.189-9.6 3.574-16.791Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#9D9D9D",
                fillRule: "evenodd",
                d: "M215.353 107.399c1.611-4.468-3.055-4.197-5.21-3.403-5.219 5.496-9.118 11.25-11.695 17.261 3.983-3.461 17.326-9.917 16.905-13.858ZM221.914 98.725c.774-.555 1.109-1.54 1.007-2.95-.894-1.915-1.857-2.664-2.889-2.247.55.475 1.178 2.207 1.882 5.197Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#DBDDDF",
                fillRule: "evenodd",
                d: "M219.829 153.227c-1.233-.208-2.477 1.065-2.784 2.851-.306 1.786.442 3.403 1.667 3.614 1.226.21 2.474-1.065 2.782-2.851.309-1.786-.433-3.401-1.665-3.614Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#DBDDDF",
                fillRule: "evenodd",
                d: "M218.443 158.7c-.758-.131-1.527.654-1.715 1.757-.187 1.102.273 2.096 1.03 2.225.756.13 1.525-.654 1.715-1.754.19-1.101-.269-2.099-1.03-2.228Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#DBDDDF",
                fillRule: "evenodd",
                d: "M217.707 162.121c-.665-.116-1.338.575-1.507 1.542-.169.967.242 1.843.907 1.957.664.115 1.338-.577 1.504-1.544.167-.967-.239-1.84-.904-1.955Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#F3F4F6",
                fillRule: "evenodd",
                d: "M265.612 188.345c-3.455-18.136-9.38-28.289-17.774-30.457 2.745 42.977 4.902 67.52 2.907 68.506-21.538-13.464-32.041-21.077-32.041-21.077-3.428-1.982-6.825-1.261-9.642.396l-12.633 4.549c-.834 2.149 3.386 1.025 10.507-.656.625 3.388 6.362 7 9.705 4.313 7.067 4.616 33.068 32.623 44.343 30.622l6.239-32.241c.019-6.954-.275-14.954-1.611-23.955Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#BBB",
                fillRule: "evenodd",
                d: "M234.091 148.155s17.278 4.841 20.56 9.718c1.115 1.65 5.239 5.627 7.803 12.825 4.107 11.539 5.931 27.368 5.933 35.594l-7.476 38.622c-9.548 1.6-34.216-20.044-44.013-29.547-.744-.721.244-3.786.319-4.778 0 0 .417-7.861 3.778-5.231 4.933 3.851 20.292 10.995 28.807 18.925 3.453 3.213-.946-16.478-1.221-17.089-.578-1.275-11.235-31.741-14.171-27.908-2.52 3.309-.319-31.131-.319-31.131Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#A7A8A9",
                fillRule: "evenodd",
                d: "M252.986 242.826c3.126 1.59 5.87 2.416 7.919 2.084l-.208 1.109c-1.459.781-3.112 1.081-5.481.067-8.351-3.574-22.067-15.005-29.987-23.045 8.165 7.521 19.925 15.807 27.757 19.785Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#999A9B",
                fillRule: "evenodd",
                d: "m191.171 191.658-3.051.019-58.395.342c-2.995.014-3.601.669-6.319 1.9l39.298 55.836 59.81 1.067c2.14-1.817 4.011-2.292 1.273-7.26l-27.652-47.211c-1.174-2.119-3.143-4.643-4.964-4.693Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#A7A8A9",
                fillRule: "evenodd",
                d: "m176.018 193.309-50.196.294c-1.58 0-3.812-.565-1.653 2.905l32.02 51.361c1.001 1.607 1.013 1.784 3.833 1.834l62.427 1.115-30.244-51.582c-4.435-7.565-5.548-5.989-16.187-5.927Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#F3F4F6",
                fillRule: "evenodd",
                d: "M149.45 230.922c2.94 9.895 2.234 9.639 1.625 9.282-7.362-4.336-8.752-8.296-7.579-14.946.146-.123.284-.246.417-.367 2.859-2.582 3.249-4.289 5.339-1.188 1.586 2.353 1.807 4.983.198 7.219Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                stroke: "#BBB",
                strokeWidth: "1.5",
                d: "M44.69 182.587c.836-35.783 23.02-110.695 105.066-124.08"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#E8E8E8",
                fillRule: "evenodd",
                d: "M166.747 38.731a29.43 29.43 0 0 1 4.702 32.365 29.428 29.428 0 0 1-28.101 16.729 29.43 29.43 0 0 1-26.997-36.63 29.437 29.437 0 0 1 30.062-22.156 29.432 29.432 0 0 1 20.334 9.692Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#BBB",
                fillRule: "evenodd",
                d: "M167.22 38.27a30.095 30.095 0 0 1 6.818 27.546 30.09 30.09 0 0 1-19.118 20.972 30.098 30.098 0 1 1 12.3-48.518Zm6.373 21.645a28.771 28.771 0 1 0-9.473 19.878 28.677 28.677 0 0 0 9.473-19.878Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("rect", {
                width: "37.235",
                height: "2.37",
                x: "131.747",
                y: "40.723",
                fill: "#BBB",
                rx: "1.185",
                transform: "rotate(21.008 131.747 40.723)"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("rect", {
                width: "37.235",
                height: "2.37",
                x: "129.927",
                y: "45.463",
                fill: "#BBB",
                rx: "1.185",
                transform: "rotate(21.008 129.927 45.463)"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("rect", {
                width: "37.235",
                height: "2.37",
                x: "128.106",
                y: "50.203",
                fill: "#BBB",
                rx: "1.185",
                transform: "rotate(21.008 128.106 50.203)"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("rect", {
                width: "37.235",
                height: "2.37",
                x: "126.286",
                y: "54.942",
                fill: "#BBB",
                rx: "1.185",
                transform: "rotate(21.008 126.286 54.942)"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("rect", {
                width: "24.823",
                height: "2.37",
                x: "124.466",
                y: "59.683",
                fill: "#BBB",
                rx: "1.185",
                transform: "rotate(21.008 124.466 59.683)"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#E8E8E8",
                fillRule: "evenodd",
                d: "M92.14 82.857a29.433 29.433 0 1 1-43.735 39.402 29.433 29.433 0 0 1 43.736-39.402Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#BBB",
                fillRule: "evenodd",
                d: "M92.614 82.396a30.099 30.099 0 1 1-44.715 40.301 30.099 30.099 0 0 1 44.715-40.301Zm6.373 21.645a28.772 28.772 0 1 0-9.474 19.878 28.658 28.658 0 0 0 9.474-19.878Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("rect", {
                width: "37.235",
                height: "2.37",
                x: "55.138",
                y: "90.064",
                fill: "#BBB",
                rx: "1.185",
                transform: "rotate(21.008 55.138 90.064)"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("rect", {
                width: "37.235",
                height: "2.37",
                x: "53.317",
                y: "94.804",
                fill: "#BBB",
                rx: "1.185",
                transform: "rotate(21.008 53.317 94.804)"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("rect", {
                width: "24.823",
                height: "2.37",
                x: "51.497",
                y: "99.544",
                fill: "#BBB",
                rx: "1.185",
                transform: "rotate(21.008 51.497 99.544)"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#E8E8E8",
                fillRule: "evenodd",
                d: "M65.727 165.233a29.432 29.432 0 1 1-43.734 39.401 29.432 29.432 0 0 1 43.734-39.401Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#BBB",
                fillRule: "evenodd",
                d: "M66.2 164.773a30.092 30.092 0 0 1 6.818 27.546A30.1 30.1 0 0 1 53.9 213.291a30.095 30.095 0 0 1-37.304-15.582 30.094 30.094 0 0 1 3.125-30.787 30.1 30.1 0 0 1 31.518-11.174 30.096 30.096 0 0 1 14.96 9.025Zm6.373 21.645a28.77 28.77 0 0 0-21.66-29.387 28.777 28.777 0 0 0-35.005 34.798A28.772 28.772 0 0 0 63.1 206.296a28.67 28.67 0 0 0 9.474-19.878Z",
                clipRule: "evenodd"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("rect", {
                width: "37.235",
                height: "2.37",
                x: "27.814",
                y: "174.81",
                fill: "#BBB",
                rx: "1.185",
                transform: "rotate(21.008 27.814 174.81)"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("rect", {
                width: "18.617",
                height: "2.37",
                x: "25.993",
                y: "179.55",
                fill: "#BBB",
                rx: "1.185",
                transform: "rotate(21.008 25.993 179.55)"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "#BBB",
                d: "M138.435 112.442a1.522 1.522 0 0 0 .006 2.154l.54.54a.255.255 0 0 1 .002.36.254.254 0 0 1-.359-.002l-1.26-1.259a1.522 1.522 0 0 0-2.153-.007 1.522 1.522 0 0 0 .007 2.154l1.259 1.259a.253.253 0 1 1-.358.358l-1.98-1.98a1.522 1.522 0 0 0-2.153-.007 1.522 1.522 0 0 0 .006 2.154l1.98 1.979c.099.099.1.261.002.36a.254.254 0 0 1-.36-.002l-7.017-7.017a1.524 1.524 0 0 0-2.154-.007 1.523 1.523 0 0 0 .007 2.154l8.445 8.445c-1.107-.172-2.969-.246-4.113.896-1.073 1.074-1.045 1.816-.712 2.15.908.908 1.607-.526 5.743 1.45 4.137 1.978 6.795 1.814 8.613.027l2.504-2.505c.014-.013-.013.014 0 0 2.547-2.546 3.276-6.027.706-8.596l-.013-.013-5.038-5.038a1.52 1.52 0 0 0-2.15-.007Z"
            })
        ]
    })
;

// EXTERNAL MODULE: external "next-i18next"
var external_next_i18next_ = __webpack_require__(11377);
;// CONCATENATED MODULE: ./src/components/message/views/select-conversation.tsx




const SelectConversation = ({ className , ...rest })=>{
    const { t  } = (0,external_next_i18next_.useTranslation)();
    return(/*#__PURE__*/ jsx_runtime_.jsx(jsx_runtime_.Fragment, {
        children: /*#__PURE__*/ jsx_runtime_.jsx("div", {
            className: external_classnames_default()('m-auto w-full', className),
            ...rest,
            children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                className: "text-center",
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx(SelectConversationIcon, {
                        className: "mx-auto mb-14"
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("h2", {
                        className: "text-xl font-medium",
                        children: t('text-select-your-conversation')
                    })
                ]
            })
        })
    }));
};
/* harmony default export */ const select_conversation = (SelectConversation);


/***/ }),

/***/ 30110:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* unused harmony export Error */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_1__);


const Error = ({ message  })=>{
    const { t  } = useTranslation('common');
    return(/*#__PURE__*/ _jsx("p", {
        className: "my-2 text-xs text-start text-red-500",
        children: t(message)
    }));
};
const ErrorMessage = ({ message  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_1__.useTranslation)('common');
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
        className: "bg-red-400 p-5 mt-16 mx-auto max-w-sm min-w-min text-center text-lg text-light font-semibold rounded",
        children: t(message)
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ErrorMessage);


/***/ }),

/***/ 79560:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "i": () => (/* reexport default from dynamic */ react_use_lib_useWindowSize__WEBPACK_IMPORTED_MODULE_0___default.a)
/* harmony export */ });
/* harmony import */ var react_use_lib_useWindowSize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(52089);
/* harmony import */ var react_use_lib_useWindowSize__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_use_lib_useWindowSize__WEBPACK_IMPORTED_MODULE_0__);



/***/ })

};
;