"use strict";
exports.id = 2051;
exports.ids = [2051];
exports.modules = {

/***/ 92051:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ CreateOrUpdateAttributeForm)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(145);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45641);
/* harmony import */ var _components_ui_button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(39258);
/* harmony import */ var _components_ui_description__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(87594);
/* harmony import */ var _components_common_card__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(81258);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _data_shop__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(10678);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _components_ui_alert__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(58788);
/* harmony import */ var react_scroll__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(83094);
/* harmony import */ var react_scroll__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_scroll__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _data_attributes__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(51384);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_hook_form__WEBPACK_IMPORTED_MODULE_2__, _data_shop__WEBPACK_IMPORTED_MODULE_8__, _data_attributes__WEBPACK_IMPORTED_MODULE_12__]);
([react_hook_form__WEBPACK_IMPORTED_MODULE_2__, _data_shop__WEBPACK_IMPORTED_MODULE_8__, _data_attributes__WEBPACK_IMPORTED_MODULE_12__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);













function CreateOrUpdateAttributeForm({ initialValues  }) {
    var ref2;
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_6__.useRouter)();
    const { 0: errorMessage , 1: setErrorMessage  } = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)(null);
    const { query: { shop  } ,  } = router;
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_7__.useTranslation)();
    const { data: shopData  } = (0,_data_shop__WEBPACK_IMPORTED_MODULE_8__/* .useShopQuery */ .DZ)({
        slug: shop
    }, {
        enabled: !!shop
    });
    const shopId = shopData === null || shopData === void 0 ? void 0 : shopData.id;
    const { register , handleSubmit , control , formState: { errors  } ,  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_2__.useForm)({
        defaultValues: initialValues ? initialValues : {
            name: '',
            values: []
        }
    });
    const { fields , append , remove  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_2__.useFieldArray)({
        control,
        name: 'values'
    });
    const { mutate: createAttribute , isLoading: creating  } = (0,_data_attributes__WEBPACK_IMPORTED_MODULE_12__/* .useCreateAttributeMutation */ .gL)();
    const { mutate: updateAttribute , isLoading: updating  } = (0,_data_attributes__WEBPACK_IMPORTED_MODULE_12__/* .useUpdateAttributeMutation */ .uT)();
    const onSubmit = (values)=>{
        if (!initialValues || !initialValues.translated_languages.includes(router.locale)) {
            createAttribute({
                language: router.locale,
                name: values.name,
                shop_id: shopId ? Number(shopId) : Number(initialValues === null || initialValues === void 0 ? void 0 : initialValues.shop_id),
                values: values === null || values === void 0 ? void 0 : values.values.map(({ id , value , meta  })=>({
                        language: router.locale,
                        value,
                        meta
                    })
                ),
                ...(initialValues === null || initialValues === void 0 ? void 0 : initialValues.slug) && {
                    slug: initialValues.slug
                }
            }, {
                onError: (error)=>{
                    var ref, ref1;
                    setErrorMessage(error === null || error === void 0 ? void 0 : (ref = error.response) === null || ref === void 0 ? void 0 : (ref1 = ref.data) === null || ref1 === void 0 ? void 0 : ref1.message);
                    react_scroll__WEBPACK_IMPORTED_MODULE_11__.animateScroll.scrollToTop();
                }
            });
        } else {
            updateAttribute({
                id: initialValues.id,
                name: values.name,
                shop_id: Number(initialValues === null || initialValues === void 0 ? void 0 : initialValues.shop_id),
                values: values.values.map(({ id , value , meta  })=>({
                        language: router.locale,
                        id: Number(id),
                        value,
                        meta
                    })
                )
            });
        }
    };
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            errorMessage ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_alert__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z, {
                message: t(`common:${errorMessage}`),
                variant: "error",
                closeable: true,
                className: "mt-5",
                onClose: ()=>setErrorMessage(null)
            }) : null,
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("form", {
                onSubmit: handleSubmit(onSubmit),
                children: [
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                        className: "my-5 flex flex-wrap border-b border-dashed border-border-base pb-8 sm:my-8",
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                                title: t('common:attribute'),
                                details: `${initialValues ? t('form:item-description-update') : t('form:item-description-add')} ${t('form:form-description-attribute-name')}`,
                                className: "sm:pe-4 md:pe-5 w-full px-0 pb-5 sm:w-4/12 sm:py-8 md:w-1/3"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_card__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                className: "w-full sm:w-8/12 md:w-2/3",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                    label: t('form:input-label-name'),
                                    ...register('name', {
                                        required: 'Name is required'
                                    }),
                                    error: t((ref2 = errors.name) === null || ref2 === void 0 ? void 0 : ref2.message),
                                    variant: "outline",
                                    className: "mb-5"
                                })
                            })
                        ]
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                        className: "my-5 flex flex-wrap sm:my-8",
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                                title: t('common:attribute-values'),
                                details: `${initialValues ? t('form:item-description-update') : t('form:item-description-add')} ${t('form:form-description-attribute-value')}`,
                                className: "sm:pe-4 md:pe-5 w-full px-0 pb-5 sm:w-4/12 sm:py-8 md:w-1/3"
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_common_card__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                className: "w-full sm:w-8/12 md:w-2/3",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                        children: fields.map((item, index)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                className: "border-b border-dashed border-border-200 py-5 last:border-0 md:py-8",
                                                children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                    className: "grid grid-cols-1 gap-5 sm:grid-cols-5",
                                                    children: [
                                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                                            className: "sm:col-span-2",
                                                            label: t('form:input-label-value'),
                                                            variant: "outline",
                                                            ...register(`values.${index}.value`),
                                                            defaultValue: item.value
                                                        }),
                                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                                            className: "sm:col-span-2",
                                                            label: t('form:input-label-meta'),
                                                            variant: "outline",
                                                            ...register(`values.${index}.meta`),
                                                            defaultValue: item.meta
                                                        }),
                                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                                                            onClick: ()=>remove(index)
                                                            ,
                                                            type: "button",
                                                            className: "text-sm text-red-500 transition-colors duration-200 hover:text-red-700 focus:outline-none sm:col-span-1 sm:mt-4",
                                                            children: t('form:button-label-remove')
                                                        })
                                                    ]
                                                })
                                            }, item.id)
                                        )
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                                        type: "button",
                                        onClick: ()=>append({
                                                value: '',
                                                meta: ''
                                            })
                                        ,
                                        className: "w-full sm:w-auto",
                                        children: t('form:button-label-add-value')
                                    })
                                ]
                            })
                        ]
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                        className: "text-end mb-4",
                        children: [
                            initialValues && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                                variant: "outline",
                                onClick: router.back,
                                className: "me-4",
                                type: "button",
                                children: t('form:button-label-back')
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_ui_button__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                                loading: creating || updating,
                                children: [
                                    initialValues ? t('form:item-description-update') : t('form:item-description-add'),
                                    ' ',
                                    t('common:attribute')
                                ]
                            })
                        ]
                    })
                ]
            })
        ]
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;