"use strict";
exports.id = 2125;
exports.ids = [2125,5047,7029];
exports.modules = {

/***/ 75737:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_icons_close_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29581);
/* harmony import */ var _components_icons_search_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(44066);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(45641);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_hook_form__WEBPACK_IMPORTED_MODULE_5__]);
react_hook_form__WEBPACK_IMPORTED_MODULE_5__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







const classes = {
    root: 'ps-10 pe-4 h-12 flex items-center w-full rounded appearance-none transition duration-300 ease-in-out text-heading text-sm focus:outline-none focus:ring-0',
    normal: 'bg-gray-100 border border-border-base focus:shadow focus:bg-light focus:border-accent',
    solid: 'bg-gray-100 border border-border-100 focus:bg-light focus:border-accent',
    outline: 'border border-border-base focus:border-accent',
    shadow: 'focus:shadow'
};
const Search = ({ className , onSearch , variant ='outline' , shadow =false , inputClassName , ...rest })=>{
    const { register , handleSubmit , watch , reset , formState: { errors  } ,  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_5__.useForm)({
        defaultValues: {
            searchText: ''
        }
    });
    const searchText = watch('searchText');
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_6__.useTranslation)();
    (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(()=>{
        if (!searchText) {
            onSearch({
                searchText: ''
            });
        }
    }, [
        searchText
    ]);
    const rootClassName = classnames__WEBPACK_IMPORTED_MODULE_3___default()(classes.root, {
        [classes.normal]: variant === 'normal',
        [classes.solid]: variant === 'solid',
        [classes.outline]: variant === 'outline'
    }, {
        [classes.shadow]: shadow
    }, inputClassName);
    function clear() {
        reset();
        onSearch({
            searchText: ''
        });
    }
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("form", {
        noValidate: true,
        role: "search",
        className: classnames__WEBPACK_IMPORTED_MODULE_3___default()('relative flex w-full items-center', className),
        onSubmit: handleSubmit(onSearch),
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
                htmlFor: "search",
                className: "sr-only",
                children: t('form:input-label-search')
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                className: "start-1 absolute p-2 text-body outline-none focus:outline-none active:outline-none",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_search_icon__WEBPACK_IMPORTED_MODULE_2__/* .SearchIcon */ .W, {
                    className: "h-5 w-5"
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                type: "text",
                id: "search",
                ...register('searchText'),
                className: rootClassName,
                placeholder: t('form:input-placeholder-search'),
                "aria-label": "Search",
                autoComplete: "off",
                ...rest
            }),
            errors.searchText && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                children: errors.searchText.message
            }),
            !!searchText && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                type: "button",
                onClick: clear,
                className: "end-1 absolute p-2 text-body outline-none focus:outline-none active:outline-none",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_close_icon__WEBPACK_IMPORTED_MODULE_1__/* .CloseIcon */ .T, {
                    className: "h-5 w-5"
                })
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Search);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 11347:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_": () => (/* binding */ ChevronDown)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const ChevronDown = ({ color ='currentColor' , width ='14px' , height ='10px' , ...props })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        width: width,
        height: height,
        ...props,
        fill: "none",
        xmlns: "http://www.w3.org/2000/svg",
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            d: "M13.4 1.845a.91.91 0 0 0-1.613-.6L7.015 6.817l-4.771-5.57A.91.91 0 1 0 .866 2.428l5.457 6.378a.91.91 0 0 0 1.385 0l5.462-6.378a.91.91 0 0 0 .23-.583Z",
            fill: color
        })
    }));
};


/***/ }),

/***/ 29998:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "A": () => (/* binding */ NoShop)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const NoShop = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 691.487 570.974",
        ...props,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("g", {
            "data-name": "Group 36290",
            children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("g", {
                "data-name": "Group 36289",
                children: [
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("g", {
                        "data-name": "Group 36286",
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                "data-name": "Path 22666",
                                d: "M87.231 120.963A12.417 12.417 0 0198 110.563c4.914-.518 7.667.088 9.729-2.194s9.5-6.083 14.549-.306.552 9.248.574 18.751 4.406 33.812-14.833 33.812-21.7-11.8-21.387-22.51c.276-9.526.4-15.837.599-17.153z",
                                fill: "#48585e"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                "data-name": "Path 22667",
                                d: "M90.171 119.004s22 .651 28-1.423c0 0 6.785 28.719-2.539 28.719-2.8 0-1.074-5.648-9.383-5.648-7.777 0-8.691 5.033-10.88 4.815-3.838-.382-5.882-1.486-6.4-7.851s1.202-18.612 1.202-18.612z",
                                fill: "#f3ebe2"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                "data-name": "Path 22668",
                                d: "M108.024 160.621a28.861 28.861 0 01-11.447-1.988l-1.971 12.4c11.258 8.639 23.014 0 23.014 0l-1.763-12.292a15.218 15.218 0 01-7.833 1.88z",
                                fill: "#f3ebe2"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                "data-name": "Path 22669",
                                d: "M161.878 215.103s-2.74-8.38-9.9-21.339-22.606-19-34.37-22.73c0 0-11.756 8.638-23.014 0-12.466 2.46-42.217 9.39-42.217 9.39L49.85 215l11.532 1.818-2.441 62.962h83.32l-2.417-43.118z",
                                fill: "#dbdbdb"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                "data-name": "Path 22670",
                                d: "M91.644 116.914a13.068 13.068 0 00-12.189 17.779l-19.58 9.635.565 1.978 20.845-8.357v-.007a13.067 13.067 0 1010.362-21.028zm0 24.151a11.083 11.083 0 1111.083-11.083 11.083 11.083 0 01-11.083 11.083z",
                                fill: "#48585e"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                "data-name": "Path 22671",
                                d: "M52.381 180.424c-6.358 1.494-12.508 2.791-12.508 2.791s22.065-29.993 25.478-30.893 8.027-2.355 9.616-5.025 4.821-11.7 3.106-12.385-2.071.491-2.071.491-11.231-7.7-11.122-2.958c0 0-3.871-1.279-3.641 1.361 0 0-4.124-1.354-4.11 1.848 0 0-3.868-1.718-3.224 2.966 0 0-40.715 41.5-40.516 53.333s37.182 13.226 37.182 13.226z",
                                fill: "#f3ebe2"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                "data-name": "Path 22672",
                                d: "M161.881 215.104c6.132 15.359 9.1 23.539 9.1 23.539s45.879 1.971 52.835.392 30.42-12.034 30.545-10.263-12.783 8.336-12.783 8.336 17.765-3.292 23.754-6.165c0 0 2.952 12.2-12.982 16.291s-11.673 3.12-20.619 4.854-59.285 11.137-69.3 8.665-20.16-26.455-20.16-26.455z",
                                fill: "#f3ebe2"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                "data-name": "Path 22673",
                                d: "M140.647 279.781l28.819 241.381h-52.343l-15.05-185.326-28.142 185.326h-51.3l39.5-241.381z",
                                fill: "#969696"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                "data-name": "Path 22674",
                                d: "M83.667 310.4a.627.627 0 01-.627.627H72.553L44.316 520.803a.627.627 0 01-.621.544.62.62 0 01-.084-.006.628.628 0 01-.538-.706l28.215-209.608H60.97a.628.628 0 110-1.255h22.071a.628.628 0 01.626.628zm49.037.627h10.354a.628.628 0 100-1.255h-22.073a.628.628 0 000 1.255h10.458L148.7 521.213a.628.628 0 00.625.576h.052a.627.627 0 00.574-.677z",
                                fill: "#48585e",
                                stroke: "#48585e",
                                strokeMiterlimit: "10"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                "data-name": "Path 22675",
                                d: "M130.18 521.162s-2.048 17.319-3.125 33.41h61.672s-.534-15.2-15.176-19.328-15.66-14.082-15.66-14.082z",
                                fill: "#48585e"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                "data-name": "Path 22676",
                                d: "M127.055 554.573v6.44h15.916l4.443-3.883 2.72 3.883h38.593v-6.44z",
                                fill: "#969696"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                "data-name": "Path 22677",
                                d: "M58.547 521.162s2.048 17.319 3.125 33.41H0s.534-15.2 15.176-19.328 15.66-14.082 15.66-14.082z",
                                fill: "#48585e"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                "data-name": "Path 22678",
                                d: "M61.672 554.573v6.44H45.756l-4.443-3.883-2.72 3.883H0v-6.44z",
                                fill: "#969696"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                "data-name": "Path 22679",
                                d: "M159.043 207.419l-18.563 18.252v10.992a.628.628 0 11-1.255 0v-24.576a.628.628 0 011.255 0v11.823l17.683-17.387a.63.63 0 11.88.9zm-99.1-25.771a.629.629 0 00-.69.558l-3.145 29.816a.627.627 0 00.558.69.613.613 0 00.067 0 .628.628 0 00.624-.562l3.145-29.816a.627.627 0 00-.561-.687zm82.328 97.507h-83.32a.628.628 0 100 1.255h83.32a.628.628 0 100-1.255z",
                                fill: "#48585e",
                                stroke: "#48585e",
                                strokeMiterlimit: "10"
                            })
                        ]
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("g", {
                        "data-name": "Group 36288",
                        children: [
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("g", {
                                "data-name": "Group 36287",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                        "data-name": "Path 22680",
                                        d: "M355.168 539.507l203.738 13.632a9.433 9.433 0 009.891-7.616L672.268 11.797A9.433 9.433 0 00661.778.649l-213.069 28a9.434 9.434 0 00-8.035 7.58l-94.137 492.092a9.433 9.433 0 008.631 11.186z",
                                        fill: "#727575",
                                        stroke: "#48585e",
                                        strokeMiterlimit: "10"
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                        "data-name": "Path 22681",
                                        d: "M645.24 27.354l-188.3 24.748-90.017 470.551 179.964 12.041z",
                                        fill: "#dbdbdb"
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                        "data-name": "Path 22682",
                                        d: "M355.168 539.507l203.739 13.632a9.432 9.432 0 009.89-7.617L672.265 11.795A9.433 9.433 0 00663.08.567c5.917-.268 29.9-.273 27.771 17.389-2.424 20.132-101.251 518.725-108.4 544.651-2.052 7.438-7.915 8.545-28.918 7.632-79.195-3.443-182.625-11.84-197.713-15.173-10.133-2.239-9.17-16.764-9.309-23.327a9.437 9.437 0 008.657 7.768z",
                                        fill: "#5a6568",
                                        stroke: "#48585e",
                                        strokeMiterlimit: "10"
                                    })
                                ]
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                "data-name": "Path 22683",
                                d: "M566.112 279.036s.876 32.7 24 32.7 29.567-28.687 29.567-28.687l52.585-271.254C674.196-.551 663.078.567 663.078.567L453.797 28.933s-12.182.859-13.127 7.3l-42.626 222.822-1.554 8.251s-4.823 30.432 19.769 32.167 32.149-28.74 32.149-28.74l4.792.573s-4.823 30.432 19.769 32.167 32.149-28.74 32.149-28.74l4.919.875s-4.823 30.432 19.769 32.167 32.149-28.74 32.149-28.74z",
                                fill: "#fff"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                "data-name": "Path 22684",
                                d: "M510.036 275.608l50.7-261.168 54.116-7.9-52.894 272.494s-7.9 29.785-32.148 28.74-19.774-32.166-19.774-32.166z",
                                fill: "#969696"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                "data-name": "Path 22685",
                                d: "M496.456 23.2l-48.048 247.532s-9.535 31.47-32.149 28.739-19.3-24.07-19.769-32.167l44.18-231.073s.208-5.547 13.127-7.3z",
                                fill: "#969696"
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("g", {
                                "data-name": "Group 36291",
                                fill: "none",
                                stroke: "#5a6568",
                                strokeLinecap: "round",
                                strokeWidth: "4",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                        "data-name": "Line 5",
                                        d: "M439.596 383.445l70.318 100.653",
                                        strokeWidth: "3.99844"
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                        "data-name": "Line 6",
                                        d: "M532.57 393.198l-107.619 83.87",
                                        strokeWidth: "3.99844"
                                    })
                                ]
                            })
                        ]
                    })
                ]
            })
        })
    })
;


/***/ }),

/***/ 90393:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "p": () => (/* binding */ PlusIcon)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const PlusIcon = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        fill: "none",
        viewBox: "0 0 24 24",
        stroke: "currentColor",
        ...props,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            strokeLinecap: "round",
            strokeLinejoin: "round",
            d: "M12 6v6m0 0v6m0-6h6m-6 0H6"
        })
    })
;


/***/ }),

/***/ 44066:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "W": () => (/* binding */ SearchIcon)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SearchIcon = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        stroke: "currentColor",
        ...props,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeWidth: 2,
            d: "M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"
        })
    })
;


/***/ }),

/***/ 77067:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "X": () => (/* binding */ ToggleIcon),
/* harmony export */   "t": () => (/* binding */ ToggleIconVertical)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const ToggleIcon = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        ...props,
        viewBox: "0 0 20 20",
        fill: "none",
        xmlns: "http://www.w3.org/2000/svg",
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            d: "M19.268 8.232a2.5 2.5 0 1 1-3.536 3.536 2.5 2.5 0 0 1 3.536-3.536ZM11.768 8.232a2.5 2.5 0 1 1-3.536 3.536 2.5 2.5 0 0 1 3.536-3.536ZM4.268 8.232a2.5 2.5 0 1 1-3.536 3.536 2.5 2.5 0 0 1 3.536-3.536Z",
            fill: "currentColor"
        })
    })
;
const ToggleIconVertical = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        ...props,
        fill: "none",
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            fill: "currentColor",
            d: "M3 4.5a2.257 2.257 0 0 0 2.25-2.25A2.257 2.257 0 0 0 3 0 2.257 2.257 0 0 0 .75 2.25 2.257 2.257 0 0 0 3 4.5Zm0 2.25A2.257 2.257 0 0 0 .75 9 2.257 2.257 0 0 0 3 11.25 2.257 2.257 0 0 0 5.25 9 2.257 2.257 0 0 0 3 6.75Zm0 6.75a2.257 2.257 0 0 0-2.25 2.25A2.257 2.257 0 0 0 3 18a2.257 2.257 0 0 0 2.25-2.25A2.257 2.257 0 0 0 3 13.5Z"
        })
    })
;


/***/ }),

/***/ 25279:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const PriorityColor = (status)=>{
    let statusColor = '';
    if ((status === null || status === void 0 ? void 0 : status.toLowerCase()) === 'high') {
        statusColor = 'bg-[#61A0FF]';
    } else if ((status === null || status === void 0 ? void 0 : status.toLowerCase()) === 'medium') {
        statusColor = 'bg-[#FFAA2C]';
    } else {
        statusColor = 'bg-[#FFD361]';
    }
    return statusColor;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PriorityColor);


/***/ }),

/***/ 81321:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_common_action_buttons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(53758);
/* harmony import */ var _components_icons_no_shop__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(29998);
/* harmony import */ var _components_store_notice_priority_color__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(25279);
/* harmony import */ var _components_ui_badge_badge__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(83002);
/* harmony import */ var _components_ui_lang_action_action__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(32361);
/* harmony import */ var _components_ui_pagination__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(61849);
/* harmony import */ var _components_ui_table__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(40447);
/* harmony import */ var _components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(99996);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(28379);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(53139);
/* harmony import */ var _utils_locals__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(10601);
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(1635);
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(dayjs__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(14195);
/* harmony import */ var dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(53291);
/* harmony import */ var dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(36619);
/* harmony import */ var dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_17__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_ui_lang_action_action__WEBPACK_IMPORTED_MODULE_4__]);
_components_ui_lang_action_action__WEBPACK_IMPORTED_MODULE_4__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



















dayjs__WEBPACK_IMPORTED_MODULE_11___default().extend((dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_12___default()));
dayjs__WEBPACK_IMPORTED_MODULE_11___default().extend((dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_14___default()));
dayjs__WEBPACK_IMPORTED_MODULE_11___default().extend((dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_13___default()));
const StoreNoticeList = ({ storeNotices , paginatorInfo , onPagination , onSort , onOrder  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_15__.useTranslation)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_16__.useRouter)();
    const { alignLeft , alignRight  } = (0,_utils_locals__WEBPACK_IMPORTED_MODULE_10__/* .useIsRTL */ .S)();
    const { 0: sortingObj , 1: setSortingObj  } = (0,react__WEBPACK_IMPORTED_MODULE_17__.useState)({
        sort: _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === null || _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === void 0 ? void 0 : _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Desc */ .As.Desc,
        column: null
    });
    const onHeaderClick = (column)=>{
        return {
            onClick: ()=>{
                onSort((currentSortDirection)=>{
                    return currentSortDirection === (_types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === null || _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === void 0 ? void 0 : _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Desc */ .As.Desc) ? _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === null || _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === void 0 ? void 0 : _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Asc */ .As.Asc : _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === null || _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === void 0 ? void 0 : _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Desc */ .As.Desc;
                });
                onOrder(column);
                setSortingObj({
                    sort: (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.sort) === (_types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === null || _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === void 0 ? void 0 : _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Desc */ .As.Desc) ? _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === null || _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === void 0 ? void 0 : _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Asc */ .As.Asc : _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === null || _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === void 0 ? void 0 : _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Desc */ .As.Desc,
                    column: column
                });
            }
        };
    };
    const columns = [
        {
            title: t('table:table-item-id'),
            dataIndex: 'id',
            key: 'id',
            align: 'center',
            width: 100
        },
        {
            title: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                title: t('table:table-item-notice'),
                ascending: (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.sort) === (_types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === null || _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === void 0 ? void 0 : _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Asc */ .As.Asc) && (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.column) === 'notice',
                isActive: (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.column) === 'notice'
            }),
            className: 'cursor-pointer',
            dataIndex: 'notice',
            key: 'notice',
            align: alignLeft,
            ellipsis: true,
            width: 200,
            onHeaderCell: ()=>onHeaderClick('notice')
            ,
            render: (text)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "whitespace-nowrap",
                    children: text
                })
        },
        {
            title: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                title: t('table:table-item-description'),
                ascending: (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.sort) === (_types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === null || _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === void 0 ? void 0 : _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Asc */ .As.Asc) && (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.column) === 'description',
                isActive: (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.column) === 'description'
            }),
            className: 'cursor-pointer',
            dataIndex: 'description',
            key: 'description',
            align: alignLeft,
            width: 300,
            ellipsis: true,
            onHeaderCell: ()=>onHeaderClick('description')
            ,
            render: (text)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "whitespace-nowrap",
                    children: text
                })
        },
        {
            title: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                title: t('table:table-item-type'),
                ascending: (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.sort) === (_types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === null || _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === void 0 ? void 0 : _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Asc */ .As.Asc) && (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.column) === 'type',
                isActive: (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.column) === 'type'
            }),
            className: 'cursor-pointer',
            dataIndex: 'type',
            key: 'type',
            align: 'center',
            width: 140,
            onHeaderCell: ()=>onHeaderClick('type')
            ,
            render: (text)=>{
                var ref;
                const typeText = text === null || text === void 0 ? void 0 : text.replace(/_/g, ' ');
                const finalResult = ((ref = typeText === null || typeText === void 0 ? void 0 : typeText.charAt(0)) === null || ref === void 0 ? void 0 : ref.toUpperCase()) + (typeText === null || typeText === void 0 ? void 0 : typeText.slice(1));
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "whitespace-nowrap",
                    children: finalResult
                }));
            }
        },
        {
            title: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                title: t('table:table-item-effective-from'),
                ascending: (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.sort) === (_types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === null || _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === void 0 ? void 0 : _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Asc */ .As.Asc) && (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.column) === 'effective_from',
                isActive: (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.column) === 'effective_from'
            }),
            className: 'cursor-pointer',
            dataIndex: 'effective_from',
            key: 'effective_from',
            align: 'center',
            width: 130,
            onHeaderCell: ()=>onHeaderClick('effective_from')
            ,
            render: (effective_from)=>{
                var ref, ref1, ref2;
                /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "whitespace-nowrap",
                    children: (ref = dayjs__WEBPACK_IMPORTED_MODULE_11___default()()) === null || ref === void 0 ? void 0 : ref.to((ref1 = (dayjs__WEBPACK_IMPORTED_MODULE_11___default()) === null || (dayjs__WEBPACK_IMPORTED_MODULE_11___default()) === void 0 ? void 0 : dayjs__WEBPACK_IMPORTED_MODULE_11___default().utc(effective_from)) === null || ref1 === void 0 ? void 0 : ref1.tz((dayjs__WEBPACK_IMPORTED_MODULE_11___default()) === null || (dayjs__WEBPACK_IMPORTED_MODULE_11___default()) === void 0 ? void 0 : (ref2 = (dayjs__WEBPACK_IMPORTED_MODULE_11___default().tz)) === null || ref2 === void 0 ? void 0 : ref2.guess()))
                });
            }
        },
        {
            title: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                title: t('table:table-item-expired-at'),
                ascending: (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.sort) === (_types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === null || _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === void 0 ? void 0 : _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Asc */ .As.Asc) && (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.column) === 'expired_at',
                isActive: (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.column) === 'expired_at'
            }),
            className: 'cursor-pointer',
            dataIndex: 'expired_at',
            key: 'expired_at',
            align: 'center',
            width: 130,
            onHeaderCell: ()=>onHeaderClick('expired_at')
            ,
            render: (expired_date)=>{
                var ref, ref3, ref4;
                /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "whitespace-nowrap",
                    children: (ref = dayjs__WEBPACK_IMPORTED_MODULE_11___default()()) === null || ref === void 0 ? void 0 : ref.to((ref3 = (dayjs__WEBPACK_IMPORTED_MODULE_11___default()) === null || (dayjs__WEBPACK_IMPORTED_MODULE_11___default()) === void 0 ? void 0 : dayjs__WEBPACK_IMPORTED_MODULE_11___default().utc(expired_date)) === null || ref3 === void 0 ? void 0 : ref3.tz((dayjs__WEBPACK_IMPORTED_MODULE_11___default()) === null || (dayjs__WEBPACK_IMPORTED_MODULE_11___default()) === void 0 ? void 0 : (ref4 = (dayjs__WEBPACK_IMPORTED_MODULE_11___default().tz)) === null || ref4 === void 0 ? void 0 : ref4.guess()))
                });
            }
        },
        {
            title: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                title: t('table:table-item-issued-by'),
                ascending: (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.sort) === (_types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === null || _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === void 0 ? void 0 : _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Asc */ .As.Asc) && (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.column) === 'creator_role',
                isActive: (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.column) === 'creator_role'
            }),
            className: 'cursor-pointer',
            dataIndex: 'creator_role',
            key: 'creator_role',
            align: 'center',
            width: 100,
            onHeaderCell: ()=>onHeaderClick('creator_role')
            ,
            render: (text)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "whitespace-nowrap",
                    children: text
                })
        },
        {
            title: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                title: t('table:table-item-priority'),
                ascending: (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.sort) === (_types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === null || _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder */ .As === void 0 ? void 0 : _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Asc */ .As.Asc) && (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.column) === 'priority',
                isActive: (sortingObj === null || sortingObj === void 0 ? void 0 : sortingObj.column) === 'priority'
            }),
            className: 'cursor-pointer',
            dataIndex: 'priority',
            key: 'priority',
            align: 'center',
            width: 120,
            onHeaderCell: ()=>onHeaderClick('priority')
            ,
            render: (text)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_badge_badge__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                    text: text,
                    className: "font-medium uppercase",
                    color: (0,_components_store_notice_priority_color__WEBPACK_IMPORTED_MODULE_18__/* ["default"] */ .Z)(text)
                })
        },
        {
            title: t('table:table-item-actions'),
            key: 'actions',
            align: alignRight,
            width: 150,
            render: (data)=>{
                if ((router === null || router === void 0 ? void 0 : router.asPath) !== '/') {
                    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_lang_action_action__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                            slug: data === null || data === void 0 ? void 0 : data.id,
                            record: data,
                            deleteModalView: "DELETE_STORE_NOTICE",
                            routes: _config_routes__WEBPACK_IMPORTED_MODULE_8__/* .Routes */ .Z === null || _config_routes__WEBPACK_IMPORTED_MODULE_8__/* .Routes */ .Z === void 0 ? void 0 : _config_routes__WEBPACK_IMPORTED_MODULE_8__/* .Routes.storeNotice */ .Z.storeNotice
                        })
                    }));
                } else {
                    var ref;
                    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_action_buttons__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        id: data === null || data === void 0 ? void 0 : data.id,
                        detailsUrl: _config_routes__WEBPACK_IMPORTED_MODULE_8__/* .Routes */ .Z === null || _config_routes__WEBPACK_IMPORTED_MODULE_8__/* .Routes */ .Z === void 0 ? void 0 : (ref = _config_routes__WEBPACK_IMPORTED_MODULE_8__/* .Routes.storeNotice */ .Z.storeNotice) === null || ref === void 0 ? void 0 : ref.details(data === null || data === void 0 ? void 0 : data.id),
                        customLocale: router === null || router === void 0 ? void 0 : router.locale
                    }));
                }
            }
        }, 
    ];
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "mb-6 overflow-hidden rounded shadow",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_table__WEBPACK_IMPORTED_MODULE_6__/* .Table */ .i, {
                    //@ts-ignore
                    columns: columns,
                    emptyText: ()=>/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                            className: "flex flex-col items-center py-6",
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                    className: "relative w-72 sm:h-80 sm:w-96",
                                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_no_shop__WEBPACK_IMPORTED_MODULE_2__/* .NoShop */ .A, {})
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                    className: "pt-6 text-sm font-semibold",
                                    children: t('table:empty-table-data')
                                })
                            ]
                        })
                    ,
                    data: storeNotices,
                    rowKey: "id",
                    scroll: {
                        x: 1000
                    }
                })
            }),
            !!(paginatorInfo === null || paginatorInfo === void 0 ? void 0 : paginatorInfo.total) && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "flex items-center justify-end",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_pagination__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                    total: paginatorInfo.total,
                    current: paginatorInfo.currentPage,
                    pageSize: paginatorInfo.perPage,
                    onChange: onPagination
                })
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StoreNoticeList);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 83002:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);



const Badge = (props)=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    const { className , color: colorOverride , textColor: textColorOverride , text , textKey , animate =false ,  } = props;
    const classes = {
        root: 'px-3 py-1 rounded-full text-xs whitespace-nowrap relative',
        animate: 'animate-pulse',
        default: 'bg-accent',
        text: 'text-light'
    };
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
            className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(classes.root, {
                [classes.default]: !colorOverride,
                [classes.text]: !textColorOverride,
                [classes.animate]: animate
            }, colorOverride, textColorOverride, className),
            children: textKey ? t(textKey) : text
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Badge);


/***/ }),

/***/ 32361:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ LanguageSwitcher)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_common_action_buttons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(53758);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(29249);
/* harmony import */ var _language_switcher__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(74675);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_config__WEBPACK_IMPORTED_MODULE_2__, _language_switcher__WEBPACK_IMPORTED_MODULE_3__]);
([_config__WEBPACK_IMPORTED_MODULE_2__, _language_switcher__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





function LanguageSwitcher({ record , slug , deleteModalView , routes , className  }) {
    const { enableMultiLang  } = _config__WEBPACK_IMPORTED_MODULE_2__/* .Config */ .D;
    const { query: { shop  } ,  } = (0,next_router__WEBPACK_IMPORTED_MODULE_4__.useRouter)();
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: enableMultiLang ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_language_switcher__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
            slug: slug,
            record: record,
            deleteModalView: deleteModalView,
            routes: routes,
            className: className
        }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_action_buttons__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
            id: record === null || record === void 0 ? void 0 : record.id,
            editUrl: routes.editWithoutLang(slug, shop),
            deleteModalView: deleteModalView
        })
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 881:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61185);
/* harmony import */ var _components_icons_chevronDownIcon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11347);
/* harmony import */ var _components_ui_link__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31434);
/* harmony import */ var _components_icons_plus_icon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(90393);
/* harmony import */ var _components_icons_edit__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(83955);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_headlessui_react__WEBPACK_IMPORTED_MODULE_3__]);
_headlessui_react__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];








const LanguageListbox = ({ title , items , translate , slug , id , routes  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_1__.useTranslation)('common');
    const { locale , query: { shop  } ,  } = (0,next_router__WEBPACK_IMPORTED_MODULE_2__.useRouter)();
    const currentSelectedItem = locale ? items === null || items === void 0 ? void 0 : items.find((o)=>{
        return (o === null || o === void 0 ? void 0 : o.value) === locale;
    }) : items[2];
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Disclosure, {
        children: ({ open  })=>{
            /*#__PURE__*/ return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                children: [
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Disclosure.Button, {
                        className: "text-left font-medium text-black w-full p-4 border-b border-solid border-[#E5E5EB] bg-white flex items-center justify-between",
                        children: [
                            title,
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                className: "text-[#8A8F9C]",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_chevronDownIcon__WEBPACK_IMPORTED_MODULE_4__/* .ChevronDown */ ._, {
                                    className: `${open ? 'rotate-180 transform origin-center' : ''} h-4 w-4`
                                })
                            })
                        ]
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Disclosure.Panel, {
                        className: "py-2",
                        children: items === null || items === void 0 ? void 0 : items.map((option, index)=>{
                            /*#__PURE__*/ return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                className: `flex items-center cursor-pointer relative px-4 py-2 transition-all hover:bg-white ${(currentSelectedItem === null || currentSelectedItem === void 0 ? void 0 : currentSelectedItem.id) === (option === null || option === void 0 ? void 0 : option.id) ? 'bg-white' : ''}`,
                                children: [
                                    option === null || option === void 0 ? void 0 : option.icon,
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                        className: "ltr:ml-3 rtl:mr-3",
                                        children: t(option === null || option === void 0 ? void 0 : option.name)
                                    }),
                                    translate === 'true' ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                        className: "ltr:ml-auto rtl:mr-auto cursor-pointer text-base transition duration-200 hover:text-heading",
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_link__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                                href: routes.edit(slug, option === null || option === void 0 ? void 0 : option.id, shop),
                                                locale: false,
                                                className: "absolute top-0 left-0 w-full h-full"
                                            }, option === null || option === void 0 ? void 0 : option.id),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_edit__WEBPACK_IMPORTED_MODULE_7__/* .EditIcon */ .d, {
                                                width: 16
                                            })
                                        ]
                                    }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                                        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                            className: "ltr:ml-auto rtl:mr-auto cursor-pointer text-base transition duration-200 hover:text-heading",
                                            children: [
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_link__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                                    href: routes.translate(slug, option === null || option === void 0 ? void 0 : option.id, shop),
                                                    locale: false,
                                                    className: "absolute top-0 left-0 w-full h-full"
                                                }, option === null || option === void 0 ? void 0 : option.id),
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_plus_icon__WEBPACK_IMPORTED_MODULE_6__/* .PlusIcon */ .p, {
                                                    width: 24
                                                })
                                            ]
                                        })
                                    })
                                ]
                            }, `language-${index}`);
                        })
                    })
                ]
            });
        }
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LanguageListbox);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 74675:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_locals__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(10601);
/* harmony import */ var _floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(91017);
/* harmony import */ var _components_common_action_buttons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(53758);
/* harmony import */ var _lang_list_box__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(881);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(29249);
/* harmony import */ var _components_ui_popover__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(85073);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__, _lang_list_box__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_8__, _components_ui_popover__WEBPACK_IMPORTED_MODULE_9__]);
([_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__, _lang_list_box__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_8__, _components_ui_popover__WEBPACK_IMPORTED_MODULE_9__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);










const LanguageSwitcher = ({ record , slug , deleteModalView , routes , className =''  })=>{
    var ref3, ref1, ref2;
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_3__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)('common');
    const { locales , locale  } = router;
    let filterItem = (ref3 = [
        ..._utils_locals__WEBPACK_IMPORTED_MODULE_4__/* .languageMenu */ .X
    ]) === null || ref3 === void 0 ? void 0 : ref3.filter((element)=>{
        return locales === null || locales === void 0 ? void 0 : locales.includes(element === null || element === void 0 ? void 0 : element.id);
    });
    let options = (ref1 = [
        ...filterItem
    ]) === null || ref1 === void 0 ? void 0 : ref1.filter((filter)=>{
        var ref;
        return !(record === null || record === void 0 ? void 0 : (ref = record.translated_languages) === null || ref === void 0 ? void 0 : ref.find((translated)=>{
            return translated === (filter === null || filter === void 0 ? void 0 : filter.value);
        }));
    });
    let filterTranslatedItem = (ref2 = [
        ..._utils_locals__WEBPACK_IMPORTED_MODULE_4__/* .languageMenu */ .X
    ]) === null || ref2 === void 0 ? void 0 : ref2.filter((element)=>{
        var ref;
        return record === null || record === void 0 ? void 0 : (ref = record.translated_languages) === null || ref === void 0 ? void 0 : ref.includes(element === null || element === void 0 ? void 0 : element.id);
    }).filter((item)=>{
        return !(locale === null || locale === void 0 ? void 0 : locale.includes(item === null || item === void 0 ? void 0 : item.id));
    });
    const { x , y , reference , floating , strategy , update , refs  } = (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.useFloating)({
        strategy: 'fixed',
        placement: 'bottom',
        middleware: [
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.offset)(20),
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.flip)(),
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.shift)()
        ]
    });
    // This one is for recalculating the position of the floating element if no space is left on the given placement
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (!refs.reference.current || !refs.floating.current) {
            return;
        }
        return (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.autoUpdate)(refs.reference.current, refs.floating.current, update);
    }, [
        refs.reference,
        refs.floating,
        update
    ]);
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: `flex w-full items-center justify-end gap-5 ${className}`,
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_action_buttons__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                id: record === null || record === void 0 ? void 0 : record.id,
                editUrl: routes.editWithoutLang(slug),
                deleteModalView: deleteModalView
            }),
            _config__WEBPACK_IMPORTED_MODULE_8__/* .Config.defaultLanguage */ .D.defaultLanguage === router.locale && // <Popover className="relative inline-block">
            //   <Popover.Button
            //     className="p-2 text-base opacity-80 transition duration-200 hover:text-heading"
            //     ref={reference}
            //   >
            //     <ToggleIcon width={20} />
            //   </Popover.Button>
            //   <div
            //     ref={floating}
            //     style={{
            //       position: strategy,
            //       top: y ?? '',
            //       left: x ?? '',
            //       zIndex: 1,
            //     }}
            //   >
            //     <Popover.Panel className="w-[18rem] max-w-[20rem] overflow-hidden rounded bg-[#F7F8F9] px-4 shadow-translatePanel sm:px-0">
            //       {options?.length ? (
            //         <LanguageListbox
            //           title={t('text-non-translated-title')}
            //           items={options}
            //           translate="false"
            //           slug={slug}
            //           id={record?.id}
            //           routes={routes}
            //         />
            //       ) : (
            //         ''
            //       )}
            //       {filterTranslatedItem?.length ? (
            //         <LanguageListbox
            //           title={t('text-translated-title')}
            //           items={filterTranslatedItem}
            //           translate="true"
            //           slug={slug}
            //           id={record?.id}
            //           routes={routes}
            //         />
            //       ) : (
            //         ''
            //       )}
            //     </Popover.Panel>
            //   </div>
            // </Popover>
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_ui_popover__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
                children: [
                    (options === null || options === void 0 ? void 0 : options.length) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_lang_list_box__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                        title: t('text-non-translated-title'),
                        items: options,
                        translate: "false",
                        slug: slug,
                        id: record === null || record === void 0 ? void 0 : record.id,
                        routes: routes
                    }) : '',
                    (filterTranslatedItem === null || filterTranslatedItem === void 0 ? void 0 : filterTranslatedItem.length) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_lang_list_box__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                        title: t('text-translated-title'),
                        items: filterTranslatedItem,
                        translate: "true",
                        slug: slug,
                        id: record === null || record === void 0 ? void 0 : record.id,
                        routes: routes
                    }) : ''
                ]
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LanguageSwitcher);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 61849:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ pagination)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
// EXTERNAL MODULE: external "rc-pagination"
var external_rc_pagination_ = __webpack_require__(73006);
var external_rc_pagination_default = /*#__PURE__*/__webpack_require__.n(external_rc_pagination_);
;// CONCATENATED MODULE: ./src/components/icons/arrow-next.tsx

const ArrowNext = ({ ...props })=>{
    return(/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 512 512",
        width: "20",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            d: "M294.1 256L167 129c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.3 34 0L345 239c9.1 9.1 9.3 23.7.7 33.1L201.1 417c-4.7 4.7-10.9 7-17 7s-12.3-2.3-17-7c-9.4-9.4-9.4-24.6 0-33.9l127-127.1z",
            fill: "currentColor",
            stroke: "currentColor"
        })
    }));
};

;// CONCATENATED MODULE: ./src/components/icons/arrow-prev.tsx

const ArrowPrev = ({ ...props })=>{
    return(/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 512 512",
        width: "20",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            d: "M217.9 256L345 129c9.4-9.4 9.4-24.6 0-33.9-9.4-9.4-24.6-9.3-34 0L167 239c-9.1 9.1-9.3 23.7-.7 33.1L310.9 417c4.7 4.7 10.9 7 17 7s12.3-2.3 17-7c9.4-9.4 9.4-24.6 0-33.9L217.9 256z",
            fill: "currentColor",
            stroke: "currentColor"
        })
    }));
};

;// CONCATENATED MODULE: ./src/components/ui/pagination.tsx





const Pagination = (props)=>{
    return(/*#__PURE__*/ jsx_runtime_.jsx((external_rc_pagination_default()), {
        nextIcon: /*#__PURE__*/ jsx_runtime_.jsx(ArrowNext, {}),
        prevIcon: /*#__PURE__*/ jsx_runtime_.jsx(ArrowPrev, {}),
        ...props
    }));
};
/* harmony default export */ const pagination = (Pagination);


/***/ }),

/***/ 85073:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61185);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_icons_toggle_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(77067);
/* harmony import */ var _floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(91017);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_headlessui_react__WEBPACK_IMPORTED_MODULE_2__, _floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__]);
([_headlessui_react__WEBPACK_IMPORTED_MODULE_2__, _floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






const PopOver = ({ children , popOverButtonClass , popOverPanelClass , iconStyle ='horizontal'  })=>{
    const { x , y , reference , floating , strategy , update , refs  } = (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.useFloating)({
        strategy: 'fixed',
        placement: 'bottom',
        middleware: [
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.offset)(0),
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.flip)(),
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.shift)()
        ]
    });
    // This one is for recalculating the position of the floating element if no space is left on the given placement
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (!refs.reference.current || !refs.floating.current) {
            return;
        }
        return (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.autoUpdate)(refs.reference.current, refs.floating.current, update);
    }, [
        refs.reference,
        refs.floating,
        update
    ]);
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Popover, {
        className: "relative inline-block",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Popover.Button, {
                className: classnames__WEBPACK_IMPORTED_MODULE_3___default()('p-2 text-base opacity-80 transition duration-200 hover:text-heading', popOverButtonClass),
                ref: reference,
                children: iconStyle === 'horizontal' ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_toggle_icon__WEBPACK_IMPORTED_MODULE_4__/* .ToggleIcon */ .X, {
                    width: 20
                }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_toggle_icon__WEBPACK_IMPORTED_MODULE_4__/* .ToggleIconVertical */ .t, {
                    height: 18,
                    width: 6
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                ref: floating,
                style: {
                    position: strategy,
                    top: y !== null && y !== void 0 ? y : '',
                    left: x !== null && x !== void 0 ? x : '',
                    zIndex: 1
                },
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Popover.Panel, {
                    className: classnames__WEBPACK_IMPORTED_MODULE_3___default()('w-[18rem] max-w-[20rem] overflow-hidden rounded bg-[#F7F8F9] px-4 shadow-translatePanel sm:px-0', popOverPanelClass),
                    children: children
                })
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PopOver);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5034:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "h": () => (/* binding */ crudFactory)
/* harmony export */ });
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_0__]);
_http_client__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

function crudFactory(endpoint) {
    return {
        all (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        paginated (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        get ({ slug , language  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(`${endpoint}/${slug}`, {
                language
            });
        },
        create (data) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.post */ .eN.post(endpoint, data);
        },
        update ({ id , ...input }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.put */ .eN.put(`${endpoint}/${id}`, input);
        },
        delete ({ id  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient["delete"] */ .eN["delete"](`${endpoint}/${id}`);
        }
    };
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 99699:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "q": () => (/* binding */ storeNoticeClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5034);
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const storeNoticeClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_1__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES),
    all: ({ notice , shop_id , ...params } = {})=>_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES, {
            searchJoin: 'and',
            shop_id: shop_id,
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                notice,
                shop_id
            })
        })
    ,
    get ({ id , language  }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES}/${id}`, {
            language
        });
    },
    paginated: ({ notice , shop_id , ...params })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES, {
            searchJoin: 'and',
            shop_id: shop_id,
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                notice,
                shop_id
            })
        });
    },
    toggle: (input)=>_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.STORE_NOTICES_IS_READ */ .P.STORE_NOTICES_IS_READ, input)
    ,
    getTypeList: ({ type  })=>_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.STORE_NOTICE_GET_STORE_NOTICE_TYPE */ .P.STORE_NOTICE_GET_STORE_NOTICE_TYPE)
    ,
    getUserOrShopList: ({ type  })=>_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.STORE_NOTICES_USER_OR_SHOP_LIST */ .P.STORE_NOTICES_USER_OR_SHOP_LIST, type)
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5047:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "qo": () => (/* binding */ useCreateStoreNoticeMutation),
/* harmony export */   "Hv": () => (/* binding */ useDeleteStoreNoticeMutation),
/* harmony export */   "Ow": () => (/* binding */ useUpdateStoreNoticeMutation),
/* harmony export */   "Vm": () => (/* binding */ useStoreNoticeQuery),
/* harmony export */   "Y4": () => (/* binding */ useStoreNoticesQuery),
/* harmony export */   "lL": () => (/* binding */ useStoreNoticesLoadMoreQuery),
/* harmony export */   "PF": () => (/* binding */ useUsersOrShopsQuery),
/* harmony export */   "DB": () => (/* binding */ useStoreNoticeRead)
/* harmony export */ });
/* unused harmony exports useListMutation, useStoreNoticeTypeQuery */
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(63354);
/* harmony import */ var _client_store_notice__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(99699);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(28379);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(85057);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(29249);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_store_notice__WEBPACK_IMPORTED_MODULE_5__, _config__WEBPACK_IMPORTED_MODULE_8__]);
([_client_store_notice__WEBPACK_IMPORTED_MODULE_5__, _config__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const useCreateStoreNoticeMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_0__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_store_notice__WEBPACK_IMPORTED_MODULE_5__/* .storeNoticeClient.create */ .q.create, {
        onSuccess: async ()=>{
            const generateRedirectUrl = router.query.shop ? `/${router.query.shop}${_config_routes__WEBPACK_IMPORTED_MODULE_6__/* .Routes.storeNotice.list */ .Z.storeNotice.list}` : _config_routes__WEBPACK_IMPORTED_MODULE_6__/* .Routes.storeNotice.list */ .Z.storeNotice.list;
            await next_router__WEBPACK_IMPORTED_MODULE_0___default().push(generateRedirectUrl, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_8__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_7__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES);
        }
    });
};
const useDeleteStoreNoticeMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_store_notice__WEBPACK_IMPORTED_MODULE_5__/* .storeNoticeClient["delete"] */ .q["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_7__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES);
        }
    });
};
const useUpdateStoreNoticeMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_0__.useRouter)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_store_notice__WEBPACK_IMPORTED_MODULE_5__/* .storeNoticeClient.update */ .q.update, {
        onSuccess: async (data)=>{
            const generateRedirectUrl = router.query.shop ? `/${router.query.shop}${_config_routes__WEBPACK_IMPORTED_MODULE_6__/* .Routes.storeNotice.list */ .Z.storeNotice.list}` : _config_routes__WEBPACK_IMPORTED_MODULE_6__/* .Routes.storeNotice.list */ .Z.storeNotice.list;
            await router.push(`${generateRedirectUrl}/${data === null || data === void 0 ? void 0 : data.id}/edit`, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_8__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_7__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES);
        }
    });
};
const useListMutation = ()=>{
    const { t  } = useTranslation();
    return useMutation(storeNoticeClient.getUserOrShopList);
};
const useStoreNoticeQuery = ({ id , language  })=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_7__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES,
        {
            id,
            language
        }
    ], ()=>_client_store_notice__WEBPACK_IMPORTED_MODULE_5__/* .storeNoticeClient.get */ .q.get({
            id,
            language
        })
    );
    return {
        storeNotice: data,
        error,
        loading: isLoading
    };
};
const useStoreNoticesQuery = (options)=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_7__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES,
        options
    ], ({ queryKey , pageParam  })=>_client_store_notice__WEBPACK_IMPORTED_MODULE_5__/* .storeNoticeClient.paginated */ .q.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    var ref;
    return {
        storeNotices: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_4__/* .mapPaginatorData */ .Q)(data),
        error,
        loading: isLoading
    };
};
const useStoreNoticesLoadMoreQuery = (options, config)=>{
    const { data , error , isLoading , isFetchingNextPage , hasNextPage , fetchNextPage ,  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useInfiniteQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_7__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES,
        options
    ], ({ queryKey , pageParam  })=>_client_store_notice__WEBPACK_IMPORTED_MODULE_5__/* .storeNoticeClient.all */ .q.all(Object.assign({}, queryKey[1], pageParam))
    , {
        ...config,
        getNextPageParam: ({ current_page , last_page  })=>last_page > current_page && {
                page: current_page + 1
            }
    });
    function handleLoadMore() {
        fetchNextPage();
    }
    var ref;
    return {
        storeNotices: (ref = data === null || data === void 0 ? void 0 : data.pages.flatMap((page)=>{
            return page === null || page === void 0 ? void 0 : page.data;
        })) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: Array.isArray(data === null || data === void 0 ? void 0 : data.pages) ? data === null || data === void 0 ? void 0 : data.pages[data.pages.length - 1] : null,
        error,
        hasNextPage,
        loading: isLoading,
        isLoadingMore: isFetchingNextPage,
        loadMore: handleLoadMore
    };
};
const useStoreNoticeTypeQuery = (options = {})=>{
    const { data , error , isLoading  } = useQuery([
        API_ENDPOINTS.STORE_NOTICE_GET_STORE_NOTICE_TYPE,
        options
    ], ({ queryKey , pageParam  })=>storeNoticeClient.getTypeList(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    return {
        noticeTypes: data !== null && data !== void 0 ? data : [],
        error,
        loading: isLoading
    };
};
const useUsersOrShopsQuery = (options = {})=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_7__/* .API_ENDPOINTS.STORE_NOTICES_USER_OR_SHOP_LIST */ .P.STORE_NOTICES_USER_OR_SHOP_LIST,
        options
    ], ({ queryKey , pageParam  })=>_client_store_notice__WEBPACK_IMPORTED_MODULE_5__/* .storeNoticeClient.getUserOrShopList */ .q.getUserOrShopList(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    return {
        usersOrShops: data !== null && data !== void 0 ? data : [],
        error,
        loading: isLoading
    };
};
function useStoreNoticeRead() {
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)('common');
    const { mutate: readStoreNotice , isLoading , isSuccess ,  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_store_notice__WEBPACK_IMPORTED_MODULE_5__/* .storeNoticeClient.toggle */ .q.toggle, {
        onSuccess: ()=>{},
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_7__/* .API_ENDPOINTS.STORE_NOTICES_IS_READ */ .P.STORE_NOTICES_IS_READ);
        }
    });
    return {
        readStoreNotice,
        isLoading,
        isSuccess
    };
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;