"use strict";
exports.id = 3125;
exports.ids = [3125];
exports.modules = {

/***/ 2437:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "l": () => (/* binding */ withdrawClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5034);
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const withdrawClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_1__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.WITHDRAWS */ .P.WITHDRAWS),
    get ({ id  }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.WITHDRAWS */ .P.WITHDRAWS}/${id}`);
    },
    paginated: ({ shop_id , ...params })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.WITHDRAWS */ .P.WITHDRAWS, {
            shop_id,
            searchJoin: 'and',
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                shop_id
            })
        });
    },
    approve (data) {
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.APPROVE_WITHDRAW */ .P.APPROVE_WITHDRAW, data);
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 23125:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "mJ": () => (/* binding */ useCreateWithdrawMutation),
/* harmony export */   "by": () => (/* binding */ useApproveWithdrawMutation),
/* harmony export */   "rX": () => (/* binding */ useWithdrawQuery),
/* harmony export */   "qv": () => (/* binding */ useWithdrawsQuery)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85057);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(63354);
/* harmony import */ var _client_withdraw__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(2437);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_withdraw__WEBPACK_IMPORTED_MODULE_6__]);
_client_withdraw__WEBPACK_IMPORTED_MODULE_6__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







const useCreateWithdrawMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_0__.useRouter)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_withdraw__WEBPACK_IMPORTED_MODULE_6__/* .withdrawClient.create */ .l.create, {
        onSuccess: ()=>{
            router.push(`/${router.query.shop}/withdraws`);
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.WITHDRAWS */ .P.WITHDRAWS);
        }
    });
};
const useApproveWithdrawMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_withdraw__WEBPACK_IMPORTED_MODULE_6__/* .withdrawClient.approve */ .l.approve, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.APPROVE_WITHDRAW */ .P.APPROVE_WITHDRAW);
        }
    });
};
const useWithdrawQuery = ({ id  })=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.WITHDRAWS */ .P.WITHDRAWS,
        {
            id
        }
    ], ()=>_client_withdraw__WEBPACK_IMPORTED_MODULE_6__/* .withdrawClient.get */ .l.get({
            id
        })
    );
    return {
        withdraw: data,
        error,
        isLoading
    };
};
const useWithdrawsQuery = (params, options = {})=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.WITHDRAWS */ .P.WITHDRAWS,
        params
    ], ({ queryKey , pageParam  })=>_client_withdraw__WEBPACK_IMPORTED_MODULE_6__/* .withdrawClient.paginated */ .l.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true,
        ...options
    });
    var ref;
    return {
        withdraws: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_5__/* .mapPaginatorData */ .Q)(data),
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;