"use strict";
exports.id = 3201;
exports.ids = [3201];
exports.modules = {

/***/ 77541:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "H": () => (/* binding */ staffClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_1__]);
_http_client__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const staffClient = {
    paginated: ({ ...params })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.STAFFS */ .P.STAFFS, {
            searchJoin: 'and',
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({})
        });
    },
    addStaff: (variables)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.ADD_STAFF */ .P.ADD_STAFF, variables);
    },
    removeStaff: ({ id  })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient["delete"] */ .eN["delete"](`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.REMOVE_STAFF */ .P.REMOVE_STAFF}/${id}`);
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 53201:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "dP": () => (/* binding */ useStaffsQuery),
/* harmony export */   "PF": () => (/* binding */ useAddStaffMutation),
/* harmony export */   "il": () => (/* binding */ useRemoveStaffMutation)
/* harmony export */ });
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(63354);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(85057);
/* harmony import */ var _client_staff__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(77541);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(28379);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_staff__WEBPACK_IMPORTED_MODULE_3__]);
_client_staff__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];








const useStaffsQuery = (params, options = {})=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_2__/* .API_ENDPOINTS.STAFFS */ .P.STAFFS,
        params
    ], ({ queryKey , pageParam  })=>_client_staff__WEBPACK_IMPORTED_MODULE_3__/* .staffClient.paginated */ .H.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true,
        ...options
    });
    var ref;
    return {
        staffs: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_1__/* .mapPaginatorData */ .Q)(data),
        error,
        loading: isLoading
    };
};
const useAddStaffMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQueryClient)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_4__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)(_client_staff__WEBPACK_IMPORTED_MODULE_3__/* .staffClient.addStaff */ .H.addStaff, {
        onSuccess: ()=>{
            var ref;
            router.push(`/${router === null || router === void 0 ? void 0 : (ref = router.query) === null || ref === void 0 ? void 0 : ref.shop}${_config_routes__WEBPACK_IMPORTED_MODULE_7__/* .Routes.staff.list */ .Z.staff.list}`);
            react_toastify__WEBPACK_IMPORTED_MODULE_6__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_2__/* .API_ENDPOINTS.STAFFS */ .P.STAFFS);
        }
    });
};
const useRemoveStaffMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)(_client_staff__WEBPACK_IMPORTED_MODULE_3__/* .staffClient.removeStaff */ .H.removeStaff, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_6__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_2__/* .API_ENDPOINTS.STAFFS */ .P.STAFFS);
        }
    });
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;