"use strict";
exports.id = 3367;
exports.ids = [3367];
exports.modules = {

/***/ 13367:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_ui_button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(39258);
/* harmony import */ var _components_ui_modal_modal_context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(44144);
/* harmony import */ var _data_refund__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(10976);
/* harmony import */ var _components_ui_select_input__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(55530);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(45641);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _components_ui_alert__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(58788);
/* harmony import */ var react_scroll__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(83094);
/* harmony import */ var react_scroll__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_scroll__WEBPACK_IMPORTED_MODULE_9__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_refund__WEBPACK_IMPORTED_MODULE_4__, _components_ui_select_input__WEBPACK_IMPORTED_MODULE_5__, react_hook_form__WEBPACK_IMPORTED_MODULE_6__]);
([_data_refund__WEBPACK_IMPORTED_MODULE_4__, _components_ui_select_input__WEBPACK_IMPORTED_MODULE_5__, react_hook_form__WEBPACK_IMPORTED_MODULE_6__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);










const RefundStatus = [
    {
        value: 'APPROVED',
        name: 'Approved'
    },
    {
        value: 'PENDING',
        name: 'Pending'
    },
    {
        value: 'REJECTED',
        name: 'Rejected'
    },
    {
        value: 'PROCESSING',
        name: 'Processing'
    }, 
];
const UpdateRefundConfirmationView = ()=>{
    const { 0: errorMessage , 1: setErrorMessage  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_7__.useTranslation)('common');
    const { handleSubmit , control  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_6__.useForm)();
    const { mutate: updateRefund , isLoading: loading  } = (0,_data_refund__WEBPACK_IMPORTED_MODULE_4__/* .useUpdateRefundMutation */ .Et)();
    const { data: id  } = (0,_components_ui_modal_modal_context__WEBPACK_IMPORTED_MODULE_3__/* .useModalState */ .X9)();
    const { closeModal  } = (0,_components_ui_modal_modal_context__WEBPACK_IMPORTED_MODULE_3__/* .useModalAction */ .SO)();
    async function handleUpdateRefundStatus({ status  }) {
        const input = {
            status: status === null || status === void 0 ? void 0 : status.value
        };
        updateRefund({
            id,
            ...input
        }, {
            onError: (error)=>{
                var ref, ref1;
                setErrorMessage(error === null || error === void 0 ? void 0 : (ref = error.response) === null || ref === void 0 ? void 0 : (ref1 = ref.data) === null || ref1 === void 0 ? void 0 : ref1.message);
                react_scroll__WEBPACK_IMPORTED_MODULE_9__.animateScroll.scrollToTop();
            }
        });
        closeModal();
    }
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            errorMessage ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_alert__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                message: t(`common:${errorMessage}`),
                variant: "error",
                closeable: true,
                className: "mt-5",
                onClose: ()=>setErrorMessage(null)
            }) : null,
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("form", {
                onSubmit: handleSubmit(handleUpdateRefundStatus),
                noValidate: true,
                children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                    className: "m-auto flex w-full max-w-sm flex-col rounded bg-light p-5 sm:w-[24rem]",
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                            className: "mb-5 text-center text-lg font-semibold text-body",
                            children: t('text-update-refund')
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_select_input__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                            name: "status",
                            control: control,
                            getOptionLabel: (option)=>option.name
                            ,
                            getOptionValue: (option)=>option.value
                            ,
                            options: RefundStatus
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                            className: "mt-3",
                            loading: loading,
                            disabled: loading,
                            children: t('text-shop-approve-button')
                        })
                    ]
                })
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UpdateRefundConfirmationView);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;