"use strict";
exports.id = 3406;
exports.ids = [3406];
exports.modules = {

/***/ 23628:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "B": () => (/* binding */ userClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_1__]);
_http_client__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const userClient = {
    me: ()=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.ME */ .P.ME);
    },
    login: (variables)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.TOKEN */ .P.TOKEN, variables);
    },
    logout: ()=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.LOGOUT */ .P.LOGOUT, {});
    },
    register: (variables)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.REGISTER */ .P.REGISTER, variables);
    },
    update: ({ id , input  })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.put */ .eN.put(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.USERS */ .P.USERS}/${id}`, input);
    },
    changePassword: (variables)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.CHANGE_PASSWORD */ .P.CHANGE_PASSWORD, variables);
    },
    forgetPassword: (variables)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.FORGET_PASSWORD */ .P.FORGET_PASSWORD, variables);
    },
    verifyForgetPasswordToken: (variables)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.VERIFY_FORGET_PASSWORD_TOKEN */ .P.VERIFY_FORGET_PASSWORD_TOKEN, variables);
    },
    resetPassword: (variables)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.RESET_PASSWORD */ .P.RESET_PASSWORD, variables);
    },
    makeAdmin: (variables)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.MAKE_ADMIN */ .P.MAKE_ADMIN, variables);
    },
    block: (variables)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.BLOCK_USER */ .P.BLOCK_USER, variables);
    },
    unblock: (variables)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.UNBLOCK_USER */ .P.UNBLOCK_USER, variables);
    },
    addWalletPoints: (variables)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.ADD_WALLET_POINTS */ .P.ADD_WALLET_POINTS, variables);
    },
    fetchUsers: ({ name , ...params })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.USERS */ .P.USERS, {
            searchJoin: 'and',
            with: 'wallet',
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                name
            })
        });
    },
    fetchAdmins: ({ ...params })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.ADMIN_LIST */ .P.ADMIN_LIST, {
            searchJoin: 'and',
            ...params
        });
    },
    fetchUser: ({ id  })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.get */ .eN.get(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.USERS */ .P.USERS}/${id}`);
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;