"use strict";
exports.id = 3691;
exports.ids = [3691];
exports.modules = {

/***/ 93691:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "UE": () => (/* binding */ useMeQuery),
/* harmony export */   "f0": () => (/* binding */ useLogin),
/* harmony export */   "_y": () => (/* binding */ useLogoutMutation),
/* harmony export */   "l4": () => (/* binding */ useRegisterMutation),
/* harmony export */   "kD": () => (/* binding */ useUpdateUserMutation),
/* harmony export */   "$h": () => (/* binding */ useChangePasswordMutation),
/* harmony export */   "xy": () => (/* binding */ useForgetPasswordMutation),
/* harmony export */   "AV": () => (/* binding */ useVerifyForgetPasswordTokenMutation),
/* harmony export */   "gL": () => (/* binding */ useResetPasswordMutation),
/* harmony export */   "lJ": () => (/* binding */ useMakeOrRevokeAdminMutation),
/* harmony export */   "q3": () => (/* binding */ useBlockUserMutation),
/* harmony export */   "xE": () => (/* binding */ useUnblockUserMutation),
/* harmony export */   "h3": () => (/* binding */ useAddWalletPointsMutation),
/* harmony export */   "bT": () => (/* binding */ useUserQuery),
/* harmony export */   "xY": () => (/* binding */ useUsersQuery),
/* harmony export */   "Jc": () => (/* binding */ useAdminsQuery)
/* harmony export */ });
/* harmony import */ var _utils_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(30957);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28379);
/* harmony import */ var js_cookie__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69915);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(85057);
/* harmony import */ var _client_user__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(23628);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(63354);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([js_cookie__WEBPACK_IMPORTED_MODULE_1__, _client_user__WEBPACK_IMPORTED_MODULE_7__]);
([js_cookie__WEBPACK_IMPORTED_MODULE_1__, _client_user__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);










const useMeQuery = ()=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_6__/* .API_ENDPOINTS.ME */ .P.ME
    ], _client_user__WEBPACK_IMPORTED_MODULE_7__/* .userClient.me */ .B.me);
};
function useLogin() {
    return (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useMutation)(_client_user__WEBPACK_IMPORTED_MODULE_7__/* .userClient.login */ .B.login);
}
const useLogoutMutation = ()=>{
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_3__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useMutation)(_client_user__WEBPACK_IMPORTED_MODULE_7__/* .userClient.logout */ .B.logout, {
        onSuccess: ()=>{
            js_cookie__WEBPACK_IMPORTED_MODULE_1__["default"].remove(_utils_constants__WEBPACK_IMPORTED_MODULE_9__/* .AUTH_CRED */ .E$);
            router.replace(_config_routes__WEBPACK_IMPORTED_MODULE_0__/* .Routes.login */ .Z.login);
            react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast.success(t('common:successfully-logout'));
        }
    });
};
const useRegisterMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useMutation)(_client_user__WEBPACK_IMPORTED_MODULE_7__/* .userClient.register */ .B.register, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast.success(t('common:successfully-register'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_6__/* .API_ENDPOINTS.REGISTER */ .P.REGISTER);
        }
    });
};
const useUpdateUserMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useMutation)(_client_user__WEBPACK_IMPORTED_MODULE_7__/* .userClient.update */ .B.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_6__/* .API_ENDPOINTS.ME */ .P.ME);
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_6__/* .API_ENDPOINTS.USERS */ .P.USERS);
        }
    });
};
const useChangePasswordMutation = ()=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useMutation)(_client_user__WEBPACK_IMPORTED_MODULE_7__/* .userClient.changePassword */ .B.changePassword);
};
const useForgetPasswordMutation = ()=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useMutation)(_client_user__WEBPACK_IMPORTED_MODULE_7__/* .userClient.forgetPassword */ .B.forgetPassword);
};
const useVerifyForgetPasswordTokenMutation = ()=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useMutation)(_client_user__WEBPACK_IMPORTED_MODULE_7__/* .userClient.verifyForgetPasswordToken */ .B.verifyForgetPasswordToken);
};
const useResetPasswordMutation = ()=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useMutation)(_client_user__WEBPACK_IMPORTED_MODULE_7__/* .userClient.resetPassword */ .B.resetPassword);
};
const useMakeOrRevokeAdminMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useMutation)(_client_user__WEBPACK_IMPORTED_MODULE_7__/* .userClient.makeAdmin */ .B.makeAdmin, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_6__/* .API_ENDPOINTS.USERS */ .P.USERS);
        }
    });
};
const useBlockUserMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useMutation)(_client_user__WEBPACK_IMPORTED_MODULE_7__/* .userClient.block */ .B.block, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast.success(t('common:successfully-block'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_6__/* .API_ENDPOINTS.USERS */ .P.USERS);
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_6__/* .API_ENDPOINTS.STAFFS */ .P.STAFFS);
        }
    });
};
const useUnblockUserMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useMutation)(_client_user__WEBPACK_IMPORTED_MODULE_7__/* .userClient.unblock */ .B.unblock, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast.success(t('common:successfully-unblock'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_6__/* .API_ENDPOINTS.USERS */ .P.USERS);
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_6__/* .API_ENDPOINTS.STAFFS */ .P.STAFFS);
        }
    });
};
const useAddWalletPointsMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useMutation)(_client_user__WEBPACK_IMPORTED_MODULE_7__/* .userClient.addWalletPoints */ .B.addWalletPoints, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_6__/* .API_ENDPOINTS.USERS */ .P.USERS);
        }
    });
};
const useUserQuery = ({ id  })=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_6__/* .API_ENDPOINTS.USERS */ .P.USERS,
        id
    ], ()=>_client_user__WEBPACK_IMPORTED_MODULE_7__/* .userClient.fetchUser */ .B.fetchUser({
            id
        })
    , {
        enabled: Boolean(id)
    });
};
const useUsersQuery = (params)=>{
    const { data , isLoading , error  } = (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_6__/* .API_ENDPOINTS.USERS */ .P.USERS,
        params
    ], ()=>_client_user__WEBPACK_IMPORTED_MODULE_7__/* .userClient.fetchUsers */ .B.fetchUsers(params)
    , {
        keepPreviousData: true
    });
    var ref;
    return {
        users: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_8__/* .mapPaginatorData */ .Q)(data),
        loading: isLoading,
        error
    };
};
const useAdminsQuery = (params)=>{
    const { data , isLoading , error  } = (0,react_query__WEBPACK_IMPORTED_MODULE_4__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_6__/* .API_ENDPOINTS.ADMIN_LIST */ .P.ADMIN_LIST,
        params
    ], ()=>_client_user__WEBPACK_IMPORTED_MODULE_7__/* .userClient.fetchAdmins */ .B.fetchAdmins(params)
    , {
        keepPreviousData: true
    });
    var ref;
    return {
        admins: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_8__/* .mapPaginatorData */ .Q)(data),
        loading: isLoading,
        error
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;