"use strict";
exports.id = 3788;
exports.ids = [3788];
exports.modules = {

/***/ 53788:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_error_message__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(30110);
/* harmony import */ var _components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(47898);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _data_user__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(93691);
/* harmony import */ var _components_shop_shop_card__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(56141);
/* harmony import */ var _components_icons_no_shop__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(29998);
/* harmony import */ var _utils_auth_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(49239);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_user__WEBPACK_IMPORTED_MODULE_4__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_7__]);
([_data_user__WEBPACK_IMPORTED_MODULE_4__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);








const ShopList = ()=>{
    var ref, ref1;
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const { data , isLoading: loading , error  } = (0,_data_user__WEBPACK_IMPORTED_MODULE_4__/* .useMeQuery */ .UE)();
    const { permissions  } = (0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_7__/* .getAuthCredentials */ .WA)();
    let permission = (0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_7__/* .hasAccess */ .Ft)(_utils_auth_utils__WEBPACK_IMPORTED_MODULE_7__/* .adminOnly */ .M$, permissions);
    if (loading) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        text: t('common:text-loading')
    }));
    if (error) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_error_message__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        message: error.message
    }));
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            permission ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "mb-5 border-b border-dashed border-border-base pb-8 sm:mb-8",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h1", {
                    className: "text-lg font-semibold text-heading",
                    children: t('common:sidebar-nav-item-my-shops')
                })
            }) : '',
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "grid grid-cols-1 gap-5 sm:grid-cols-2 md:grid-cols-3 3xl:grid-cols-5",
                children: data === null || data === void 0 ? void 0 : (ref = data.shops) === null || ref === void 0 ? void 0 : ref.map((myShop, idx)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_shop_shop_card__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                        shop: myShop
                    }, idx)
                )
            }),
            !(data === null || data === void 0 ? void 0 : data.managed_shop) && !(data === null || data === void 0 ? void 0 : (ref1 = data.shops) === null || ref1 === void 0 ? void 0 : ref1.length) ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "flex flex-col items-center w-full p-10",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "relative h-auto min-h-[180px] w-[300px] sm:min-h-[370px] sm:w-[490px]",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_no_shop__WEBPACK_IMPORTED_MODULE_6__/* .NoShop */ .A, {})
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                        className: "mt-6 text-lg font-semibold text-center text-body-dark sm:mt-10",
                        children: t('common:text-no-shop')
                    })
                ]
            }) : null,
            !!(data === null || data === void 0 ? void 0 : data.managed_shop) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "grid grid-cols-1 gap-5 sm:grid-cols-2 md:grid-cols-3 xl:grid-cols-4 3xl:grid-cols-5",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_shop_shop_card__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                    shop: data === null || data === void 0 ? void 0 : data.managed_shop
                })
            }) : null
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ShopList);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 56141:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_image__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38579);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_ui_link__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31434);
/* harmony import */ var _components_ui_badge_badge__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(83002);





const ShopCard = ({ shop  })=>{
    var ref;
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    const isNew = false;
    var ref1;
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_link__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        href: `/${shop === null || shop === void 0 ? void 0 : shop.slug}`,
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
            className: "relative flex cursor-pointer items-center rounded border border-gray-200 bg-light p-5",
            children: [
                isNew && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "end-2 absolute top-2 rounded bg-blue-500 px-2 py-1 text-xs text-light",
                    children: t('common:text-new')
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                    className: "relative flex h-16 w-16 flex-shrink-0 items-center justify-center overflow-hidden rounded-full border border-gray-100 bg-gray-300",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(next_image__WEBPACK_IMPORTED_MODULE_1__["default"], {
                        alt: t('common:text-logo'),
                        src: (ref1 = shop === null || shop === void 0 ? void 0 : (ref = shop.logo) === null || ref === void 0 ? void 0 : ref.thumbnail) !== null && ref1 !== void 0 ? ref1 : '/product-placeholder-borderless.svg',
                        layout: "fill",
                        objectFit: "cover"
                    })
                }),
                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                    className: "ms-4 flex flex-col",
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                            className: "mb-2 text-lg font-semibold text-heading",
                            children: shop === null || shop === void 0 ? void 0 : shop.name
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_badge_badge__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                                textKey: (shop === null || shop === void 0 ? void 0 : shop.is_active) ? 'common:text-active' : 'common:text-inactive',
                                color: (shop === null || shop === void 0 ? void 0 : shop.is_active) ? 'bg-accent' : 'bg-red-500'
                            })
                        })
                    ]
                })
            ]
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ShopCard);


/***/ }),

/***/ 30110:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* unused harmony export Error */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_1__);


const Error = ({ message  })=>{
    const { t  } = useTranslation('common');
    return(/*#__PURE__*/ _jsx("p", {
        className: "my-2 text-xs text-start text-red-500",
        children: t(message)
    }));
};
const ErrorMessage = ({ message  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_1__.useTranslation)('common');
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
        className: "bg-red-400 p-5 mt-16 mx-auto max-w-sm min-w-min text-center text-lg text-light font-semibold rounded",
        children: t(message)
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ErrorMessage);


/***/ }),

/***/ 31434:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(79894);


const Link = ({ className , children , ...props })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(next_link__WEBPACK_IMPORTED_MODULE_1__["default"], {
        ...props,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("a", {
            className: className,
            children: children
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Link);


/***/ })

};
;