"use strict";
exports.id = 4144;
exports.ids = [4144];
exports.modules = {

/***/ 44144:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DY": () => (/* binding */ ModalProvider),
/* harmony export */   "X9": () => (/* binding */ useModalState),
/* harmony export */   "SO": () => (/* binding */ useModalAction)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const initialState = {
    view: undefined,
    isOpen: false,
    data: null
};
function modalReducer(state, action) {
    switch(action.type){
        case 'open':
            return {
                ...state,
                view: action.view,
                data: action.payload,
                isOpen: true
            };
        case 'close':
            return {
                ...state,
                view: undefined,
                data: null,
                isOpen: false
            };
        default:
            throw new Error('Unknown Modal Action!');
    }
}
const ModalStateContext = /*#__PURE__*/ react__WEBPACK_IMPORTED_MODULE_1___default().createContext(initialState);
ModalStateContext.displayName = 'ModalStateContext';
const ModalActionContext = /*#__PURE__*/ react__WEBPACK_IMPORTED_MODULE_1___default().createContext(undefined);
ModalActionContext.displayName = 'ModalActionContext';
const ModalProvider = ({ children  })=>{
    const [state, dispatch] = react__WEBPACK_IMPORTED_MODULE_1___default().useReducer(modalReducer, initialState);
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(ModalStateContext.Provider, {
        value: state,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(ModalActionContext.Provider, {
            value: dispatch,
            children: children
        })
    }));
};
function useModalState() {
    const context = react__WEBPACK_IMPORTED_MODULE_1___default().useContext(ModalStateContext);
    if (context === undefined) {
        throw new Error(`useModalState must be used within a ModalProvider`);
    }
    return context;
}
function useModalAction() {
    const dispatch = react__WEBPACK_IMPORTED_MODULE_1___default().useContext(ModalActionContext);
    if (dispatch === undefined) {
        throw new Error(`useModalAction must be used within a ModalProvider`);
    }
    return {
        openModal (view, payload) {
            dispatch({
                type: 'open',
                view,
                payload
            });
        },
        closeModal () {
            dispatch({
                type: 'close'
            });
        }
    };
}


/***/ })

};
;