"use strict";
exports.id = 428;
exports.ids = [428,6229,6797,4428,1351,4342];
exports.modules = {

/***/ 81258:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);


const Card = ({ className , ...props })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('p-5 md:p-8 bg-light shadow rounded', className),
        ...props
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Card);


/***/ }),

/***/ 75737:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_icons_close_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29581);
/* harmony import */ var _components_icons_search_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(44066);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(45641);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_hook_form__WEBPACK_IMPORTED_MODULE_5__]);
react_hook_form__WEBPACK_IMPORTED_MODULE_5__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







const classes = {
    root: 'ps-10 pe-4 h-12 flex items-center w-full rounded appearance-none transition duration-300 ease-in-out text-heading text-sm focus:outline-none focus:ring-0',
    normal: 'bg-gray-100 border border-border-base focus:shadow focus:bg-light focus:border-accent',
    solid: 'bg-gray-100 border border-border-100 focus:bg-light focus:border-accent',
    outline: 'border border-border-base focus:border-accent',
    shadow: 'focus:shadow'
};
const Search = ({ className , onSearch , variant ='outline' , shadow =false , inputClassName , ...rest })=>{
    const { register , handleSubmit , watch , reset , formState: { errors  } ,  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_5__.useForm)({
        defaultValues: {
            searchText: ''
        }
    });
    const searchText = watch('searchText');
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_6__.useTranslation)();
    (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(()=>{
        if (!searchText) {
            onSearch({
                searchText: ''
            });
        }
    }, [
        searchText
    ]);
    const rootClassName = classnames__WEBPACK_IMPORTED_MODULE_3___default()(classes.root, {
        [classes.normal]: variant === 'normal',
        [classes.solid]: variant === 'solid',
        [classes.outline]: variant === 'outline'
    }, {
        [classes.shadow]: shadow
    }, inputClassName);
    function clear() {
        reset();
        onSearch({
            searchText: ''
        });
    }
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("form", {
        noValidate: true,
        role: "search",
        className: classnames__WEBPACK_IMPORTED_MODULE_3___default()('relative flex w-full items-center', className),
        onSubmit: handleSubmit(onSearch),
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
                htmlFor: "search",
                className: "sr-only",
                children: t('form:input-label-search')
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                className: "start-1 absolute p-2 text-body outline-none focus:outline-none active:outline-none",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_search_icon__WEBPACK_IMPORTED_MODULE_2__/* .SearchIcon */ .W, {
                    className: "h-5 w-5"
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                type: "text",
                id: "search",
                ...register('searchText'),
                className: rootClassName,
                placeholder: t('form:input-placeholder-search'),
                "aria-label": "Search",
                autoComplete: "off",
                ...rest
            }),
            errors.searchText && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                children: errors.searchText.message
            }),
            !!searchText && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                type: "button",
                onClick: clear,
                className: "end-1 absolute p-2 text-body outline-none focus:outline-none active:outline-none",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_close_icon__WEBPACK_IMPORTED_MODULE_1__/* .CloseIcon */ .T, {
                    className: "h-5 w-5"
                })
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Search);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 99172:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "K": () => (/* binding */ ArrowDown)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const ArrowDown = ({ color ='currentColor' , width ='12px' , height ='12px' , ...props })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        width: width,
        height: height,
        viewBox: "0 0 11.996 12",
        ...props,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            "data-name": "Path 2462",
            d: "M18.276,12.1,12.7,6.524a.424.424,0,0,0-.6,0L6.524,12.1a.424.424,0,0,0,0,.6.424.424,0,0,0,.6,0l4.854-4.854V17.977a.423.423,0,1,0,.847,0V7.846L17.677,12.7a.424.424,0,0,0,.6,0A.434.434,0,0,0,18.276,12.1Z",
            transform: "translate(18.396 18.4) rotate(180)",
            fill: color
        })
    }));
};


/***/ }),

/***/ 93681:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "a": () => (/* binding */ ArrowUp)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const ArrowUp = ({ color ='currentColor' , width ='12px' , height ='12px' , ...props })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        width: width,
        height: height,
        viewBox: "0 0 11.996 12",
        ...props,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            "data-name": "Path 2462",
            d: "M18.276,12.1,12.7,6.524a.424.424,0,0,0-.6,0L6.524,12.1a.424.424,0,0,0,0,.6.424.424,0,0,0,.6,0l4.854-4.854V17.977a.423.423,0,1,0,.847,0V7.846L17.677,12.7a.424.424,0,0,0,.6,0A.434.434,0,0,0,18.276,12.1Z",
            transform: "translate(-6.4 -6.4)",
            fill: color
        })
    }));
};


/***/ }),

/***/ 11347:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_": () => (/* binding */ ChevronDown)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const ChevronDown = ({ color ='currentColor' , width ='14px' , height ='10px' , ...props })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        width: width,
        height: height,
        ...props,
        fill: "none",
        xmlns: "http://www.w3.org/2000/svg",
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            d: "M13.4 1.845a.91.91 0 0 0-1.613-.6L7.015 6.817l-4.771-5.57A.91.91 0 1 0 .866 2.428l5.457 6.378a.91.91 0 0 0 1.385 0l5.462-6.378a.91.91 0 0 0 .23-.583Z",
            fill: color
        })
    }));
};


/***/ }),

/***/ 90393:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "p": () => (/* binding */ PlusIcon)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const PlusIcon = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        fill: "none",
        viewBox: "0 0 24 24",
        stroke: "currentColor",
        ...props,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            strokeLinecap: "round",
            strokeLinejoin: "round",
            d: "M12 6v6m0 0v6m0-6h6m-6 0H6"
        })
    })
;


/***/ }),

/***/ 44066:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "W": () => (/* binding */ SearchIcon)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SearchIcon = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        stroke: "currentColor",
        ...props,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeWidth: 2,
            d: "M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"
        })
    })
;


/***/ }),

/***/ 77067:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "X": () => (/* binding */ ToggleIcon),
/* harmony export */   "t": () => (/* binding */ ToggleIconVertical)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const ToggleIcon = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        ...props,
        viewBox: "0 0 20 20",
        fill: "none",
        xmlns: "http://www.w3.org/2000/svg",
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            d: "M19.268 8.232a2.5 2.5 0 1 1-3.536 3.536 2.5 2.5 0 0 1 3.536-3.536ZM11.768 8.232a2.5 2.5 0 1 1-3.536 3.536 2.5 2.5 0 0 1 3.536-3.536ZM4.268 8.232a2.5 2.5 0 1 1-3.536 3.536 2.5 2.5 0 0 1 3.536-3.536Z",
            fill: "currentColor"
        })
    })
;
const ToggleIconVertical = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        ...props,
        fill: "none",
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            fill: "currentColor",
            d: "M3 4.5a2.257 2.257 0 0 0 2.25-2.25A2.257 2.257 0 0 0 3 0 2.257 2.257 0 0 0 .75 2.25 2.257 2.257 0 0 0 3 4.5Zm0 2.25A2.257 2.257 0 0 0 .75 9 2.257 2.257 0 0 0 3 11.25 2.257 2.257 0 0 0 5.25 9 2.257 2.257 0 0 0 3 6.75Zm0 6.75a2.257 2.257 0 0 0-2.25 2.25A2.257 2.257 0 0 0 3 18a2.257 2.257 0 0 0 2.25-2.25A2.257 2.257 0 0 0 3 13.5Z"
        })
    })
;


/***/ }),

/***/ 7991:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ CategoryTypeFilter)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_select_select__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26798);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_ui_label__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(63815);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _data_category__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8580);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _data_type__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(98077);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_category__WEBPACK_IMPORTED_MODULE_6__, _data_type__WEBPACK_IMPORTED_MODULE_8__]);
([_data_category__WEBPACK_IMPORTED_MODULE_6__, _data_type__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









function CategoryTypeFilter({ onTypeFilter , onCategoryFilter , className  }) {
    const { locale  } = (0,next_router__WEBPACK_IMPORTED_MODULE_7__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const { types , loading  } = (0,_data_type__WEBPACK_IMPORTED_MODULE_8__/* .useTypesQuery */ .qs)({
        language: locale
    });
    const { categories , loading: categoryLoading  } = (0,_data_category__WEBPACK_IMPORTED_MODULE_6__/* .useCategoriesQuery */ .Ei)({
        limit: 999,
        language: locale
    });
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: classnames__WEBPACK_IMPORTED_MODULE_5___default()('flex w-full flex-col space-y-5 rtl:space-x-reverse md:flex-row md:items-end md:space-x-5 md:space-y-0', className),
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "w-full",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                        children: t('common:filter-by-group')
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_select_select__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        options: types,
                        isLoading: loading,
                        getOptionLabel: (option)=>option.name
                        ,
                        getOptionValue: (option)=>option.slug
                        ,
                        placeholder: t('common:filter-by-group-placeholder'),
                        onChange: onTypeFilter
                    })
                ]
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "w-full",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                        children: t('common:filter-by-category')
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_select_select__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        options: categories,
                        getOptionLabel: (option)=>option.name
                        ,
                        getOptionValue: (option)=>option.slug
                        ,
                        placeholder: t('common:filter-by-category-placeholder'),
                        isLoading: categoryLoading,
                        onChange: onCategoryFilter
                    })
                ]
            })
        ]
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 47592:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_pagination__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61849);
/* harmony import */ var next_image__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(38579);
/* harmony import */ var _components_ui_table__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(40447);
/* harmony import */ var _settings_site_settings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(37070);
/* harmony import */ var _utils_use_price__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(86797);
/* harmony import */ var _components_ui_badge_badge__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(83002);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(53139);
/* harmony import */ var _utils_locals__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(10601);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(99996);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(28379);
/* harmony import */ var _components_ui_lang_action_action__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(32361);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_settings_site_settings__WEBPACK_IMPORTED_MODULE_4__, _utils_use_price__WEBPACK_IMPORTED_MODULE_5__, _components_ui_lang_action_action__WEBPACK_IMPORTED_MODULE_14__]);
([_settings_site_settings__WEBPACK_IMPORTED_MODULE_4__, _utils_use_price__WEBPACK_IMPORTED_MODULE_5__, _components_ui_lang_action_action__WEBPACK_IMPORTED_MODULE_14__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);















const ProductList = ({ products , paginatorInfo , onPagination , onSort , onOrder  })=>{
    var ref;
    // const { data, paginatorInfo } = products! ?? {};
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_7__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_8__.useTranslation)();
    const { alignLeft , alignRight  } = (0,_utils_locals__WEBPACK_IMPORTED_MODULE_10__/* .useIsRTL */ .S)();
    console.log('Products are', products);
    const { 0: sortingObj , 1: setSortingObj  } = (0,react__WEBPACK_IMPORTED_MODULE_11__.useState)({
        sort: _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Desc */ .As.Desc,
        column: null
    });
    const onHeaderClick = (column)=>({
            onClick: ()=>{
                onSort((currentSortDirection)=>currentSortDirection === _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Desc */ .As.Desc ? _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Asc */ .As.Asc : _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Desc */ .As.Desc
                );
                onOrder(column);
                setSortingObj({
                    sort: sortingObj.sort === _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Desc */ .As.Desc ? _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Asc */ .As.Asc : _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Desc */ .As.Desc,
                    column: column
                });
            }
        })
    ;
    var ref1;
    let columns = [
        {
            title: t('table:table-item-image'),
            dataIndex: 'image',
            key: 'image',
            align: alignLeft,
            width: 74,
            render: (image, { name  })=>{
                /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(next_image__WEBPACK_IMPORTED_MODULE_2__["default"], {
                    src: (ref1 = image === null || image === void 0 ? void 0 : image.thumbnail) !== null && ref1 !== void 0 ? ref1 : _settings_site_settings__WEBPACK_IMPORTED_MODULE_4__/* .siteSettings.product.placeholder */ .U.product.placeholder,
                    alt: name,
                    layout: "fixed",
                    width: 42,
                    height: 42,
                    className: "overflow-hidden rounded"
                });
            }
        },
        {
            title: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Z, {
                title: t('table:table-item-title'),
                ascending: sortingObj.sort === _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Asc */ .As.Asc && sortingObj.column === 'name',
                isActive: sortingObj.column === 'name'
            }),
            className: 'cursor-pointer',
            dataIndex: 'name',
            key: 'name',
            align: alignLeft,
            width: 300,
            ellipsis: true,
            onHeaderCell: ()=>onHeaderClick('name')
        },
        {
            title: t('table:table-item-group'),
            dataIndex: 'type',
            key: 'type',
            width: 120,
            align: 'center',
            ellipsis: true,
            render: (type)=>{
                /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "truncate whitespace-nowrap",
                    children: type === null || type === void 0 ? void 0 : type.name
                });
            }
        },
        {
            title: t('table:table-item-shop'),
            dataIndex: 'shop',
            key: 'shop',
            width: 120,
            align: 'center',
            ellipsis: true,
            render: (shop)=>{
                /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "truncate whitespace-nowrap",
                    children: shop === null || shop === void 0 ? void 0 : shop.name
                });
            }
        },
        {
            title: 'Product Type',
            dataIndex: 'product_type',
            key: 'product_type',
            width: 120,
            align: 'center',
            render: (product_type)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "truncate whitespace-nowrap",
                    children: product_type
                })
        },
        {
            title: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Z, {
                title: t('table:table-item-unit'),
                ascending: sortingObj.sort === _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Asc */ .As.Asc && sortingObj.column === 'price',
                isActive: sortingObj.column === 'price'
            }),
            className: 'cursor-pointer',
            dataIndex: 'price',
            key: 'price',
            align: alignRight,
            width: 180,
            onHeaderCell: ()=>onHeaderClick('price')
            ,
            render: function Render(value, record) {
                const { price: max_price  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .ZP)({
                    amount: record === null || record === void 0 ? void 0 : record.max_price
                });
                const { price: min_price  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .ZP)({
                    amount: record === null || record === void 0 ? void 0 : record.min_price
                });
                const { price  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .ZP)({
                    amount: value
                });
                const renderPrice = (record === null || record === void 0 ? void 0 : record.product_type) === _types__WEBPACK_IMPORTED_MODULE_9__/* .ProductType.Variable */ .kv.Variable ? `${min_price} - ${max_price}` : price;
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "whitespace-nowrap",
                    title: renderPrice,
                    children: renderPrice
                }));
            }
        },
        {
            title: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Z, {
                title: t('table:table-item-quantity'),
                ascending: sortingObj.sort === _types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Asc */ .As.Asc && sortingObj.column === 'quantity',
                isActive: sortingObj.column === 'quantity'
            }),
            className: 'cursor-pointer',
            dataIndex: 'quantity',
            key: 'quantity',
            align: 'center',
            width: 150,
            onHeaderCell: ()=>onHeaderClick('quantity')
            ,
            render: (quantity)=>{
                if (quantity < 2) {
                    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_badge_badge__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                        text: t('common:text-out-of-stock'),
                        color: "bg-red-500 text-white"
                    }));
                }
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    children: quantity
                }));
            }
        },
        {
            title: t('table:table-item-status'),
            dataIndex: 'status',
            key: 'status',
            align: 'left',
            width: 180,
            render: (status, record)=>{
                /*#__PURE__*/ return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                    className: `flex justify-start ${(record === null || record === void 0 ? void 0 : record.quantity) > 0 && (record === null || record === void 0 ? void 0 : record.quantity) < 10 ? 'flex-col items-baseline space-y-3 3xl:flex-row 3xl:space-x-3 3xl:space-y-0 rtl:3xl:space-x-reverse' : 'items-center space-x-3 rtl:space-x-reverse'}`,
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_badge_badge__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                            text: status,
                            color: status.toLocaleLowerCase() === 'draft' ? 'bg-yellow-400' : 'bg-accent'
                        }),
                        (record === null || record === void 0 ? void 0 : record.quantity) > 0 && (record === null || record === void 0 ? void 0 : record.quantity) < 10 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_badge_badge__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                            text: t('common:text-low-quantity'),
                            color: "bg-red-600",
                            animate: true
                        })
                    ]
                });
            }
        },
        {
            title: t('table:table-item-actions'),
            dataIndex: 'slug',
            key: 'actions',
            align: 'right',
            width: 120,
            render: (slug, record)=>{
                /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_lang_action_action__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .Z, {
                    slug: slug,
                    record: record,
                    deleteModalView: "DELETE_PRODUCT",
                    routes: _config_routes__WEBPACK_IMPORTED_MODULE_13__/* .Routes */ .Z === null || _config_routes__WEBPACK_IMPORTED_MODULE_13__/* .Routes */ .Z === void 0 ? void 0 : _config_routes__WEBPACK_IMPORTED_MODULE_13__/* .Routes.product */ .Z.product
                });
            }
        }, 
    ];
    if (router === null || router === void 0 ? void 0 : (ref = router.query) === null || ref === void 0 ? void 0 : ref.shop) {
        columns = columns === null || columns === void 0 ? void 0 : columns.filter((column)=>{
            return (column === null || column === void 0 ? void 0 : column.key) !== 'shop';
        });
    }
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "mb-6 overflow-hidden rounded shadow",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_table__WEBPACK_IMPORTED_MODULE_3__/* .Table */ .i, {
                    /* @ts-ignore */ columns: columns,
                    emptyText: t('table:empty-table-data'),
                    data: products,
                    rowKey: "id",
                    scroll: {
                        x: 900
                    }
                })
            }),
            !!(paginatorInfo === null || paginatorInfo === void 0 ? void 0 : paginatorInfo.total) && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "flex items-center justify-end",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_pagination__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                    total: paginatorInfo.total,
                    current: paginatorInfo.currentPage,
                    pageSize: paginatorInfo.perPage,
                    onChange: onPagination,
                    showLessItems: true
                })
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProductList);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 83002:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);



const Badge = (props)=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    const { className , color: colorOverride , textColor: textColorOverride , text , textKey , animate =false ,  } = props;
    const classes = {
        root: 'px-3 py-1 rounded-full text-xs whitespace-nowrap relative',
        animate: 'animate-pulse',
        default: 'bg-accent',
        text: 'text-light'
    };
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
            className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(classes.root, {
                [classes.default]: !colorOverride,
                [classes.text]: !textColorOverride,
                [classes.animate]: animate
            }, colorOverride, textColorOverride, className),
            children: textKey ? t(textKey) : text
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Badge);


/***/ }),

/***/ 63815:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);


const Label = ({ className , ...rest })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
        className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('block text-body-dark font-semibold text-sm leading-none mb-3', className),
        ...rest
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Label);


/***/ }),

/***/ 32361:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ LanguageSwitcher)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_common_action_buttons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(53758);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(29249);
/* harmony import */ var _language_switcher__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(74675);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_config__WEBPACK_IMPORTED_MODULE_2__, _language_switcher__WEBPACK_IMPORTED_MODULE_3__]);
([_config__WEBPACK_IMPORTED_MODULE_2__, _language_switcher__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





function LanguageSwitcher({ record , slug , deleteModalView , routes , className  }) {
    const { enableMultiLang  } = _config__WEBPACK_IMPORTED_MODULE_2__/* .Config */ .D;
    const { query: { shop  } ,  } = (0,next_router__WEBPACK_IMPORTED_MODULE_4__.useRouter)();
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: enableMultiLang ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_language_switcher__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
            slug: slug,
            record: record,
            deleteModalView: deleteModalView,
            routes: routes,
            className: className
        }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_action_buttons__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
            id: record === null || record === void 0 ? void 0 : record.id,
            editUrl: routes.editWithoutLang(slug, shop),
            deleteModalView: deleteModalView
        })
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 881:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61185);
/* harmony import */ var _components_icons_chevronDownIcon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11347);
/* harmony import */ var _components_ui_link__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31434);
/* harmony import */ var _components_icons_plus_icon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(90393);
/* harmony import */ var _components_icons_edit__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(83955);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_headlessui_react__WEBPACK_IMPORTED_MODULE_3__]);
_headlessui_react__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];








const LanguageListbox = ({ title , items , translate , slug , id , routes  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_1__.useTranslation)('common');
    const { locale , query: { shop  } ,  } = (0,next_router__WEBPACK_IMPORTED_MODULE_2__.useRouter)();
    const currentSelectedItem = locale ? items === null || items === void 0 ? void 0 : items.find((o)=>{
        return (o === null || o === void 0 ? void 0 : o.value) === locale;
    }) : items[2];
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Disclosure, {
        children: ({ open  })=>{
            /*#__PURE__*/ return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                children: [
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Disclosure.Button, {
                        className: "text-left font-medium text-black w-full p-4 border-b border-solid border-[#E5E5EB] bg-white flex items-center justify-between",
                        children: [
                            title,
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                className: "text-[#8A8F9C]",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_chevronDownIcon__WEBPACK_IMPORTED_MODULE_4__/* .ChevronDown */ ._, {
                                    className: `${open ? 'rotate-180 transform origin-center' : ''} h-4 w-4`
                                })
                            })
                        ]
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Disclosure.Panel, {
                        className: "py-2",
                        children: items === null || items === void 0 ? void 0 : items.map((option, index)=>{
                            /*#__PURE__*/ return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                className: `flex items-center cursor-pointer relative px-4 py-2 transition-all hover:bg-white ${(currentSelectedItem === null || currentSelectedItem === void 0 ? void 0 : currentSelectedItem.id) === (option === null || option === void 0 ? void 0 : option.id) ? 'bg-white' : ''}`,
                                children: [
                                    option === null || option === void 0 ? void 0 : option.icon,
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                        className: "ltr:ml-3 rtl:mr-3",
                                        children: t(option === null || option === void 0 ? void 0 : option.name)
                                    }),
                                    translate === 'true' ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                        className: "ltr:ml-auto rtl:mr-auto cursor-pointer text-base transition duration-200 hover:text-heading",
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_link__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                                href: routes.edit(slug, option === null || option === void 0 ? void 0 : option.id, shop),
                                                locale: false,
                                                className: "absolute top-0 left-0 w-full h-full"
                                            }, option === null || option === void 0 ? void 0 : option.id),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_edit__WEBPACK_IMPORTED_MODULE_7__/* .EditIcon */ .d, {
                                                width: 16
                                            })
                                        ]
                                    }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                                        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                            className: "ltr:ml-auto rtl:mr-auto cursor-pointer text-base transition duration-200 hover:text-heading",
                                            children: [
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_link__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                                    href: routes.translate(slug, option === null || option === void 0 ? void 0 : option.id, shop),
                                                    locale: false,
                                                    className: "absolute top-0 left-0 w-full h-full"
                                                }, option === null || option === void 0 ? void 0 : option.id),
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_plus_icon__WEBPACK_IMPORTED_MODULE_6__/* .PlusIcon */ .p, {
                                                    width: 24
                                                })
                                            ]
                                        })
                                    })
                                ]
                            }, `language-${index}`);
                        })
                    })
                ]
            });
        }
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LanguageListbox);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 74675:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_locals__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(10601);
/* harmony import */ var _floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(91017);
/* harmony import */ var _components_common_action_buttons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(53758);
/* harmony import */ var _lang_list_box__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(881);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(29249);
/* harmony import */ var _components_ui_popover__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(85073);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__, _lang_list_box__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_8__, _components_ui_popover__WEBPACK_IMPORTED_MODULE_9__]);
([_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__, _lang_list_box__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_8__, _components_ui_popover__WEBPACK_IMPORTED_MODULE_9__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);










const LanguageSwitcher = ({ record , slug , deleteModalView , routes , className =''  })=>{
    var ref3, ref1, ref2;
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_3__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)('common');
    const { locales , locale  } = router;
    let filterItem = (ref3 = [
        ..._utils_locals__WEBPACK_IMPORTED_MODULE_4__/* .languageMenu */ .X
    ]) === null || ref3 === void 0 ? void 0 : ref3.filter((element)=>{
        return locales === null || locales === void 0 ? void 0 : locales.includes(element === null || element === void 0 ? void 0 : element.id);
    });
    let options = (ref1 = [
        ...filterItem
    ]) === null || ref1 === void 0 ? void 0 : ref1.filter((filter)=>{
        var ref;
        return !(record === null || record === void 0 ? void 0 : (ref = record.translated_languages) === null || ref === void 0 ? void 0 : ref.find((translated)=>{
            return translated === (filter === null || filter === void 0 ? void 0 : filter.value);
        }));
    });
    let filterTranslatedItem = (ref2 = [
        ..._utils_locals__WEBPACK_IMPORTED_MODULE_4__/* .languageMenu */ .X
    ]) === null || ref2 === void 0 ? void 0 : ref2.filter((element)=>{
        var ref;
        return record === null || record === void 0 ? void 0 : (ref = record.translated_languages) === null || ref === void 0 ? void 0 : ref.includes(element === null || element === void 0 ? void 0 : element.id);
    }).filter((item)=>{
        return !(locale === null || locale === void 0 ? void 0 : locale.includes(item === null || item === void 0 ? void 0 : item.id));
    });
    const { x , y , reference , floating , strategy , update , refs  } = (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.useFloating)({
        strategy: 'fixed',
        placement: 'bottom',
        middleware: [
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.offset)(20),
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.flip)(),
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.shift)()
        ]
    });
    // This one is for recalculating the position of the floating element if no space is left on the given placement
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (!refs.reference.current || !refs.floating.current) {
            return;
        }
        return (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.autoUpdate)(refs.reference.current, refs.floating.current, update);
    }, [
        refs.reference,
        refs.floating,
        update
    ]);
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: `flex w-full items-center justify-end gap-5 ${className}`,
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_action_buttons__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                id: record === null || record === void 0 ? void 0 : record.id,
                editUrl: routes.editWithoutLang(slug),
                deleteModalView: deleteModalView
            }),
            _config__WEBPACK_IMPORTED_MODULE_8__/* .Config.defaultLanguage */ .D.defaultLanguage === router.locale && // <Popover className="relative inline-block">
            //   <Popover.Button
            //     className="p-2 text-base opacity-80 transition duration-200 hover:text-heading"
            //     ref={reference}
            //   >
            //     <ToggleIcon width={20} />
            //   </Popover.Button>
            //   <div
            //     ref={floating}
            //     style={{
            //       position: strategy,
            //       top: y ?? '',
            //       left: x ?? '',
            //       zIndex: 1,
            //     }}
            //   >
            //     <Popover.Panel className="w-[18rem] max-w-[20rem] overflow-hidden rounded bg-[#F7F8F9] px-4 shadow-translatePanel sm:px-0">
            //       {options?.length ? (
            //         <LanguageListbox
            //           title={t('text-non-translated-title')}
            //           items={options}
            //           translate="false"
            //           slug={slug}
            //           id={record?.id}
            //           routes={routes}
            //         />
            //       ) : (
            //         ''
            //       )}
            //       {filterTranslatedItem?.length ? (
            //         <LanguageListbox
            //           title={t('text-translated-title')}
            //           items={filterTranslatedItem}
            //           translate="true"
            //           slug={slug}
            //           id={record?.id}
            //           routes={routes}
            //         />
            //       ) : (
            //         ''
            //       )}
            //     </Popover.Panel>
            //   </div>
            // </Popover>
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_ui_popover__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
                children: [
                    (options === null || options === void 0 ? void 0 : options.length) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_lang_list_box__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                        title: t('text-non-translated-title'),
                        items: options,
                        translate: "false",
                        slug: slug,
                        id: record === null || record === void 0 ? void 0 : record.id,
                        routes: routes
                    }) : '',
                    (filterTranslatedItem === null || filterTranslatedItem === void 0 ? void 0 : filterTranslatedItem.length) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_lang_list_box__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                        title: t('text-translated-title'),
                        items: filterTranslatedItem,
                        translate: "true",
                        slug: slug,
                        id: record === null || record === void 0 ? void 0 : record.id,
                        routes: routes
                    }) : ''
                ]
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LanguageSwitcher);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 61849:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ pagination)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
// EXTERNAL MODULE: external "rc-pagination"
var external_rc_pagination_ = __webpack_require__(73006);
var external_rc_pagination_default = /*#__PURE__*/__webpack_require__.n(external_rc_pagination_);
;// CONCATENATED MODULE: ./src/components/icons/arrow-next.tsx

const ArrowNext = ({ ...props })=>{
    return(/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 512 512",
        width: "20",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            d: "M294.1 256L167 129c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.3 34 0L345 239c9.1 9.1 9.3 23.7.7 33.1L201.1 417c-4.7 4.7-10.9 7-17 7s-12.3-2.3-17-7c-9.4-9.4-9.4-24.6 0-33.9l127-127.1z",
            fill: "currentColor",
            stroke: "currentColor"
        })
    }));
};

;// CONCATENATED MODULE: ./src/components/icons/arrow-prev.tsx

const ArrowPrev = ({ ...props })=>{
    return(/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 512 512",
        width: "20",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            d: "M217.9 256L345 129c9.4-9.4 9.4-24.6 0-33.9-9.4-9.4-24.6-9.3-34 0L167 239c-9.1 9.1-9.3 23.7-.7 33.1L310.9 417c4.7 4.7 10.9 7 17 7s12.3-2.3 17-7c9.4-9.4 9.4-24.6 0-33.9L217.9 256z",
            fill: "currentColor",
            stroke: "currentColor"
        })
    }));
};

;// CONCATENATED MODULE: ./src/components/ui/pagination.tsx





const Pagination = (props)=>{
    return(/*#__PURE__*/ jsx_runtime_.jsx((external_rc_pagination_default()), {
        nextIcon: /*#__PURE__*/ jsx_runtime_.jsx(ArrowNext, {}),
        prevIcon: /*#__PURE__*/ jsx_runtime_.jsx(ArrowPrev, {}),
        ...props
    }));
};
/* harmony default export */ const pagination = (Pagination);


/***/ }),

/***/ 85073:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61185);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_icons_toggle_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(77067);
/* harmony import */ var _floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(91017);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_headlessui_react__WEBPACK_IMPORTED_MODULE_2__, _floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__]);
([_headlessui_react__WEBPACK_IMPORTED_MODULE_2__, _floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






const PopOver = ({ children , popOverButtonClass , popOverPanelClass , iconStyle ='horizontal'  })=>{
    const { x , y , reference , floating , strategy , update , refs  } = (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.useFloating)({
        strategy: 'fixed',
        placement: 'bottom',
        middleware: [
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.offset)(0),
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.flip)(),
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.shift)()
        ]
    });
    // This one is for recalculating the position of the floating element if no space is left on the given placement
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (!refs.reference.current || !refs.floating.current) {
            return;
        }
        return (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.autoUpdate)(refs.reference.current, refs.floating.current, update);
    }, [
        refs.reference,
        refs.floating,
        update
    ]);
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Popover, {
        className: "relative inline-block",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Popover.Button, {
                className: classnames__WEBPACK_IMPORTED_MODULE_3___default()('p-2 text-base opacity-80 transition duration-200 hover:text-heading', popOverButtonClass),
                ref: reference,
                children: iconStyle === 'horizontal' ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_toggle_icon__WEBPACK_IMPORTED_MODULE_4__/* .ToggleIcon */ .X, {
                    width: 20
                }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_toggle_icon__WEBPACK_IMPORTED_MODULE_4__/* .ToggleIconVertical */ .t, {
                    height: 18,
                    width: 6
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                ref: floating,
                style: {
                    position: strategy,
                    top: y !== null && y !== void 0 ? y : '',
                    left: x !== null && x !== void 0 ? x : '',
                    zIndex: 1
                },
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Popover.Panel, {
                    className: classnames__WEBPACK_IMPORTED_MODULE_3___default()('w-[18rem] max-w-[20rem] overflow-hidden rounded bg-[#F7F8F9] px-4 shadow-translatePanel sm:px-0', popOverPanelClass),
                    children: children
                })
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PopOver);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 26798:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* unused harmony export Select */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_locals__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10601);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_select__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61929);
/* harmony import */ var react_select__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_select__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _select_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(76302);





const Select = /*#__PURE__*/ react__WEBPACK_IMPORTED_MODULE_2___default().forwardRef((props, ref)=>{
    const { isRTL  } = (0,_utils_locals__WEBPACK_IMPORTED_MODULE_1__/* .useIsRTL */ .S)();
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((react_select__WEBPACK_IMPORTED_MODULE_3___default()), {
        ref: ref,
        styles: _select_styles__WEBPACK_IMPORTED_MODULE_4__/* .selectStyles */ .X,
        isRtl: isRTL,
        ...props
    }));
});
Select.displayName = 'Select';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Select);


/***/ }),

/***/ 99996:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ title_with_sort)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
// EXTERNAL MODULE: external "classnames"
var external_classnames_ = __webpack_require__(59003);
var external_classnames_default = /*#__PURE__*/__webpack_require__.n(external_classnames_);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(16689);
;// CONCATENATED MODULE: ./src/components/icons/triangle-arrow-down.tsx


const TriangleArrowDown = (props)=>/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 123.959 123.958",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            d: "M117.979 28.017h-112c-5.3 0-8 6.4-4.2 10.2l56 56c2.3 2.3 6.1 2.3 8.401 0l56-56c3.799-3.8 1.099-10.2-4.201-10.2z",
            fill: "currentColor"
        })
    })
;

;// CONCATENATED MODULE: ./src/components/icons/triangle-arrow-up.tsx

const TriangleArrowUp = (props)=>/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 123.959 123.959",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            d: "M66.18 29.742c-2.301-2.3-6.101-2.3-8.401 0l-56 56c-3.8 3.801-1.1 10.2 4.2 10.2h112c5.3 0 8-6.399 4.2-10.2l-55.999-56z",
            fill: "currentColor"
        })
    })
;

;// CONCATENATED MODULE: ./src/components/ui/title-with-sort.tsx




const TitleWithSort = ({ title , ascending , isActive =true  })=>{
    return(/*#__PURE__*/ (0,jsx_runtime_.jsxs)("span", {
        className: "inline-flex items-center",
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx("span", {
                children: title
            }),
            ascending ? /*#__PURE__*/ jsx_runtime_.jsx(TriangleArrowUp, {
                width: "9",
                className: external_classnames_default()('ms-1.5 flex-shrink-0 text-gray-300', {
                    '!text-heading': isActive
                })
            }) : /*#__PURE__*/ jsx_runtime_.jsx(TriangleArrowDown, {
                width: "9",
                className: external_classnames_default()('ms-1.5 flex-shrink-0 text-gray-300', {
                    '!text-heading': isActive
                })
            })
        ]
    }));
};
/* harmony default export */ const title_with_sort = (TitleWithSort);


/***/ }),

/***/ 8580:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "m7": () => (/* binding */ useCreateCategoryMutation),
/* harmony export */   "l8": () => (/* binding */ useDeleteCategoryMutation),
/* harmony export */   "pi": () => (/* binding */ useUpdateCategoryMutation),
/* harmony export */   "Im": () => (/* binding */ useCategoryQuery),
/* harmony export */   "Ei": () => (/* binding */ useCategoriesQuery)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28379);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85057);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63354);
/* harmony import */ var _client_category__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(76105);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(29249);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_category__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_8__]);
([_client_category__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const useCreateCategoryMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_category__WEBPACK_IMPORTED_MODULE_7__/* .categoryClient.create */ .X.create, {
        onSuccess: ()=>{
            next_router__WEBPACK_IMPORTED_MODULE_0___default().push(_config_routes__WEBPACK_IMPORTED_MODULE_4__/* .Routes.category.list */ .Z.category.list, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_8__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES);
        }
    });
};
const useDeleteCategoryMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_category__WEBPACK_IMPORTED_MODULE_7__/* .categoryClient["delete"] */ .X["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES);
        }
    });
};
const useUpdateCategoryMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_category__WEBPACK_IMPORTED_MODULE_7__/* .categoryClient.update */ .X.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES);
        }
    });
};
const useCategoryQuery = ({ slug , language  })=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES,
        {
            slug,
            language
        }
    ], ()=>_client_category__WEBPACK_IMPORTED_MODULE_7__/* .categoryClient.get */ .X.get({
            slug,
            language
        })
    );
    return {
        category: data,
        error,
        isLoading
    };
};
const useCategoriesQuery = (options)=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES,
        options
    ], ({ queryKey , pageParam  })=>_client_category__WEBPACK_IMPORTED_MODULE_7__/* .categoryClient.paginated */ .X.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    var ref;
    return {
        categories: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__/* .mapPaginatorData */ .Q)(data),
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 76105:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "X": () => (/* binding */ categoryClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5034);
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const categoryClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_1__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES),
    paginated: ({ type , name , ...params })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES, {
            searchJoin: 'and',
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                type,
                name
            })
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5034:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "h": () => (/* binding */ crudFactory)
/* harmony export */ });
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_0__]);
_http_client__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

function crudFactory(endpoint) {
    return {
        all (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        paginated (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        get ({ slug , language  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(`${endpoint}/${slug}`, {
                language
            });
        },
        create (data) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.post */ .eN.post(endpoint, data);
        },
        update ({ id , ...input }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.put */ .eN.put(`${endpoint}/${id}`, input);
        },
        delete ({ id  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient["delete"] */ .eN["delete"](`${endpoint}/${id}`);
        }
    };
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 21351:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "M": () => (/* binding */ productClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5034);
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const productClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_1__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.PRODUCTS */ .P.PRODUCTS),
    get ({ slug , language  }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.PRODUCTS */ .P.PRODUCTS}/${slug}`, {
            language,
            with: 'type;shop;categories;tags;variations.attribute.values;variation_options;author;manufacturer;digital_file'
        });
    },
    paginated: ({ type , name , categories , shop_id , ...params })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.PRODUCTS */ .P.PRODUCTS, {
            searchJoin: 'and',
            with: 'shop;type',
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                type,
                name,
                categories,
                shop_id
            })
        });
    },
    popular ({ shop_id , ...params }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.POPULAR_PRODUCTS */ .P.POPULAR_PRODUCTS, {
            searchJoin: 'and',
            with: 'type;shop',
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                shop_id
            })
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4372:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "A": () => (/* binding */ typeClient)
/* harmony export */ });
/* harmony import */ var _data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5034);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
/* harmony import */ var _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const typeClient = {
    ...(0,_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__/* .crudFactory */ .h)(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.TYPES */ .P.TYPES),
    all: ({ name , ...params })=>{
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.TYPES */ .P.TYPES, {
            searchJoin: 'and',
            ...params,
            search: _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                name
            })
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 24342:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "qX": () => (/* binding */ useCreateProductMutation),
/* harmony export */   "wE": () => (/* binding */ useUpdateProductMutation),
/* harmony export */   "xq": () => (/* binding */ useDeleteProductMutation),
/* harmony export */   "FA": () => (/* binding */ useProductQuery),
/* harmony export */   "kN": () => (/* binding */ useProductsQuery)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85057);
/* harmony import */ var _client_product__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(21351);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63354);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(28379);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(29249);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_product__WEBPACK_IMPORTED_MODULE_5__, _config__WEBPACK_IMPORTED_MODULE_8__]);
([_client_product__WEBPACK_IMPORTED_MODULE_5__, _config__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const useCreateProductMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useQueryClient)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_0__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useMutation)(_client_product__WEBPACK_IMPORTED_MODULE_5__/* .productClient.create */ .M.create, {
        onSuccess: async ()=>{
            const generateRedirectUrl = router.query.shop ? `/${router.query.shop}${_config_routes__WEBPACK_IMPORTED_MODULE_7__/* .Routes.product.list */ .Z.product.list}` : _config_routes__WEBPACK_IMPORTED_MODULE_7__/* .Routes.product.list */ .Z.product.list;
            await next_router__WEBPACK_IMPORTED_MODULE_0___default().push(generateRedirectUrl, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_8__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.PRODUCTS */ .P.PRODUCTS);
        }
    });
};
const useUpdateProductMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useQueryClient)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_0__.useRouter)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useMutation)(_client_product__WEBPACK_IMPORTED_MODULE_5__/* .productClient.update */ .M.update, {
        onSuccess: async (data)=>{
            const generateRedirectUrl = router.query.shop ? `/${router.query.shop}${_config_routes__WEBPACK_IMPORTED_MODULE_7__/* .Routes.product.list */ .Z.product.list}` : _config_routes__WEBPACK_IMPORTED_MODULE_7__/* .Routes.product.list */ .Z.product.list;
            await router.push(`${generateRedirectUrl}/${data === null || data === void 0 ? void 0 : data.slug}/edit`, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_8__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.PRODUCTS */ .P.PRODUCTS);
        }
    });
};
const useDeleteProductMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useMutation)(_client_product__WEBPACK_IMPORTED_MODULE_5__/* .productClient["delete"] */ .M["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.PRODUCTS */ .P.PRODUCTS);
        }
    });
};
const useProductQuery = ({ slug , language  })=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.PRODUCTS */ .P.PRODUCTS,
        {
            slug,
            language
        }
    ], ()=>_client_product__WEBPACK_IMPORTED_MODULE_5__/* .productClient.get */ .M.get({
            slug,
            language
        })
    );
    return {
        product: data,
        error,
        isLoading
    };
};
const useProductsQuery = (params, options = {})=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.PRODUCTS */ .P.PRODUCTS,
        params
    ], ({ queryKey , pageParam  })=>_client_product__WEBPACK_IMPORTED_MODULE_5__/* .productClient.paginated */ .M.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true,
        ...options
    });
    var ref;
    return {
        products: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__/* .mapPaginatorData */ .Q)(data),
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 98077:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "jT": () => (/* binding */ useCreateTypeMutation),
/* harmony export */   "e7": () => (/* binding */ useDeleteTypeMutation),
/* harmony export */   "oy": () => (/* binding */ useUpdateTypeMutation),
/* harmony export */   "F2": () => (/* binding */ useTypeQuery),
/* harmony export */   "qs": () => (/* binding */ useTypesQuery)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28379);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85057);
/* harmony import */ var _data_client_type__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4372);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(29249);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(63354);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_type__WEBPACK_IMPORTED_MODULE_6__, _config__WEBPACK_IMPORTED_MODULE_7__]);
([_data_client_type__WEBPACK_IMPORTED_MODULE_6__, _config__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const useCreateTypeMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient.create */ .A.create, {
        onSuccess: ()=>{
            next_router__WEBPACK_IMPORTED_MODULE_0___default().push(_config_routes__WEBPACK_IMPORTED_MODULE_4__/* .Routes.type.list */ .Z.type.list, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_7__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES);
        }
    });
};
const useDeleteTypeMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient["delete"] */ .A["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES);
        }
    });
};
const useUpdateTypeMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient.update */ .A.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES);
        }
    });
};
const useTypeQuery = ({ slug , language  })=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES,
        {
            slug,
            language
        }
    ], ()=>_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient.get */ .A.get({
            slug,
            language
        })
    );
    return {
        type: data,
        error,
        isLoading
    };
};
const useTypesQuery = (options)=>{
    const { data , isLoading , error  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES,
        options
    ], ({ queryKey , pageParam  })=>_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient.paginated */ .A.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    var ref;
    return {
        types: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_8__/* .mapPaginatorData */ .Q)(data),
        loading: isLoading,
        error
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 86797:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ZP": () => (/* binding */ usePrice)
/* harmony export */ });
/* unused harmony exports formatPrice, formatVariantPrice */
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _settings_site_settings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37070);
/* harmony import */ var _contexts_settings_context__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(92303);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_settings_site_settings__WEBPACK_IMPORTED_MODULE_1__]);
_settings_site_settings__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



function formatPrice({ amount , currencyCode , locale  }) {
    const formatCurrency = new Intl.NumberFormat(locale, {
        style: 'currency',
        currency: currencyCode
    });
    return formatCurrency.format(amount);
}
function formatVariantPrice({ amount , baseAmount , currencyCode , locale  }) {
    const hasDiscount = baseAmount < amount;
    const formatDiscount = new Intl.NumberFormat(locale, {
        style: 'percent'
    });
    const discount = hasDiscount ? formatDiscount.format((amount - baseAmount) / amount) : null;
    const price = formatPrice({
        amount,
        currencyCode,
        locale
    });
    const basePrice = hasDiscount ? formatPrice({
        amount: baseAmount,
        currencyCode,
        locale
    }) : null;
    return {
        price,
        basePrice,
        discount
    };
}
function usePrice(data) {
    const { currency  } = (0,_contexts_settings_context__WEBPACK_IMPORTED_MODULE_2__/* .useSettings */ .rV)();
    const { amount , baseAmount , currencyCode =currency  } = data !== null && data !== void 0 ? data : {};
    const locale = _settings_site_settings__WEBPACK_IMPORTED_MODULE_1__/* .siteSettings.defaultLanguage */ .U.defaultLanguage;
    const value = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(()=>{
        if (typeof amount !== 'number' || !currencyCode) return '';
        return baseAmount ? formatVariantPrice({
            amount,
            baseAmount,
            currencyCode,
            locale
        }) : formatPrice({
            amount,
            currencyCode,
            locale
        });
    }, [
        amount,
        baseAmount,
        currencyCode
    ]);
    return typeof value === 'string' ? {
        price: value,
        basePrice: null,
        discount: null
    } : value;
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;