"use strict";
exports.id = 4511;
exports.ids = [4511];
exports.modules = {

/***/ 39876:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "b": () => (/* binding */ Eye)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const Eye = (props)=>/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        stroke: "currentColor",
        ...props,
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: 2,
                d: "M15 12a3 3 0 11-6 0 3 3 0 016 0z"
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: 2,
                d: "M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"
            })
        ]
    })
;


/***/ }),

/***/ 4511:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ password_input)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
// EXTERNAL MODULE: ./src/components/icons/eye-icon.tsx
var eye_icon = __webpack_require__(39876);
;// CONCATENATED MODULE: ./src/components/icons/eye-off-icon.tsx

const EyeOff = (props)=>/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        stroke: "currentColor",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeWidth: 2,
            d: "M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"
        })
    })
;

// EXTERNAL MODULE: external "classnames"
var external_classnames_ = __webpack_require__(59003);
var external_classnames_default = /*#__PURE__*/__webpack_require__.n(external_classnames_);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(16689);
var external_react_default = /*#__PURE__*/__webpack_require__.n(external_react_);
// EXTERNAL MODULE: ./src/components/ui/link.tsx
var ui_link = __webpack_require__(31434);
;// CONCATENATED MODULE: ./src/components/ui/password-input.tsx






const classes = {
    root: 'px-4 h-12 flex items-center w-full rounded appearance-none transition duration-300 ease-in-out text-heading text-sm focus:outline-none focus:ring-0',
    normal: 'bg-gray-100 border border-border-base focus:shadow focus:bg-light focus:border-accent',
    solid: 'bg-gray-100 border border-border-100 focus:bg-light focus:border-accent',
    outline: 'border border-border-base focus:border-accent',
    shadow: 'focus:shadow'
};
const PasswordInput = /*#__PURE__*/ external_react_default().forwardRef(({ className , inputClassName , forgotPassHelpText , label , name , error , children , variant ='normal' , shadow =false , type ='text' , forgotPageLink ='' , ...rest }, ref)=>{
    const { 0: show , 1: setShow  } = (0,external_react_.useState)(false);
    const rootClassName = external_classnames_default()(classes.root, {
        [classes.normal]: variant === 'normal',
        [classes.solid]: variant === 'solid',
        [classes.outline]: variant === 'outline'
    }, shadow == true && classes.shadow, inputClassName);
    return(/*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
        className: className,
        children: [
            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                className: "mb-3 flex items-center justify-between",
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("label", {
                        htmlFor: name,
                        className: "text-sm font-semibold leading-none text-body-dark",
                        children: label
                    }),
                    forgotPageLink && forgotPassHelpText && /*#__PURE__*/ jsx_runtime_.jsx(ui_link/* default */.Z, {
                        href: forgotPageLink,
                        className: "text-xs text-accent transition-colors duration-200 hover:text-accent-hover focus:font-semibold focus:text-accent-700 focus:outline-none",
                        children: forgotPassHelpText
                    })
                ]
            }),
            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                className: "relative",
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("input", {
                        id: name,
                        name: name,
                        type: show ? 'text' : 'password',
                        ref: ref,
                        className: rootClassName,
                        autoComplete: "off",
                        autoCorrect: "off",
                        autoCapitalize: "off",
                        spellCheck: "false",
                        ...rest
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("label", {
                        htmlFor: name,
                        className: "end-4 absolute top-5 -mt-2 text-body",
                        onClick: ()=>setShow((prev)=>!prev
                            )
                        ,
                        children: show ? /*#__PURE__*/ jsx_runtime_.jsx(EyeOff, {
                            className: "h-5 w-5"
                        }) : /*#__PURE__*/ jsx_runtime_.jsx(eye_icon/* Eye */.b, {
                            className: "h-5 w-5"
                        })
                    })
                ]
            }),
            error && /*#__PURE__*/ jsx_runtime_.jsx("p", {
                className: "text-start my-2 text-xs text-red-500",
                children: error
            })
        ]
    }));
});
PasswordInput.displayName = 'PasswordInput';
/* harmony default export */ const password_input = (PasswordInput);


/***/ })

};
;