"use strict";
exports.id = 4536;
exports.ids = [4536];
exports.modules = {

/***/ 36459:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "E": () => (/* binding */ MessageAvatarPlaceholderIcon)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageAvatarPlaceholderIcon = ({ color ='currentColor' , ...props })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 40 40",
        width: "1em",
        height: "1em",
        fill: "none",
        ...props,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            fill: color,
            fillRule: "evenodd",
            d: "M20 40c11.046 0 20-8.954 20-20S31.046 0 20 0 0 8.954 0 20s8.954 20 20 20Zm1.116-28.32 7.204 7.204c.89.89.909 2.317.04 3.186l-6.29 6.29c-.869.869-2.295.85-3.186-.04l-7.204-7.204a2.298 2.298 0 0 1-.642-2.042l.994-5.297a2.177 2.177 0 0 1 1.745-1.744l5.297-.995a2.298 2.298 0 0 1 2.042.642Zm-6.123 5.672a1.668 1.668 0 1 0 2.359-2.36 1.668 1.668 0 0 0-2.36 2.36Z",
            clipRule: "evenodd"
        })
    }));
};


/***/ }),

/***/ 35282:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "z": () => (/* binding */ conversationsClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5034);
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const conversationsClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_1__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.CONVERSIONS */ .P.CONVERSIONS),
    getMessage ({ slug , ...prams }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.MESSAGE */ .P.MESSAGE}/${slug}`, {
            searchJoin: 'and',
            ...prams
        });
    },
    getConversion ({ id  }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.CONVERSIONS */ .P.CONVERSIONS}/${id}`);
    },
    messageCreate ({ id , ...input }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.post */ .eN.post(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.MESSAGE */ .P.MESSAGE}/${id}`, input);
    },
    messageSeen ({ id  }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.post */ .eN.post(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.MESSAGE_SEEN */ .P.MESSAGE_SEEN}/${id}`, id);
    },
    allConversation: (params)=>_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.CONVERSIONS */ .P.CONVERSIONS, params)
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 84891:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "sw": () => (/* binding */ useConversationsQuery),
/* harmony export */   "As": () => (/* binding */ useCreateConversations),
/* harmony export */   "kY": () => (/* binding */ useMessagesQuery),
/* harmony export */   "Cq": () => (/* binding */ useConversationQuery),
/* harmony export */   "$3": () => (/* binding */ useSendMessage),
/* harmony export */   "uX": () => (/* binding */ useMessageSeen)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28379);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85057);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63354);
/* harmony import */ var _client_conversations__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(35282);
/* harmony import */ var _components_ui_modal_modal_context__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(44144);
/* harmony import */ var _utils_auth_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(49239);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_conversations__WEBPACK_IMPORTED_MODULE_7__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_9__]);
([_client_conversations__WEBPACK_IMPORTED_MODULE_7__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_9__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);










const useConversationsQuery = (options)=>{
    var ref;
    const { data , isLoading , error , refetch , fetchNextPage , hasNextPage , isFetching , isSuccess , isFetchingNextPage ,  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useInfiniteQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CONVERSIONS */ .P.CONVERSIONS,
        options
    ], ({ queryKey , pageParam  })=>_client_conversations__WEBPACK_IMPORTED_MODULE_7__/* .conversationsClient.allConversation */ .z.allConversation(Object.assign({}, queryKey[1], pageParam))
    , {
        getNextPageParam: ({ current_page , last_page  })=>last_page > current_page && {
                page: current_page + 1
            }
    });
    function handleLoadMore() {
        if (Boolean(hasNextPage)) {
            fetchNextPage();
        }
    }
    var ref1;
    return {
        conversations: (ref1 = data === null || data === void 0 ? void 0 : (ref = data.pages) === null || ref === void 0 ? void 0 : ref.flatMap((page)=>page.data
        )) !== null && ref1 !== void 0 ? ref1 : [],
        paginatorInfo: Array.isArray(data === null || data === void 0 ? void 0 : data.pages) ? (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__/* .mapPaginatorData */ .Q)(data === null || data === void 0 ? void 0 : data.pages[data.pages.length - 1]) : null,
        loading: isLoading,
        error,
        isFetching,
        refetch,
        isSuccess,
        isLoadingMore: isFetchingNextPage,
        loadMore: handleLoadMore,
        hasMore: Boolean(hasNextPage)
    };
};
const useCreateConversations = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_0__.useRouter)();
    const { closeModal  } = (0,_components_ui_modal_modal_context__WEBPACK_IMPORTED_MODULE_8__/* .useModalAction */ .SO)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { permissions  } = (0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_9__/* .getAuthCredentials */ .WA)();
    let permission = (0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_9__/* .hasAccess */ .Ft)(_utils_auth_utils__WEBPACK_IMPORTED_MODULE_9__/* .adminOnly */ .M$, permissions);
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_conversations__WEBPACK_IMPORTED_MODULE_7__/* .conversationsClient.create */ .z.create, {
        onSuccess: (data)=>{
            if (data === null || data === void 0 ? void 0 : data.id) {
                var ref, ref2;
                const routes = permission ? _config_routes__WEBPACK_IMPORTED_MODULE_4__/* .Routes */ .Z === null || _config_routes__WEBPACK_IMPORTED_MODULE_4__/* .Routes */ .Z === void 0 ? void 0 : (ref = _config_routes__WEBPACK_IMPORTED_MODULE_4__/* .Routes.message */ .Z.message) === null || ref === void 0 ? void 0 : ref.details(data === null || data === void 0 ? void 0 : data.id) : _config_routes__WEBPACK_IMPORTED_MODULE_4__/* .Routes */ .Z === null || _config_routes__WEBPACK_IMPORTED_MODULE_4__/* .Routes */ .Z === void 0 ? void 0 : (ref2 = _config_routes__WEBPACK_IMPORTED_MODULE_4__/* .Routes.shopMessage */ .Z.shopMessage) === null || ref2 === void 0 ? void 0 : ref2.details(data === null || data === void 0 ? void 0 : data.id);
                react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-created'));
                router.push(`${routes}`);
                closeModal();
            } else {
                var ref3;
                // @ts-ignore
                react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.error(t((ref3 = data === null || data === void 0 ? void 0 : data.errors[0]) === null || ref3 === void 0 ? void 0 : ref3.message));
            }
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.MESSAGE */ .P.MESSAGE);
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CONVERSIONS */ .P.CONVERSIONS);
        }
    });
};
const useMessagesQuery = (options)=>{
    var ref;
    const { data , isLoading , error , refetch , fetchNextPage , hasNextPage , isFetching , isSuccess , isFetchingNextPage ,  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useInfiniteQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.MESSAGE */ .P.MESSAGE,
        options
    ], ({ queryKey , pageParam  })=>_client_conversations__WEBPACK_IMPORTED_MODULE_7__/* .conversationsClient.getMessage */ .z.getMessage(Object.assign({}, queryKey[1], pageParam))
    , {
        getNextPageParam: ({ current_page , last_page  })=>last_page > current_page && {
                page: current_page + 1
            }
    });
    function handleLoadMore() {
        if (Boolean(hasNextPage)) {
            fetchNextPage();
        }
    }
    var ref4;
    return {
        messages: (ref4 = data === null || data === void 0 ? void 0 : (ref = data.pages) === null || ref === void 0 ? void 0 : ref.flatMap((page)=>page.data
        )) !== null && ref4 !== void 0 ? ref4 : [],
        paginatorInfo: Array.isArray(data === null || data === void 0 ? void 0 : data.pages) ? (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__/* .mapPaginatorData */ .Q)(data === null || data === void 0 ? void 0 : data.pages[data.pages.length - 1]) : null,
        loading: isLoading,
        error,
        isFetching,
        refetch,
        isSuccess,
        isLoadingMore: isFetchingNextPage,
        loadMore: handleLoadMore,
        hasMore: Boolean(hasNextPage)
    };
};
const useConversationQuery = ({ id  })=>{
    const { data , error , isLoading , isFetching  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CONVERSIONS */ .P.CONVERSIONS,
        id
    ], ()=>_client_conversations__WEBPACK_IMPORTED_MODULE_7__/* .conversationsClient.getConversion */ .z.getConversion({
            id
        })
    , {
        keepPreviousData: true
    });
    return {
        data: data !== null && data !== void 0 ? data : [],
        error,
        loading: isLoading,
        isFetching
    };
};
const useSendMessage = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_conversations__WEBPACK_IMPORTED_MODULE_7__/* .conversationsClient.messageCreate */ .z.messageCreate, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:text-message-sent'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.MESSAGE */ .P.MESSAGE);
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CONVERSIONS */ .P.CONVERSIONS);
        }
    });
};
const useMessageSeen = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_conversations__WEBPACK_IMPORTED_MODULE_7__/* .conversationsClient.messageSeen */ .z.messageSeen, {
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.MESSAGE */ .P.MESSAGE);
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CONVERSIONS */ .P.CONVERSIONS);
        }
    });
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;