"use strict";
exports.id = 4708;
exports.ids = [4708];
exports.modules = {

/***/ 29993:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ add_to_cart_btn)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
// EXTERNAL MODULE: ./src/components/icons/plus-icon.tsx
var plus_icon = __webpack_require__(90393);
;// CONCATENATED MODULE: ./src/components/icons/cart.tsx

const Cart = (props)=>{
    return(/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        ...props,
        viewBox: "0 0 14.4 12",
        children: /*#__PURE__*/ jsx_runtime_.jsx("g", {
            transform: "translate(-288 -413.89)",
            children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
                fill: "currentColor",
                d: "M298.7,418.289l-2.906-4.148a.835.835,0,0,0-.528-.251.607.607,0,0,0-.529.251l-2.905,4.148h-3.17a.609.609,0,0,0-.661.625v.191l1.651,5.84a1.336,1.336,0,0,0,1.255.945h8.588a1.261,1.261,0,0,0,1.254-.945l1.651-5.84v-.191a.609.609,0,0,0-.661-.625Zm-5.419,0,1.984-2.767,1.98,2.767Zm1.984,5.024a1.258,1.258,0,1,1,1.319-1.258,1.3,1.3,0,0,1-1.319,1.258Zm0,0"
            })
        })
    }));
};
/* harmony default export */ const cart = (Cart);

// EXTERNAL MODULE: external "next-i18next"
var external_next_i18next_ = __webpack_require__(11377);
// EXTERNAL MODULE: external "classnames"
var external_classnames_ = __webpack_require__(59003);
var external_classnames_default = /*#__PURE__*/__webpack_require__.n(external_classnames_);
;// CONCATENATED MODULE: ./src/components/cart/add-to-cart/add-to-cart-btn.tsx





const AddToCartBtn = ({ variant , onClick , disabled  })=>{
    const { t  } = (0,external_next_i18next_.useTranslation)('common');
    switch(variant){
        case 'neon':
            return(/*#__PURE__*/ (0,jsx_runtime_.jsxs)("button", {
                onClick: onClick,
                disabled: disabled,
                className: "group flex h-7 w-full items-center justify-between rounded bg-gray-100 text-xs text-body-dark transition-colors hover:border-accent hover:bg-accent hover:text-light focus:border-accent focus:bg-accent focus:text-light focus:outline-none md:h-9 md:text-sm",
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("span", {
                        className: "flex-1",
                        children: t('text-add')
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("span", {
                        className: "rounded-te rounded-be grid h-7 w-7 place-items-center bg-gray-200 transition-colors duration-200 group-hover:bg-accent-600 group-focus:bg-accent-600 md:h-9 md:w-9",
                        children: /*#__PURE__*/ jsx_runtime_.jsx(plus_icon/* PlusIcon */.p, {
                            className: "h-4 w-4 stroke-2 group-hover:text-light"
                        })
                    })
                ]
            }));
        case 'argon':
            return(/*#__PURE__*/ jsx_runtime_.jsx("button", {
                onClick: onClick,
                disabled: disabled,
                className: "flex h-7 w-7 items-center justify-center rounded border border-border-200 bg-light text-sm text-heading transition-colors hover:border-accent hover:bg-accent hover:text-light focus:border-accent focus:bg-accent focus:text-light focus:outline-none md:h-9 md:w-9",
                children: /*#__PURE__*/ jsx_runtime_.jsx(plus_icon/* PlusIcon */.p, {
                    className: "h-5 w-5 stroke-2"
                })
            }));
        case 'oganesson':
            return(/*#__PURE__*/ (0,jsx_runtime_.jsxs)("button", {
                onClick: onClick,
                disabled: disabled,
                className: "shadow-500 flex h-8 w-8 items-center justify-center rounded-full bg-accent text-sm text-light transition-colors hover:border-accent hover:bg-accent hover:text-light focus:border-accent focus:bg-accent focus:text-light focus:outline-none md:h-10 md:w-10",
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("span", {
                        className: "sr-only",
                        children: t('text-plus')
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx(plus_icon/* PlusIcon */.p, {
                        className: "h-5 w-5 stroke-2 md:h-6 md:w-6"
                    })
                ]
            }));
        case 'single':
            return(/*#__PURE__*/ (0,jsx_runtime_.jsxs)("button", {
                onClick: onClick,
                disabled: disabled,
                className: "order-5 flex items-center justify-center rounded-full border-2 border-border-100 bg-light py-2 px-3 text-sm font-semibold text-accent transition-colors duration-300 hover:border-accent hover:bg-accent hover:text-light focus:border-accent focus:bg-accent focus:text-light focus:outline-none sm:order-4 sm:justify-start sm:px-5",
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx(cart, {
                        className: "me-2.5 h-4 w-4"
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("span", {
                        children: t('text-cart')
                    })
                ]
            }));
        case 'big':
            return(/*#__PURE__*/ jsx_runtime_.jsx("button", {
                onClick: onClick,
                disabled: disabled,
                className: external_classnames_default()('flex w-full items-center justify-center rounded bg-accent py-4 px-5 text-sm font-light text-light transition-colors duration-300 hover:bg-accent-hover focus:bg-accent-hover focus:outline-none lg:text-base', {
                    'cursor-not-allowed border border-border-400 !bg-gray-300 !text-body hover:!bg-gray-300': disabled
                }),
                children: /*#__PURE__*/ jsx_runtime_.jsx("span", {
                    children: t('text-add-cart')
                })
            }));
        default:
            return(/*#__PURE__*/ (0,jsx_runtime_.jsxs)("button", {
                onClick: onClick,
                disabled: disabled,
                title: disabled ? 'Out Of Stock' : '',
                className: "flex h-7 w-7 items-center justify-center rounded border border-border-200 bg-light text-sm text-accent transition-colors hover:border-accent hover:bg-accent hover:text-light focus:border-accent focus:bg-accent focus:text-light focus:outline-none md:h-9 md:w-9",
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("span", {
                        className: "sr-only",
                        children: t('text-plus')
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx(plus_icon/* PlusIcon */.p, {
                        className: "h-5 w-5 stroke-2"
                    })
                ]
            }));
    }
};
/* harmony default export */ const add_to_cart_btn = (AddToCartBtn);


/***/ }),

/***/ 54003:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "o": () => (/* binding */ AddToCart)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_counter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(62245);
/* harmony import */ var _components_cart_add_to_cart_add_to_cart_btn__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(29993);
/* harmony import */ var _utils_cart_animation__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(7642);
/* harmony import */ var _contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(40601);
/* harmony import */ var _contexts_quick_cart_generate_cart_item__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(92623);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_3__]);
_contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






const AddToCart = ({ data , variant ='helium' , counterVariant , counterClass , variation , disabled  })=>{
    const { addItemToCart , removeItemFromCart , isInStock , getItemFromCart , isInCart ,  } = (0,_contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_3__/* .useCart */ .jD)();
    const item = (0,_contexts_quick_cart_generate_cart_item__WEBPACK_IMPORTED_MODULE_4__/* .generateCartItem */ .z)(data, variation);
    const handleAddClick = (e)=>{
        e.stopPropagation();
        addItemToCart(item, 1);
        if (!isInCart(item.id)) {
            (0,_utils_cart_animation__WEBPACK_IMPORTED_MODULE_5__/* .cartAnimation */ .L)(e);
        }
    };
    const handleRemoveClick = (e)=>{
        e.stopPropagation();
        removeItemFromCart(item.id);
    };
    const outOfStock = isInCart(item === null || item === void 0 ? void 0 : item.id) && !isInStock(item.id);
    return !isInCart(item === null || item === void 0 ? void 0 : item.id) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_cart_add_to_cart_add_to_cart_btn__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        disabled: disabled || outOfStock,
        variant: variant,
        onClick: handleAddClick
    }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_counter__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
            value: getItemFromCart(item.id).quantity,
            onDecrement: handleRemoveClick,
            onIncrement: handleAddClick,
            variant: counterVariant || variant,
            className: counterClass,
            disabled: outOfStock
        })
    });
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 90393:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "p": () => (/* binding */ PlusIcon)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const PlusIcon = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        fill: "none",
        viewBox: "0 0 24 24",
        stroke: "currentColor",
        ...props,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            strokeLinecap: "round",
            strokeLinejoin: "round",
            d: "M12 6v6m0 0v6m0-6h6m-6 0H6"
        })
    })
;


/***/ }),

/***/ 69080:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "iv": () => (/* binding */ AttributesProvider),
/* harmony export */   "Ch": () => (/* binding */ useAttributes)
/* harmony export */ });
/* unused harmony export AttributesContext */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const initialState = {};
const AttributesContext = /*#__PURE__*/ react__WEBPACK_IMPORTED_MODULE_1___default().createContext(initialState);
AttributesContext.displayName = 'AttributesContext';
const AttributesProvider = (props)=>{
    const [state, dispatch] = react__WEBPACK_IMPORTED_MODULE_1___default().useState(initialState);
    const value = react__WEBPACK_IMPORTED_MODULE_1___default().useMemo(()=>({
            attributes: state,
            setAttributes: dispatch
        })
    , [
        state
    ]);
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(AttributesContext.Provider, {
        value: value,
        ...props
    }));
};
const useAttributes = ()=>{
    const context = react__WEBPACK_IMPORTED_MODULE_1___default().useContext(AttributesContext);
    if (context === undefined) {
        throw new Error(`useAttributes must be used within a SettingsProvider`);
    }
    return context;
};


/***/ }),

/***/ 15612:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "y": () => (/* binding */ getVariations)
/* harmony export */ });
/* harmony import */ var lodash_groupBy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98492);
/* harmony import */ var lodash_groupBy__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_groupBy__WEBPACK_IMPORTED_MODULE_0__);

function getVariations(variations) {
    if (!variations) return {};
    return lodash_groupBy__WEBPACK_IMPORTED_MODULE_0___default()(variations, 'attribute.slug');
}


/***/ }),

/***/ 94258:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "V": () => (/* binding */ isVariationSelected)
/* harmony export */ });
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(89699);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0__);

function isVariationSelected(variations, attributes) {
    if (lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0___default()(variations)) return true;
    if (!lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0___default()(attributes)) {
        return Object.keys(variations).every((variation)=>attributes.hasOwnProperty(variation)
        );
    }
    return false;
}


/***/ }),

/***/ 30531:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ variation_groups)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
// EXTERNAL MODULE: external "classnames"
var external_classnames_ = __webpack_require__(59003);
var external_classnames_default = /*#__PURE__*/__webpack_require__.n(external_classnames_);
;// CONCATENATED MODULE: ./src/components/ui/attribute.tsx


const Attribute = ({ value , active , className , color , ...props })=>{
    const classes = external_classnames_default()({
        'px-4 py-3 text-sm border rounded text-heading bg-gray-50 border-border-200': className !== 'color',
        '!text-light !bg-accent !border-accent': active && className !== 'color',
        'h-11 w-11 p-0.5 flex items-center justify-center border-2 rounded-full border-transparent': className === 'color',
        '!border-accent': active && className === 'color'
    }, 'cursor-pointer');
    return(/*#__PURE__*/ jsx_runtime_.jsx("div", {
        className: classes,
        ...props,
        children: className === 'color' ? /*#__PURE__*/ jsx_runtime_.jsx("span", {
            className: "w-full h-full rounded-full border border-border-200",
            style: {
                backgroundColor: color
            }
        }) : value
    }));
};
/* harmony default export */ const ui_attribute = (Attribute);

// EXTERNAL MODULE: ./src/components/ui/scrollbar.tsx
var scrollbar = __webpack_require__(97046);
// EXTERNAL MODULE: ./src/components/product/variation/attributes.context.tsx
var attributes_context = __webpack_require__(69080);
;// CONCATENATED MODULE: ./src/components/product/variation/variation-groups.tsx




const VariationGroups = ({ variations  })=>{
    const { attributes , setAttributes  } = (0,attributes_context/* useAttributes */.Ch)();
    const replaceHyphens = (str)=>{
        return str.replace(/-/g, ' ');
    };
    return(/*#__PURE__*/ jsx_runtime_.jsx(jsx_runtime_.Fragment, {
        children: Object.keys(variations).map((variationName, index)=>{
            /*#__PURE__*/ return (0,jsx_runtime_.jsxs)("div", {
                className: "flex items-center border-b border-border-200 border-opacity-70 py-4 first:pt-0 last:border-b-0 last:pb-0",
                children: [
                    /*#__PURE__*/ (0,jsx_runtime_.jsxs)("span", {
                        className: "me-4 inline-block min-w-[60px] whitespace-nowrap text-sm font-semibold capitalize leading-none text-heading",
                        children: [
                            replaceHyphens(variationName),
                            ":"
                        ]
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        className: "-mb-5 w-full overflow-hidden",
                        children: /*#__PURE__*/ jsx_runtime_.jsx(scrollbar/* default */.Z, {
                            className: "w-full pb-5",
                            options: {
                                scrollbars: {
                                    autoHide: 'never'
                                }
                            },
                            children: /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                className: "space-s-4 flex w-full",
                                children: variations[variationName].map((attribute)=>{
                                    /*#__PURE__*/ return jsx_runtime_.jsx(ui_attribute, {
                                        className: variationName,
                                        color: attribute.meta ? attribute.meta : attribute === null || attribute === void 0 ? void 0 : attribute.value,
                                        active: attributes[variationName] === attribute.value,
                                        value: attribute.value,
                                        onClick: ()=>setAttributes((prev)=>({
                                                    ...prev,
                                                    [variationName]: attribute.value
                                                })
                                            )
                                    }, attribute.id);
                                })
                            })
                        })
                    })
                ]
            }, index);
        })
    }));
};
/* harmony default export */ const variation_groups = (VariationGroups);


/***/ }),

/***/ 44614:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ VariationPrice)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_use_price__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(86797);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(89699);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_2__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_utils_use_price__WEBPACK_IMPORTED_MODULE_1__]);
_utils_use_price__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



function VariationPrice({ selectedVariation , minPrice , maxPrice  }) {
    const { price , basePrice  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)(selectedVariation && {
        amount: selectedVariation.sale_price ? selectedVariation.sale_price : selectedVariation.price,
        baseAmount: selectedVariation.price
    });
    const { price: min_price  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)({
        amount: minPrice
    });
    const { price: max_price  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP)({
        amount: maxPrice
    });
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
        className: "flex items-center",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("ins", {
                className: "text-2xl font-semibold text-accent no-underline",
                children: !lodash_isEmpty__WEBPACK_IMPORTED_MODULE_2___default()(selectedVariation) ? `${price}` : `${min_price} - ${max_price}`
            }),
            basePrice && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("del", {
                className: "ms-2 text-sm font-normal text-muted md:text-base",
                children: basePrice
            })
        ]
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 54708:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _get_variations__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15612);
/* harmony import */ var _is_variation_selected__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(94258);
/* harmony import */ var _variation_groups__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(30531);
/* harmony import */ var _variation_price__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(44614);
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(40113);
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash_isEqual__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _attributes_context__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(69080);
/* harmony import */ var _components_cart_add_to_cart_add_to_cart__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(54003);
/* harmony import */ var _data_product__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(24342);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_10__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_variation_price__WEBPACK_IMPORTED_MODULE_5__, _components_cart_add_to_cart_add_to_cart__WEBPACK_IMPORTED_MODULE_8__, _data_product__WEBPACK_IMPORTED_MODULE_9__]);
([_variation_price__WEBPACK_IMPORTED_MODULE_5__, _components_cart_add_to_cart_add_to_cart__WEBPACK_IMPORTED_MODULE_8__, _data_product__WEBPACK_IMPORTED_MODULE_9__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);











const Variation = ({ product  })=>{
    const { attributes  } = (0,_attributes_context__WEBPACK_IMPORTED_MODULE_7__/* .useAttributes */ .Ch)();
    const variations = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(()=>{
        return (0,_get_variations__WEBPACK_IMPORTED_MODULE_2__/* .getVariations */ .y)(product === null || product === void 0 ? void 0 : product.variations);
    }, [
        product === null || product === void 0 ? void 0 : product.variations
    ]);
    const isSelected = (0,_is_variation_selected__WEBPACK_IMPORTED_MODULE_3__/* .isVariationSelected */ .V)(variations, attributes);
    let selectedVariation = {};
    if (isSelected) {
        var ref;
        selectedVariation = product === null || product === void 0 ? void 0 : (ref = product.variation_options) === null || ref === void 0 ? void 0 : ref.find((o)=>lodash_isEqual__WEBPACK_IMPORTED_MODULE_6___default()(o.options.map((v)=>v.value
            ).sort(), Object.values(attributes).sort())
        );
    }
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "w-[95vw] max-w-lg rounded-md bg-white p-8",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h3", {
                className: "mb-2 text-center text-2xl font-semibold text-heading",
                children: product === null || product === void 0 ? void 0 : product.name
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "mb-8 flex items-center justify-center",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_variation_price__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                    selectedVariation: selectedVariation,
                    minPrice: product.min_price,
                    maxPrice: product.max_price
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "mb-8",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_variation_groups__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                    variations: variations
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_cart_add_to_cart_add_to_cart__WEBPACK_IMPORTED_MODULE_8__/* .AddToCart */ .o, {
                data: product,
                variant: "big",
                variation: selectedVariation,
                disabled: (selectedVariation === null || selectedVariation === void 0 ? void 0 : selectedVariation.is_disable) || !isSelected
            })
        ]
    }));
};
const ProductVariation = ({ productSlug  })=>{
    const { locale  } = (0,next_router__WEBPACK_IMPORTED_MODULE_10__.useRouter)();
    const { product , isLoading: loading  } = (0,_data_product__WEBPACK_IMPORTED_MODULE_9__/* .useProductQuery */ .FA)({
        slug: productSlug,
        language: locale
    });
    if (loading || !product) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        children: "Loading"
    }));
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_attributes_context__WEBPACK_IMPORTED_MODULE_7__/* .AttributesProvider */ .iv, {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(Variation, {
            product: product
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProductVariation);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 62245:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ counter)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
// EXTERNAL MODULE: external "classnames"
var external_classnames_ = __webpack_require__(59003);
var external_classnames_default = /*#__PURE__*/__webpack_require__.n(external_classnames_);
// EXTERNAL MODULE: ./src/components/icons/plus-icon.tsx
var plus_icon = __webpack_require__(90393);
;// CONCATENATED MODULE: ./src/components/icons/minus-icon.tsx

const MinusIcon = (props)=>/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        fill: "none",
        viewBox: "0 0 24 24",
        stroke: "currentColor",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            strokeLinecap: "round",
            strokeLinejoin: "round",
            d: "M20 12H4"
        })
    })
;

// EXTERNAL MODULE: external "next-i18next"
var external_next_i18next_ = __webpack_require__(11377);
;// CONCATENATED MODULE: ./src/components/ui/counter.tsx





const variantClasses = {
    helium: 'w-7 h-18 sm:w-20 sm:h-7 md:h-9 md:w-24 bg-accent flex-col-reverse sm:flex-row absolute sm:static bottom-3 end-3 sm:bottom-0 sm:end-0 text-light rounded',
    neon: 'w-full h-7 md:h-9 bg-accent text-light rounded',
    argon: 'w-7 h-18 sm:w-20 sm:h-7 md:h-9 md:w-24 bg-accent flex-col-reverse sm:flex-row text-light rounded',
    oganesson: 'w-20 h-8 md:w-24 md:h-10 bg-accent text-light rounded-full shadow-500',
    single: 'order-5 sm:order-4 w-9 sm:w-24 h-24 sm:h-10 bg-accent text-light rounded-full flex-col-reverse sm:flex-row absolute sm:relative bottom-0 sm:bottom-auto end-0 sm:end-auto',
    details: 'order-5 sm:order-4 w-full sm:w-24 h-10 bg-accent text-light rounded-full',
    pillVertical: 'flex-col-reverse items-center w-8 h-24 bg-gray-100 text-heading rounded-full',
    big: 'w-full h-14 rounded text-light bg-accent inline-flex justify-between'
};
const Counter = ({ value , variant ='helium' , onDecrement , onIncrement , className , disabled ,  })=>{
    const { t  } = (0,external_next_i18next_.useTranslation)('common');
    return(/*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
        className: external_classnames_default()('flex overflow-hidden', variantClasses[variant], className),
        children: [
            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("button", {
                onClick: onDecrement,
                className: external_classnames_default()('cursor-pointer p-2 transition-colors duration-200 hover:bg-accent-hover focus:outline-none', {
                    'px-3 py-3 sm:px-2': variant === 'single',
                    'px-5': variant === 'big',
                    'hover:!bg-gray-100': variant === 'pillVertical'
                }),
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("span", {
                        className: "sr-only",
                        children: t('text-minus')
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx(MinusIcon, {
                        className: "h-3 w-3 stroke-2"
                    })
                ]
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                className: external_classnames_default()('flex flex-1 items-center justify-center text-sm font-semibold', variant === 'pillVertical' && 'text-heading'),
                children: value
            }),
            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("button", {
                onClick: onIncrement,
                disabled: disabled,
                className: external_classnames_default()('cursor-pointer p-2 transition-colors duration-200 hover:bg-accent-hover focus:outline-none', {
                    'px-3 py-3 sm:px-2': variant === 'single',
                    'px-5': variant === 'big',
                    'hover:!bg-gray-100': variant === 'pillVertical'
                }),
                title: disabled ? t('text-out-stock') : '',
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("span", {
                        className: "sr-only",
                        children: t('text-plus')
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx(plus_icon/* PlusIcon */.p, {
                        className: "md:h-4.5 md:w-4.5 h-3.5 w-3.5 stroke-2"
                    })
                ]
            })
        ]
    }));
};
/* harmony default export */ const counter = (Counter);


/***/ }),

/***/ 97046:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var overlayscrollbars_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(153);
/* harmony import */ var overlayscrollbars_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(overlayscrollbars_react__WEBPACK_IMPORTED_MODULE_2__);




const Scrollbar = ({ options , children , style , className , ...props })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(overlayscrollbars_react__WEBPACK_IMPORTED_MODULE_2__.OverlayScrollbarsComponent, {
        options: {
            className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('os-theme-thin-dark', className),
            scrollbars: {
                autoHide: 'scroll'
            },
            ...options
        },
        style: style,
        ...props,
        children: children
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Scrollbar);


/***/ }),

/***/ 92623:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "z": () => (/* binding */ generateCartItem)
/* harmony export */ });
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(89699);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0__);

function generateCartItem(item, variation) {
    const { id , name , slug , image , price , sale_price , quantity , unit , is_digital ,  } = item;
    if (!lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0___default()(variation)) {
        return {
            id: `${id}.${variation.id}`,
            productId: id,
            name: `${name} - ${variation.title}`,
            slug,
            unit,
            is_digital,
            stock: variation.quantity,
            price: variation.sale_price ? variation.sale_price : variation.price,
            image: image === null || image === void 0 ? void 0 : image.thumbnail,
            variationId: variation.id
        };
    }
    return {
        id,
        name,
        slug,
        unit,
        is_digital,
        image: image === null || image === void 0 ? void 0 : image.thumbnail,
        stock: quantity,
        price: sale_price ? sale_price : price
    };
}


/***/ }),

/***/ 7642:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "L": () => (/* binding */ cartAnimation)
/* harmony export */ });
const cartAnimation = (event)=>{
    const getClosest = function(elem, selector) {
        for(; elem && elem !== document; elem = elem.parentNode){
            if (elem.matches(selector)) return elem;
        }
        return null;
    };
    // start animation block
    let imgToDrag = getClosest(event.target, '.product-card');
    if (!imgToDrag) return;
    let viewCart = document.getElementsByClassName('product-cart')[0];
    let imgToDragImage = imgToDrag.querySelector('.product-image');
    let disLeft = imgToDrag.getBoundingClientRect().left;
    let disTop = imgToDrag.getBoundingClientRect().top;
    let cartLeft = viewCart.getBoundingClientRect().left;
    let cartTop = viewCart.getBoundingClientRect().top;
    let image = imgToDragImage.cloneNode(true);
    image.style = 'z-index: 11111; width: 100px;opacity:1; position:fixed; top:' + disTop + 'px;left:' + disLeft + 'px;transition: left 1s, top 1s, width 1s, opacity 1s cubic-bezier(1, 1, 1, 1);border-radius: 50px; overflow: hidden; box-shadow: 0 21px 36px rgba(0,0,0,0.1)';
    var reChange = document.body.appendChild(image);
    setTimeout(function() {
        image.style.left = cartLeft + 'px';
        image.style.top = cartTop + 'px';
        image.style.width = '40px';
        image.style.opacity = '0';
    }, 200);
    setTimeout(function() {
        reChange.parentNode.removeChild(reChange);
    }, 1000);
// End Animation Block
};


/***/ })

};
;