"use strict";
exports.id = 4992;
exports.ids = [4992];
exports.modules = {

/***/ 57792:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "H": () => (/* binding */ reviewClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5034);
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const reviewClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_1__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.REVIEWS */ .P.REVIEWS),
    reportAbuse: (data)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.ABUSIVE_REPORTS */ .P.ABUSIVE_REPORTS, data);
    },
    decline: (data)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.ABUSIVE_REPORTS_DECLINE */ .P.ABUSIVE_REPORTS_DECLINE, data);
    },
    get ({ id  }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.REVIEWS */ .P.REVIEWS}/${id}`, {
            with: 'abusive_reports.user;product;user'
        });
    },
    paginated: ({ type , shop_id , ...params })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.REVIEWS */ .P.REVIEWS, {
            searchJoin: 'and',
            with: 'product;user',
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                type,
                shop_id
            })
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 24992:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Cw": () => (/* binding */ useAbuseReportMutation),
/* harmony export */   "Bs": () => (/* binding */ useDeclineReviewMutation),
/* harmony export */   "hI": () => (/* binding */ useDeleteReviewMutation),
/* harmony export */   "$B": () => (/* binding */ useReviewQuery),
/* harmony export */   "_s": () => (/* binding */ useReviewsQuery)
/* harmony export */ });
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(63354);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85057);
/* harmony import */ var _components_ui_modal_modal_context__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(44144);
/* harmony import */ var _data_client_review__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(57792);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_review__WEBPACK_IMPORTED_MODULE_6__]);
_data_client_review__WEBPACK_IMPORTED_MODULE_6__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







const useAbuseReportMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)('common');
    const { closeModal  } = (0,_components_ui_modal_modal_context__WEBPACK_IMPORTED_MODULE_5__/* .useModalAction */ .SO)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)(_data_client_review__WEBPACK_IMPORTED_MODULE_6__/* .reviewClient.reportAbuse */ .H.reportAbuse, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.success(t('text-abuse-report-submitted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.refetchQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.REVIEWS */ .P.REVIEWS);
            closeModal();
        }
    });
};
const useDeclineReviewMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)('common');
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)(_data_client_review__WEBPACK_IMPORTED_MODULE_6__/* .reviewClient.decline */ .H.decline, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.success(t('successfully-decline'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.refetchQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.REVIEWS */ .P.REVIEWS);
        }
    });
};
const useDeleteReviewMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)(_data_client_review__WEBPACK_IMPORTED_MODULE_6__/* .reviewClient["delete"] */ .H["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.REVIEWS */ .P.REVIEWS);
        }
    });
};
const useReviewQuery = (id)=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.REVIEWS */ .P.REVIEWS,
        id
    ], ()=>_data_client_review__WEBPACK_IMPORTED_MODULE_6__/* .reviewClient.get */ .H.get({
            id
        })
    );
};
const useReviewsQuery = (params, options = {})=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.REVIEWS */ .P.REVIEWS,
        params
    ], ({ queryKey , pageParam  })=>_data_client_review__WEBPACK_IMPORTED_MODULE_6__/* .reviewClient.paginated */ .H.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true,
        ...options
    });
    var ref;
    return {
        reviews: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_3__/* .mapPaginatorData */ .Q)(data),
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;