"use strict";
exports.id = 5047;
exports.ids = [5047];
exports.modules = {

/***/ 99699:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "q": () => (/* binding */ storeNoticeClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5034);
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const storeNoticeClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_1__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES),
    all: ({ notice , shop_id , ...params } = {})=>_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES, {
            searchJoin: 'and',
            shop_id: shop_id,
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                notice,
                shop_id
            })
        })
    ,
    get ({ id , language  }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES}/${id}`, {
            language
        });
    },
    paginated: ({ notice , shop_id , ...params })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES, {
            searchJoin: 'and',
            shop_id: shop_id,
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                notice,
                shop_id
            })
        });
    },
    toggle: (input)=>_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.STORE_NOTICES_IS_READ */ .P.STORE_NOTICES_IS_READ, input)
    ,
    getTypeList: ({ type  })=>_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.STORE_NOTICE_GET_STORE_NOTICE_TYPE */ .P.STORE_NOTICE_GET_STORE_NOTICE_TYPE)
    ,
    getUserOrShopList: ({ type  })=>_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.STORE_NOTICES_USER_OR_SHOP_LIST */ .P.STORE_NOTICES_USER_OR_SHOP_LIST, type)
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5047:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "qo": () => (/* binding */ useCreateStoreNoticeMutation),
/* harmony export */   "Hv": () => (/* binding */ useDeleteStoreNoticeMutation),
/* harmony export */   "Ow": () => (/* binding */ useUpdateStoreNoticeMutation),
/* harmony export */   "Vm": () => (/* binding */ useStoreNoticeQuery),
/* harmony export */   "Y4": () => (/* binding */ useStoreNoticesQuery),
/* harmony export */   "lL": () => (/* binding */ useStoreNoticesLoadMoreQuery),
/* harmony export */   "PF": () => (/* binding */ useUsersOrShopsQuery),
/* harmony export */   "DB": () => (/* binding */ useStoreNoticeRead)
/* harmony export */ });
/* unused harmony exports useListMutation, useStoreNoticeTypeQuery */
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(63354);
/* harmony import */ var _client_store_notice__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(99699);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(28379);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(85057);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(29249);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_store_notice__WEBPACK_IMPORTED_MODULE_5__, _config__WEBPACK_IMPORTED_MODULE_8__]);
([_client_store_notice__WEBPACK_IMPORTED_MODULE_5__, _config__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const useCreateStoreNoticeMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_0__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_store_notice__WEBPACK_IMPORTED_MODULE_5__/* .storeNoticeClient.create */ .q.create, {
        onSuccess: async ()=>{
            const generateRedirectUrl = router.query.shop ? `/${router.query.shop}${_config_routes__WEBPACK_IMPORTED_MODULE_6__/* .Routes.storeNotice.list */ .Z.storeNotice.list}` : _config_routes__WEBPACK_IMPORTED_MODULE_6__/* .Routes.storeNotice.list */ .Z.storeNotice.list;
            await next_router__WEBPACK_IMPORTED_MODULE_0___default().push(generateRedirectUrl, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_8__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_7__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES);
        }
    });
};
const useDeleteStoreNoticeMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_store_notice__WEBPACK_IMPORTED_MODULE_5__/* .storeNoticeClient["delete"] */ .q["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_7__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES);
        }
    });
};
const useUpdateStoreNoticeMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_0__.useRouter)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_store_notice__WEBPACK_IMPORTED_MODULE_5__/* .storeNoticeClient.update */ .q.update, {
        onSuccess: async (data)=>{
            const generateRedirectUrl = router.query.shop ? `/${router.query.shop}${_config_routes__WEBPACK_IMPORTED_MODULE_6__/* .Routes.storeNotice.list */ .Z.storeNotice.list}` : _config_routes__WEBPACK_IMPORTED_MODULE_6__/* .Routes.storeNotice.list */ .Z.storeNotice.list;
            await router.push(`${generateRedirectUrl}/${data === null || data === void 0 ? void 0 : data.id}/edit`, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_8__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_7__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES);
        }
    });
};
const useListMutation = ()=>{
    const { t  } = useTranslation();
    return useMutation(storeNoticeClient.getUserOrShopList);
};
const useStoreNoticeQuery = ({ id , language  })=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_7__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES,
        {
            id,
            language
        }
    ], ()=>_client_store_notice__WEBPACK_IMPORTED_MODULE_5__/* .storeNoticeClient.get */ .q.get({
            id,
            language
        })
    );
    return {
        storeNotice: data,
        error,
        loading: isLoading
    };
};
const useStoreNoticesQuery = (options)=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_7__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES,
        options
    ], ({ queryKey , pageParam  })=>_client_store_notice__WEBPACK_IMPORTED_MODULE_5__/* .storeNoticeClient.paginated */ .q.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    var ref;
    return {
        storeNotices: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_4__/* .mapPaginatorData */ .Q)(data),
        error,
        loading: isLoading
    };
};
const useStoreNoticesLoadMoreQuery = (options, config)=>{
    const { data , error , isLoading , isFetchingNextPage , hasNextPage , fetchNextPage ,  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useInfiniteQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_7__/* .API_ENDPOINTS.STORE_NOTICES */ .P.STORE_NOTICES,
        options
    ], ({ queryKey , pageParam  })=>_client_store_notice__WEBPACK_IMPORTED_MODULE_5__/* .storeNoticeClient.all */ .q.all(Object.assign({}, queryKey[1], pageParam))
    , {
        ...config,
        getNextPageParam: ({ current_page , last_page  })=>last_page > current_page && {
                page: current_page + 1
            }
    });
    function handleLoadMore() {
        fetchNextPage();
    }
    var ref;
    return {
        storeNotices: (ref = data === null || data === void 0 ? void 0 : data.pages.flatMap((page)=>{
            return page === null || page === void 0 ? void 0 : page.data;
        })) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: Array.isArray(data === null || data === void 0 ? void 0 : data.pages) ? data === null || data === void 0 ? void 0 : data.pages[data.pages.length - 1] : null,
        error,
        hasNextPage,
        loading: isLoading,
        isLoadingMore: isFetchingNextPage,
        loadMore: handleLoadMore
    };
};
const useStoreNoticeTypeQuery = (options = {})=>{
    const { data , error , isLoading  } = useQuery([
        API_ENDPOINTS.STORE_NOTICE_GET_STORE_NOTICE_TYPE,
        options
    ], ({ queryKey , pageParam  })=>storeNoticeClient.getTypeList(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    return {
        noticeTypes: data !== null && data !== void 0 ? data : [],
        error,
        loading: isLoading
    };
};
const useUsersOrShopsQuery = (options = {})=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_7__/* .API_ENDPOINTS.STORE_NOTICES_USER_OR_SHOP_LIST */ .P.STORE_NOTICES_USER_OR_SHOP_LIST,
        options
    ], ({ queryKey , pageParam  })=>_client_store_notice__WEBPACK_IMPORTED_MODULE_5__/* .storeNoticeClient.getUserOrShopList */ .q.getUserOrShopList(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    return {
        usersOrShops: data !== null && data !== void 0 ? data : [],
        error,
        loading: isLoading
    };
};
function useStoreNoticeRead() {
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)('common');
    const { mutate: readStoreNotice , isLoading , isSuccess ,  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_store_notice__WEBPACK_IMPORTED_MODULE_5__/* .storeNoticeClient.toggle */ .q.toggle, {
        onSuccess: ()=>{},
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_7__/* .API_ENDPOINTS.STORE_NOTICES_IS_READ */ .P.STORE_NOTICES_IS_READ);
        }
    });
    return {
        readStoreNotice,
        isLoading,
        isSuccess
    };
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;