"use strict";
exports.id = 5394;
exports.ids = [5394];
exports.modules = {

/***/ 29995:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Y": () => (/* binding */ orderClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5034);
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const orderClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_1__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.ORDERS */ .P.ORDERS),
    get: ({ id , language  })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.ORDERS */ .P.ORDERS}/${id}`, {
            language
        });
    },
    paginated: ({ tracking_number , ...params })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.ORDERS */ .P.ORDERS, {
            searchJoin: 'and',
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                tracking_number
            })
        });
    },
    downloadInvoice: (input)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.post */ .eN.post(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.ORDER_INVOICE_DOWNLOAD */ .P.ORDER_INVOICE_DOWNLOAD}`, input);
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5394:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "mU": () => (/* binding */ useOrdersQuery),
/* harmony export */   "OT": () => (/* binding */ useOrderQuery),
/* harmony export */   "kD": () => (/* binding */ useCreateOrderMutation),
/* harmony export */   "Oc": () => (/* binding */ useUpdateOrderMutation),
/* harmony export */   "qD": () => (/* binding */ useDownloadInvoiceMutation)
/* harmony export */ });
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(85057);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(63354);
/* harmony import */ var _client_order__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(29995);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(28379);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_order__WEBPACK_IMPORTED_MODULE_5__]);
_client_order__WEBPACK_IMPORTED_MODULE_5__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];









const useOrdersQuery = (params, options = {})=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.ORDERS */ .P.ORDERS,
        params
    ], ({ queryKey , pageParam  })=>_client_order__WEBPACK_IMPORTED_MODULE_5__/* .orderClient.paginated */ .Y.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true,
        ...options
    });
    var ref;
    return {
        orders: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_4__/* .mapPaginatorData */ .Q)(data),
        error,
        loading: isLoading
    };
};
const useOrderQuery = ({ id , language  })=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.ORDERS */ .P.ORDERS,
        {
            id,
            language
        }
    ], ()=>_client_order__WEBPACK_IMPORTED_MODULE_5__/* .orderClient.get */ .Y.get({
            id,
            language
        })
    );
    return {
        order: data,
        error,
        isLoading
    };
};
// export const useCreateOrderMutation = () => {
//   return useMutation(orderClient.create);
// };
function useCreateOrderMutation() {
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_6__.useRouter)();
    const { locale  } = router;
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    const { mutate: createOrder , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)(_client_order__WEBPACK_IMPORTED_MODULE_5__/* .orderClient.create */ .Y.create, {
        onSuccess: (data)=>{
            if (data === null || data === void 0 ? void 0 : data.id) {
                router.push(`${_config_routes__WEBPACK_IMPORTED_MODULE_7__/* .Routes.order.list */ .Z.order.list}/${data === null || data === void 0 ? void 0 : data.id}`);
            }
        },
        onError: (error)=>{
            const { response: { data  } ,  } = error !== null && error !== void 0 ? error : {};
            react_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.error(data === null || data === void 0 ? void 0 : data.message);
        }
    });
    function formatOrderInput(input) {
        const formattedInputs = {
            ...input,
            language: locale,
            // TODO: Make it for Graphql too
            invoice_translated_text: {
                subtotal: t('order-sub-total'),
                discount: t('order-discount'),
                tax: t('order-tax'),
                delivery_fee: t('order-delivery-fee'),
                total: t('order-total'),
                products: t('text-products'),
                quantity: t('text-quantity'),
                invoice_no: t('text-invoice-no'),
                date: t('text-date')
            }
        };
        createOrder(formattedInputs);
    }
    return {
        createOrder: formatOrderInput,
        isLoading
    };
}
const useUpdateOrderMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)(_client_order__WEBPACK_IMPORTED_MODULE_5__/* .orderClient.update */ .Y.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.ORDERS */ .P.ORDERS);
        }
    });
};
const useDownloadInvoiceMutation = ({ order_id , isRTL , language  }, options = {})=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    const formattedInput = {
        order_id,
        is_rtl: isRTL,
        language,
        translated_text: {
            subtotal: t('order-sub-total'),
            discount: t('order-discount'),
            tax: t('order-tax'),
            delivery_fee: t('order-delivery-fee'),
            total: t('order-total'),
            products: t('text-products'),
            quantity: t('text-quantity'),
            invoice_no: t('text-invoice-no'),
            date: t('text-date')
        }
    };
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.ORDER_INVOICE_DOWNLOAD */ .P.ORDER_INVOICE_DOWNLOAD
    ], ()=>_client_order__WEBPACK_IMPORTED_MODULE_5__/* .orderClient.downloadInvoice */ .Y.downloadInvoice(formattedInput)
    , {
        ...options
    });
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;