"use strict";
exports.id = 5822;
exports.ids = [5822];
exports.modules = {

/***/ 32310:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "z": () => (/* binding */ CheckAvailabilityAction)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_format_ordered_product__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(77520);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_ui_validation_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(83957);
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(63901);
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_omit__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var jotai__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(82451);
/* harmony import */ var _contexts_checkout__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11458);
/* harmony import */ var _components_ui_button__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(39258);
/* harmony import */ var _contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(40601);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _data_checkout__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(99287);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([jotai__WEBPACK_IMPORTED_MODULE_5__, _contexts_checkout__WEBPACK_IMPORTED_MODULE_6__, _contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_8__, _data_checkout__WEBPACK_IMPORTED_MODULE_10__]);
([jotai__WEBPACK_IMPORTED_MODULE_5__, _contexts_checkout__WEBPACK_IMPORTED_MODULE_6__, _contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_8__, _data_checkout__WEBPACK_IMPORTED_MODULE_10__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);












const CheckAvailabilityAction = (props)=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_9__.useTranslation)('common');
    const [billing_address] = (0,jotai__WEBPACK_IMPORTED_MODULE_5__.useAtom)(_contexts_checkout__WEBPACK_IMPORTED_MODULE_6__/* .billingAddressAtom */ .Km);
    const [shipping_address] = (0,jotai__WEBPACK_IMPORTED_MODULE_5__.useAtom)(_contexts_checkout__WEBPACK_IMPORTED_MODULE_6__/* .shippingAddressAtom */ .du);
    const [{ customer  }] = (0,jotai__WEBPACK_IMPORTED_MODULE_5__.useAtom)(_contexts_checkout__WEBPACK_IMPORTED_MODULE_6__/* .checkoutAtom */ .hq);
    const [_, setVerifiedResponse] = (0,jotai__WEBPACK_IMPORTED_MODULE_5__.useAtom)(_contexts_checkout__WEBPACK_IMPORTED_MODULE_6__/* .verifiedResponseAtom */ .Jb);
    const { 0: errorMessage , 1: setError  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)('');
    const { items , total , isEmpty  } = (0,_contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_8__/* .useCart */ .jD)();
    const { mutate: verifyCheckout , isLoading: loading  } = (0,_data_checkout__WEBPACK_IMPORTED_MODULE_10__/* .useVerifyCheckoutMutation */ .I)();
    function handleVerifyCheckout() {
        if (billing_address && shipping_address) {
            verifyCheckout({
                amount: total,
                customer_id: customer === null || customer === void 0 ? void 0 : customer.value,
                products: items === null || items === void 0 ? void 0 : items.map((item)=>(0,_utils_format_ordered_product__WEBPACK_IMPORTED_MODULE_11__/* .formatOrderedProduct */ .Y)(item)
                ),
                billing_address: {
                    ...(billing_address === null || billing_address === void 0 ? void 0 : billing_address.address) && lodash_omit__WEBPACK_IMPORTED_MODULE_4___default()(billing_address.address, [
                        '__typename'
                    ])
                },
                shipping_address: {
                    ...(shipping_address === null || shipping_address === void 0 ? void 0 : shipping_address.address) && lodash_omit__WEBPACK_IMPORTED_MODULE_4___default()(shipping_address.address, [
                        '__typename'
                    ])
                }
            }, {
                onSuccess: (data)=>{
                    //@ts-ignore
                    if (data === null || data === void 0 ? void 0 : data.errors) {
                        var ref;
                        //@ts-ignore
                        react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.error((ref = data === null || data === void 0 ? void 0 : data.errors[0]) === null || ref === void 0 ? void 0 : ref.message);
                    } else {
                        //@ts-ignore
                        setVerifiedResponse(data);
                    }
                },
                onError: (error)=>{
                    setError(error === null || error === void 0 ? void 0 : error.message);
                }
            });
        } else {
            setError('error-add-both-address');
        }
    }
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                loading: loading,
                className: "w-full mt-5",
                onClick: handleVerifyCheckout,
                disabled: isEmpty,
                ...props
            }),
            errorMessage && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "mt-3",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_validation_error__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                    message: t(errorMessage)
                })
            })
        ]
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 85822:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40601);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _item_card__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(10431);
/* harmony import */ var _components_icons_empty_cart__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(70465);
/* harmony import */ var _utils_use_price__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(86797);
/* harmony import */ var _item_info_row__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(98856);
/* harmony import */ var _components_checkout_check_availability_action__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(32310);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_1__, _item_card__WEBPACK_IMPORTED_MODULE_3__, _utils_use_price__WEBPACK_IMPORTED_MODULE_5__, _components_checkout_check_availability_action__WEBPACK_IMPORTED_MODULE_7__]);
([_contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_1__, _item_card__WEBPACK_IMPORTED_MODULE_3__, _utils_use_price__WEBPACK_IMPORTED_MODULE_5__, _components_checkout_check_availability_action__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);








const UnverifiedItemList = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)('common');
    const { items , total , isEmpty  } = (0,_contexts_quick_cart_cart_context__WEBPACK_IMPORTED_MODULE_1__/* .useCart */ .jD)();
    const { price: subtotal  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .ZP)(items && {
        amount: total
    });
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "w-full",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "space-s-4 mb-4 flex flex-col items-center",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "text-base font-bold text-heading",
                    children: t('text-your-order')
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "flex flex-col border-b border-border-200 py-3",
                children: isEmpty ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                    className: "mb-4 flex h-full flex-col items-center justify-center",
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_empty_cart__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                            width: 140,
                            height: 176
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h4", {
                            className: "mt-6 text-base font-semibold",
                            children: t('text-no-products')
                        })
                    ]
                }) : items === null || items === void 0 ? void 0 : items.map((item)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_item_card__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                        item: item
                    }, item.id)
                )
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "mt-4 space-y-2",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_item_info_row__WEBPACK_IMPORTED_MODULE_6__/* .ItemInfoRow */ .m, {
                        title: t('text-sub-total'),
                        value: subtotal
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_item_info_row__WEBPACK_IMPORTED_MODULE_6__/* .ItemInfoRow */ .m, {
                        title: t('text-tax'),
                        value: t('text-calculated-checkout')
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_item_info_row__WEBPACK_IMPORTED_MODULE_6__/* .ItemInfoRow */ .m, {
                        title: t('text-estimated-shipping'),
                        value: t('text-calculated-checkout')
                    })
                ]
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_checkout_check_availability_action__WEBPACK_IMPORTED_MODULE_7__/* .CheckAvailabilityAction */ .z, {
                children: t('text-check-availability')
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UnverifiedItemList);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 99287:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "I": () => (/* binding */ useVerifyCheckoutMutation)
/* harmony export */ });
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _data_client_checkout__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(75503);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_checkout__WEBPACK_IMPORTED_MODULE_1__]);
_data_client_checkout__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const useVerifyCheckoutMutation = ()=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)(_data_client_checkout__WEBPACK_IMPORTED_MODULE_1__/* .checkoutClient.verify */ .A.verify);
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 75503:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "A": () => (/* binding */ checkoutClient)
/* harmony export */ });
/* harmony import */ var _data_client_http_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67904);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_http_client__WEBPACK_IMPORTED_MODULE_0__]);
_data_client_http_client__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const checkoutClient = {
    verify: (input)=>{
        {
            return _data_client_http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.post */ .eN.post(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.CHECKOUT */ .P.CHECKOUT, input);
        }
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;