"use strict";
exports.id = 5839;
exports.ids = [5839];
exports.modules = {

/***/ 11458:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "hq": () => (/* binding */ checkoutAtom),
/* harmony export */   "y9": () => (/* binding */ clearCheckoutAtom),
/* harmony export */   "Km": () => (/* binding */ billingAddressAtom),
/* harmony export */   "du": () => (/* binding */ shippingAddressAtom),
/* harmony export */   "Gh": () => (/* binding */ deliveryTimeAtom),
/* harmony export */   "HA": () => (/* binding */ paymentGatewayAtom),
/* harmony export */   "lu": () => (/* binding */ customerContactAtom),
/* harmony export */   "TM": () => (/* binding */ customerAtom),
/* harmony export */   "Jb": () => (/* binding */ verifiedResponseAtom),
/* harmony export */   "GO": () => (/* binding */ couponAtom),
/* harmony export */   "yw": () => (/* binding */ discountAtom),
/* harmony export */   "xc": () => (/* binding */ walletAtom),
/* harmony export */   "y2": () => (/* binding */ payableAmountAtom)
/* harmony export */ });
/* unused harmony exports defaultCheckout, verifiedTokenAtom */
/* harmony import */ var _utils_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(30957);
/* harmony import */ var jotai__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82451);
/* harmony import */ var jotai_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2752);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([jotai__WEBPACK_IMPORTED_MODULE_0__, jotai_utils__WEBPACK_IMPORTED_MODULE_1__]);
([jotai__WEBPACK_IMPORTED_MODULE_0__, jotai_utils__WEBPACK_IMPORTED_MODULE_1__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const defaultCheckout = {
    billing_address: null,
    shipping_address: null,
    delivery_time: null,
    customer_contact: '',
    customer: null,
    payment_gateway: 'CASH',
    verified_response: null,
    coupon: null,
    payable_amount: 0,
    use_wallet: false
};
// Original atom.
const checkoutAtom = (0,jotai_utils__WEBPACK_IMPORTED_MODULE_1__.atomWithStorage)(_utils_constants__WEBPACK_IMPORTED_MODULE_2__/* .CHECKOUT */ .iK, defaultCheckout);
const clearCheckoutAtom = (0,jotai__WEBPACK_IMPORTED_MODULE_0__.atom)(null, (_get, set, _data)=>{
    return set(checkoutAtom, defaultCheckout);
});
const billingAddressAtom = (0,jotai__WEBPACK_IMPORTED_MODULE_0__.atom)((get)=>get(checkoutAtom).billing_address
, (get, set, data)=>{
    const prev = get(checkoutAtom);
    return set(checkoutAtom, {
        ...prev,
        billing_address: data
    });
});
const shippingAddressAtom = (0,jotai__WEBPACK_IMPORTED_MODULE_0__.atom)((get)=>get(checkoutAtom).shipping_address
, (get, set, data)=>{
    const prev = get(checkoutAtom);
    return set(checkoutAtom, {
        ...prev,
        shipping_address: data
    });
});
const deliveryTimeAtom = (0,jotai__WEBPACK_IMPORTED_MODULE_0__.atom)((get)=>get(checkoutAtom).delivery_time
, (get, set, data)=>{
    const prev = get(checkoutAtom);
    return set(checkoutAtom, {
        ...prev,
        delivery_time: data
    });
});
const paymentGatewayAtom = (0,jotai__WEBPACK_IMPORTED_MODULE_0__.atom)((get)=>get(checkoutAtom).payment_gateway
, (get, set, data)=>{
    const prev = get(checkoutAtom);
    return set(checkoutAtom, {
        ...prev,
        payment_gateway: data
    });
});
const verifiedTokenAtom = (0,jotai__WEBPACK_IMPORTED_MODULE_0__.atom)((get)=>get(checkoutAtom).token
, (get, set, data)=>{
    const prev = get(checkoutAtom);
    return set(checkoutAtom, {
        ...prev,
        token: data
    });
});
const customerContactAtom = (0,jotai__WEBPACK_IMPORTED_MODULE_0__.atom)((get)=>get(checkoutAtom).customer_contact
, (get, set, data)=>{
    const prev = get(checkoutAtom);
    return set(checkoutAtom, {
        ...prev,
        customer_contact: data
    });
});
const customerAtom = (0,jotai__WEBPACK_IMPORTED_MODULE_0__.atom)((get)=>get(checkoutAtom).customer
, (get, set, data)=>{
    const prev = get(checkoutAtom);
    return set(checkoutAtom, {
        ...prev,
        billing_address: null,
        shipping_address: null,
        delivery_time: null,
        customer_contact: '',
        customer: data
    });
});
const verifiedResponseAtom = (0,jotai__WEBPACK_IMPORTED_MODULE_0__.atom)((get)=>get(checkoutAtom).verified_response
, (get, set, data)=>{
    const prev = get(checkoutAtom);
    return set(checkoutAtom, {
        ...prev,
        verified_response: data
    });
});
const couponAtom = (0,jotai__WEBPACK_IMPORTED_MODULE_0__.atom)((get)=>get(checkoutAtom).coupon
, (get, set, data)=>{
    const prev = get(checkoutAtom);
    return set(checkoutAtom, {
        ...prev,
        coupon: data
    });
});
const discountAtom = (0,jotai__WEBPACK_IMPORTED_MODULE_0__.atom)((get)=>{
    var ref;
    return (ref = get(checkoutAtom).coupon) === null || ref === void 0 ? void 0 : ref.amount;
});
const walletAtom = (0,jotai__WEBPACK_IMPORTED_MODULE_0__.atom)((get)=>get(checkoutAtom).use_wallet
, (get, set)=>{
    const prev = get(checkoutAtom);
    return set(checkoutAtom, {
        ...prev,
        use_wallet: !prev.use_wallet
    });
});
const payableAmountAtom = (0,jotai__WEBPACK_IMPORTED_MODULE_0__.atom)((get)=>get(checkoutAtom).payable_amount
, (get, set, data)=>{
    const prev = get(checkoutAtom);
    return set(checkoutAtom, {
        ...prev,
        payable_amount: data
    });
});

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 40601:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "jD": () => (/* binding */ useCart),
/* harmony export */   "Zl": () => (/* binding */ CartProvider)
/* harmony export */ });
/* unused harmony export cartContext */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _cart_reducer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(46844);
/* harmony import */ var _cart_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(85170);
/* harmony import */ var _utils_use_local_storage__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(40888);
/* harmony import */ var _utils_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(30957);
/* harmony import */ var jotai__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(82451);
/* harmony import */ var _contexts_checkout__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11458);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([jotai__WEBPACK_IMPORTED_MODULE_4__, _contexts_checkout__WEBPACK_IMPORTED_MODULE_5__]);
([jotai__WEBPACK_IMPORTED_MODULE_4__, _contexts_checkout__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);








const cartContext = /*#__PURE__*/ react__WEBPACK_IMPORTED_MODULE_1___default().createContext(undefined);
cartContext.displayName = 'CartContext';
const useCart = ()=>{
    const context = react__WEBPACK_IMPORTED_MODULE_1___default().useContext(cartContext);
    if (context === undefined) {
        throw new Error(`useCart must be used within a CartProvider`);
    }
    return context;
};
const CartProvider = (props)=>{
    const [savedCart, saveCart] = (0,_utils_use_local_storage__WEBPACK_IMPORTED_MODULE_3__/* .useLocalStorage */ ._)(_utils_constants__WEBPACK_IMPORTED_MODULE_6__/* .CART_KEY */ .qW, JSON.stringify(_cart_reducer__WEBPACK_IMPORTED_MODULE_2__/* .initialState */ .E));
    const [state, dispatch] = react__WEBPACK_IMPORTED_MODULE_1___default().useReducer(_cart_reducer__WEBPACK_IMPORTED_MODULE_2__/* .cartReducer */ .C, JSON.parse(savedCart));
    const [, emptyVerifiedResponse] = (0,jotai__WEBPACK_IMPORTED_MODULE_4__.useAtom)(_contexts_checkout__WEBPACK_IMPORTED_MODULE_5__/* .verifiedResponseAtom */ .Jb);
    react__WEBPACK_IMPORTED_MODULE_1___default().useEffect(()=>{
        emptyVerifiedResponse(null);
    }, [
        emptyVerifiedResponse,
        state
    ]);
    react__WEBPACK_IMPORTED_MODULE_1___default().useEffect(()=>{
        saveCart(JSON.stringify(state));
    }, [
        state,
        saveCart
    ]);
    const addItemToCart = (item, quantity)=>dispatch({
            type: 'ADD_ITEM_WITH_QUANTITY',
            item,
            quantity
        })
    ;
    const removeItemFromCart = (id)=>dispatch({
            type: 'REMOVE_ITEM_OR_QUANTITY',
            id
        })
    ;
    const clearItemFromCart = (id)=>dispatch({
            type: 'REMOVE_ITEM',
            id
        })
    ;
    const isInCart = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((id)=>!!(0,_cart_utils__WEBPACK_IMPORTED_MODULE_7__/* .getItem */ .rV)(state.items, id)
    , [
        state.items
    ]);
    const getItemFromCart = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((id)=>(0,_cart_utils__WEBPACK_IMPORTED_MODULE_7__/* .getItem */ .rV)(state.items, id)
    , [
        state.items
    ]);
    const isInStock = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((id)=>(0,_cart_utils__WEBPACK_IMPORTED_MODULE_7__/* .inStock */ .pz)(state.items, id)
    , [
        state.items
    ]);
    const resetCart = ()=>dispatch({
            type: 'RESET_CART'
        })
    ;
    const value = react__WEBPACK_IMPORTED_MODULE_1___default().useMemo(()=>({
            ...state,
            addItemToCart,
            removeItemFromCart,
            clearItemFromCart,
            getItemFromCart,
            isInCart,
            isInStock,
            resetCart
        })
    , [
        getItemFromCart,
        isInCart,
        isInStock,
        state
    ]);
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(cartContext.Provider, {
        value: value,
        ...props
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 46844:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "E": () => (/* binding */ initialState),
/* harmony export */   "C": () => (/* binding */ cartReducer)
/* harmony export */ });
/* harmony import */ var _cart_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85170);

const initialState = {
    items: [],
    isEmpty: true,
    totalItems: 0,
    totalUniqueItems: 0,
    total: 0,
    meta: null
};
function cartReducer(state, action) {
    switch(action.type){
        case 'ADD_ITEM_WITH_QUANTITY':
            {
                const items = (0,_cart_utils__WEBPACK_IMPORTED_MODULE_0__/* .addItemWithQuantity */ .Kv)(state.items, action.item, action.quantity);
                return generateFinalState(state, items);
            }
        case 'REMOVE_ITEM_OR_QUANTITY':
            {
                const items = (0,_cart_utils__WEBPACK_IMPORTED_MODULE_0__/* .removeItemOrQuantity */ .um)(state.items, action.id, action.quantity = 1);
                return generateFinalState(state, items);
            }
        case 'ADD_ITEM':
            {
                const items = (0,_cart_utils__WEBPACK_IMPORTED_MODULE_0__/* .addItem */ .jX)(state.items, action.item);
                return generateFinalState(state, items);
            }
        case 'REMOVE_ITEM':
            {
                const items = (0,_cart_utils__WEBPACK_IMPORTED_MODULE_0__/* .removeItem */ .cl)(state.items, action.id);
                return generateFinalState(state, items);
            }
        case 'UPDATE_ITEM':
            {
                const items = (0,_cart_utils__WEBPACK_IMPORTED_MODULE_0__/* .updateItem */ .$G)(state.items, action.id, action.item);
                return generateFinalState(state, items);
            }
        case 'RESET_CART':
            return initialState;
        default:
            return state;
    }
}
const generateFinalState = (state, items)=>{
    const totalUniqueItems = (0,_cart_utils__WEBPACK_IMPORTED_MODULE_0__/* .calculateUniqueItems */ .tm)(items);
    return {
        ...state,
        items: (0,_cart_utils__WEBPACK_IMPORTED_MODULE_0__/* .calculateItemTotals */ .pQ)(items),
        totalItems: (0,_cart_utils__WEBPACK_IMPORTED_MODULE_0__/* .calculateTotalItems */ .yL)(items),
        totalUniqueItems,
        total: (0,_cart_utils__WEBPACK_IMPORTED_MODULE_0__/* .calculateTotal */ .tf)(items),
        isEmpty: totalUniqueItems === 0
    };
};


/***/ }),

/***/ 85170:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Kv": () => (/* binding */ addItemWithQuantity),
/* harmony export */   "um": () => (/* binding */ removeItemOrQuantity),
/* harmony export */   "jX": () => (/* binding */ addItem),
/* harmony export */   "rV": () => (/* binding */ getItem),
/* harmony export */   "$G": () => (/* binding */ updateItem),
/* harmony export */   "cl": () => (/* binding */ removeItem),
/* harmony export */   "pz": () => (/* binding */ inStock),
/* harmony export */   "pQ": () => (/* binding */ calculateItemTotals),
/* harmony export */   "tf": () => (/* binding */ calculateTotal),
/* harmony export */   "yL": () => (/* binding */ calculateTotalItems),
/* harmony export */   "tm": () => (/* binding */ calculateUniqueItems),
/* harmony export */   "eA": () => (/* binding */ calculatePaidTotal)
/* harmony export */ });
function addItemWithQuantity(items, item, quantity) {
    if (quantity <= 0) throw new Error("cartQuantity can't be zero or less than zero");
    const existingItemIndex = items.findIndex((existingItem)=>existingItem.id === item.id
    );
    if (existingItemIndex > -1) {
        const newItems = [
            ...items
        ];
        newItems[existingItemIndex].quantity += quantity;
        return newItems;
    }
    return [
        ...items,
        {
            ...item,
            quantity
        }
    ];
}
function removeItemOrQuantity(items, id, quantity) {
    return items.reduce((acc, item)=>{
        if (item.id === id) {
            const newQuantity = item.quantity - quantity;
            return newQuantity > 0 ? [
                ...acc,
                {
                    ...item,
                    quantity: newQuantity
                }
            ] : [
                ...acc
            ];
        }
        return [
            ...acc,
            item
        ];
    }, []);
}
// Simple CRUD for Item
function addItem(items, item) {
    return [
        ...items,
        item
    ];
}
function getItem(items, id) {
    return items.find((item)=>item.id === id
    );
}
function updateItem(items, id, item) {
    return items.map((existingItem)=>existingItem.id === id ? {
            ...existingItem,
            ...item
        } : existingItem
    );
}
function removeItem(items, id) {
    return items.filter((existingItem)=>existingItem.id !== id
    );
}
function inStock(items, id) {
    const item = getItem(items, id);
    if (item) return item['quantity'] < item['stock'];
    return false;
}
const calculateItemTotals = (items)=>items.map((item)=>({
            ...item,
            itemTotal: item.price * item.quantity
        })
    )
;
const calculateTotal = (items)=>items.reduce((total, item)=>total + item.quantity * item.price
    , 0)
;
const calculateTotalItems = (items)=>items.reduce((sum, item)=>sum + item.quantity
    , 0)
;
const calculateUniqueItems = (items)=>items.length
;
const calculatePaidTotal = ({ totalAmount , tax , shipping_charge  }, discount)=>{
    let paidTotal = totalAmount + tax + shipping_charge;
    if (discount) {
        paidTotal = paidTotal - discount;
    }
    return paidTotal;
};


/***/ }),

/***/ 49421:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "JP": () => (/* binding */ UIProvider),
/* harmony export */   "l8": () => (/* binding */ useUI)
/* harmony export */ });
/* unused harmony export UIContext */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const initialState = {
    displaySidebar: false,
    displayCartSidebar: false,
    displayModal: false,
    modalView: 'LOGIN_VIEW',
    modalData: null
};
const UIContext = /*#__PURE__*/ react__WEBPACK_IMPORTED_MODULE_1___default().createContext(initialState);
UIContext.displayName = 'UIContext';
function uiReducer(state, action) {
    switch(action.type){
        case 'OPEN_SIDEBAR':
            {
                return {
                    ...state,
                    displaySidebar: true
                };
            }
        case 'CLOSE_SIDEBAR':
            {
                return {
                    ...state,
                    displaySidebar: false
                };
            }
        case 'OPEN_CART_SIDEBAR':
            {
                return {
                    ...state,
                    displayCartSidebar: true
                };
            }
        case 'CLOSE_CART_SIDEBAR':
            {
                return {
                    ...state,
                    displayCartSidebar: false
                };
            }
        case 'OPEN_MODAL':
            {
                return {
                    ...state,
                    displayModal: true
                };
            }
        case 'CLOSE_MODAL':
            {
                return {
                    ...state,
                    displayModal: false
                };
            }
        case 'SET_MODAL_VIEW':
            {
                return {
                    ...state,
                    modalView: action.view
                };
            }
        case 'SET_MODAL_DATA':
            {
                return {
                    ...state,
                    modalData: action.data
                };
            }
    }
}
const UIProvider = (props)=>{
    const [state, dispatch] = react__WEBPACK_IMPORTED_MODULE_1___default().useReducer(uiReducer, initialState);
    const openSidebar = ()=>dispatch({
            type: 'OPEN_SIDEBAR'
        })
    ;
    const closeSidebar = ()=>dispatch({
            type: 'CLOSE_SIDEBAR'
        })
    ;
    const toggleSidebar = ()=>state.displaySidebar ? dispatch({
            type: 'CLOSE_SIDEBAR'
        }) : dispatch({
            type: 'OPEN_SIDEBAR'
        })
    ;
    const openCartSidebar = ()=>dispatch({
            type: 'OPEN_CART_SIDEBAR'
        })
    ;
    const closeCartSidebar = ()=>dispatch({
            type: 'CLOSE_CART_SIDEBAR'
        })
    ;
    const toggleCartSidebar = ()=>state.displayCartSidebar ? dispatch({
            type: 'CLOSE_CART_SIDEBAR'
        }) : dispatch({
            type: 'OPEN_CART_SIDEBAR'
        })
    ;
    const closeSidebarIfPresent = ()=>state.displaySidebar && dispatch({
            type: 'CLOSE_SIDEBAR'
        })
    ;
    const openModal = ()=>dispatch({
            type: 'OPEN_MODAL'
        })
    ;
    const closeModal = ()=>dispatch({
            type: 'CLOSE_MODAL'
        })
    ;
    const setModalView = (view)=>dispatch({
            type: 'SET_MODAL_VIEW',
            view
        })
    ;
    const setModalData = (data)=>dispatch({
            type: 'SET_MODAL_DATA',
            data
        })
    ;
    const value = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(()=>({
            ...state,
            openSidebar,
            closeSidebar,
            toggleSidebar,
            openCartSidebar,
            closeCartSidebar,
            toggleCartSidebar,
            closeSidebarIfPresent,
            openModal,
            closeModal,
            setModalView,
            setModalData
        })
    , [
        state
    ]);
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(UIContext.Provider, {
        value: value,
        ...props
    }));
};
const useUI = ()=>{
    const context = react__WEBPACK_IMPORTED_MODULE_1___default().useContext(UIContext);
    if (context === undefined) {
        throw new Error(`useUI must be used within a UIProvider`);
    }
    return context;
};


/***/ }),

/***/ 40888:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_": () => (/* reexport default from dynamic */ react_use_lib_useLocalStorage__WEBPACK_IMPORTED_MODULE_0___default.a)
/* harmony export */ });
/* harmony import */ var react_use_lib_useLocalStorage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(57139);
/* harmony import */ var react_use_lib_useLocalStorage__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_use_lib_useLocalStorage__WEBPACK_IMPORTED_MODULE_0__);



/***/ })

};
;