"use strict";
exports.id = 6228;
exports.ids = [6228];
exports.modules = {

/***/ 51007:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ address_card)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
;// CONCATENATED MODULE: ./src/components/icons/pencil-icon.tsx

const PencilIcon = (props)=>/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        ...props,
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            d: "M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L3 14.172V17h2.828l8.38-8.379-2.83-2.828z"
        })
    })
;

// EXTERNAL MODULE: ./src/components/ui/modal/modal.context.tsx
var modal_context = __webpack_require__(44144);
// EXTERNAL MODULE: ./src/utils/format-address.tsx
var format_address = __webpack_require__(1125);
// EXTERNAL MODULE: external "classnames"
var external_classnames_ = __webpack_require__(59003);
var external_classnames_default = /*#__PURE__*/__webpack_require__.n(external_classnames_);
// EXTERNAL MODULE: external "next-i18next"
var external_next_i18next_ = __webpack_require__(11377);
;// CONCATENATED MODULE: ./src/components/address/address-card.tsx






const AddressCard = ({ checked , address , userId  })=>{
    const { t  } = (0,external_next_i18next_.useTranslation)();
    const { openModal  } = (0,modal_context/* useModalAction */.SO)();
    function onEdit() {
        openModal('ADD_OR_UPDATE_ADDRESS', {
            customerId: userId,
            address
        });
    }
    return(/*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
        className: external_classnames_default()('group relative h-full cursor-pointer overflow-hidden rounded border p-4 hover:border-accent', {
            'border-accent shadow-sm': checked,
            'border-transparent bg-gray-100': !checked
        }),
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx("p", {
                className: "mb-3 truncate text-sm font-semibold capitalize text-heading",
                children: address.title
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("p", {
                className: "group flex flex-col text-sm text-sub-heading",
                children: (0,format_address/* formatAddress */.T)(address.address)
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                className: "absolute top-4 flex opacity-0 end-4 space-s-2 group-hover:opacity-100",
                children: onEdit && /*#__PURE__*/ (0,jsx_runtime_.jsxs)("button", {
                    className: "flex h-5 w-5 items-center justify-center rounded-full bg-accent text-light",
                    onClick: onEdit,
                    children: [
                        /*#__PURE__*/ jsx_runtime_.jsx("span", {
                            className: "sr-only",
                            children: t('text-edit')
                        }),
                        /*#__PURE__*/ jsx_runtime_.jsx(PencilIcon, {
                            className: "h-3 w-3"
                        })
                    ]
                })
            })
        ]
    }));
};
/* harmony default export */ const address_card = (AddressCard);


/***/ }),

/***/ 35076:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "V": () => (/* binding */ AddressHeader)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_icons_plus_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(90393);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);



const AddressHeader = ({ onAdd , count , label ,  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)('common');
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "mb-5 flex items-center justify-between md:mb-8",
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "space-s-3 md:space-s-4 flex items-center",
                children: [
                    count && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                        className: "flex h-8 w-8 items-center justify-center rounded-full bg-accent text-base text-light lg:text-xl",
                        children: count
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                        className: "text-lg capitalize text-heading lg:text-xl",
                        children: label
                    })
                ]
            }),
            onAdd && /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("button", {
                className: "flex items-center text-sm font-semibold text-accent transition-colors duration-200 hover:text-accent-hover focus:text-accent-hover focus:outline-none",
                onClick: onAdd,
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_plus_icon__WEBPACK_IMPORTED_MODULE_1__/* .PlusIcon */ .p, {
                        className: "me-0.5 h-4 w-4 stroke-2"
                    }),
                    t('text-add')
                ]
            })
        ]
    }));
};


/***/ }),

/***/ 86228:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddressGrid": () => (/* binding */ AddressGrid),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_modal_modal_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44144);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61185);
/* harmony import */ var jotai__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(82451);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _components_address_address_card__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(51007);
/* harmony import */ var _components_address_address_header__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(35076);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_7__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_headlessui_react__WEBPACK_IMPORTED_MODULE_2__, jotai__WEBPACK_IMPORTED_MODULE_3__]);
([_headlessui_react__WEBPACK_IMPORTED_MODULE_2__, jotai__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);








const AddressGrid = ({ addresses , label , atom , className , userId , count , type ,  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_7__.useTranslation)('common');
    const [selectedAddress, setAddress] = (0,jotai__WEBPACK_IMPORTED_MODULE_3__.useAtom)(atom);
    const { openModal  } = (0,_components_ui_modal_modal_context__WEBPACK_IMPORTED_MODULE_1__/* .useModalAction */ .SO)();
    (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(()=>{
        if (addresses === null || addresses === void 0 ? void 0 : addresses.length) {
            if (selectedAddress === null || selectedAddress === void 0 ? void 0 : selectedAddress.id) {
                const index = addresses.findIndex((a)=>a.id === selectedAddress.id
                );
                setAddress(addresses[index]);
            } else {
                setAddress(addresses === null || addresses === void 0 ? void 0 : addresses[0]);
            }
        }
    }, [
        addresses,
        addresses === null || addresses === void 0 ? void 0 : addresses.length,
        selectedAddress === null || selectedAddress === void 0 ? void 0 : selectedAddress.id,
        setAddress
    ]);
    function onAdd() {
        openModal('ADD_OR_UPDATE_ADDRESS', {
            customerId: userId,
            type
        });
    }
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: className,
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_address_address_header__WEBPACK_IMPORTED_MODULE_6__/* .AddressHeader */ .V, {
                onAdd: onAdd,
                count: count,
                label: label
            }),
            addresses && (addresses === null || addresses === void 0 ? void 0 : addresses.length) ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.RadioGroup, {
                value: selectedAddress,
                onChange: setAddress,
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.RadioGroup.Label, {
                        className: "sr-only",
                        children: label
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "grid grid-cols-1 gap-4 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-2 xl:grid-cols-3",
                        children: addresses === null || addresses === void 0 ? void 0 : addresses.map((address)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.RadioGroup.Option, {
                                value: address,
                                children: ({ checked  })=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_address_address_card__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                        checked: checked,
                                        address: address,
                                        userId: userId
                                    })
                            }, address.id)
                        )
                    })
                ]
            }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "grid grid-cols-1 gap-4 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-2 xl:grid-cols-3",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "relative rounded border border-border-200 bg-gray-100 px-5 py-6 text-center text-base",
                    children: t('text-no-address')
                })
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AddressGrid);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1125:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "T": () => (/* binding */ formatAddress)
/* harmony export */ });
function removeFalsy(obj) {
    return Object.fromEntries(Object.entries(obj).filter(([_, v])=>Boolean(v)
    ));
}
function formatAddress(address) {
    if (!address) return;
    const temp = [
        'street_address',
        'city',
        'state',
        'zip',
        'country'
    ].reduce((acc, k)=>({
            ...acc,
            [k]: address[k]
        })
    , {});
    const formattedAddress = removeFalsy(temp);
    return Object.values(formattedAddress).join(', ');
}


/***/ })

};
;