"use strict";
exports.id = 642;
exports.ids = [642];
exports.modules = {

/***/ 5034:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "h": () => (/* binding */ crudFactory)
/* harmony export */ });
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_0__]);
_http_client__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

function crudFactory(endpoint) {
    return {
        all (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        paginated (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        get ({ slug , language  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(`${endpoint}/${slug}`, {
                language
            });
        },
        create (data) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.post */ .eN.post(endpoint, data);
        },
        update ({ id , ...input }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.put */ .eN.put(`${endpoint}/${id}`, input);
        },
        delete ({ id  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient["delete"] */ .eN["delete"](`${endpoint}/${id}`);
        }
    };
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 77305:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "z": () => (/* binding */ settingsClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5034);
/* harmony import */ var _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const settingsClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_1__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SETTINGS */ .P.SETTINGS),
    all ({ language  }) {
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SETTINGS */ .P.SETTINGS, {
            language
        });
    },
    update: ({ ...data })=>{
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SETTINGS */ .P.SETTINGS, {
            ...data
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 50642:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "B": () => (/* binding */ useUpdateSettingsMutation),
/* harmony export */   "n": () => (/* binding */ useSettingsQuery)
/* harmony export */ });
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(85057);
/* harmony import */ var _client_settings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(77305);
/* harmony import */ var _contexts_settings_context__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(92303);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_settings__WEBPACK_IMPORTED_MODULE_4__]);
_client_settings__WEBPACK_IMPORTED_MODULE_4__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






const useUpdateSettingsMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQueryClient)();
    const { updateSettings  } = (0,_contexts_settings_context__WEBPACK_IMPORTED_MODULE_5__/* .useSettings */ .rV)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)(_client_settings__WEBPACK_IMPORTED_MODULE_4__/* .settingsClient.update */ .z.update, {
        onError: (error)=>{
            console.log(error);
        },
        onSuccess: (data)=>{
            updateSettings(data === null || data === void 0 ? void 0 : data.options);
            react_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SETTINGS */ .P.SETTINGS);
        }
    });
};
const useSettingsQuery = ({ language  })=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SETTINGS */ .P.SETTINGS,
        {
            language
        }
    ], ()=>_client_settings__WEBPACK_IMPORTED_MODULE_4__/* .settingsClient.all */ .z.all({
            language
        })
    );
    return {
        settings: data !== null && data !== void 0 ? data : {},
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;