"use strict";
exports.id = 678;
exports.ids = [678];
exports.modules = {

/***/ 5683:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "b": () => (/* binding */ shopClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67904);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5034);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_1__, _curd_factory__WEBPACK_IMPORTED_MODULE_2__]);
([_http_client__WEBPACK_IMPORTED_MODULE_1__, _curd_factory__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const shopClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_2__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS),
    get ({ slug  }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.get */ .eN.get(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS}/${slug}`);
    },
    paginated: ({ name , ...params })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS, {
            searchJoin: 'and',
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                name
            })
        });
    },
    approve: (variables)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.APPROVE_SHOP */ .P.APPROVE_SHOP, variables);
    },
    disapprove: (variables)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.DISAPPROVE_SHOP */ .P.DISAPPROVE_SHOP, variables);
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 10678:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "bg": () => (/* binding */ useApproveShopMutation),
/* harmony export */   "mj": () => (/* binding */ useDisApproveShopMutation),
/* harmony export */   "TC": () => (/* binding */ useCreateShopMutation),
/* harmony export */   "D9": () => (/* binding */ useUpdateShopMutation),
/* harmony export */   "DZ": () => (/* binding */ useShopQuery),
/* harmony export */   "uL": () => (/* binding */ useShopsQuery)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28379);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(85057);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _client_shop__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(5683);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63354);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(49239);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_shop__WEBPACK_IMPORTED_MODULE_5__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__]);
([_client_shop__WEBPACK_IMPORTED_MODULE_5__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const useApproveShopMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_shop__WEBPACK_IMPORTED_MODULE_5__/* .shopClient.approve */ .b.approve, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_4__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS);
        }
    });
};
const useDisApproveShopMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_shop__WEBPACK_IMPORTED_MODULE_5__/* .shopClient.disapprove */ .b.disapprove, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_4__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS);
        }
    });
};
const useCreateShopMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_7__.useRouter)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_shop__WEBPACK_IMPORTED_MODULE_5__/* .shopClient.create */ .b.create, {
        onSuccess: ()=>{
            const { permissions  } = (0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__/* .getAuthCredentials */ .WA)();
            if ((0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__/* .hasAccess */ .Ft)(_utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__/* .adminOnly */ .M$, permissions)) {
                return router.push(_config_routes__WEBPACK_IMPORTED_MODULE_1__/* .Routes.adminMyShops */ .Z.adminMyShops);
            }
            router.push(_config_routes__WEBPACK_IMPORTED_MODULE_1__/* .Routes.dashboard */ .Z.dashboard);
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS);
        }
    });
};
const useUpdateShopMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_shop__WEBPACK_IMPORTED_MODULE_5__/* .shopClient.update */ .b.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_4__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS);
        }
    });
};
const useShopQuery = ({ slug  }, options)=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS,
        {
            slug
        }
    ], ()=>_client_shop__WEBPACK_IMPORTED_MODULE_5__/* .shopClient.get */ .b.get({
            slug
        })
    , options);
};
const useShopsQuery = (options)=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS,
        options
    ], ({ queryKey , pageParam  })=>_client_shop__WEBPACK_IMPORTED_MODULE_5__/* .shopClient.paginated */ .b.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    var ref;
    return {
        shops: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__/* .mapPaginatorData */ .Q)(data),
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;