"use strict";
exports.id = 6797;
exports.ids = [6797];
exports.modules = {

/***/ 86797:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ZP": () => (/* binding */ usePrice)
/* harmony export */ });
/* unused harmony exports formatPrice, formatVariantPrice */
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _settings_site_settings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37070);
/* harmony import */ var _contexts_settings_context__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(92303);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_settings_site_settings__WEBPACK_IMPORTED_MODULE_1__]);
_settings_site_settings__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



function formatPrice({ amount , currencyCode , locale  }) {
    const formatCurrency = new Intl.NumberFormat(locale, {
        style: 'currency',
        currency: currencyCode
    });
    return formatCurrency.format(amount);
}
function formatVariantPrice({ amount , baseAmount , currencyCode , locale  }) {
    const hasDiscount = baseAmount < amount;
    const formatDiscount = new Intl.NumberFormat(locale, {
        style: 'percent'
    });
    const discount = hasDiscount ? formatDiscount.format((amount - baseAmount) / amount) : null;
    const price = formatPrice({
        amount,
        currencyCode,
        locale
    });
    const basePrice = hasDiscount ? formatPrice({
        amount: baseAmount,
        currencyCode,
        locale
    }) : null;
    return {
        price,
        basePrice,
        discount
    };
}
function usePrice(data) {
    const { currency  } = (0,_contexts_settings_context__WEBPACK_IMPORTED_MODULE_2__/* .useSettings */ .rV)();
    const { amount , baseAmount , currencyCode =currency  } = data !== null && data !== void 0 ? data : {};
    const locale = _settings_site_settings__WEBPACK_IMPORTED_MODULE_1__/* .siteSettings.defaultLanguage */ .U.defaultLanguage;
    const value = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(()=>{
        if (typeof amount !== 'number' || !currencyCode) return '';
        return baseAmount ? formatVariantPrice({
            amount,
            baseAmount,
            currencyCode,
            locale
        }) : formatPrice({
            amount,
            currencyCode,
            locale
        });
    }, [
        amount,
        baseAmount,
        currencyCode
    ]);
    return typeof value === 'string' ? {
        price: value,
        basePrice: null,
        discount: null
    } : value;
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;