"use strict";
exports.id = 7721;
exports.ids = [7721];
exports.modules = {

/***/ 28379:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Routes)
/* harmony export */ });
const Routes = {
    dashboard: '/',
    login: '/login',
    logout: '/logout',
    register: '/register',
    forgotPassword: '/forgot-password',
    resetPassword: '/reset-password',
    adminMyShops: '/my-shops',
    profile: '/profile',
    verifyCoupons: '/coupons/verify',
    settings: '/settings',
    storeSettings: '/vendor/settings',
    storeKeepers: '/vendor/store_keepers',
    profileUpdate: '/profile-update',
    'payment-keys': '/payment-keys',
    coin: '/coins',
    checkout: '/orders/checkout',
    user: {
        ...routesFactory('/users')
    },
    menu: {
        ...routesFactory('/menus')
    },
    sixAdBanner: {
        ...routesFactory('/six-ad-banner')
    },
    section: {
        ...routesFactory('/section')
    },
    banner: {
        ...routesFactory('/banners')
    },
    carousel: {
        ...routesFactory('/carousels')
    },
    type: {
        ...routesFactory('/brands')
    },
    category: {
        ...routesFactory('/categories')
    },
    attribute: {
        ...routesFactory('/attributes')
    },
    attributeValue: {
        ...routesFactory('/attribute-values')
    },
    tag: {
        ...routesFactory('/tags')
    },
    reviews: {
        ...routesFactory('/reviews')
    },
    abuseReviews: {
        ...routesFactory('/abusive_reports')
    },
    abuseReviewsReport: {
        ...routesFactory('/abusive_reports/reject')
    },
    author: {
        ...routesFactory('/authors')
    },
    coupon: {
        ...routesFactory('/coupons')
    },
    manufacturer: {
        ...routesFactory('/manufacturers')
    },
    order: {
        ...routesFactory('/orders')
    },
    orderStatus: {
        ...routesFactory('/order-status')
    },
    orderCreate: {
        ...routesFactory('/orders/create')
    },
    product: {
        ...routesFactory('/products')
    },
    shop: {
        ...routesFactory('/shops')
    },
    tax: {
        ...routesFactory('/taxes')
    },
    shipping: {
        ...routesFactory('/shippings')
    },
    'shipping-address': {
        ...routesFactory('/shipping-address')
    },
    withdraw: {
        ...routesFactory('/withdraws')
    },
    staff: {
        ...routesFactory('/staffs')
    },
    refund: {
        ...routesFactory('/refunds')
    },
    question: {
        ...routesFactory('/questions')
    },
    message: {
        ...routesFactory('/message')
    },
    shopMessage: {
        ...routesFactory('/shop-message')
    },
    conversations: {
        ...routesFactory('/message/conversations')
    },
    storeNotice: {
        ...routesFactory('/store-notices')
    },
    storeNoticeRead: {
        ...routesFactory('/store-notices/read')
    }
};
function routesFactory(endpoint) {
    return {
        list: `${endpoint}`,
        create: `${endpoint}/create`,
        editWithoutLang: (slug, shop)=>{
            return shop ? `/${shop}${endpoint}/${slug}/edit` : `${endpoint}/${slug}/edit`;
        },
        edit: (slug, language, shop)=>{
            return shop ? `/${language}/${shop}${endpoint}/${slug}/edit` : `${language}${endpoint}/${slug}/edit`;
        },
        translate: (slug, language, shop)=>{
            return shop ? `/${language}/${shop}${endpoint}/${slug}/translate` : `${language}${endpoint}/${slug}/translate`;
        },
        details: (slug)=>`${endpoint}/${slug}`
    };
}


/***/ }),

/***/ 30957:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "VZ": () => (/* binding */ LIMIT),
/* harmony export */   "Mc": () => (/* binding */ SUPER_ADMIN),
/* harmony export */   "dL": () => (/* binding */ STORE_OWNER),
/* harmony export */   "G9": () => (/* binding */ STAFF),
/* harmony export */   "o3": () => (/* binding */ TOKEN),
/* harmony export */   "_I": () => (/* binding */ PERMISSIONS),
/* harmony export */   "E$": () => (/* binding */ AUTH_CRED),
/* harmony export */   "qW": () => (/* binding */ CART_KEY),
/* harmony export */   "iK": () => (/* binding */ CHECKOUT),
/* harmony export */   "h2": () => (/* binding */ RESPONSIVE_WIDTH),
/* harmony export */   "_0": () => (/* binding */ ACCEPTED_FILE_TYPES)
/* harmony export */ });
const LIMIT = 10;
const SUPER_ADMIN = 'super_admin';
const STORE_OWNER = 'store_owner';
const STAFF = 'staff';
const TOKEN = 'token';
const PERMISSIONS = 'permissions';
const AUTH_CRED = 'AUTH_CRED';
const CART_KEY = 'pick-cart';
const CHECKOUT = 'pickbazar-checkout';
const RESPONSIVE_WIDTH = 659;
// https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP/MIME_types/Common_types
const ACCEPTED_FILE_TYPES = 'image/*,application/pdf,application/zip,application/vnd.rar,application/epub+zip,.psd';


/***/ })

};
;