"use strict";
exports.id = 7725;
exports.ids = [7725];
exports.modules = {

/***/ 20286:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Uploader)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_icons_upload_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19525);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_dropzone__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56358);
/* harmony import */ var react_dropzone__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_dropzone__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_icons_close_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29581);
/* harmony import */ var _components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(47898);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _data_upload__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(34421);
/* harmony import */ var next_image__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(38579);
/* harmony import */ var _utils_placeholders__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(34896);
/* harmony import */ var _utils_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(30957);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_upload__WEBPACK_IMPORTED_MODULE_7__]);
_data_upload__WEBPACK_IMPORTED_MODULE_7__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];











const getPreviewImage = (value)=>{
    let images = [];
    if (value) {
        images = Array.isArray(value) ? value : [
            {
                ...value
            }
        ];
    }
    return images;
};
function Uploader({ onChange , value , multiple , acceptFile , helperText  }) {
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_6__.useTranslation)();
    const { 0: files , 1: setFiles  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(getPreviewImage(value));
    const { mutate: upload , isLoading: loading  } = (0,_data_upload__WEBPACK_IMPORTED_MODULE_7__/* .useUploadMutation */ .g)();
    const { 0: error1 , 1: setError  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(null);
    const { getRootProps , getInputProps  } = (0,react_dropzone__WEBPACK_IMPORTED_MODULE_3__.useDropzone)({
        ...!acceptFile ? {
            accept: 'image/*'
        } : {
            accept: _utils_constants__WEBPACK_IMPORTED_MODULE_10__/* .ACCEPTED_FILE_TYPES */ ._0
        },
        multiple,
        onDrop: async (acceptedFiles)=>{
            if (acceptedFiles.length) {
                upload(acceptedFiles, {
                    onSuccess: (data)=>{
                        // Process Digital File Name section
                        data && (data === null || data === void 0 ? void 0 : data.map((file, idx)=>{
                            var ref, ref1;
                            const splitArray = file === null || file === void 0 ? void 0 : (ref = file.original) === null || ref === void 0 ? void 0 : ref.split('/');
                            let fileSplitName = (ref1 = splitArray[(splitArray === null || splitArray === void 0 ? void 0 : splitArray.length) - 1]) === null || ref1 === void 0 ? void 0 : ref1.split('.');
                            const fileType = fileSplitName === null || fileSplitName === void 0 ? void 0 : fileSplitName.pop(); // it will pop the last item from the fileSplitName arr which is the file ext
                            const filename = fileSplitName === null || fileSplitName === void 0 ? void 0 : fileSplitName.join('.'); // it will join the array with dot, which restore the original filename
                            data[idx]['file_name'] = filename + '.' + fileType;
                        }));
                        let mergedData;
                        if (multiple) {
                            mergedData = files.concat(data);
                            setFiles(files.concat(data));
                        } else {
                            mergedData = data[0];
                            setFiles(data);
                        }
                        if (onChange) {
                            onChange(mergedData);
                        }
                    }
                });
            }
        },
        onDropRejected: (fileRejections)=>{
            fileRejections.forEach((file)=>{
                var ref;
                file === null || file === void 0 ? void 0 : (ref = file.errors) === null || ref === void 0 ? void 0 : ref.forEach((error)=>{
                    if ((error === null || error === void 0 ? void 0 : error.code) === 'file-too-large') {
                        setError(t('error-file-too-large'));
                    } else if ((error === null || error === void 0 ? void 0 : error.code) === 'file-invalid-type') {
                        setError(t('error-invalid-file-type'));
                    }
                });
            });
        }
    });
    const handleDelete = (image)=>{
        const images = files.filter((file)=>file.thumbnail !== image
        );
        setFiles(images);
        if (onChange) {
            onChange(images);
        }
    };
    const thumbs = files === null || files === void 0 ? void 0 : files.map((file, idx)=>{
        const imgTypes = [
            'tif',
            'tiff',
            'bmp',
            'jpg',
            'jpeg',
            'gif',
            'png',
            'eps',
            'raw', 
        ];
        // let filename, fileType, isImage;
        if (file && file.id) {
            var ref;
            console.log('File is', file);
            // const processedFile = processFileWithName(file);
            const splitArray = file === null || file === void 0 ? void 0 : (ref = file.file_name) === null || ref === void 0 ? void 0 : ref.split('.');
            const fileType = splitArray === null || splitArray === void 0 ? void 0 : splitArray.pop(); // it will pop the last item from the fileSplitName arr which is the file ext
            const filename = splitArray === null || splitArray === void 0 ? void 0 : splitArray.join('.'); // it will join the array with dot, which restore the original filename
            const isImage = (file === null || file === void 0 ? void 0 : file.thumbnail) && imgTypes.includes(fileType); // check if the original filename has the img ext
            // Old Code *******
            // const splitArray = file?.original?.split('/');
            // let fileSplitName = splitArray[splitArray?.length - 1]?.split('.'); // it will create an array of words of filename
            // const fileType = fileSplitName.pop(); // it will pop the last item from the fileSplitName arr which is the file ext
            // const filename = fileSplitName.join('.'); // it will join the array with dot, which restore the original filename
            // const isImage = file?.thumbnail && imgTypes.includes(fileType); // check if the original filename has the img ext
            return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: `relative mt-2 inline-flex flex-col overflow-hidden rounded me-2 ${isImage ? 'border border-border-200' : ''}`,
                children: [
                    isImage ? // <div className="flex h-16 w-16 min-w-0 items-center justify-center overflow-hidden">
                    //   <Image
                    //     src={file.thumbnail}
                    //     width={56}
                    //     height={56}
                    //     alt="uploaded image"
                    //   />
                    // </div>
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("figure", {
                        className: "relative h-16 w-28",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(next_image__WEBPACK_IMPORTED_MODULE_8__["default"], {
                            src: file.thumbnail,
                            alt: filename,
                            layout: "fill",
                            objectFit: "contain"
                        })
                    }) : /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                        className: "flex flex-col items-center",
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                className: "flex h-14 w-14 min-w-0 items-center justify-center overflow-hidden",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(next_image__WEBPACK_IMPORTED_MODULE_8__["default"], {
                                    src: _utils_placeholders__WEBPACK_IMPORTED_MODULE_9__/* .zipPlaceholder */ .GZ,
                                    width: 56,
                                    height: 56,
                                    alt: "upload placeholder"
                                })
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("p", {
                                className: "flex cursor-default items-baseline p-1 text-xs text-body",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                        className: "inline-block max-w-[64px] overflow-hidden overflow-ellipsis whitespace-nowrap",
                                        title: `${filename}.${fileType}`,
                                        children: filename
                                    }),
                                    ".",
                                    fileType
                                ]
                            })
                        ]
                    }),
                    multiple ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                        className: "absolute top-1 flex h-4 w-4 items-center justify-center rounded-full bg-red-600 text-xs text-light shadow-xl outline-none end-1",
                        onClick: ()=>handleDelete(file.thumbnail)
                        ,
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_close_icon__WEBPACK_IMPORTED_MODULE_4__/* .CloseIcon */ .T, {
                            width: 10,
                            height: 10
                        })
                    }) : null
                ]
            }, idx));
        }
    });
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(()=>()=>{
            // Reset error after upload new file
            setError(null);
            // Make sure to revoke the data uris to avoid memory leaks
            files.forEach((file)=>URL.revokeObjectURL(file.thumbnail)
            );
        }
    , [
        files
    ]);
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("section", {
        className: "upload",
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                ...getRootProps({
                    className: 'border-dashed border-2 border-border-base h-36 rounded flex flex-col justify-center items-center cursor-pointer focus:border-accent-400 focus:outline-none'
                }),
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                        ...getInputProps()
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_upload_icon__WEBPACK_IMPORTED_MODULE_1__/* .UploadIcon */ .r, {
                        className: "text-muted-light"
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                        className: "mt-4 text-center text-sm text-body",
                        children: helperText ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                            className: "font-semibold text-gray-500",
                            children: helperText
                        }) : /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                    className: "font-semibold text-accent",
                                    children: t('text-upload-highlight')
                                }),
                                ' ',
                                t('text-upload-message'),
                                " ",
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("br", {}),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                    className: "text-xs text-body",
                                    children: t('text-img-format')
                                })
                            ]
                        })
                    }),
                    error1 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                        className: "mt-4 text-center text-sm text-body text-red-600",
                        children: error1
                    })
                ]
            }),
            (!!thumbs.length || loading) && /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("aside", {
                className: "mt-2 flex flex-wrap",
                children: [
                    !!thumbs.length && thumbs,
                    loading && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "mt-2 flex h-16 items-center ms-2",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                            simple: true,
                            className: "h-6 w-6"
                        })
                    })
                ]
            })
        ]
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 77725:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_common_uploader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20286);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45641);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_common_uploader__WEBPACK_IMPORTED_MODULE_1__, react_hook_form__WEBPACK_IMPORTED_MODULE_2__]);
([_components_common_uploader__WEBPACK_IMPORTED_MODULE_1__, react_hook_form__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const FileInput = ({ control , name , multiple =true , acceptFile =false , helperText , defaultValue =[]  })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_hook_form__WEBPACK_IMPORTED_MODULE_2__.Controller, {
        control: control,
        name: name,
        defaultValue: defaultValue,
        render: ({ field: { ref , ...rest }  })=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_uploader__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                ...rest,
                multiple: multiple,
                acceptFile: acceptFile,
                helperText: helperText
            })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FileInput);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 12721:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "t": () => (/* binding */ uploadClient)
/* harmony export */ });
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67904);
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_0__]);
_http_client__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const uploadClient = {
    upload: async (variables)=>{
        let formData = new FormData();
        variables.forEach((attachment)=>{
            formData.append('attachment[]', attachment);
        });
        const options = {
            headers: {
                'Content-Type': 'multipart/form-data'
            }
        };
        return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.ATTACHMENTS */ .P.ATTACHMENTS, formData, options);
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 34421:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "g": () => (/* binding */ useUploadMutation)
/* harmony export */ });
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
/* harmony import */ var _data_client_upload__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12721);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_upload__WEBPACK_IMPORTED_MODULE_2__]);
_data_client_upload__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const useUploadMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)((input)=>{
        return _data_client_upload__WEBPACK_IMPORTED_MODULE_2__/* .uploadClient.upload */ .t.upload(input);
    }, {
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.SETTINGS */ .P.SETTINGS);
        }
    });
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;