"use strict";
exports.id = 7843;
exports.ids = [7843];
exports.modules = {

/***/ 87843:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_select_select__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26798);
/* harmony import */ var _data_shop__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(10678);
/* harmony import */ var _data_user__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(93691);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(53139);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _data_conversations__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(84891);
/* harmony import */ var _components_ui_button__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(39258);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(45641);
/* harmony import */ var next_image__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(38579);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(89699);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _components_ui_error_message__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(30110);
/* harmony import */ var _utils_auth_utils__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(49239);
/* harmony import */ var _components_icons_message_avatar_placeholder_icon__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(36459);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_shop__WEBPACK_IMPORTED_MODULE_2__, _data_user__WEBPACK_IMPORTED_MODULE_3__, _data_conversations__WEBPACK_IMPORTED_MODULE_7__, react_hook_form__WEBPACK_IMPORTED_MODULE_9__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_13__]);
([_data_shop__WEBPACK_IMPORTED_MODULE_2__, _data_user__WEBPACK_IMPORTED_MODULE_3__, _data_conversations__WEBPACK_IMPORTED_MODULE_7__, react_hook_form__WEBPACK_IMPORTED_MODULE_9__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_13__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);















const formatOptionLabel = ({ logo , name  })=>{
    /*#__PURE__*/ return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "flex items-center",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "relative mr-3 h-6 w-6 shrink-0 overflow-hidden rounded-full",
                children: !lodash_isEmpty__WEBPACK_IMPORTED_MODULE_11___default()(logo === null || logo === void 0 ? void 0 : logo.thumbnail) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(next_image__WEBPACK_IMPORTED_MODULE_10__["default"], {
                    src: logo === null || logo === void 0 ? void 0 : logo.thumbnail,
                    alt: name,
                    layout: "fill",
                    objectFit: "contain",
                    className: "product-image"
                }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_message_avatar_placeholder_icon__WEBPACK_IMPORTED_MODULE_14__/* .MessageAvatarPlaceholderIcon */ .E, {
                    className: "text-[1.5rem]",
                    color: "#DDDDDD"
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "truncate",
                children: name
            })
        ]
    });
};
const ComposeMessageModal = ()=>{
    const { 0: shop1 , 1: setShop  } = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(null);
    const { 0: active , 1: setIsActive  } = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(Boolean(0));
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_6__.useTranslation)();
    const { permissions  } = (0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_13__/* .getAuthCredentials */ .WA)();
    let permission = (0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_13__/* .hasAccess */ .Ft)(_utils_auth_utils__WEBPACK_IMPORTED_MODULE_13__/* .adminOnly */ .M$, permissions);
    let options = {
        limit: 1000,
        page: 1,
        orderBy: 'created_at',
        sortedBy: _types__WEBPACK_IMPORTED_MODULE_5__/* .SortOrder.Desc */ .As.Desc
    };
    let { shops , loading , error  } = (0,_data_shop__WEBPACK_IMPORTED_MODULE_2__/* .useShopsQuery */ .uL)(options);
    let { admins , loading: adminLoading , error: adminError ,  } = (0,_data_user__WEBPACK_IMPORTED_MODULE_3__/* .useAdminsQuery */ .Jc)(options);
    const { mutate: createConversations , isLoading: creating  } = (0,_data_conversations__WEBPACK_IMPORTED_MODULE_7__/* .useCreateConversations */ .As)();
    const { handleSubmit  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_9__.useForm)();
    let lists = permission ? shops : admins;
    let loadingState = permission ? loading : adminLoading;
    let errorState = permission ? error : adminError;
    if (errorState) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_error_message__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Z, {
        message: error === null || error === void 0 ? void 0 : error.message
    }));
    const onTypeFilter = (shop)=>{
        // @ts-ignore
        setShop(shop === null || shop === void 0 ? void 0 : shop.id);
        // @ts-ignore
        setIsActive(shop === null || shop === void 0 ? void 0 : shop.is_active);
    };
    async function onSubmit() {
        if (shop1 || !Boolean(active)) {
            createConversations({
                // @ts-ignore
                shop_id: shop1
            });
        }
    }
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "m-auto block max-w-lg rounded bg-light p-6 md:w-[32.5rem]",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h2", {
                className: "mb-6 text-base font-medium",
                children: t('text-starting-chat')
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("form", {
                onSubmit: handleSubmit(onSubmit),
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_select_select__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        options: lists,
                        isLoading: loadingState,
                        getOptionLabel: (option)=>option.name
                        ,
                        getOptionValue: (option)=>option.slug
                        ,
                        placeholder: "Find Vendor",
                        onChange: onTypeFilter,
                        isClearable: true,
                        // @ts-ignore
                        formatOptionLabel: formatOptionLabel
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "mt-6 text-right",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                            className: "h-full px-4 text-base",
                            loading: creating,
                            disabled: !!creating || !shop1 || !Boolean(active),
                            children: t('text-start-conversation')
                        })
                    })
                ]
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComposeMessageModal);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 26798:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* unused harmony export Select */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_locals__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10601);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_select__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61929);
/* harmony import */ var react_select__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_select__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _select_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(76302);





const Select = /*#__PURE__*/ react__WEBPACK_IMPORTED_MODULE_2___default().forwardRef((props, ref)=>{
    const { isRTL  } = (0,_utils_locals__WEBPACK_IMPORTED_MODULE_1__/* .useIsRTL */ .S)();
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((react_select__WEBPACK_IMPORTED_MODULE_3___default()), {
        ref: ref,
        styles: _select_styles__WEBPACK_IMPORTED_MODULE_4__/* .selectStyles */ .X,
        isRtl: isRTL,
        ...props
    }));
});
Select.displayName = 'Select';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Select);


/***/ })

};
;