"use strict";
exports.id = 8304;
exports.ids = [8304];
exports.modules = {

/***/ 91644:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ CreateOrUpdateShippingForm)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(145);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45641);
/* harmony import */ var _components_ui_button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(39258);
/* harmony import */ var _components_common_card__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(81258);
/* harmony import */ var _components_ui_description__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(87594);
/* harmony import */ var _components_ui_radio_radio__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(45691);
/* harmony import */ var _components_ui_label__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(63815);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(53139);
/* harmony import */ var _data_shipping__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(60263);
/* harmony import */ var _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(61908);
/* harmony import */ var _shipping_validation_schema__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(73246);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_13__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_hook_form__WEBPACK_IMPORTED_MODULE_2__, _data_shipping__WEBPACK_IMPORTED_MODULE_9__, _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_10__]);
([react_hook_form__WEBPACK_IMPORTED_MODULE_2__, _data_shipping__WEBPACK_IMPORTED_MODULE_9__, _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_10__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);














const defaultValues = {
    name: '',
    amount: 0,
    is_global: true,
    type: _types__WEBPACK_IMPORTED_MODULE_8__/* .ShippingType.Fixed */ .sA.Fixed
};
function CreateOrUpdateShippingForm({ initialValues  }) {
    var ref, ref1;
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_12__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_13__.useTranslation)();
    const { register , handleSubmit , control , formState: { errors  } ,  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_2__.useForm)({
        shouldUnregister: true,
        resolver: (0,_hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_10__.yupResolver)(_shipping_validation_schema__WEBPACK_IMPORTED_MODULE_11__/* .shippingValidationSchema */ .z),
        defaultValues: initialValues !== null && initialValues !== void 0 ? initialValues : defaultValues
    });
    const { mutate: createShippingClass , isLoading: creating  } = (0,_data_shipping__WEBPACK_IMPORTED_MODULE_9__/* .useCreateShippingMutation */ .Zj)();
    const { mutate: updateShippingClass , isLoading: updating  } = (0,_data_shipping__WEBPACK_IMPORTED_MODULE_9__/* .useUpdateShippingMutation */ .eI)();
    const onSubmit = async (values)=>{
        if (initialValues) {
            updateShippingClass({
                id: initialValues.id,
                ...values
            });
        } else {
            createShippingClass({
                ...values
            });
        }
    };
    const type = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_2__.useWatch)({
        name: 'type',
        control
    });
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("form", {
        onSubmit: handleSubmit(onSubmit),
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "my-5 flex flex-wrap sm:my-8",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                        title: t('form:item-description'),
                        details: `${initialValues ? t('form:item-description-update') : t('form:item-description-add')} ${t('form:shipping-form-info-help-text')}`,
                        className: "w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pe-4 md:w-1/3 md:pe-5"
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_common_card__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                        className: "w-full sm:w-8/12 md:w-2/3",
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-name'),
                                ...register('name', {
                                    required: 'Name is required'
                                }),
                                error: t((ref = errors.name) === null || ref === void 0 ? void 0 : ref.message),
                                variant: "outline",
                                className: "mb-5"
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                className: "mb-5",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                                        children: t('form:input-label-type')
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_radio_radio__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                                        label: t('form:input-label-free'),
                                        ...register('type'),
                                        id: "FREE",
                                        value: _types__WEBPACK_IMPORTED_MODULE_8__/* .ShippingType.Free */ .sA.Free,
                                        className: "mb-2"
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_radio_radio__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                                        label: t('form:input-label-fixed'),
                                        ...register('type'),
                                        id: "FIXED",
                                        value: _types__WEBPACK_IMPORTED_MODULE_8__/* .ShippingType.Fixed */ .sA.Fixed,
                                        className: "mb-2"
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_radio_radio__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                                        label: t('form:input-label-percentage'),
                                        ...register('type'),
                                        id: "PERCENTAGE",
                                        value: _types__WEBPACK_IMPORTED_MODULE_8__/* .ShippingType.Percentage */ .sA.Percentage
                                    })
                                ]
                            }),
                            type !== _types__WEBPACK_IMPORTED_MODULE_8__/* .ShippingType.Free */ .sA.Free && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-amount'),
                                ...register('amount'),
                                type: "number",
                                error: t((ref1 = errors.amount) === null || ref1 === void 0 ? void 0 : ref1.message),
                                variant: "outline",
                                className: "mb-5"
                            })
                        ]
                    })
                ]
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "mb-4 text-end",
                children: [
                    initialValues && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                        variant: "outline",
                        onClick: router.back,
                        className: "me-4",
                        type: "button",
                        children: t('form:button-label-back')
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_ui_button__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                        loading: creating || updating,
                        disabled: creating || updating,
                        children: [
                            initialValues ? t('form:button-label-update') : t('form:button-label-add'),
                            ' ',
                            t('form:button-label-shipping')
                        ]
                    })
                ]
            })
        ]
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 73246:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "z": () => (/* binding */ shippingValidationSchema)
/* harmony export */ });
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(53139);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_1__);


const shippingValidationSchema = yup__WEBPACK_IMPORTED_MODULE_1__.object().shape({
    name: yup__WEBPACK_IMPORTED_MODULE_1__.string().required('form:error-name-required'),
    type: yup__WEBPACK_IMPORTED_MODULE_1__.string().required('form:error-type-required'),
    amount: yup__WEBPACK_IMPORTED_MODULE_1__.mixed().when('type', {
        is: (value)=>value !== _types__WEBPACK_IMPORTED_MODULE_0__/* .ShippingType.Free */ .sA.Free
        ,
        then: yup__WEBPACK_IMPORTED_MODULE_1__.number().typeError('form:error-amount-must-number').positive('form:error-amount-must-positive').required('form:error-amount-required')
    })
});


/***/ }),

/***/ 5034:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "h": () => (/* binding */ crudFactory)
/* harmony export */ });
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_0__]);
_http_client__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

function crudFactory(endpoint) {
    return {
        all (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        paginated (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        get ({ slug , language  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(`${endpoint}/${slug}`, {
                language
            });
        },
        create (data) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.post */ .eN.post(endpoint, data);
        },
        update ({ id , ...input }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.put */ .eN.put(`${endpoint}/${id}`, input);
        },
        delete ({ id  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient["delete"] */ .eN["delete"](`${endpoint}/${id}`);
        }
    };
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;