"use strict";
exports.id = 835;
exports.ids = [835];
exports.modules = {

/***/ 20835:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Dashboard)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_icons_cart_icon_bag__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(41645);
/* harmony import */ var _components_icons_coin_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67315);
/* harmony import */ var _components_widgets_column_chart__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(63154);
/* harmony import */ var _components_widgets_sticker_card__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8720);
/* harmony import */ var _components_ui_error_message__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(30110);
/* harmony import */ var _utils_use_price__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(86797);
/* harmony import */ var _components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(47898);
/* harmony import */ var _components_order_recent_orders__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(52529);
/* harmony import */ var _components_product_popular_product_list__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(98837);
/* harmony import */ var _data_order__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(5394);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _data_withdraw__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(23125);
/* harmony import */ var _components_withdraw_withdraw_table__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(61168);
/* harmony import */ var _components_icons_sidebar__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(69831);
/* harmony import */ var _components_icons_shops_dollar__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(40827);
/* harmony import */ var _data_dashboard__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(49443);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_17__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_utils_use_price__WEBPACK_IMPORTED_MODULE_6__, _components_order_recent_orders__WEBPACK_IMPORTED_MODULE_8__, _components_product_popular_product_list__WEBPACK_IMPORTED_MODULE_9__, _data_order__WEBPACK_IMPORTED_MODULE_10__, _data_withdraw__WEBPACK_IMPORTED_MODULE_12__, _components_withdraw_withdraw_table__WEBPACK_IMPORTED_MODULE_13__, _data_dashboard__WEBPACK_IMPORTED_MODULE_16__]);
([_utils_use_price__WEBPACK_IMPORTED_MODULE_6__, _components_order_recent_orders__WEBPACK_IMPORTED_MODULE_8__, _components_product_popular_product_list__WEBPACK_IMPORTED_MODULE_9__, _data_order__WEBPACK_IMPORTED_MODULE_10__, _data_withdraw__WEBPACK_IMPORTED_MODULE_12__, _components_withdraw_withdraw_table__WEBPACK_IMPORTED_MODULE_13__, _data_dashboard__WEBPACK_IMPORTED_MODULE_16__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);


















function Dashboard() {
    var ref;
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_11__.useTranslation)();
    const { locale  } = (0,next_router__WEBPACK_IMPORTED_MODULE_17__.useRouter)();
    const { data , isLoading: loading  } = (0,_data_dashboard__WEBPACK_IMPORTED_MODULE_16__/* .useAnalyticsQuery */ .K)();
    const { price: total_revenue  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .ZP)(data && {
        amount: data === null || data === void 0 ? void 0 : data.totalRevenue
    });
    const { price: todays_revenue  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .ZP)(data && {
        amount: data === null || data === void 0 ? void 0 : data.todaysRevenue
    });
    const { error: orderError , orders: orderData , loading: orderLoading , paginatorInfo ,  } = (0,_data_order__WEBPACK_IMPORTED_MODULE_10__/* .useOrdersQuery */ .mU)({
        language: locale,
        limit: 10,
        page: 1
    });
    const { data: popularProductData , isLoading: popularProductLoading , error: popularProductError ,  } = (0,_data_dashboard__WEBPACK_IMPORTED_MODULE_16__/* .usePopularProductsQuery */ .T)({
        limit: 10,
        language: locale
    });
    const { withdraws , loading: withdrawLoading  } = (0,_data_withdraw__WEBPACK_IMPORTED_MODULE_12__/* .useWithdrawsQuery */ .qv)({
        limit: 10
    });
    if (loading || orderLoading || popularProductLoading || withdrawLoading) {
        return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
            text: t('common:text-loading')
        }));
    }
    if (orderError || popularProductError) {
        return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_error_message__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
            message: (orderError === null || orderError === void 0 ? void 0 : orderError.message) || (popularProductError === null || popularProductError === void 0 ? void 0 : popularProductError.message)
        }));
    }
    let salesByYear = Array.from({
        length: 12
    }, (_)=>0
    );
    if (!!(data === null || data === void 0 ? void 0 : (ref = data.totalYearSaleByMonth) === null || ref === void 0 ? void 0 : ref.length)) {
        salesByYear = data.totalYearSaleByMonth.map((item)=>item.total.toFixed(2)
        );
    }
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "mb-6 grid w-full grid-cols-1 gap-5 sm:grid-cols-2 xl:grid-cols-4",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "w-full ",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_widgets_sticker_card__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                            titleTransKey: "sticker-card-title-rev",
                            subtitleTransKey: "sticker-card-subtitle-rev",
                            icon: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_shops_dollar__WEBPACK_IMPORTED_MODULE_15__/* .DollarIcon */ .t, {
                                className: "h-7 w-7",
                                color: "#047857"
                            }),
                            iconBgStyle: {
                                backgroundColor: '#A7F3D0'
                            },
                            price: total_revenue
                        })
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "w-full ",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_widgets_sticker_card__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                            titleTransKey: "sticker-card-title-order",
                            subtitleTransKey: "sticker-card-subtitle-order",
                            icon: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_cart_icon_bag__WEBPACK_IMPORTED_MODULE_1__/* .CartIconBig */ .S, {}),
                            price: data === null || data === void 0 ? void 0 : data.totalOrders
                        })
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "w-full ",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_widgets_sticker_card__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                            titleTransKey: "sticker-card-title-today-rev",
                            icon: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_coin_icon__WEBPACK_IMPORTED_MODULE_2__/* .CoinIcon */ .c, {}),
                            price: todays_revenue
                        })
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "w-full ",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_widgets_sticker_card__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                            titleTransKey: "sticker-card-title-total-shops",
                            icon: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_sidebar__WEBPACK_IMPORTED_MODULE_14__.ShopIcon, {
                                className: "w-6",
                                color: "#1D4ED8"
                            }),
                            iconBgStyle: {
                                backgroundColor: '#93C5FD'
                            },
                            price: data === null || data === void 0 ? void 0 : data.totalShops
                        })
                    })
                ]
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "mb-6 flex w-full flex-wrap md:flex-nowrap",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_widgets_column_chart__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                    widgetTitle: t('common:sale-history'),
                    colors: [
                        '#03D3B5'
                    ],
                    series: salesByYear,
                    categories: [
                        t('common:january'),
                        t('common:february'),
                        t('common:march'),
                        t('common:april'),
                        t('common:may'),
                        t('common:june'),
                        t('common:july'),
                        t('common:august'),
                        t('common:september'),
                        t('common:october'),
                        t('common:november'),
                        t('common:december'), 
                    ]
                })
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "mb-6 flex w-full flex-wrap space-y-6 rtl:space-x-reverse xl:flex-nowrap xl:space-y-0 xl:space-x-5",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "w-full xl:w-1/2",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_order_recent_orders__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                            orders: orderData,
                            title: t('table:recent-order-table-title')
                        })
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "w-full xl:w-1/2",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_withdraw_withdraw_table__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z, {
                            withdraws: withdraws,
                            title: t('table:withdraw-table-title')
                        })
                    })
                ]
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "mb-6 w-full xl:mb-0",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_product_popular_product_list__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
                    products: popularProductData,
                    title: t('table:popular-products-table-title')
                })
            })
        ]
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 93681:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "a": () => (/* binding */ ArrowUp)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const ArrowUp = ({ color ='currentColor' , width ='12px' , height ='12px' , ...props })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        width: width,
        height: height,
        viewBox: "0 0 11.996 12",
        ...props,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            "data-name": "Path 2462",
            d: "M18.276,12.1,12.7,6.524a.424.424,0,0,0-.6,0L6.524,12.1a.424.424,0,0,0,0,.6.424.424,0,0,0,.6,0l4.854-4.854V17.977a.423.423,0,1,0,.847,0V7.846L17.677,12.7a.424.424,0,0,0,.6,0A.434.434,0,0,0,18.276,12.1Z",
            transform: "translate(-6.4 -6.4)",
            fill: color
        })
    }));
};


/***/ }),

/***/ 41645:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "S": () => (/* binding */ CartIconBig)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const CartIconBig = ({ width ='48px' , height ='48px'  })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        width: width,
        height: height,
        viewBox: "0 0 48 48",
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("g", {
            "data-name": "Group 2994",
            transform: "translate(-601 -757)",
            children: [
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("rect", {
                    "data-name": "Rectangle 541",
                    width: "48",
                    height: "48",
                    rx: "20",
                    transform: "translate(601 757)",
                    fill: "#facaca"
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("g", {
                    transform: "translate(610.988 768.246)",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("g", {
                        "data-name": "Group 2985",
                        transform: "translate(3.013 0.754)",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                            "data-name": "Path 3641",
                            d: "M6.071,15.424H23.177a.726.726,0,0,0,.724-.674l.778-10.885a.726.726,0,0,0-.724-.778h-8.6V1.48a.726.726,0,1,0-1.452,0V3.087H5.832c-.051-.618-2.058-.416-.7-.077-.113-.517-.571-.277-.71,0L5.29,14.073a3.058,3.058,0,0,0,.78,6.016h.121a3.058,3.058,0,1,0,5.2,0h6.849a3.059,3.059,0,1,0,5.175-.042.726.726,0,0,0-.241-1.41H6.071a1.607,1.607,0,0,1,0-3.213ZM13.9,4.539V9.058L12.8,7.964a.726.726,0,0,0-1.027,1.027l2.333,2.333a.726.726,0,0,0,1.027,0L17.47,8.991a.726.726,0,0,0-1.027-1.027L15.35,9.058V4.539h7.825L22.5,13.972H6.739L5.953,4.539Zm6.946,15.55A1.607,1.607,0,1,1,19.237,21.7,1.608,1.608,0,0,1,20.844,20.089Zm-12.051,0A1.607,1.607,0,1,1,7.186,21.7,1.608,1.608,0,0,1,8.792,20.089Z",
                            transform: "translate(-3.013 -0.754)",
                            fill: "#ff6e6e"
                        })
                    })
                })
            ]
        })
    }));
};


/***/ }),

/***/ 67315:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "c": () => (/* binding */ CoinIcon)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const CoinIcon = ({ width ='48px' , height ='48px'  })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        width: width,
        height: height,
        viewBox: "0 0 48 48",
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("g", {
            "data-name": "Group 2993",
            transform: "translate(-608 -807)",
            children: [
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                    "data-name": "Path 3646",
                    d: "M20,0h8A20,20,0,0,1,48,20v8A20,20,0,0,1,28,48H20A20,20,0,0,1,0,28V20A20,20,0,0,1,20,0Z",
                    transform: "translate(608 807)",
                    fill: "#ffe8b2"
                }),
                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("g", {
                    transform: "translate(620 819)",
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("g", {
                            "data-name": "Group 2982",
                            transform: "translate(0)",
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("g", {
                                "data-name": "Group 2981",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                    "data-name": "Path 3639",
                                    d: "M20.485,3.515A12,12,0,0,0,3.515,20.485,12,12,0,0,0,20.485,3.515ZM12,22.594A10.594,10.594,0,1,1,22.594,12,10.606,10.606,0,0,1,12,22.594Z",
                                    transform: "translate(0 0)",
                                    fill: "#ffb300"
                                })
                            })
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("g", {
                            "data-name": "Group 2984",
                            transform: "translate(8.284 4.519)",
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("g", {
                                "data-name": "Group 2983",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                    "data-name": "Path 3640",
                                    d: "M181.2,103.179H179.7a1.556,1.556,0,1,1,0-3.112h3.013a.7.7,0,1,0,0-1.406h-1.556V97.1a.7.7,0,0,0-1.406,0V98.66h-.05a2.962,2.962,0,1,0,0,5.925H181.2a1.556,1.556,0,0,1,0,3.113H178.19a.7.7,0,0,0,0,1.406h1.556v1.556a.7.7,0,0,0,1.406,0V109.1h.05a2.963,2.963,0,0,0,0-5.925Z",
                                    transform: "translate(-176.734 -96.401)",
                                    fill: "#ffb300"
                                })
                            })
                        })
                    ]
                })
            ]
        })
    }));
};


/***/ }),

/***/ 52529:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1635);
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(dayjs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_ui_table__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(40447);
/* harmony import */ var _utils_use_price__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(86797);
/* harmony import */ var dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(14195);
/* harmony import */ var dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(36619);
/* harmony import */ var dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(53291);
/* harmony import */ var dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _components_ui_badge_badge__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(83002);
/* harmony import */ var _components_order_status_color__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(19714);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_utils_use_price__WEBPACK_IMPORTED_MODULE_3__]);
_utils_use_price__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];










const RecentOrders = ({ orders , title  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_7__.useTranslation)();
    const rowExpandable = (record)=>{
        var ref;
        return (ref = record.children) === null || ref === void 0 ? void 0 : ref.length;
    };
    const columns = [
        {
            title: t('table:table-item-tracking-number'),
            dataIndex: 'tracking_number',
            key: 'tracking_number',
            align: 'center',
            width: 150
        },
        {
            title: t('table:table-item-total'),
            dataIndex: 'total',
            key: 'total',
            align: 'center',
            render: function Render(value) {
                const { price  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP)({
                    amount: value
                });
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "whitespace-nowrap",
                    children: price
                }));
            }
        },
        {
            title: t('table:table-item-order-date'),
            dataIndex: 'created_at',
            key: 'created_at',
            align: 'center',
            render: (date)=>{
                dayjs__WEBPACK_IMPORTED_MODULE_1___default().extend((dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_4___default()));
                dayjs__WEBPACK_IMPORTED_MODULE_1___default().extend((dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_5___default()));
                dayjs__WEBPACK_IMPORTED_MODULE_1___default().extend((dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_6___default()));
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "whitespace-nowrap",
                    children: dayjs__WEBPACK_IMPORTED_MODULE_1___default().utc(date).tz(dayjs__WEBPACK_IMPORTED_MODULE_1___default().tz.guess()).fromNow()
                }));
            }
        },
        {
            title: t('table:table-item-status'),
            dataIndex: 'order_status',
            key: 'order_status',
            align: 'center',
            render: (order_status)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_badge_badge__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                    text: t(order_status),
                    color: (0,_components_order_status_color__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z)(order_status)
                })
        }, 
    ];
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
            className: "overflow-hidden rounded shadow",
            children: [
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h3", {
                    className: "border-b border-border-200 bg-light px-4 py-3 text-center font-semibold text-heading",
                    children: title
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_table__WEBPACK_IMPORTED_MODULE_2__/* .Table */ .i, {
                    //@ts-ignore
                    columns: columns,
                    emptyText: t('table:empty-table-data'),
                    data: orders,
                    rowKey: "id",
                    scroll: {
                        x: 200
                    },
                    expandable: {
                        expandedRowRender: ()=>''
                        ,
                        rowExpandable: rowExpandable
                    }
                })
            ]
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RecentOrders);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 19714:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const StatusColor = (status)=>{
    let bg_class = '';
    if ((status === null || status === void 0 ? void 0 : status.toLowerCase()) === 'order-pending' || (status === null || status === void 0 ? void 0 : status.toLowerCase()) === 'payment-pending') {
        bg_class = 'bg-[#EAB308]';
    } else if ((status === null || status === void 0 ? void 0 : status.toLowerCase()) === 'order-processing' || (status === null || status === void 0 ? void 0 : status.toLowerCase()) === 'payment-processing') {
        bg_class = 'bg-[#F59E0B]';
    } else if ((status === null || status === void 0 ? void 0 : status.toLowerCase()) === 'order-completed' || (status === null || status === void 0 ? void 0 : status.toLowerCase()) === 'payment-success') {
        bg_class = 'bg-accent';
    } else if ((status === null || status === void 0 ? void 0 : status.toLowerCase()) === 'order-cancelled' || (status === null || status === void 0 ? void 0 : status.toLowerCase()) === 'payment-reversal') {
        bg_class = 'bg-[#9CA3AF]';
    } else if ((status === null || status === void 0 ? void 0 : status.toLowerCase()) === 'order-failed' || (status === null || status === void 0 ? void 0 : status.toLowerCase()) === 'payment-failed') {
        bg_class = 'bg-[#EF4444]';
    } else if ((status === null || status === void 0 ? void 0 : status.toLowerCase()) === 'order-at-local-facility') {
        bg_class = 'bg-[#10B981]';
    } else if ((status === null || status === void 0 ? void 0 : status.toLowerCase()) === 'order-out-for-delivery') {
        bg_class = 'bg-[#D9D9D9]';
    } else {
        bg_class = 'bg-accent';
    }
    return bg_class;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StatusColor);


/***/ }),

/***/ 98837:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_table__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40447);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53139);
/* harmony import */ var _utils_use_price__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(86797);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _utils_locals__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(10601);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_utils_use_price__WEBPACK_IMPORTED_MODULE_3__]);
_utils_use_price__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







const PopularProductList = ({ products , title  })=>{
    var ref;
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_4__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    const { alignLeft , alignRight  } = (0,_utils_locals__WEBPACK_IMPORTED_MODULE_6__/* .useIsRTL */ .S)();
    let columns = [
        {
            title: t('table:table-item-id'),
            dataIndex: 'id',
            key: 'id',
            align: 'center',
            width: 64
        },
        {
            title: t('table:table-item-title'),
            dataIndex: 'name',
            key: 'name',
            align: alignLeft,
            width: 200,
            render: (name)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "whitespace-nowrap",
                    children: name
                })
        },
        {
            title: t('table:table-item-group'),
            dataIndex: 'type',
            key: 'type',
            align: 'center',
            width: 120,
            render: (type)=>{
                /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "whitespace-nowrap",
                    children: type === null || type === void 0 ? void 0 : type.name
                });
            }
        },
        {
            title: t('table:table-item-shop'),
            dataIndex: 'shop',
            key: 'shop',
            width: 120,
            align: 'center',
            ellipsis: true,
            render: (shop)=>{
                /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "truncate whitespace-nowrap",
                    children: shop === null || shop === void 0 ? void 0 : shop.name
                });
            }
        },
        {
            title: t('table:table-item-unit'),
            dataIndex: 'price',
            key: 'price',
            align: alignRight,
            width: 160,
            render: function Render(value, record) {
                const { price: max_price  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP)({
                    amount: record === null || record === void 0 ? void 0 : record.max_price
                });
                const { price: min_price  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP)({
                    amount: record === null || record === void 0 ? void 0 : record.min_price
                });
                const { price  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP)({
                    amount: value
                });
                const renderPrice = (record === null || record === void 0 ? void 0 : record.product_type) === _types__WEBPACK_IMPORTED_MODULE_2__/* .ProductType.Variable */ .kv.Variable ? `${min_price} - ${max_price}` : price;
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "whitespace-nowrap",
                    title: renderPrice,
                    children: renderPrice
                }));
            }
        },
        {
            title: t('table:table-item-quantity'),
            dataIndex: 'quantity',
            key: 'quantity',
            align: 'center',
            width: 80
        }, 
    ];
    if (router === null || router === void 0 ? void 0 : (ref = router.query) === null || ref === void 0 ? void 0 : ref.shop) {
        columns = columns === null || columns === void 0 ? void 0 : columns.filter((column)=>{
            return (column === null || column === void 0 ? void 0 : column.key) !== 'shop';
        });
    }
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "mb-6 overflow-hidden rounded shadow",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h3", {
                className: "border-b border-border-200 bg-light px-4 py-3 text-center font-semibold text-heading",
                children: title
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_table__WEBPACK_IMPORTED_MODULE_1__/* .Table */ .i, {
                //@ts-ignore
                columns: columns,
                emptyText: t('table:empty-table-data'),
                //@ts-ignore
                data: products,
                rowKey: "id",
                scroll: {
                    x: 700
                }
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PopularProductList);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 83002:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);



const Badge = (props)=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    const { className , color: colorOverride , textColor: textColorOverride , text , textKey , animate =false ,  } = props;
    const classes = {
        root: 'px-3 py-1 rounded-full text-xs whitespace-nowrap relative',
        animate: 'animate-pulse',
        default: 'bg-accent',
        text: 'text-light'
    };
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
            className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(classes.root, {
                [classes.default]: !colorOverride,
                [classes.text]: !textColorOverride,
                [classes.animate]: animate
            }, colorOverride, textColorOverride, className),
            children: textKey ? t(textKey) : text
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Badge);


/***/ }),

/***/ 63154:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ column_chart)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
// EXTERNAL MODULE: ../node_modules/next/dynamic.js
var dynamic = __webpack_require__(65218);
;// CONCATENATED MODULE: ./src/components/ui/chart.tsx


const Charts = (0,dynamic["default"])(null, {
    loadableGenerated: {
        modules: [
            "../components/ui/chart.tsx -> " + "react-apexcharts"
        ]
    },
    ssr: false
});
const Chart = ({ ...props })=>{
    return(/*#__PURE__*/ jsx_runtime_.jsx(Charts, {
        ...props
    }));
};
/* harmony default export */ const chart = (Chart);

// EXTERNAL MODULE: external "classnames"
var external_classnames_ = __webpack_require__(59003);
var external_classnames_default = /*#__PURE__*/__webpack_require__.n(external_classnames_);
// EXTERNAL MODULE: ./src/components/icons/arrow-up.tsx
var arrow_up = __webpack_require__(93681);
// EXTERNAL MODULE: ./src/components/icons/arrow-down.tsx
var arrow_down = __webpack_require__(99172);
;// CONCATENATED MODULE: ./src/components/widgets/column-chart.tsx





const BarChart = ({ widgetTitle , series , colors , prefix , totalValue , text , position , percentage , categories  })=>{
    const options = {
        options: {
            chart: {
                toolbar: {
                    show: false
                }
            },
            plotOptions: {
                bar: {
                    columnWidth: '65%',
                    endingShape: 'flat'
                }
            },
            dataLabels: {
                enabled: false
            },
            stroke: {
                show: false,
                width: 2
            },
            grid: {
                borderColor: '#F7F7F7',
                xaxis: {
                    lines: {
                        show: false
                    }
                }
            },
            colors: colors,
            xaxis: {
                labels: {
                    show: true,
                    style: {
                        colors: '#161F6A',
                        fontSize: '14px',
                        fontFamily: "'Lato', sans-serif"
                    }
                },
                axisBorder: {
                    show: false
                },
                axisTicks: {
                    show: false
                },
                categories: categories
            },
            yaxis: {
                show: true,
                labels: {
                    show: true,
                    style: {
                        color: '#161F6A',
                        fontSize: '14px',
                        fontFamily: "'Lato', sans-serif"
                    }
                }
            }
        },
        series: [
            {
                name: 'Sale',
                data: series
            }, 
        ]
    };
    return(/*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
        className: "h-full w-full rounded bg-light shadow-sm",
        children: [
            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                className: "flex items-center justify-between p-8",
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("h3", {
                        className: "text-sm text-heading",
                        children: widgetTitle
                    }),
                    /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                        className: "flex flex-col",
                        children: [
                            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("span", {
                                className: "text-lg font-semibold text-green-500",
                                children: [
                                    prefix,
                                    totalValue
                                ]
                            }),
                            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                className: "flex items-center",
                                children: [
                                    position === 'up' && /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                        className: "text-green-500",
                                        children: /*#__PURE__*/ jsx_runtime_.jsx(arrow_up/* ArrowUp */.a, {})
                                    }),
                                    position === 'down' && /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                        className: "text-red-400",
                                        children: /*#__PURE__*/ jsx_runtime_.jsx(arrow_down/* ArrowDown */.K, {})
                                    }),
                                    /*#__PURE__*/ (0,jsx_runtime_.jsxs)("span", {
                                        className: "ms-1 text-sm text-heading",
                                        children: [
                                            /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                                className: external_classnames_default()(position === 'down' ? 'text-red-400' : 'text-green-500'),
                                                children: percentage
                                            }),
                                            "\xa0",
                                            text
                                        ]
                                    })
                                ]
                            })
                        ]
                    })
                ]
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                className: "flex w-full flex-wrap",
                style: {
                    display: 'block'
                },
                children: /*#__PURE__*/ jsx_runtime_.jsx(chart, {
                    options: options.options,
                    series: options.series,
                    height: "350",
                    width: "100%",
                    type: "bar"
                })
            })
        ]
    }));
};
/* harmony default export */ const column_chart = (BarChart);


/***/ }),

/***/ 8720:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ sticker_card)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(16689);
;// CONCATENATED MODULE: ./src/components/icons/ios-arrow-down.tsx


const IosArrowDown = ({ color ='currentColor' , width ='7px' , height ='10px' , ...props })=>{
    return(/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        width: width,
        height: height,
        viewBox: "0 0 7 10",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            d: "M166.5,118.477a.454.454,0,0,0-.639,0l-2.115,2.108v-8.034a.452.452,0,0,0-.9,0v8.034l-2.115-2.112a.457.457,0,0,0-.639,0,.45.45,0,0,0,0,.636l2.883,2.862a.507.507,0,0,0,.142.094.431.431,0,0,0,.174.035.453.453,0,0,0,.316-.129l2.883-2.862A.442.442,0,0,0,166.5,118.477Z",
            transform: "translate(-159.962 -112.1)",
            fill: color
        })
    }));
};

;// CONCATENATED MODULE: ./src/components/icons/ios-arrow-up.tsx


const IosArrowUp = ({ color ='currentColor' , width ='7px' , height ='10px' , ...props })=>{
    return(/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        width: width,
        height: height,
        viewBox: "0 0 7 10",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            d: "M166.5,115.723a.454.454,0,0,1-.639,0l-2.115-2.108v8.034a.452.452,0,0,1-.9,0v-8.034l-2.115,2.112a.457.457,0,0,1-.639,0,.45.45,0,0,1,0-.636l2.883-2.862a.507.507,0,0,1,.142-.094.431.431,0,0,1,.174-.035.453.453,0,0,1,.316.129l2.883,2.862A.442.442,0,0,1,166.5,115.723Z",
            transform: "translate(-159.962 -112.1)",
            fill: color
        })
    }));
};

// EXTERNAL MODULE: external "next-i18next"
var external_next_i18next_ = __webpack_require__(11377);
;// CONCATENATED MODULE: ./src/components/widgets/sticker-card.tsx





const StickerCard = ({ titleTransKey , subtitleTransKey , icon , iconBgStyle , price , indicator , indicatorText , note , link , linkText  })=>{
    const { t  } = (0,external_next_i18next_.useTranslation)('widgets');
    return(/*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
        className: "flex h-full w-full flex-col rounded bg-light p-7",
        children: [
            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                className: "mb-auto flex w-full justify-between pb-8",
                children: [
                    /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                        className: "flex w-full flex-col",
                        children: [
                            /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                className: "mb-1 text-base font-semibold text-heading",
                                children: t(titleTransKey)
                            }),
                            /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                className: "text-xs font-semibold text-body",
                                children: t(subtitleTransKey)
                            })
                        ]
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        className: "ms-3 flex h-12 w-12 flex-shrink-0 items-center justify-center rounded-full bg-gray-200",
                        style: iconBgStyle,
                        children: icon
                    })
                ]
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("span", {
                className: "mb-2 text-xl font-semibold text-heading",
                children: price
            }),
            indicator === 'up' && /*#__PURE__*/ (0,jsx_runtime_.jsxs)("span", {
                className: "mb-12 inline-block text-sm font-semibold text-body",
                style: {
                    color: '#03D3B5'
                },
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx(IosArrowUp, {
                        width: "9px",
                        height: "11px",
                        className: "inline-block"
                    }),
                    ' ',
                    indicatorText,
                    /*#__PURE__*/ (0,jsx_runtime_.jsxs)("span", {
                        className: "text-sm font-normal text-body",
                        children: [
                            " ",
                            note
                        ]
                    })
                ]
            }),
            indicator === 'down' && /*#__PURE__*/ (0,jsx_runtime_.jsxs)("span", {
                className: "mb-12 inline-block text-sm font-semibold text-body",
                style: {
                    color: '#FC6687'
                },
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx(IosArrowDown, {
                        width: "9px",
                        height: "11px",
                        className: "inline-block"
                    }),
                    ' ',
                    indicatorText,
                    /*#__PURE__*/ (0,jsx_runtime_.jsxs)("span", {
                        className: "text-sm font-normal text-body",
                        children: [
                            " ",
                            note
                        ]
                    })
                ]
            }),
            link && /*#__PURE__*/ jsx_runtime_.jsx("a", {
                className: "text-xs font-semibold text-purple-700 no-underline",
                href: link,
                target: "_blank",
                rel: "noreferrer",
                children: linkText
            })
        ]
    }));
};
/* harmony default export */ const sticker_card = (StickerCard);


/***/ }),

/***/ 61168:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_table__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40447);
/* harmony import */ var _components_common_action_buttons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53758);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_locals__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(10601);
/* harmony import */ var _utils_use_price__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(86797);
/* harmony import */ var _utils_auth_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(49239);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(28379);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _components_ui_badge_badge__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(83002);
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(1635);
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(dayjs__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(14195);
/* harmony import */ var dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(36619);
/* harmony import */ var dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(53291);
/* harmony import */ var dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_13__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_utils_use_price__WEBPACK_IMPORTED_MODULE_5__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_6__]);
([_utils_use_price__WEBPACK_IMPORTED_MODULE_5__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_6__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);














const WithdrawTable = ({ withdraws , title  })=>{
    var ref;
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const { alignLeft  } = (0,_utils_locals__WEBPACK_IMPORTED_MODULE_4__/* .useIsRTL */ .S)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_8__.useRouter)();
    const renderStatusBadge = (status)=>{
        switch(status.toUpperCase()){
            case 'APPROVED':
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_badge_badge__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
                    text: t('text-approved'),
                    color: "bg-accent"
                }));
            case 'PENDING':
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_badge_badge__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
                    text: t('text-pending'),
                    color: "bg-purple-500"
                }));
            case 'ON_HOLD':
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_badge_badge__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
                    text: t('text-on-hold'),
                    color: "bg-pink-500"
                }));
            case 'REJECTED':
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_badge_badge__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
                    text: t('text-rejected'),
                    color: "bg-red-500"
                }));
            case 'PROCESSING':
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_badge_badge__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
                    text: t('text-processing'),
                    color: "bg-yellow-500"
                }));
        }
    };
    let columns = [
        {
            title: t('table:table-item-shop-name'),
            dataIndex: 'shop',
            key: 'shop',
            align: alignLeft,
            render: (shop)=>shop.name
        },
        {
            title: t('table:table-item-amount'),
            dataIndex: 'amount',
            key: 'amount',
            align: 'right',
            render: function Render(amount) {
                const { price  } = (0,_utils_use_price__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .ZP)({
                    amount: amount
                });
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                    children: price
                }));
            }
        },
        {
            title: t('table:table-item-status'),
            dataIndex: 'status',
            key: 'status',
            align: 'center',
            render: (status)=>renderStatusBadge(status)
        },
        {
            title: t('table:table-item-created-at'),
            dataIndex: 'created_at',
            key: 'created_at',
            align: 'center',
            render: (date)=>{
                dayjs__WEBPACK_IMPORTED_MODULE_10___default().extend((dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_11___default()));
                dayjs__WEBPACK_IMPORTED_MODULE_10___default().extend((dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_12___default()));
                dayjs__WEBPACK_IMPORTED_MODULE_10___default().extend((dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_13___default()));
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "whitespace-nowrap",
                    children: dayjs__WEBPACK_IMPORTED_MODULE_10___default().utc(date).tz(dayjs__WEBPACK_IMPORTED_MODULE_10___default().tz.guess()).fromNow()
                }));
            }
        },
        {
            title: t('table:table-item-actions'),
            dataIndex: 'id',
            key: 'actions',
            align: 'center',
            render: (id)=>{
                const { permissions  } = (0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_6__/* .getAuthCredentials */ .WA)();
                if ((0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_6__/* .hasAccess */ .Ft)(_utils_auth_utils__WEBPACK_IMPORTED_MODULE_6__/* .adminOnly */ .M$, permissions)) {
                    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_action_buttons__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                        detailsUrl: `${_config_routes__WEBPACK_IMPORTED_MODULE_7__/* .Routes.withdraw.list */ .Z.withdraw.list}/${id}`,
                        id: id
                    }));
                }
                return null;
            }
        }, 
    ];
    if (router === null || router === void 0 ? void 0 : (ref = router.query) === null || ref === void 0 ? void 0 : ref.shop) {
        columns = columns === null || columns === void 0 ? void 0 : columns.filter((column)=>{
            return (column === null || column === void 0 ? void 0 : column.key) !== 'actions';
        });
    }
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "overflow-hidden rounded shadow",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h3", {
                className: "border-b border-border-200 bg-light px-4 py-3 text-center font-semibold text-heading",
                children: title
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_table__WEBPACK_IMPORTED_MODULE_1__/* .Table */ .i, {
                //@ts-ignore
                columns: columns,
                emptyText: t('table:empty-table-data'),
                data: withdraws,
                rowKey: "id",
                scroll: {
                    x: 700
                }
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (WithdrawTable);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9927:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "L": () => (/* binding */ dashboardClient)
/* harmony export */ });
/* harmony import */ var _data_client_http_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67904);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_http_client__WEBPACK_IMPORTED_MODULE_0__]);
_data_client_http_client__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const dashboardClient = {
    analytics () {
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.ANALYTICS */ .P.ANALYTICS);
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 49443:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "K": () => (/* binding */ useAnalyticsQuery),
/* harmony export */   "T": () => (/* binding */ usePopularProductsQuery)
/* harmony export */ });
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
/* harmony import */ var _data_client_dashboard__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9927);
/* harmony import */ var _data_client_product__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(21351);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_dashboard__WEBPACK_IMPORTED_MODULE_2__, _data_client_product__WEBPACK_IMPORTED_MODULE_3__]);
([_data_client_dashboard__WEBPACK_IMPORTED_MODULE_2__, _data_client_product__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




function useAnalyticsQuery() {
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.ANALYTICS */ .P.ANALYTICS
    ], _data_client_dashboard__WEBPACK_IMPORTED_MODULE_2__/* .dashboardClient.analytics */ .L.analytics);
}
function usePopularProductsQuery(options) {
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.POPULAR_PRODUCTS */ .P.POPULAR_PRODUCTS,
        options
    ], ({ queryKey , pageParam  })=>_data_client_product__WEBPACK_IMPORTED_MODULE_3__/* .productClient.popular */ .M.popular(Object.assign({}, pageParam, queryKey[1]))
    );
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;