exports.id = 8602;
exports.ids = [8602,9525,678,4896,8788,7725,1384,1351,5502,4342];
exports.modules = {

/***/ 54137:
/***/ ((module) => {

// Exports
module.exports = {
	"radio_input": "radio_radio_input__nO8HJ"
};


/***/ }),

/***/ 20286:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Uploader)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_icons_upload_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19525);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_dropzone__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56358);
/* harmony import */ var react_dropzone__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_dropzone__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_icons_close_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29581);
/* harmony import */ var _components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(47898);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _data_upload__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(34421);
/* harmony import */ var next_image__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(38579);
/* harmony import */ var _utils_placeholders__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(34896);
/* harmony import */ var _utils_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(30957);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_upload__WEBPACK_IMPORTED_MODULE_7__]);
_data_upload__WEBPACK_IMPORTED_MODULE_7__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];











const getPreviewImage = (value)=>{
    let images = [];
    if (value) {
        images = Array.isArray(value) ? value : [
            {
                ...value
            }
        ];
    }
    return images;
};
function Uploader({ onChange , value , multiple , acceptFile , helperText  }) {
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_6__.useTranslation)();
    const { 0: files , 1: setFiles  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(getPreviewImage(value));
    const { mutate: upload , isLoading: loading  } = (0,_data_upload__WEBPACK_IMPORTED_MODULE_7__/* .useUploadMutation */ .g)();
    const { 0: error1 , 1: setError  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(null);
    const { getRootProps , getInputProps  } = (0,react_dropzone__WEBPACK_IMPORTED_MODULE_3__.useDropzone)({
        ...!acceptFile ? {
            accept: 'image/*'
        } : {
            accept: _utils_constants__WEBPACK_IMPORTED_MODULE_10__/* .ACCEPTED_FILE_TYPES */ ._0
        },
        multiple,
        onDrop: async (acceptedFiles)=>{
            if (acceptedFiles.length) {
                upload(acceptedFiles, {
                    onSuccess: (data)=>{
                        // Process Digital File Name section
                        data && (data === null || data === void 0 ? void 0 : data.map((file, idx)=>{
                            var ref, ref1;
                            const splitArray = file === null || file === void 0 ? void 0 : (ref = file.original) === null || ref === void 0 ? void 0 : ref.split('/');
                            let fileSplitName = (ref1 = splitArray[(splitArray === null || splitArray === void 0 ? void 0 : splitArray.length) - 1]) === null || ref1 === void 0 ? void 0 : ref1.split('.');
                            const fileType = fileSplitName === null || fileSplitName === void 0 ? void 0 : fileSplitName.pop(); // it will pop the last item from the fileSplitName arr which is the file ext
                            const filename = fileSplitName === null || fileSplitName === void 0 ? void 0 : fileSplitName.join('.'); // it will join the array with dot, which restore the original filename
                            data[idx]['file_name'] = filename + '.' + fileType;
                        }));
                        let mergedData;
                        if (multiple) {
                            mergedData = files.concat(data);
                            setFiles(files.concat(data));
                        } else {
                            mergedData = data[0];
                            setFiles(data);
                        }
                        if (onChange) {
                            onChange(mergedData);
                        }
                    }
                });
            }
        },
        onDropRejected: (fileRejections)=>{
            fileRejections.forEach((file)=>{
                var ref;
                file === null || file === void 0 ? void 0 : (ref = file.errors) === null || ref === void 0 ? void 0 : ref.forEach((error)=>{
                    if ((error === null || error === void 0 ? void 0 : error.code) === 'file-too-large') {
                        setError(t('error-file-too-large'));
                    } else if ((error === null || error === void 0 ? void 0 : error.code) === 'file-invalid-type') {
                        setError(t('error-invalid-file-type'));
                    }
                });
            });
        }
    });
    const handleDelete = (image)=>{
        const images = files.filter((file)=>file.thumbnail !== image
        );
        setFiles(images);
        if (onChange) {
            onChange(images);
        }
    };
    const thumbs = files === null || files === void 0 ? void 0 : files.map((file, idx)=>{
        const imgTypes = [
            'tif',
            'tiff',
            'bmp',
            'jpg',
            'jpeg',
            'gif',
            'png',
            'eps',
            'raw', 
        ];
        // let filename, fileType, isImage;
        if (file && file.id) {
            var ref;
            console.log('File is', file);
            // const processedFile = processFileWithName(file);
            const splitArray = file === null || file === void 0 ? void 0 : (ref = file.file_name) === null || ref === void 0 ? void 0 : ref.split('.');
            const fileType = splitArray === null || splitArray === void 0 ? void 0 : splitArray.pop(); // it will pop the last item from the fileSplitName arr which is the file ext
            const filename = splitArray === null || splitArray === void 0 ? void 0 : splitArray.join('.'); // it will join the array with dot, which restore the original filename
            const isImage = (file === null || file === void 0 ? void 0 : file.thumbnail) && imgTypes.includes(fileType); // check if the original filename has the img ext
            // Old Code *******
            // const splitArray = file?.original?.split('/');
            // let fileSplitName = splitArray[splitArray?.length - 1]?.split('.'); // it will create an array of words of filename
            // const fileType = fileSplitName.pop(); // it will pop the last item from the fileSplitName arr which is the file ext
            // const filename = fileSplitName.join('.'); // it will join the array with dot, which restore the original filename
            // const isImage = file?.thumbnail && imgTypes.includes(fileType); // check if the original filename has the img ext
            return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: `relative mt-2 inline-flex flex-col overflow-hidden rounded me-2 ${isImage ? 'border border-border-200' : ''}`,
                children: [
                    isImage ? // <div className="flex h-16 w-16 min-w-0 items-center justify-center overflow-hidden">
                    //   <Image
                    //     src={file.thumbnail}
                    //     width={56}
                    //     height={56}
                    //     alt="uploaded image"
                    //   />
                    // </div>
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("figure", {
                        className: "relative h-16 w-28",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(next_image__WEBPACK_IMPORTED_MODULE_8__["default"], {
                            src: file.thumbnail,
                            alt: filename,
                            layout: "fill",
                            objectFit: "contain"
                        })
                    }) : /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                        className: "flex flex-col items-center",
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                className: "flex h-14 w-14 min-w-0 items-center justify-center overflow-hidden",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(next_image__WEBPACK_IMPORTED_MODULE_8__["default"], {
                                    src: _utils_placeholders__WEBPACK_IMPORTED_MODULE_9__/* .zipPlaceholder */ .GZ,
                                    width: 56,
                                    height: 56,
                                    alt: "upload placeholder"
                                })
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("p", {
                                className: "flex cursor-default items-baseline p-1 text-xs text-body",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                        className: "inline-block max-w-[64px] overflow-hidden overflow-ellipsis whitespace-nowrap",
                                        title: `${filename}.${fileType}`,
                                        children: filename
                                    }),
                                    ".",
                                    fileType
                                ]
                            })
                        ]
                    }),
                    multiple ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                        className: "absolute top-1 flex h-4 w-4 items-center justify-center rounded-full bg-red-600 text-xs text-light shadow-xl outline-none end-1",
                        onClick: ()=>handleDelete(file.thumbnail)
                        ,
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_close_icon__WEBPACK_IMPORTED_MODULE_4__/* .CloseIcon */ .T, {
                            width: 10,
                            height: 10
                        })
                    }) : null
                ]
            }, idx));
        }
    });
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(()=>()=>{
            // Reset error after upload new file
            setError(null);
            // Make sure to revoke the data uris to avoid memory leaks
            files.forEach((file)=>URL.revokeObjectURL(file.thumbnail)
            );
        }
    , [
        files
    ]);
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("section", {
        className: "upload",
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                ...getRootProps({
                    className: 'border-dashed border-2 border-border-base h-36 rounded flex flex-col justify-center items-center cursor-pointer focus:border-accent-400 focus:outline-none'
                }),
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                        ...getInputProps()
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_upload_icon__WEBPACK_IMPORTED_MODULE_1__/* .UploadIcon */ .r, {
                        className: "text-muted-light"
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                        className: "mt-4 text-center text-sm text-body",
                        children: helperText ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                            className: "font-semibold text-gray-500",
                            children: helperText
                        }) : /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                    className: "font-semibold text-accent",
                                    children: t('text-upload-highlight')
                                }),
                                ' ',
                                t('text-upload-message'),
                                " ",
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("br", {}),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                    className: "text-xs text-body",
                                    children: t('text-img-format')
                                })
                            ]
                        })
                    }),
                    error1 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                        className: "mt-4 text-center text-sm text-body text-red-600",
                        children: error1
                    })
                ]
            }),
            (!!thumbs.length || loading) && /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("aside", {
                className: "mt-2 flex flex-wrap",
                children: [
                    !!thumbs.length && thumbs,
                    loading && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "mt-2 flex h-16 items-center ms-2",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                            simple: true,
                            className: "h-6 w-6"
                        })
                    })
                ]
            })
        ]
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 19525:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "r": () => (/* binding */ UploadIcon)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const UploadIcon = ({ color ='currentColor' , width ='41px' , height ='30px' , ...rest })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        width: width,
        height: height,
        viewBox: "0 0 40.909 30",
        ...rest,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("g", {
            transform: "translate(0 -73.091)",
            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                "data-name": "Path 2125",
                d: "M39.129,89.827A8.064,8.064,0,0,0,34.58,86.94,5.446,5.446,0,0,0,30,78.546a5.207,5.207,0,0,0-3.537,1.321,10.921,10.921,0,0,0-10.1-6.776,10.511,10.511,0,0,0-7.713,3.2A10.508,10.508,0,0,0,5.454,84q0,.277.043.916A9.528,9.528,0,0,0,0,93.546a9.193,9.193,0,0,0,2.8,6.743,9.191,9.191,0,0,0,6.744,2.8H32.728a8.172,8.172,0,0,0,6.4-13.264Zm-12.06-.575a.656.656,0,0,1-.479.2H21.818v7.5a.691.691,0,0,1-.681.681H17.045a.691.691,0,0,1-.682-.681v-7.5H11.59a.655.655,0,0,1-.681-.681.8.8,0,0,1,.213-.512L18.6,80.783a.722.722,0,0,1,.98,0l7.5,7.5a.663.663,0,0,1,.191.49A.656.656,0,0,1,27.07,89.252Z",
                transform: "translate(0)",
                fill: "currentColor"
            })
        })
    }));
};


/***/ }),

/***/ 92940:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "i1": () => (/* binding */ filterAttributes),
  "zo": () => (/* binding */ getCartesianProduct),
  "YF": () => (/* binding */ getProductDefaultValues),
  "p9": () => (/* binding */ getProductInputValues)
});

// UNUSED EXPORTS: calculateMinMaxPrice, calculateQuantity, getFormattedVariations, processFileWithName, processOptions, productTypeOptions

// EXTERNAL MODULE: ./src/types/index.ts
var types = __webpack_require__(53139);
// EXTERNAL MODULE: external "lodash/groupBy"
var groupBy_ = __webpack_require__(98492);
var groupBy_default = /*#__PURE__*/__webpack_require__.n(groupBy_);
// EXTERNAL MODULE: external "lodash/orderBy"
var orderBy_ = __webpack_require__(49949);
var orderBy_default = /*#__PURE__*/__webpack_require__.n(orderBy_);
// EXTERNAL MODULE: external "lodash/sum"
var sum_ = __webpack_require__(95594);
var sum_default = /*#__PURE__*/__webpack_require__.n(sum_);
// EXTERNAL MODULE: external "lodash/cloneDeep"
var cloneDeep_ = __webpack_require__(59591);
var cloneDeep_default = /*#__PURE__*/__webpack_require__.n(cloneDeep_);
// EXTERNAL MODULE: external "lodash/isEmpty"
var isEmpty_ = __webpack_require__(89699);
var isEmpty_default = /*#__PURE__*/__webpack_require__.n(isEmpty_);
// EXTERNAL MODULE: external "lodash/omit"
var omit_ = __webpack_require__(63901);
var omit_default = /*#__PURE__*/__webpack_require__.n(omit_);
;// CONCATENATED MODULE: ./src/utils/omit-typename.ts

function omitTypename(data) {
    if (data === null || data === void 0 ? void 0 : data.__typename) {
        return omit_default()(data, '__typename');
    }
    return data;
}

;// CONCATENATED MODULE: ./src/utils/cartesian.ts
/**
 * Cartesian result of multiple arrays
 * @param a array - check the sample input below
 * @returns array of arrays - check the sample out put below
 */ const cartesian = (...a1)=>a1.reduce((a, b)=>a.flatMap((d)=>b.map((e)=>[
                    d,
                    e
                ].flat()
            )
        )
    )
; // Cartesian Example
 // ==========================================
 // INPUT:
 // Sample for calling the function:
 // cartesian([1,2],[10,20],[100,200,300]) [LG,S],[RED, BLACK],[1KG,5KG]
 // ==========================================
 // OUTPUT:
 // [ [ 1, 10, 100 ],
 //   [ 1, 10, 200 ],
 //   [ 1, 10, 300 ],
 //   [ 1, 20, 100 ],
 //   [ 1, 20, 200 ],
 //   [ 1, 20, 300 ],
 //   [ 2, 10, 100 ],
 //   [ 2, 10, 200 ],
 //   [ 2, 10, 300 ],
 //   [ 2, 20, 100 ],
 //   [ 2, 20, 200 ],
 //   [ 2, 20, 300 ] ]

;// CONCATENATED MODULE: ./src/components/product/form-utils.ts









const productTypeOptions = Object.entries(types/* ProductType */.kv).map(([key, value])=>({
        name: key,
        value
    })
);
function getFormattedVariations(variations) {
    var ref1;
    const variationGroup = groupBy_default()(variations, 'attribute.slug');
    return (ref1 = Object.values(variationGroup)) === null || ref1 === void 0 ? void 0 : ref1.map((vg)=>{
        var ref;
        return {
            attribute: vg === null || vg === void 0 ? void 0 : (ref = vg[0]) === null || ref === void 0 ? void 0 : ref.attribute,
            value: vg === null || vg === void 0 ? void 0 : vg.map((v)=>({
                    id: v.id,
                    value: v.value
                })
            )
        };
    });
}
function processOptions(options) {
    try {
        return JSON.parse(options);
    } catch (error) {
        return options;
    }
}
function calculateMinMaxPrice(variationOptions) {
    var ref, ref2, ref3;
    if (!variationOptions || !variationOptions.length) {
        return {
            min_price: null,
            max_price: null
        };
    }
    const sortedVariationsByPrice = orderBy_default()(variationOptions, [
        'price'
    ]);
    const sortedVariationsBySalePrice = orderBy_default()(variationOptions, [
        'sale_price'
    ]);
    return {
        min_price: (sortedVariationsBySalePrice === null || sortedVariationsBySalePrice === void 0 ? void 0 : sortedVariationsBySalePrice[0].sale_price) < (sortedVariationsByPrice === null || sortedVariationsByPrice === void 0 ? void 0 : (ref = sortedVariationsByPrice[0]) === null || ref === void 0 ? void 0 : ref.price) ? sortedVariationsBySalePrice === null || sortedVariationsBySalePrice === void 0 ? void 0 : sortedVariationsBySalePrice[0].sale_price : sortedVariationsByPrice === null || sortedVariationsByPrice === void 0 ? void 0 : (ref2 = sortedVariationsByPrice[0]) === null || ref2 === void 0 ? void 0 : ref2.price,
        max_price: sortedVariationsByPrice === null || sortedVariationsByPrice === void 0 ? void 0 : (ref3 = sortedVariationsByPrice[(sortedVariationsByPrice === null || sortedVariationsByPrice === void 0 ? void 0 : sortedVariationsByPrice.length) - 1]) === null || ref3 === void 0 ? void 0 : ref3.price
    };
}
function calculateQuantity(variationOptions) {
    return sum_default()(variationOptions === null || variationOptions === void 0 ? void 0 : variationOptions.map(({ quantity  })=>quantity
    ));
}
function getProductDefaultValues(product, isNewTranslation = false) {
    if (!product) {
        return {
            product_type: productTypeOptions[0],
            min_price: 0,
            max_price: 0,
            categories: [],
            tags: [],
            in_stock: true,
            is_taxable: false,
            image: [],
            gallery: [],
            status: types/* ProductStatus.Publish */.Pt.Publish,
            // isVariation: false,
            variations: [],
            variation_options: []
        };
    }
    const { variations , variation_options , product_type , is_digital , digital_file ,  } = product;
    return cloneDeep_default()({
        ...product,
        product_type: productTypeOptions.find((option)=>product_type === option.value
        ),
        ...product_type === types/* ProductType.Simple */.kv.Simple && {
            ...is_digital && {
                digital_file_input: {
                    id: digital_file === null || digital_file === void 0 ? void 0 : digital_file.attachment_id,
                    thumbnail: digital_file === null || digital_file === void 0 ? void 0 : digital_file.url,
                    original: digital_file === null || digital_file === void 0 ? void 0 : digital_file.url,
                    file_name: digital_file === null || digital_file === void 0 ? void 0 : digital_file.file_name
                }
            }
        },
        ...product_type === types/* ProductType.Variable */.kv.Variable && {
            variations: getFormattedVariations(variations),
            variation_options: variation_options === null || variation_options === void 0 ? void 0 : variation_options.map(({ image , ...option })=>{
                var ref, ref4, ref5;
                return {
                    ...option,
                    ...!isEmpty_default()(image) && {
                        image: omitTypename(image)
                    },
                    ...(option === null || option === void 0 ? void 0 : option.digital_file) && {
                        digital_file_input: {
                            id: option === null || option === void 0 ? void 0 : (ref = option.digital_file) === null || ref === void 0 ? void 0 : ref.attachment_id,
                            thumbnail: option === null || option === void 0 ? void 0 : (ref4 = option.digital_file) === null || ref4 === void 0 ? void 0 : ref4.url,
                            original: option === null || option === void 0 ? void 0 : (ref5 = option.digital_file) === null || ref5 === void 0 ? void 0 : ref5.url
                        }
                    }
                };
            })
        },
        // isVariation: variations?.length && variation_options?.length ? true : false,
        // Remove initial dependent value for new translation
        ...isNewTranslation && {
            type: null,
            categories: [],
            author_id: null,
            manufacturer_id: null,
            tags: [],
            author: [],
            manufacturer: [],
            variations: [],
            variation_options: [],
            digital_file: '',
            digital_file_input: {},
            ...product_type === types/* ProductType.Variable */.kv.Variable && {
                quantity: null
            }
        }
    });
}
function filterAttributes(attributes, variations) {
    let res = [];
    res = attributes === null || attributes === void 0 ? void 0 : attributes.filter((el)=>{
        return !(variations === null || variations === void 0 ? void 0 : variations.find((element)=>{
            var ref;
            return (element === null || element === void 0 ? void 0 : (ref = element.attribute) === null || ref === void 0 ? void 0 : ref.slug) === (el === null || el === void 0 ? void 0 : el.slug);
        }));
    });
    return res;
}
function getCartesianProduct(values) {
    const formattedValues = values === null || values === void 0 ? void 0 : values.map((v)=>{
        var ref6;
        return v === null || v === void 0 ? void 0 : (ref6 = v.value) === null || ref6 === void 0 ? void 0 : ref6.map((a)=>{
            var ref;
            return {
                name: v === null || v === void 0 ? void 0 : (ref = v.attribute) === null || ref === void 0 ? void 0 : ref.name,
                value: a === null || a === void 0 ? void 0 : a.value
            };
        });
    }).filter((i)=>i !== undefined
    );
    if (isEmpty_default()(formattedValues)) return [];
    return cartesian(...formattedValues);
}
function processFileWithName(file_input) {
    var ref, ref7;
    // Process Digital File Name section
    const splitArray = file_input === null || file_input === void 0 ? void 0 : (ref = file_input.original) === null || ref === void 0 ? void 0 : ref.split('/');
    let fileSplitName = splitArray === null || splitArray === void 0 ? void 0 : (ref7 = splitArray[(splitArray === null || splitArray === void 0 ? void 0 : splitArray.length) - 1]) === null || ref7 === void 0 ? void 0 : ref7.split('.');
    const fileType = fileSplitName === null || fileSplitName === void 0 ? void 0 : fileSplitName.pop(); // it will pop the last item from the fileSplitName arr which is the file ext
    const filename = fileSplitName === null || fileSplitName === void 0 ? void 0 : fileSplitName.join('.'); // it will join the array with dot, which restore the original filename
    return [
        {
            fileType: fileType,
            filename: filename
        }, 
    ];
}
function getProductInputValues(values, initialValues) {
    var ref, ref8, ref9, ref10;
    const { product_type , type , quantity , author , manufacturer , image , is_digital , categories , tags , section_id , digital_file_input , variation_options , variations , ...simpleValues } = values;
    // const { locale } = useRouter();
    // const router = useRouter();
    const processedFile = processFileWithName(digital_file_input);
    return {
        ...simpleValues,
        is_digital,
        // language: router.locale,
        author_id: author === null || author === void 0 ? void 0 : author.id,
        manufacturer_id: manufacturer === null || manufacturer === void 0 ? void 0 : manufacturer.id,
        type_id: type === null || type === void 0 ? void 0 : type.id,
        product_type: product_type === null || product_type === void 0 ? void 0 : product_type.value,
        categories: categories.map((category)=>{
            return category === null || category === void 0 ? void 0 : category.id;
        }),
        tags: tags.map((tag)=>{
            return tag === null || tag === void 0 ? void 0 : tag.id;
        }),
        image: omitTypename(image),
        gallery: (ref = values.gallery) === null || ref === void 0 ? void 0 : ref.map((gi)=>omitTypename(gi)
        ),
        section_id: section_id === null || section_id === void 0 ? void 0 : section_id.id,
        ...(product_type === null || product_type === void 0 ? void 0 : product_type.value) === (types/* ProductType */.kv === null || types/* ProductType */.kv === void 0 ? void 0 : types/* ProductType.Simple */.kv.Simple) && {
            quantity,
            ...is_digital && {
                digital_file: {
                    id: initialValues === null || initialValues === void 0 ? void 0 : (ref8 = initialValues.digital_file) === null || ref8 === void 0 ? void 0 : ref8.id,
                    attachment_id: digital_file_input.id,
                    url: digital_file_input.original,
                    file_name: processedFile[0].filename + '.' + processedFile[0].fileType
                }
            }
        },
        variations: [],
        variation_options: {
            upsert: [],
            delete: initialValues === null || initialValues === void 0 ? void 0 : (ref9 = initialValues.variation_options) === null || ref9 === void 0 ? void 0 : ref9.map((variation)=>{
                return variation === null || variation === void 0 ? void 0 : variation.id;
            })
        },
        ...(product_type === null || product_type === void 0 ? void 0 : product_type.value) === (types/* ProductType */.kv === null || types/* ProductType */.kv === void 0 ? void 0 : types/* ProductType.Variable */.kv.Variable) && {
            quantity: calculateQuantity(variation_options),
            variations: variations === null || variations === void 0 ? void 0 : variations.flatMap(({ value  })=>{
                return value === null || value === void 0 ? void 0 : value.map(({ id  })=>({
                        attribute_value_id: id
                    })
                );
            }),
            variation_options: {
                // @ts-ignore
                upsert: variation_options === null || variation_options === void 0 ? void 0 : variation_options.map(({ options , id , digital_file , image: variationImage , digital_file_input: digital_file_input_ , ...rest })=>{
                    return {
                        ...id !== '' ? {
                            id
                        } : {},
                        ...omit_default()(rest, '__typename'),
                        ...!isEmpty_default()(variationImage) && {
                            image: omitTypename(variationImage)
                        },
                        ...(rest === null || rest === void 0 ? void 0 : rest.is_digital) && {
                            digital_file: {
                                id: digital_file === null || digital_file === void 0 ? void 0 : digital_file.id,
                                attachment_id: digital_file_input_ === null || digital_file_input_ === void 0 ? void 0 : digital_file_input_.id,
                                url: digital_file_input_ === null || digital_file_input_ === void 0 ? void 0 : digital_file_input_.original,
                                file_name: digital_file === null || digital_file === void 0 ? void 0 : digital_file.file_name
                            }
                        },
                        options: processOptions(options).map(({ name , value  })=>({
                                name,
                                value
                            })
                        )
                    };
                }),
                delete: initialValues === null || initialValues === void 0 ? void 0 : (ref10 = initialValues.variation_options) === null || ref10 === void 0 ? void 0 : ref10.map((initialVariationOption)=>{
                    // @ts-ignore
                    const find = variation_options === null || variation_options === void 0 ? void 0 : variation_options.find((variationOption)=>{
                        return (variationOption === null || variationOption === void 0 ? void 0 : variationOption.id) === (initialVariationOption === null || initialVariationOption === void 0 ? void 0 : initialVariationOption.id);
                    });
                    if (!find) {
                        return initialVariationOption === null || initialVariationOption === void 0 ? void 0 : initialVariationOption.id;
                    }
                }).filter((item)=>item !== undefined
                )
            }
        },
        ...calculateMinMaxPrice(variation_options)
    };
}


/***/ }),

/***/ 15001:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55530);
/* harmony import */ var _components_ui_label__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(63815);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(45641);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _data_category__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8580);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_7__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__, react_hook_form__WEBPACK_IMPORTED_MODULE_3__, _data_category__WEBPACK_IMPORTED_MODULE_6__]);
([_components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__, react_hook_form__WEBPACK_IMPORTED_MODULE_3__, _data_category__WEBPACK_IMPORTED_MODULE_6__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);








const ProductCategoryInput = ({ control , setValue  })=>{
    const { locale  } = (0,next_router__WEBPACK_IMPORTED_MODULE_7__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)('common');
    const type = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_3__.useWatch)({
        control,
        name: 'type'
    });
    const { dirtyFields  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_3__.useFormState)({
        control
    });
    (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(()=>{
        if ((type === null || type === void 0 ? void 0 : type.slug) && (dirtyFields === null || dirtyFields === void 0 ? void 0 : dirtyFields.type)) {
            setValue('categories', []);
        }
    }, [
        type === null || type === void 0 ? void 0 : type.slug
    ]);
    const { categories , loading  } = (0,_data_category__WEBPACK_IMPORTED_MODULE_6__/* .useCategoriesQuery */ .Ei)({
        limit: 999,
        type: type === null || type === void 0 ? void 0 : type.slug,
        language: locale
    });
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "mb-5",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                children: t('form:input-label-categories')
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                name: "categories",
                isMulti: true,
                control: control,
                getOptionLabel: (option)=>option.name
                ,
                getOptionValue: (option)=>option.id
                ,
                // @ts-ignore
                options: categories,
                isLoading: loading
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProductCategoryInput);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 88602:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ CreateOrUpdateProductForm)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(145);
/* harmony import */ var _components_ui_text_area__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(83375);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(45641);
/* harmony import */ var _components_ui_button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(39258);
/* harmony import */ var _components_ui_description__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(87594);
/* harmony import */ var _components_common_card__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(81258);
/* harmony import */ var _components_ui_label__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(63815);
/* harmony import */ var _components_ui_radio_radio__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(45691);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(61908);
/* harmony import */ var _components_ui_file_input__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(77725);
/* harmony import */ var _product_validation_schema__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(54427);
/* harmony import */ var _product_variable_form__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(809);
/* harmony import */ var _product_simple_form__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(52017);
/* harmony import */ var _product_group_input__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(33540);
/* harmony import */ var _product_category_input__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(15001);
/* harmony import */ var _product_type_input__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(46142);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(53139);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var _data_shop__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(10678);
/* harmony import */ var _product_tag_input__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(49840);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(29249);
/* harmony import */ var _components_ui_alert__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(58788);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var _components_icons_edit__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(83955);
/* harmony import */ var _form_utils__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(92940);
/* harmony import */ var _utils_form_error__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(1326);
/* harmony import */ var _data_product__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(24342);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(46517);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_29___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_29__);
/* harmony import */ var _product_section_input__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(14523);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_hook_form__WEBPACK_IMPORTED_MODULE_3__, _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_10__, _components_ui_file_input__WEBPACK_IMPORTED_MODULE_11__, _product_variable_form__WEBPACK_IMPORTED_MODULE_13__, _product_simple_form__WEBPACK_IMPORTED_MODULE_14__, _product_group_input__WEBPACK_IMPORTED_MODULE_15__, _product_category_input__WEBPACK_IMPORTED_MODULE_16__, _product_type_input__WEBPACK_IMPORTED_MODULE_17__, _data_shop__WEBPACK_IMPORTED_MODULE_20__, _product_tag_input__WEBPACK_IMPORTED_MODULE_21__, _config__WEBPACK_IMPORTED_MODULE_22__, _utils_form_error__WEBPACK_IMPORTED_MODULE_27__, _data_product__WEBPACK_IMPORTED_MODULE_28__, _product_section_input__WEBPACK_IMPORTED_MODULE_30__]);
([react_hook_form__WEBPACK_IMPORTED_MODULE_3__, _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_10__, _components_ui_file_input__WEBPACK_IMPORTED_MODULE_11__, _product_variable_form__WEBPACK_IMPORTED_MODULE_13__, _product_simple_form__WEBPACK_IMPORTED_MODULE_14__, _product_group_input__WEBPACK_IMPORTED_MODULE_15__, _product_category_input__WEBPACK_IMPORTED_MODULE_16__, _product_type_input__WEBPACK_IMPORTED_MODULE_17__, _data_shop__WEBPACK_IMPORTED_MODULE_20__, _product_tag_input__WEBPACK_IMPORTED_MODULE_21__, _config__WEBPACK_IMPORTED_MODULE_22__, _utils_form_error__WEBPACK_IMPORTED_MODULE_27__, _data_product__WEBPACK_IMPORTED_MODULE_28__, _product_section_input__WEBPACK_IMPORTED_MODULE_30__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);































function CreateOrUpdateProductForm({ initialValues  }) {
    var ref, ref1, ref2, ref3, ref4, ref5, ref6;
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_9__.useRouter)();
    const { 0: isSlugDisable , 1: setIsSlugDisable  } = (0,react__WEBPACK_IMPORTED_MODULE_24__.useState)(true);
    const { 0: errorMessage , 1: setErrorMessage  } = (0,react__WEBPACK_IMPORTED_MODULE_24__.useState)(null);
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_19__.useTranslation)();
    const { data: shopData  } = (0,_data_shop__WEBPACK_IMPORTED_MODULE_20__/* .useShopQuery */ .DZ)({
        slug: router.query.shop
    }, {
        enabled: !!router.query.shop
    });
    const shopId = shopData === null || shopData === void 0 ? void 0 : shopData.id;
    const isNewTranslation = (router === null || router === void 0 ? void 0 : (ref = router.query) === null || ref === void 0 ? void 0 : ref.action) === 'translate';
    const isSlugEditable = (router === null || router === void 0 ? void 0 : (ref1 = router.query) === null || ref1 === void 0 ? void 0 : ref1.action) === 'edit' && (router === null || router === void 0 ? void 0 : router.locale) === _config__WEBPACK_IMPORTED_MODULE_22__/* .Config.defaultLanguage */ .D.defaultLanguage;
    const methods = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_3__.useForm)({
        resolver: (0,_hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_10__.yupResolver)(_product_validation_schema__WEBPACK_IMPORTED_MODULE_12__/* .productValidationSchema */ .X),
        shouldUnregister: true,
        // @ts-ignore
        defaultValues: (0,_form_utils__WEBPACK_IMPORTED_MODULE_26__/* .getProductDefaultValues */ .YF)(initialValues, isNewTranslation)
    });
    const { register , handleSubmit , control , getValues , setValue , setError , watch , formState: { errors  } ,  } = methods;
    const { mutate: createProduct , isLoading: creating  } = (0,_data_product__WEBPACK_IMPORTED_MODULE_28__/* .useCreateProductMutation */ .qX)();
    const { mutate: updateProduct , isLoading: updating  } = (0,_data_product__WEBPACK_IMPORTED_MODULE_28__/* .useUpdateProductMutation */ .wE)();
    const onSubmit = async (values)=>{
        const inputValues = {
            language: router.locale,
            ...(0,_form_utils__WEBPACK_IMPORTED_MODULE_26__/* .getProductInputValues */ .p9)(values, initialValues)
        };
        try {
            if (!initialValues || !initialValues.translated_languages.includes(router.locale)) {
                //@ts-ignore
                createProduct({
                    ...inputValues,
                    ...(initialValues === null || initialValues === void 0 ? void 0 : initialValues.slug) && {
                        slug: initialValues.slug
                    },
                    shop_id: shopId || (initialValues === null || initialValues === void 0 ? void 0 : initialValues.shop_id)
                });
            } else {
                //@ts-ignore
                updateProduct({
                    ...inputValues,
                    id: initialValues.id,
                    shop_id: initialValues.shop_id
                });
            }
        } catch (error) {
            const serverErrors = (0,_utils_form_error__WEBPACK_IMPORTED_MODULE_27__/* .getErrorMessage */ .e)(error);
            Object.keys(serverErrors === null || serverErrors === void 0 ? void 0 : serverErrors.validation).forEach((field)=>{
                setError(field.split('.')[1], {
                    type: 'manual',
                    message: serverErrors === null || serverErrors === void 0 ? void 0 : serverErrors.validation[field][0]
                });
            });
        }
    };
    const product_type = watch('product_type');
    const is_digital = watch('is_digital');
    const is_external = watch('is_external');
    const slugAutoSuggest = (0,lodash__WEBPACK_IMPORTED_MODULE_29__.join)((0,lodash__WEBPACK_IMPORTED_MODULE_29__.split)(watch('name'), ' '), '-').toLowerCase();
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            errorMessage ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_alert__WEBPACK_IMPORTED_MODULE_23__/* ["default"] */ .Z, {
                message: t(`common:${errorMessage}`),
                variant: "error",
                closeable: true,
                className: "mt-5",
                onClose: ()=>setErrorMessage(null)
            }) : null,
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_hook_form__WEBPACK_IMPORTED_MODULE_3__.FormProvider, {
                ...methods,
                children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("form", {
                    onSubmit: handleSubmit(onSubmit),
                    noValidate: true,
                    children: [
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                            className: "my-5 flex flex-wrap border-b border-dashed border-border-base pb-8 sm:my-8",
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                    title: t('form:featured-image-title'),
                                    details: t('form:featured-image-help-text'),
                                    className: "w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pe-4 md:w-1/3 md:pe-5"
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_card__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                                    className: "w-full sm:w-8/12 md:w-2/3",
                                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_file_input__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z, {
                                        name: "image",
                                        control: control,
                                        multiple: false
                                    })
                                })
                            ]
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                            className: "my-5 flex flex-wrap border-b border-dashed border-border-base pb-8 sm:my-8",
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                    title: t('form:gallery-title'),
                                    details: t('form:gallery-help-text'),
                                    className: "w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pe-4 md:w-1/3 md:pe-5"
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_card__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                                    className: "w-full sm:w-8/12 md:w-2/3",
                                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_file_input__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z, {
                                        name: "gallery",
                                        control: control
                                    })
                                })
                            ]
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                            className: "my-5 flex flex-wrap border-b border-dashed border-border-base pb-8 sm:my-8",
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                    title: t('form:type-and-category'),
                                    details: t('form:type-and-category-help-text'),
                                    className: "w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pe-4 md:w-1/3 md:pe-5"
                                }),
                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_common_card__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                                    className: "w-full sm:w-8/12 md:w-2/3",
                                    children: [
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_product_group_input__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
                                            control: control,
                                            error: t((ref2 = errors === null || errors === void 0 ? void 0 : errors.type) === null || ref2 === void 0 ? void 0 : ref2.message)
                                        }),
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_product_category_input__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .Z, {
                                            control: control,
                                            setValue: setValue
                                        }),
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_product_section_input__WEBPACK_IMPORTED_MODULE_30__/* ["default"] */ .Z, {
                                            control: control,
                                            setValue: setValue
                                        }),
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_product_tag_input__WEBPACK_IMPORTED_MODULE_21__/* ["default"] */ .Z, {
                                            control: control,
                                            setValue: setValue
                                        })
                                    ]
                                })
                            ]
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                            className: "my-5 flex flex-wrap sm:my-8",
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                    title: t('form:item-description'),
                                    details: `${initialValues ? t('form:item-description-edit') : t('form:item-description-add')} ${t('form:product-description-help-text')}`,
                                    className: "w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pe-4 md:w-1/3 md:pe-5"
                                }),
                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_common_card__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                                    className: "w-full sm:w-8/12 md:w-2/3",
                                    children: [
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                            label: `${t('form:input-label-name')}*`,
                                            ...register('name'),
                                            error: t((ref3 = errors.name) === null || ref3 === void 0 ? void 0 : ref3.message),
                                            variant: "outline",
                                            className: "mb-5"
                                        }),
                                        isSlugEditable ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                            className: "relative mb-5",
                                            children: [
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                                    label: `${t('Slug')}`,
                                                    ...register('slug'),
                                                    error: t((ref4 = errors.slug) === null || ref4 === void 0 ? void 0 : ref4.message),
                                                    variant: "outline",
                                                    disabled: isSlugDisable
                                                }),
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                                                    className: "absolute top-[27px] right-px z-10 flex h-[46px] w-11 items-center justify-center rounded-tr rounded-br border-l border-solid border-border-base bg-white px-2 text-body transition duration-200 hover:text-heading focus:outline-none",
                                                    type: "button",
                                                    title: t('common:text-edit'),
                                                    onClick: ()=>setIsSlugDisable(false)
                                                    ,
                                                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_edit__WEBPACK_IMPORTED_MODULE_25__/* .EditIcon */ .d, {
                                                        width: 14
                                                    })
                                                })
                                            ]
                                        }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                            label: `${t('Slug')}`,
                                            ...register('slug'),
                                            value: slugAutoSuggest,
                                            variant: "outline",
                                            className: "mb-5",
                                            disabled: true
                                        }),
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                            label: `${t('form:input-label-unit')}*`,
                                            ...register('unit'),
                                            error: t((ref5 = errors.unit) === null || ref5 === void 0 ? void 0 : ref5.message),
                                            variant: "outline",
                                            className: "mb-5"
                                        }),
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_text_area__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                                            label: t('form:input-label-description'),
                                            ...register('description'),
                                            error: t((ref6 = errors.description) === null || ref6 === void 0 ? void 0 : ref6.message),
                                            variant: "outline",
                                            className: "mb-5"
                                        }),
                                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                            children: [
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                                                    children: t('form:input-label-status')
                                                }),
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_radio_radio__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                                                    ...register('status'),
                                                    label: t('form:input-label-published'),
                                                    id: "published",
                                                    value: "publish",
                                                    className: "mb-2"
                                                }),
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_radio_radio__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                                                    ...register('status'),
                                                    id: "draft",
                                                    label: t('form:input-label-draft'),
                                                    value: "draft"
                                                })
                                            ]
                                        })
                                    ]
                                })
                            ]
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                            className: "my-5 flex flex-wrap border-b border-dashed border-border-base pb-8 sm:my-8",
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                    title: t('form:form-title-product-type'),
                                    details: t('form:form-description-product-type'),
                                    className: "w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pr-4 md:w-1/3 md:pr-5"
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_product_type_input__WEBPACK_IMPORTED_MODULE_17__/* ["default"] */ .Z, {})
                            ]
                        }),
                        (product_type === null || product_type === void 0 ? void 0 : product_type.value) === _types__WEBPACK_IMPORTED_MODULE_18__/* .ProductType.Simple */ .kv.Simple && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_product_simple_form__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .Z, {
                            initialValues: initialValues
                        }),
                        (product_type === null || product_type === void 0 ? void 0 : product_type.value) === _types__WEBPACK_IMPORTED_MODULE_18__/* .ProductType.Variable */ .kv.Variable && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_product_variable_form__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z, {
                            shopId: shopId,
                            initialValues: initialValues
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                            className: "mb-4 text-end",
                            children: [
                                initialValues && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                                    variant: "outline",
                                    onClick: router.back,
                                    className: "me-4",
                                    type: "button",
                                    children: t('form:button-label-back')
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                                    loading: updating || creating,
                                    children: initialValues ? t('form:button-label-update-product') : t('form:button-label-add-product')
                                })
                            ]
                        })
                    ]
                })
            })
        ]
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 33540:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55530);
/* harmony import */ var _components_ui_label__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(63815);
/* harmony import */ var _components_ui_form_validation_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56965);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _data_type__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(98077);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__, _data_type__WEBPACK_IMPORTED_MODULE_5__]);
([_components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__, _data_type__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);







const ProductGroupInput = ({ control , error  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_4__.useTranslation)();
    const { locale  } = (0,next_router__WEBPACK_IMPORTED_MODULE_6__.useRouter)();
    const { types , loading  } = (0,_data_type__WEBPACK_IMPORTED_MODULE_5__/* .useTypesQuery */ .qs)({
        limit: 200,
        language: locale
    });
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "mb-5",
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_ui_label__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                children: [
                    t('form:input-label-group'),
                    "*"
                ]
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                name: "type",
                control: control,
                getOptionLabel: (option)=>option.name
                ,
                getOptionValue: (option)=>option.id
                ,
                options: types,
                isLoading: loading
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_form_validation_error__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                message: t(error)
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProductGroupInput);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 14523:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55530);
/* harmony import */ var _components_ui_label__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(63815);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(45641);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _data_section__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(47840);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__, react_hook_form__WEBPACK_IMPORTED_MODULE_3__, _data_section__WEBPACK_IMPORTED_MODULE_7__]);
([_components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__, react_hook_form__WEBPACK_IMPORTED_MODULE_3__, _data_section__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);








const ProductSectionInput = ({ control , setValue  })=>{
    const { locale  } = (0,next_router__WEBPACK_IMPORTED_MODULE_6__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)('common');
    const type = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_3__.useWatch)({
        control,
        name: 'type'
    });
    const { dirtyFields  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_3__.useFormState)({
        control
    });
    (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(()=>{
        if ((type === null || type === void 0 ? void 0 : type.slug) && (dirtyFields === null || dirtyFields === void 0 ? void 0 : dirtyFields.type)) {
            setValue('categories', []);
        }
    }, [
        type === null || type === void 0 ? void 0 : type.slug
    ]);
    const { sections , loading  } = (0,_data_section__WEBPACK_IMPORTED_MODULE_7__/* .useSectionQuery */ .oD)({
        limit: 999,
        type: type === null || type === void 0 ? void 0 : type.slug,
        language: locale
    });
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "mb-5",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                children: "Section"
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                name: "section_id",
                control: control,
                getOptionLabel: (option)=>option.name
                ,
                getOptionValue: (option)=>option.id
                ,
                // @ts-ignore
                options: sections,
                isLoading: loading
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProductSectionInput);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 52017:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ ProductSimpleForm)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(145);
/* harmony import */ var _components_ui_description__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87594);
/* harmony import */ var _components_common_card__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(81258);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(45641);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _components_ui_label__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63815);
/* harmony import */ var _components_ui_file_input__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(77725);
/* harmony import */ var _components_ui_checkbox_checkbox__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(33785);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(29249);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_10__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_hook_form__WEBPACK_IMPORTED_MODULE_4__, _components_ui_file_input__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_9__]);
([react_hook_form__WEBPACK_IMPORTED_MODULE_4__, _components_ui_file_input__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_9__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);











function ProductSimpleForm({ initialValues  }) {
    var ref, ref1, ref2, ref3, ref4, ref5, ref6, ref7, ref8, ref9;
    const { register , control , watch , formState: { errors  } ,  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_4__.useFormContext)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    const { locale  } = (0,next_router__WEBPACK_IMPORTED_MODULE_10__.useRouter)();
    const isTranslateProduct = locale !== _config__WEBPACK_IMPORTED_MODULE_9__/* .Config.defaultLanguage */ .D.defaultLanguage;
    const is_digital = watch('is_digital');
    const is_external = watch('is_external');
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "my-5 flex flex-wrap sm:my-8",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                title: t('form:form-title-simple-product-info'),
                details: `${initialValues ? t('form:item-description-edit') : t('form:item-description-add')} ${t('form:form-description-simple-product-info')}`,
                className: "sm:pe-4 md:pe-5 w-full px-0 pb-5 sm:w-4/12 sm:py-8 md:w-1/3"
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_common_card__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                className: "w-full sm:w-8/12 md:w-2/3",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        label: `${t('form:input-label-price')}*`,
                        ...register('price'),
                        type: "number",
                        error: t((ref = errors.price) === null || ref === void 0 ? void 0 : ref.message),
                        variant: "outline",
                        className: "mb-5"
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        label: t('form:input-label-sale-price'),
                        type: "number",
                        ...register('sale_price'),
                        error: t((ref1 = errors.sale_price) === null || ref1 === void 0 ? void 0 : ref1.message),
                        variant: "outline",
                        className: "mb-5"
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        label: `${t('form:input-label-quantity')}*`,
                        type: "number",
                        ...register('quantity'),
                        error: t((ref2 = errors.quantity) === null || ref2 === void 0 ? void 0 : ref2.message),
                        variant: "outline",
                        className: "mb-5",
                        // Need discussion
                        disabled: isTranslateProduct
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        label: `${t('form:input-label-sku')}*`,
                        ...register('sku'),
                        note: _config__WEBPACK_IMPORTED_MODULE_9__/* .Config.enableMultiLang */ .D.enableMultiLang ? `${t('form:input-note-multilang-sku')}` : '',
                        error: t((ref3 = errors.sku) === null || ref3 === void 0 ? void 0 : ref3.message),
                        variant: "outline",
                        className: "mb-5",
                        disabled: isTranslateProduct
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        label: t('form:input-label-width'),
                        ...register('width'),
                        error: t((ref4 = errors.width) === null || ref4 === void 0 ? void 0 : ref4.message),
                        variant: "outline",
                        className: "mb-5"
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        label: t('form:input-label-height'),
                        ...register('height'),
                        error: t((ref5 = errors.height) === null || ref5 === void 0 ? void 0 : ref5.message),
                        variant: "outline",
                        className: "mb-5"
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        label: t('form:input-label-length'),
                        ...register('length'),
                        error: t((ref6 = errors.length) === null || ref6 === void 0 ? void 0 : ref6.message),
                        variant: "outline",
                        className: "mb-5"
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_checkbox_checkbox__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                        ...register('is_digital'),
                        id: "is_digital",
                        label: t('form:input-label-is-digital'),
                        disabled: Boolean(is_external),
                        className: "mb-5"
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_checkbox_checkbox__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                        ...register('is_external'),
                        id: "is_external",
                        label: t('form:input-label-is-external'),
                        disabled: Boolean(is_digital),
                        className: "mb-5"
                    }),
                    is_digital ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                                children: t('form:input-label-digital-file')
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_file_input__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                                name: "digital_file_input",
                                control: control,
                                multiple: false,
                                acceptFile: true,
                                defaultValue: {}
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                                type: "hidden",
                                ...register(`digital_file`)
                            }),
                            errors.digital_file_input && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                                className: "my-2 text-xs text-start text-red-500",
                                children: t((ref7 = errors.digital_file_input) === null || ref7 === void 0 ? void 0 : ref7.message)
                            })
                        ]
                    }) : null,
                    is_external ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-external-product-url'),
                                ...register('external_product_url'),
                                error: t((ref8 = errors.external_product_url) === null || ref8 === void 0 ? void 0 : ref8.message),
                                variant: "outline",
                                className: "mb-5"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-external-product-button-text'),
                                ...register('external_product_button_text'),
                                error: t((ref9 = errors.external_product_button_text) === null || ref9 === void 0 ? void 0 : ref9.message),
                                variant: "outline",
                                className: "mb-5"
                            })
                        ]
                    }) : null
                ]
            })
        ]
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 49840:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55530);
/* harmony import */ var _components_ui_label__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(63815);
/* harmony import */ var _data_tag__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(14149);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__, _data_tag__WEBPACK_IMPORTED_MODULE_3__]);
([_components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__, _data_tag__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






const ProductTagInput = ({ control , setValue  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    const { locale  } = (0,next_router__WEBPACK_IMPORTED_MODULE_4__.useRouter)();
    // const type = useWatch({
    //   control,
    //   name: 'type',
    // });
    // const { dirtyFields } = useFormState({
    //   control,
    // });
    // useEffect(() => {
    //   if (type?.slug && dirtyFields?.type) {
    //     setValue('tags', []);
    //   }
    // }, [type?.slug]);
    const { tags , loading  } = (0,_data_tag__WEBPACK_IMPORTED_MODULE_3__/* .useTagsQuery */ .Qd)({
        limit: 999,
        // type: type?.slug,
        language: locale
    });
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                children: t('sidebar-nav-item-tags')
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                name: "tags",
                isMulti: true,
                control: control,
                getOptionLabel: (option)=>option.name
                ,
                getOptionValue: (option)=>option.id
                ,
                // @ts-ignore
                options: tags,
                isLoading: loading
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProductTagInput);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 46142:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55530);
/* harmony import */ var _components_ui_label__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(63815);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(45641);
/* harmony import */ var _components_common_card__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(81258);
/* harmony import */ var _components_ui_form_validation_error__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(56965);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(53139);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_7__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__, react_hook_form__WEBPACK_IMPORTED_MODULE_3__]);
([_components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__, react_hook_form__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);








const productType = [
    {
        name: 'Simple Product',
        value: _types__WEBPACK_IMPORTED_MODULE_6__/* .ProductType.Simple */ .kv.Simple
    },
    {
        name: 'Variable Product',
        value: _types__WEBPACK_IMPORTED_MODULE_6__/* .ProductType.Variable */ .kv.Variable
    }, 
];
const ProductTypeInput = ()=>{
    var ref;
    const { control , formState: { errors  } ,  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_3__.useFormContext)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_7__.useTranslation)();
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_card__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
        className: "w-full sm:w-8/12 md:w-2/3",
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
            className: "mb-5",
            children: [
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                    children: t('form:form-title-product-type')
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                    name: "product_type",
                    control: control,
                    getOptionLabel: (option)=>option.name
                    ,
                    getOptionValue: (option)=>option.value
                    ,
                    options: productType
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_form_validation_error__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                    message: t((ref = errors.product_type) === null || ref === void 0 ? void 0 : ref.message)
                })
            ]
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProductTypeInput);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 54427:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "X": () => (/* binding */ productValidationSchema)
/* harmony export */ });
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(53139);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_1__);


const productValidationSchema = yup__WEBPACK_IMPORTED_MODULE_1__.object().shape({
    name: yup__WEBPACK_IMPORTED_MODULE_1__.string().required('form:error-name-required'),
    product_type: yup__WEBPACK_IMPORTED_MODULE_1__.object().required('form:error-product-type-required'),
    sku: yup__WEBPACK_IMPORTED_MODULE_1__.mixed().when('product_type', {
        is: (productType)=>{
            return (productType === null || productType === void 0 ? void 0 : productType.value) === _types__WEBPACK_IMPORTED_MODULE_0__/* .ProductType.Simple */ .kv.Simple;
        },
        then: yup__WEBPACK_IMPORTED_MODULE_1__.string().nullable().required('form:error-sku-required')
    }),
    price: yup__WEBPACK_IMPORTED_MODULE_1__.mixed().when('product_type', {
        is: (productType)=>{
            return (productType === null || productType === void 0 ? void 0 : productType.value) === _types__WEBPACK_IMPORTED_MODULE_0__/* .ProductType.Simple */ .kv.Simple;
        },
        then: yup__WEBPACK_IMPORTED_MODULE_1__.number().typeError('form:error-price-must-number').positive('form:error-price-must-positive').required('form:error-price-required')
    }),
    sale_price: yup__WEBPACK_IMPORTED_MODULE_1__.number().transform((value)=>isNaN(value) ? undefined : value
    ).lessThan(yup__WEBPACK_IMPORTED_MODULE_1__.ref('price'), 'Sale Price should be less than ${less}').positive('form:error-sale-price-must-positive'),
    quantity: yup__WEBPACK_IMPORTED_MODULE_1__.mixed().when('product_type', {
        is: (productType)=>{
            return (productType === null || productType === void 0 ? void 0 : productType.value) === _types__WEBPACK_IMPORTED_MODULE_0__/* .ProductType.Simple */ .kv.Simple;
        },
        then: yup__WEBPACK_IMPORTED_MODULE_1__.number().typeError('form:error-quantity-must-number').positive('form:error-quantity-must-positive').integer('form:error-quantity-must-integer').required('form:error-quantity-required')
    }),
    unit: yup__WEBPACK_IMPORTED_MODULE_1__.string().required('form:error-unit-required'),
    type: yup__WEBPACK_IMPORTED_MODULE_1__.object().nullable().required('form:error-type-required'),
    status: yup__WEBPACK_IMPORTED_MODULE_1__.string().required('form:error-status-required'),
    variation_options: yup__WEBPACK_IMPORTED_MODULE_1__.array().of(yup__WEBPACK_IMPORTED_MODULE_1__.object().shape({
        price: yup__WEBPACK_IMPORTED_MODULE_1__.number().typeError('form:error-price-must-number').positive('form:error-price-must-positive').required('form:error-price-required'),
        sale_price: yup__WEBPACK_IMPORTED_MODULE_1__.number().transform((value)=>isNaN(value) ? undefined : value
        ).lessThan(yup__WEBPACK_IMPORTED_MODULE_1__.ref('price'), 'Sale Price should be less than ${less}').positive('form:error-sale-price-must-positive'),
        quantity: yup__WEBPACK_IMPORTED_MODULE_1__.number().typeError('form:error-quantity-must-number').positive('form:error-quantity-must-positive').integer('form:error-quantity-must-integer').required('form:error-quantity-required'),
        sku: yup__WEBPACK_IMPORTED_MODULE_1__.string().required('form:error-sku-required'),
        digital_file_input: yup__WEBPACK_IMPORTED_MODULE_1__.mixed().when('is_digital', (isDigital)=>{
            if (isDigital) {
                return yup__WEBPACK_IMPORTED_MODULE_1__.object().test('check-digital-file', 'form:error-digital-file-input-required', (file)=>{
                    return file && (file === null || file === void 0 ? void 0 : file.original);
                });
            }
            return yup__WEBPACK_IMPORTED_MODULE_1__.string().nullable();
        })
    })),
    digital_file_input: yup__WEBPACK_IMPORTED_MODULE_1__.mixed().when('is_digital', (isDigital)=>{
        if (isDigital) {
            return yup__WEBPACK_IMPORTED_MODULE_1__.object().test('check-digital-file', 'form:error-digital-file-input-required', (file)=>{
                return file && (file === null || file === void 0 ? void 0 : file.original);
            });
        }
        return yup__WEBPACK_IMPORTED_MODULE_1__.string().nullable();
    })
});


/***/ }),

/***/ 809:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ ProductVariableForm)
/* harmony export */ });
/* unused harmony export TitleAndOptionsInput */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(145);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45641);
/* harmony import */ var _components_ui_button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(39258);
/* harmony import */ var _components_ui_description__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(87594);
/* harmony import */ var _components_common_card__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(81258);
/* harmony import */ var _components_ui_label__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63815);
/* harmony import */ var _components_ui_title__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(98469);
/* harmony import */ var _components_ui_checkbox_checkbox__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(33785);
/* harmony import */ var _components_ui_select_input__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(55530);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _data_attributes__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(51384);
/* harmony import */ var _components_ui_file_input__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(77725);
/* harmony import */ var _components_ui_form_validation_error__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(56965);
/* harmony import */ var _form_utils__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(92940);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(29249);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_hook_form__WEBPACK_IMPORTED_MODULE_2__, _components_ui_select_input__WEBPACK_IMPORTED_MODULE_9__, _data_attributes__WEBPACK_IMPORTED_MODULE_12__, _components_ui_file_input__WEBPACK_IMPORTED_MODULE_13__, _config__WEBPACK_IMPORTED_MODULE_17__]);
([react_hook_form__WEBPACK_IMPORTED_MODULE_2__, _components_ui_select_input__WEBPACK_IMPORTED_MODULE_9__, _data_attributes__WEBPACK_IMPORTED_MODULE_12__, _components_ui_file_input__WEBPACK_IMPORTED_MODULE_13__, _config__WEBPACK_IMPORTED_MODULE_17__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);


















function ProductVariableForm({ shopId , initialValues  }) {
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_11__.useTranslation)();
    const { locale  } = (0,next_router__WEBPACK_IMPORTED_MODULE_16__.useRouter)();
    const { attributes , loading  } = (0,_data_attributes__WEBPACK_IMPORTED_MODULE_12__/* .useAttributesQuery */ .OO)({
        shop_id: initialValues ? initialValues.shop_id : shopId,
        language: locale
    });
    const { register , control , watch , setValue , getValues , formState: { errors  } ,  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_2__.useFormContext)();
    // This field array will keep all the attribute dropdown fields
    const { fields , append , remove  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_2__.useFieldArray)({
        shouldUnregister: true,
        control,
        name: 'variations'
    });
    const variations = watch('variations');
    const cartesianProduct = (0,_form_utils__WEBPACK_IMPORTED_MODULE_15__/* .getCartesianProduct */ .zo)(getValues('variations'));
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "my-5 flex flex-wrap sm:my-8",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                title: t('form:form-title-variation-product-info'),
                details: `${initialValues ? t('form:item-description-update') : t('form:item-description-choose')} ${t('form:form-description-variation-product-info')}`,
                className: "sm:pe-4 md:pe-5 w-full px-0 pb-5 sm:w-4/12 sm:py-8 md:w-1/3"
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_card__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                className: "w-full p-0 sm:w-8/12 md:w-2/3 md:p-0",
                children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                    className: "mb-5 border-t border-dashed border-border-200 md:mb-8",
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_title__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                            className: "mb-0 mt-8 px-5 text-center text-lg uppercase md:px-8",
                            children: t('form:form-title-options')
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                            children: fields === null || fields === void 0 ? void 0 : fields.map((field, index)=>{
                                var ref;
                                return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                    className: "border-b border-dashed border-border-200 p-5 last:border-0 md:p-8",
                                    children: [
                                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                            className: "flex items-center justify-between",
                                            children: [
                                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_ui_title__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                                                    className: "mb-0",
                                                    children: [
                                                        t('form:form-title-options'),
                                                        " ",
                                                        index + 1
                                                    ]
                                                }),
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                                                    onClick: ()=>remove(index)
                                                    ,
                                                    type: "button",
                                                    className: "text-sm text-red-500 transition-colors duration-200 hover:text-red-700 focus:outline-none",
                                                    children: t('form:button-label-remove')
                                                })
                                            ]
                                        }),
                                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                            className: "grid grid-cols-fit gap-5",
                                            children: [
                                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                    className: "mt-5",
                                                    children: [
                                                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_ui_label__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                                                            children: [
                                                                t('form:input-label-attribute-name'),
                                                                "*"
                                                            ]
                                                        }),
                                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_select_input__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
                                                            name: `variations.${index}.attribute`,
                                                            control: control,
                                                            defaultValue: field.attribute,
                                                            getOptionLabel: (option)=>option.name
                                                            ,
                                                            getOptionValue: (option)=>option.id
                                                            ,
                                                            options: (0,_form_utils__WEBPACK_IMPORTED_MODULE_15__/* .filterAttributes */ .i1)(attributes, variations),
                                                            isLoading: loading
                                                        })
                                                    ]
                                                }),
                                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                    className: "col-span-2 mt-5",
                                                    children: [
                                                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_ui_label__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                                                            children: [
                                                                t('form:input-label-attribute-value'),
                                                                "*"
                                                            ]
                                                        }),
                                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_select_input__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
                                                            isMulti: true,
                                                            name: `variations.${index}.value`,
                                                            control: control,
                                                            defaultValue: field.value,
                                                            getOptionLabel: (option)=>option.value
                                                            ,
                                                            getOptionValue: (option)=>option.id
                                                            ,
                                                            options: (ref = watch(`variations.${index}.attribute`)) === null || ref === void 0 ? void 0 : ref.values
                                                        })
                                                    ]
                                                })
                                            ]
                                        })
                                    ]
                                }, field.id));
                            })
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                            className: "px-5 md:px-8",
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                                disabled: fields.length === (attributes === null || attributes === void 0 ? void 0 : attributes.length),
                                onClick: (e)=>{
                                    e.preventDefault();
                                    append({
                                        attribute: '',
                                        value: []
                                    });
                                },
                                type: "button",
                                children: t('form:button-label-add-option')
                            })
                        }),
                        !!(cartesianProduct === null || cartesianProduct === void 0 ? void 0 : cartesianProduct.length) && /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                            className: "mt-5 border-t border-dashed border-border-200 pt-5 md:mt-8 md:pt-8",
                            children: [
                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_ui_title__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                                    className: "mb-0 px-5 text-center text-lg uppercase md:px-8",
                                    children: [
                                        cartesianProduct === null || cartesianProduct === void 0 ? void 0 : cartesianProduct.length,
                                        " ",
                                        t('form:total-variation-added')
                                    ]
                                }),
                                cartesianProduct.map((fieldAttributeValue, index)=>{
                                    var ref, ref1, ref2, ref3, ref4, ref5, ref6, ref7, ref8, ref9, ref10, ref11, ref12, ref13, ref14, ref15, ref16, ref17;
                                    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                        className: "mb-5 mt-5 border-b border-dashed border-border-200 p-5 last:mb-8 last:border-0 md:p-8 md:last:pb-0",
                                        children: [
                                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_ui_title__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                                                className: "mb-8 !text-lg",
                                                children: [
                                                    t('form:form-title-variant'),
                                                    ":",
                                                    ' ',
                                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                                        className: "font-normal text-blue-600",
                                                        children: Array.isArray(fieldAttributeValue) ? fieldAttributeValue === null || fieldAttributeValue === void 0 ? void 0 : fieldAttributeValue.map((a)=>a.value
                                                        ).join('/') : fieldAttributeValue.value
                                                    })
                                                ]
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(TitleAndOptionsInput, {
                                                register: register,
                                                setValue: setValue,
                                                index: index,
                                                fieldAttributeValue: fieldAttributeValue
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                                                ...register(`variation_options.${index}.id`),
                                                type: "hidden"
                                            }),
                                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                className: "grid grid-cols-2 gap-5",
                                                children: [
                                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                                        label: `${t('form:input-label-price')}*`,
                                                        type: "number",
                                                        ...register(`variation_options.${index}.price`),
                                                        error: t((ref = errors.variation_options) === null || ref === void 0 ? void 0 : (ref1 = ref[index]) === null || ref1 === void 0 ? void 0 : (ref2 = ref1.price) === null || ref2 === void 0 ? void 0 : ref2.message),
                                                        variant: "outline",
                                                        className: "mb-5"
                                                    }),
                                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                                        label: t('form:input-label-sale-price'),
                                                        type: "number",
                                                        ...register(`variation_options.${index}.sale_price`),
                                                        error: t((ref3 = errors.variation_options) === null || ref3 === void 0 ? void 0 : (ref4 = ref3[index]) === null || ref4 === void 0 ? void 0 : (ref5 = ref4.sale_price) === null || ref5 === void 0 ? void 0 : ref5.message),
                                                        variant: "outline",
                                                        className: "mb-5"
                                                    }),
                                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                                        label: `${t('form:input-label-sku')}*`,
                                                        note: _config__WEBPACK_IMPORTED_MODULE_17__/* .Config.enableMultiLang */ .D.enableMultiLang ? `${t('form:input-note-multilang-sku')}` : '',
                                                        ...register(`variation_options.${index}.sku`),
                                                        error: t((ref6 = errors.variation_options) === null || ref6 === void 0 ? void 0 : (ref7 = ref6[index]) === null || ref7 === void 0 ? void 0 : (ref8 = ref7.sku) === null || ref8 === void 0 ? void 0 : ref8.message),
                                                        variant: "outline",
                                                        className: "mb-5"
                                                    }),
                                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                                        label: `${t('form:input-label-quantity')}*`,
                                                        type: "number",
                                                        ...register(`variation_options.${index}.quantity`),
                                                        error: t((ref9 = errors.variation_options) === null || ref9 === void 0 ? void 0 : (ref10 = ref9[index]) === null || ref10 === void 0 ? void 0 : (ref11 = ref10.quantity) === null || ref11 === void 0 ? void 0 : ref11.message),
                                                        variant: "outline",
                                                        className: "mb-5"
                                                    })
                                                ]
                                            }),
                                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                children: [
                                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                                                        children: t('form:input-label-image')
                                                    }),
                                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_file_input__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z, {
                                                        name: `variation_options.${index}.image`,
                                                        control: control,
                                                        multiple: false
                                                    })
                                                ]
                                            }),
                                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                className: "mb-5 mt-5",
                                                children: [
                                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_checkbox_checkbox__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                                                        ...register(`variation_options.${index}.is_digital`),
                                                        label: t('form:input-label-is-digital')
                                                    }),
                                                    !!watch(`variation_options.${index}.is_digital`) && /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                        className: "mt-5",
                                                        children: [
                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                                                                children: t('form:input-label-digital-file')
                                                            }),
                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_file_input__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z, {
                                                                name: `variation_options.${index}.digital_file_input`,
                                                                control: control,
                                                                multiple: false,
                                                                acceptFile: true,
                                                                helperText: t('form:text-upload-digital-file'),
                                                                defaultValue: {}
                                                            }),
                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_form_validation_error__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .Z, {
                                                                message: t(errors === null || errors === void 0 ? void 0 : (ref12 = errors.variation_options) === null || ref12 === void 0 ? void 0 : (ref13 = ref12[index]) === null || ref13 === void 0 ? void 0 : (ref14 = ref13.digital_file_input) === null || ref14 === void 0 ? void 0 : ref14.message)
                                                            }),
                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                                                                type: "hidden",
                                                                ...register(`variation_options.${index}.digital_file`)
                                                            })
                                                        ]
                                                    })
                                                ]
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                className: "mb-5 mt-5",
                                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_checkbox_checkbox__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                                                    ...register(`variation_options.${index}.is_disable`),
                                                    error: t((ref15 = errors.variation_options) === null || ref15 === void 0 ? void 0 : (ref16 = ref15[index]) === null || ref16 === void 0 ? void 0 : (ref17 = ref16.is_disable) === null || ref17 === void 0 ? void 0 : ref17.message),
                                                    label: t('form:input-label-disable-variant')
                                                })
                                            })
                                        ]
                                    }, `fieldAttributeValues-${index}`));
                                })
                            ]
                        })
                    ]
                })
            })
        ]
    }));
};
const TitleAndOptionsInput = ({ fieldAttributeValue , index , setValue , register  })=>{
    const title = Array.isArray(fieldAttributeValue) ? fieldAttributeValue.map((a)=>a.value
    ).join('/') : fieldAttributeValue.value;
    const options = Array.isArray(fieldAttributeValue) ? JSON.stringify(fieldAttributeValue) : JSON.stringify([
        fieldAttributeValue
    ]);
    (0,react__WEBPACK_IMPORTED_MODULE_10__.useEffect)(()=>{
        setValue(`variation_options.${index}.title`, title);
        setValue(`variation_options.${index}.options`, options);
    }, [
        fieldAttributeValue
    ]);
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                ...register(`variation_options.${index}.title`),
                type: "hidden"
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                ...register(`variation_options.${index}.options`),
                type: "hidden"
            })
        ]
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 58788:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_icons_close_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(29581);



const variantClasses = {
    info: 'bg-blue-100 text-blue-600',
    warning: 'bg-yellow-100 text-yellow-600',
    error: 'bg-red-100 text-red-500',
    success: 'bg-green-100 text-accent',
    infoOutline: 'border border-blue-200 text-blue-600',
    warningOutline: 'border border-yellow-200 text-yellow-600',
    errorOutline: 'border border-red-200 text-red-600',
    successOutline: 'border border-green-200 text-green-600'
};
const Alert = ({ message ='' , closeable =false , variant ='info' , className , onClose ,  })=>{
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('relative flex items-center justify-between rounded py-4 px-5 shadow-sm', variantClasses[variant], className),
        role: "alert",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                className: "text-sm",
                children: message
            }),
            closeable && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                "data-dismiss": "alert",
                "aria-label": "Close",
                onClick: onClose,
                title: "Close alert",
                className: "-me-0.5 end-2 absolute top-1/2 -mt-3 flex h-6 w-6 flex-shrink-0 items-center justify-center rounded-full text-red-500 transition-colors duration-200 hover:bg-gray-300 hover:bg-opacity-25 focus:bg-gray-300 focus:bg-opacity-25 focus:outline-none",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    "aria-hidden": "true",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_close_icon__WEBPACK_IMPORTED_MODULE_2__/* .CloseIcon */ .T, {
                        className: "h-3 w-3"
                    })
                })
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Alert);


/***/ }),

/***/ 33785:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const Checkbox = /*#__PURE__*/ react__WEBPACK_IMPORTED_MODULE_1___default().forwardRef(({ className , label , name , error , ...rest }, ref)=>{
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: className,
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "flex items-center",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                        id: name,
                        name: name,
                        type: "checkbox",
                        ref: ref,
                        className: "pb-checkbox",
                        ...rest
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
                        htmlFor: name,
                        className: "text-body text-sm",
                        children: label
                    })
                ]
            }),
            error && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                className: "my-2 text-xs text-end text-red-500",
                children: error
            })
        ]
    }));
});
Checkbox.displayName = 'Checkbox';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Checkbox);


/***/ }),

/***/ 77725:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_common_uploader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20286);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45641);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_common_uploader__WEBPACK_IMPORTED_MODULE_1__, react_hook_form__WEBPACK_IMPORTED_MODULE_2__]);
([_components_common_uploader__WEBPACK_IMPORTED_MODULE_1__, react_hook_form__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const FileInput = ({ control , name , multiple =true , acceptFile =false , helperText , defaultValue =[]  })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_hook_form__WEBPACK_IMPORTED_MODULE_2__.Controller, {
        control: control,
        name: name,
        defaultValue: defaultValue,
        render: ({ field: { ref , ...rest }  })=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_uploader__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                ...rest,
                multiple: multiple,
                acceptFile: acceptFile,
                helperText: helperText
            })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FileInput);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 56965:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const ValidationError = ({ message  })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
        className: "my-2 text-xs text-start text-red-500",
        children: message
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ValidationError);


/***/ }),

/***/ 63815:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);


const Label = ({ className , ...rest })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
        className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('block text-body-dark font-semibold text-sm leading-none mb-3', className),
        ...rest
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Label);


/***/ }),

/***/ 45691:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _radio_module_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(54137);
/* harmony import */ var _radio_module_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_radio_module_css__WEBPACK_IMPORTED_MODULE_2__);



const Radio = /*#__PURE__*/ react__WEBPACK_IMPORTED_MODULE_1___default().forwardRef(({ className , label , name , id , error , ...rest }, ref)=>{
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: className,
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "flex items-center",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                        id: id,
                        name: name,
                        type: "radio",
                        ref: ref,
                        className: (_radio_module_css__WEBPACK_IMPORTED_MODULE_2___default().radio_input),
                        ...rest
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
                        htmlFor: id,
                        className: "text-body text-sm",
                        children: label
                    })
                ]
            }),
            error && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                className: "my-2 text-xs text-end text-red-500",
                children: error
            })
        ]
    }));
});
Radio.displayName = 'Radio';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Radio);


/***/ }),

/***/ 98469:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);


const Title = ({ className ='mb-3' , ...rest })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
        className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('block text-body-dark font-semibold text-sm leading-none', className),
        ...rest
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Title);


/***/ }),

/***/ 51384:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "gL": () => (/* binding */ useCreateAttributeMutation),
/* harmony export */   "uT": () => (/* binding */ useUpdateAttributeMutation),
/* harmony export */   "Oi": () => (/* binding */ useDeleteAttributeMutation),
/* harmony export */   "I1": () => (/* binding */ useAttributeQuery),
/* harmony export */   "OO": () => (/* binding */ useAttributesQuery)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28379);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85057);
/* harmony import */ var _data_client_attribute__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(48893);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(29249);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_attribute__WEBPACK_IMPORTED_MODULE_6__, _config__WEBPACK_IMPORTED_MODULE_7__]);
([_data_client_attribute__WEBPACK_IMPORTED_MODULE_6__, _config__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);








const useCreateAttributeMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_attribute__WEBPACK_IMPORTED_MODULE_6__/* .attributeClient.create */ .b.create, {
        onSuccess: ()=>{
            next_router__WEBPACK_IMPORTED_MODULE_0___default().push(_config_routes__WEBPACK_IMPORTED_MODULE_4__/* .Routes.attribute.list */ .Z.attribute.list, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_7__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.ATTRIBUTES */ .P.ATTRIBUTES);
        }
    });
};
const useUpdateAttributeMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_attribute__WEBPACK_IMPORTED_MODULE_6__/* .attributeClient.update */ .b.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.ATTRIBUTES */ .P.ATTRIBUTES);
        }
    });
};
const useDeleteAttributeMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_attribute__WEBPACK_IMPORTED_MODULE_6__/* .attributeClient["delete"] */ .b["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.ATTRIBUTES */ .P.ATTRIBUTES);
        }
    });
};
const useAttributeQuery = ({ slug , language  })=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.ATTRIBUTES */ .P.ATTRIBUTES,
        {
            slug,
            language
        }
    ], ()=>_data_client_attribute__WEBPACK_IMPORTED_MODULE_6__/* .attributeClient.get */ .b.get({
            slug,
            language
        })
    );
};
const useAttributesQuery = (params, options = {})=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.ATTRIBUTES */ .P.ATTRIBUTES,
        params
    ], ({ queryKey , pageParam  })=>_data_client_attribute__WEBPACK_IMPORTED_MODULE_6__/* .attributeClient.all */ .b.all(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true,
        ...options
    });
    return {
        attributes: data !== null && data !== void 0 ? data : [],
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8580:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "m7": () => (/* binding */ useCreateCategoryMutation),
/* harmony export */   "l8": () => (/* binding */ useDeleteCategoryMutation),
/* harmony export */   "pi": () => (/* binding */ useUpdateCategoryMutation),
/* harmony export */   "Im": () => (/* binding */ useCategoryQuery),
/* harmony export */   "Ei": () => (/* binding */ useCategoriesQuery)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28379);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85057);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63354);
/* harmony import */ var _client_category__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(76105);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(29249);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_category__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_8__]);
([_client_category__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const useCreateCategoryMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_category__WEBPACK_IMPORTED_MODULE_7__/* .categoryClient.create */ .X.create, {
        onSuccess: ()=>{
            next_router__WEBPACK_IMPORTED_MODULE_0___default().push(_config_routes__WEBPACK_IMPORTED_MODULE_4__/* .Routes.category.list */ .Z.category.list, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_8__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES);
        }
    });
};
const useDeleteCategoryMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_category__WEBPACK_IMPORTED_MODULE_7__/* .categoryClient["delete"] */ .X["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES);
        }
    });
};
const useUpdateCategoryMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_category__WEBPACK_IMPORTED_MODULE_7__/* .categoryClient.update */ .X.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES);
        }
    });
};
const useCategoryQuery = ({ slug , language  })=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES,
        {
            slug,
            language
        }
    ], ()=>_client_category__WEBPACK_IMPORTED_MODULE_7__/* .categoryClient.get */ .X.get({
            slug,
            language
        })
    );
    return {
        category: data,
        error,
        isLoading
    };
};
const useCategoriesQuery = (options)=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES,
        options
    ], ({ queryKey , pageParam  })=>_client_category__WEBPACK_IMPORTED_MODULE_7__/* .categoryClient.paginated */ .X.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    var ref;
    return {
        categories: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__/* .mapPaginatorData */ .Q)(data),
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 48893:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "b": () => (/* binding */ attributeClient)
/* harmony export */ });
/* harmony import */ var _data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5034);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
/* harmony import */ var _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const attributeClient = {
    ...(0,_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__/* .crudFactory */ .h)(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.ATTRIBUTES */ .P.ATTRIBUTES),
    paginated: ({ type , name , shop_id , ...params })=>{
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.ATTRIBUTES */ .P.ATTRIBUTES, {
            searchJoin: 'and',
            ...params,
            search: _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                type,
                name,
                shop_id
            })
        });
    },
    all: ({ type , name , shop_id , ...params })=>{
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.ATTRIBUTES */ .P.ATTRIBUTES, {
            searchJoin: 'and',
            ...params,
            search: _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                type,
                name,
                shop_id
            })
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 76105:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "X": () => (/* binding */ categoryClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5034);
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const categoryClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_1__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES),
    paginated: ({ type , name , ...params })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES, {
            searchJoin: 'and',
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                type,
                name
            })
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5034:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "h": () => (/* binding */ crudFactory)
/* harmony export */ });
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_0__]);
_http_client__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

function crudFactory(endpoint) {
    return {
        all (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        paginated (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        get ({ slug , language  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(`${endpoint}/${slug}`, {
                language
            });
        },
        create (data) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.post */ .eN.post(endpoint, data);
        },
        update ({ id , ...input }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.put */ .eN.put(`${endpoint}/${id}`, input);
        },
        delete ({ id  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient["delete"] */ .eN["delete"](`${endpoint}/${id}`);
        }
    };
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 21351:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "M": () => (/* binding */ productClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5034);
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const productClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_1__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.PRODUCTS */ .P.PRODUCTS),
    get ({ slug , language  }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.PRODUCTS */ .P.PRODUCTS}/${slug}`, {
            language,
            with: 'type;shop;categories;tags;variations.attribute.values;variation_options;author;manufacturer;digital_file'
        });
    },
    paginated: ({ type , name , categories , shop_id , ...params })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.PRODUCTS */ .P.PRODUCTS, {
            searchJoin: 'and',
            with: 'shop;type',
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                type,
                name,
                categories,
                shop_id
            })
        });
    },
    popular ({ shop_id , ...params }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.POPULAR_PRODUCTS */ .P.POPULAR_PRODUCTS, {
            searchJoin: 'and',
            with: 'type;shop',
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                shop_id
            })
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 69003:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "o": () => (/* binding */ SectionClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5034);
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const SectionClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_1__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SECTION */ .P.SECTION),
    get ({ slug , language  }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SECTION */ .P.SECTION}/${slug}`, {
            language,
            with: 'type;shop;categories;tags;variations.attribute.values;variation_options;author;manufacturer;digital_file'
        });
    },
    paginated: ({ ...params })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SECTION */ .P.SECTION, {
            searchJoin: 'and',
            with: 'shop;type',
            ...params
        });
    },
    popular ({ ...params }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SECTION */ .P.SECTION, {
            searchJoin: 'and',
            with: 'type;shop',
            ...params
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5683:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "b": () => (/* binding */ shopClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67904);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5034);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_1__, _curd_factory__WEBPACK_IMPORTED_MODULE_2__]);
([_http_client__WEBPACK_IMPORTED_MODULE_1__, _curd_factory__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const shopClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_2__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS),
    get ({ slug  }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.get */ .eN.get(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS}/${slug}`);
    },
    paginated: ({ name , ...params })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS, {
            searchJoin: 'and',
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                name
            })
        });
    },
    approve: (variables)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.APPROVE_SHOP */ .P.APPROVE_SHOP, variables);
    },
    disapprove: (variables)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.DISAPPROVE_SHOP */ .P.DISAPPROVE_SHOP, variables);
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 2331:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "K": () => (/* binding */ tagClient)
/* harmony export */ });
/* harmony import */ var _data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5034);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
/* harmony import */ var _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const tagClient = {
    ...(0,_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__/* .crudFactory */ .h)(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.TAGS */ .P.TAGS),
    paginated: ({ type , name , ...params })=>{
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.TAGS */ .P.TAGS, {
            searchJoin: 'and',
            ...params,
            search: _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                type,
                name
            })
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4372:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "A": () => (/* binding */ typeClient)
/* harmony export */ });
/* harmony import */ var _data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5034);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
/* harmony import */ var _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const typeClient = {
    ...(0,_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__/* .crudFactory */ .h)(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.TYPES */ .P.TYPES),
    all: ({ name , ...params })=>{
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.TYPES */ .P.TYPES, {
            searchJoin: 'and',
            ...params,
            search: _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                name
            })
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 12721:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "t": () => (/* binding */ uploadClient)
/* harmony export */ });
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67904);
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_0__]);
_http_client__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const uploadClient = {
    upload: async (variables)=>{
        let formData = new FormData();
        variables.forEach((attachment)=>{
            formData.append('attachment[]', attachment);
        });
        const options = {
            headers: {
                'Content-Type': 'multipart/form-data'
            }
        };
        return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.ATTACHMENTS */ .P.ATTACHMENTS, formData, options);
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 24342:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "qX": () => (/* binding */ useCreateProductMutation),
/* harmony export */   "wE": () => (/* binding */ useUpdateProductMutation),
/* harmony export */   "xq": () => (/* binding */ useDeleteProductMutation),
/* harmony export */   "FA": () => (/* binding */ useProductQuery),
/* harmony export */   "kN": () => (/* binding */ useProductsQuery)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85057);
/* harmony import */ var _client_product__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(21351);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63354);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(28379);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(29249);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_product__WEBPACK_IMPORTED_MODULE_5__, _config__WEBPACK_IMPORTED_MODULE_8__]);
([_client_product__WEBPACK_IMPORTED_MODULE_5__, _config__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const useCreateProductMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useQueryClient)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_0__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useMutation)(_client_product__WEBPACK_IMPORTED_MODULE_5__/* .productClient.create */ .M.create, {
        onSuccess: async ()=>{
            const generateRedirectUrl = router.query.shop ? `/${router.query.shop}${_config_routes__WEBPACK_IMPORTED_MODULE_7__/* .Routes.product.list */ .Z.product.list}` : _config_routes__WEBPACK_IMPORTED_MODULE_7__/* .Routes.product.list */ .Z.product.list;
            await next_router__WEBPACK_IMPORTED_MODULE_0___default().push(generateRedirectUrl, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_8__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.PRODUCTS */ .P.PRODUCTS);
        }
    });
};
const useUpdateProductMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useQueryClient)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_0__.useRouter)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useMutation)(_client_product__WEBPACK_IMPORTED_MODULE_5__/* .productClient.update */ .M.update, {
        onSuccess: async (data)=>{
            const generateRedirectUrl = router.query.shop ? `/${router.query.shop}${_config_routes__WEBPACK_IMPORTED_MODULE_7__/* .Routes.product.list */ .Z.product.list}` : _config_routes__WEBPACK_IMPORTED_MODULE_7__/* .Routes.product.list */ .Z.product.list;
            await router.push(`${generateRedirectUrl}/${data === null || data === void 0 ? void 0 : data.slug}/edit`, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_8__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.PRODUCTS */ .P.PRODUCTS);
        }
    });
};
const useDeleteProductMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useMutation)(_client_product__WEBPACK_IMPORTED_MODULE_5__/* .productClient["delete"] */ .M["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.PRODUCTS */ .P.PRODUCTS);
        }
    });
};
const useProductQuery = ({ slug , language  })=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.PRODUCTS */ .P.PRODUCTS,
        {
            slug,
            language
        }
    ], ()=>_client_product__WEBPACK_IMPORTED_MODULE_5__/* .productClient.get */ .M.get({
            slug,
            language
        })
    );
    return {
        product: data,
        error,
        isLoading
    };
};
const useProductsQuery = (params, options = {})=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.PRODUCTS */ .P.PRODUCTS,
        params
    ], ({ queryKey , pageParam  })=>_client_product__WEBPACK_IMPORTED_MODULE_5__/* .productClient.paginated */ .M.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true,
        ...options
    });
    var ref;
    return {
        products: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__/* .mapPaginatorData */ .Q)(data),
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 47840:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "IO": () => (/* binding */ useUpdateSectionMutation),
/* harmony export */   "oD": () => (/* binding */ useSectionQuery),
/* harmony export */   "i$": () => (/* binding */ useSingleSectionQuery)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85057);
/* harmony import */ var _client_section__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(69003);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63354);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(28379);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(29249);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_section__WEBPACK_IMPORTED_MODULE_5__, _config__WEBPACK_IMPORTED_MODULE_8__]);
([_client_section__WEBPACK_IMPORTED_MODULE_5__, _config__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const useUpdateSectionMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useQueryClient)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_0__.useRouter)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useMutation)(_client_section__WEBPACK_IMPORTED_MODULE_5__/* .SectionClient.update */ .o.update, {
        onSuccess: async (data)=>{
            await router.push(_config_routes__WEBPACK_IMPORTED_MODULE_7__/* .Routes.section.list */ .Z.section.list, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_8__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.SECTION */ .P.SECTION);
        }
    });
};
const useSectionQuery = (options = {})=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.SECTION */ .P.SECTION
    ], ({ queryKey , pageParam  })=>_client_section__WEBPACK_IMPORTED_MODULE_5__/* .SectionClient.paginated */ .o.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true,
        ...options
    });
    var ref;
    return {
        sections: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__/* .mapPaginatorData */ .Q)(data),
        error,
        loading: isLoading
    };
};
const useSingleSectionQuery = ({ slug , language  })=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.SECTION */ .P.SECTION,
        {
            slug,
            language
        }
    ], ()=>_client_section__WEBPACK_IMPORTED_MODULE_5__/* .SectionClient.get */ .o.get({
            slug,
            language
        })
    );
    return {
        section: data,
        error,
        isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 10678:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "bg": () => (/* binding */ useApproveShopMutation),
/* harmony export */   "mj": () => (/* binding */ useDisApproveShopMutation),
/* harmony export */   "TC": () => (/* binding */ useCreateShopMutation),
/* harmony export */   "D9": () => (/* binding */ useUpdateShopMutation),
/* harmony export */   "DZ": () => (/* binding */ useShopQuery),
/* harmony export */   "uL": () => (/* binding */ useShopsQuery)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28379);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(85057);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _client_shop__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(5683);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63354);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(49239);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_shop__WEBPACK_IMPORTED_MODULE_5__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__]);
([_client_shop__WEBPACK_IMPORTED_MODULE_5__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const useApproveShopMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_shop__WEBPACK_IMPORTED_MODULE_5__/* .shopClient.approve */ .b.approve, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_4__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS);
        }
    });
};
const useDisApproveShopMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_shop__WEBPACK_IMPORTED_MODULE_5__/* .shopClient.disapprove */ .b.disapprove, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_4__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS);
        }
    });
};
const useCreateShopMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_7__.useRouter)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_shop__WEBPACK_IMPORTED_MODULE_5__/* .shopClient.create */ .b.create, {
        onSuccess: ()=>{
            const { permissions  } = (0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__/* .getAuthCredentials */ .WA)();
            if ((0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__/* .hasAccess */ .Ft)(_utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__/* .adminOnly */ .M$, permissions)) {
                return router.push(_config_routes__WEBPACK_IMPORTED_MODULE_1__/* .Routes.adminMyShops */ .Z.adminMyShops);
            }
            router.push(_config_routes__WEBPACK_IMPORTED_MODULE_1__/* .Routes.dashboard */ .Z.dashboard);
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS);
        }
    });
};
const useUpdateShopMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_shop__WEBPACK_IMPORTED_MODULE_5__/* .shopClient.update */ .b.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_4__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS);
        }
    });
};
const useShopQuery = ({ slug  }, options)=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS,
        {
            slug
        }
    ], ()=>_client_shop__WEBPACK_IMPORTED_MODULE_5__/* .shopClient.get */ .b.get({
            slug
        })
    , options);
};
const useShopsQuery = (options)=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS,
        options
    ], ({ queryKey , pageParam  })=>_client_shop__WEBPACK_IMPORTED_MODULE_5__/* .shopClient.paginated */ .b.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    var ref;
    return {
        shops: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__/* .mapPaginatorData */ .Q)(data),
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 14149:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "be": () => (/* binding */ useCreateTagMutation),
/* harmony export */   "BW": () => (/* binding */ useDeleteTagMutation),
/* harmony export */   "go": () => (/* binding */ useUpdateTagMutation),
/* harmony export */   "wt": () => (/* binding */ useTagQuery),
/* harmony export */   "Qd": () => (/* binding */ useTagsQuery)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(63354);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85057);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(28379);
/* harmony import */ var _data_client_tag__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(2331);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(29249);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_tag__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_8__]);
([_data_client_tag__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const useCreateTagMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_tag__WEBPACK_IMPORTED_MODULE_7__/* .tagClient.create */ .K.create, {
        onSuccess: ()=>{
            next_router__WEBPACK_IMPORTED_MODULE_0___default().push(_config_routes__WEBPACK_IMPORTED_MODULE_6__/* .Routes.tag.list */ .Z.tag.list, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_8__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TAGS */ .P.TAGS);
        }
    });
};
const useDeleteTagMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_tag__WEBPACK_IMPORTED_MODULE_7__/* .tagClient["delete"] */ .K["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TAGS */ .P.TAGS);
        }
    });
};
const useUpdateTagMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_tag__WEBPACK_IMPORTED_MODULE_7__/* .tagClient.update */ .K.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TAGS */ .P.TAGS);
        }
    });
};
const useTagQuery = ({ slug , language  })=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES,
        {
            slug,
            language
        }
    ], ()=>_data_client_tag__WEBPACK_IMPORTED_MODULE_7__/* .tagClient.get */ .K.get({
            slug,
            language
        })
    );
    return {
        tag: data,
        error,
        loading: isLoading
    };
};
const useTagsQuery = (options)=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TAGS */ .P.TAGS,
        options
    ], ({ queryKey , pageParam  })=>_data_client_tag__WEBPACK_IMPORTED_MODULE_7__/* .tagClient.paginated */ .K.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    var ref;
    return {
        tags: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_4__/* .mapPaginatorData */ .Q)(data),
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 98077:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "jT": () => (/* binding */ useCreateTypeMutation),
/* harmony export */   "e7": () => (/* binding */ useDeleteTypeMutation),
/* harmony export */   "oy": () => (/* binding */ useUpdateTypeMutation),
/* harmony export */   "F2": () => (/* binding */ useTypeQuery),
/* harmony export */   "qs": () => (/* binding */ useTypesQuery)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28379);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85057);
/* harmony import */ var _data_client_type__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4372);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(29249);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(63354);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_type__WEBPACK_IMPORTED_MODULE_6__, _config__WEBPACK_IMPORTED_MODULE_7__]);
([_data_client_type__WEBPACK_IMPORTED_MODULE_6__, _config__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const useCreateTypeMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient.create */ .A.create, {
        onSuccess: ()=>{
            next_router__WEBPACK_IMPORTED_MODULE_0___default().push(_config_routes__WEBPACK_IMPORTED_MODULE_4__/* .Routes.type.list */ .Z.type.list, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_7__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES);
        }
    });
};
const useDeleteTypeMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient["delete"] */ .A["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES);
        }
    });
};
const useUpdateTypeMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient.update */ .A.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES);
        }
    });
};
const useTypeQuery = ({ slug , language  })=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES,
        {
            slug,
            language
        }
    ], ()=>_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient.get */ .A.get({
            slug,
            language
        })
    );
    return {
        type: data,
        error,
        isLoading
    };
};
const useTypesQuery = (options)=>{
    const { data , isLoading , error  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES,
        options
    ], ({ queryKey , pageParam  })=>_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient.paginated */ .A.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    var ref;
    return {
        types: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_8__/* .mapPaginatorData */ .Q)(data),
        loading: isLoading,
        error
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 34421:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "g": () => (/* binding */ useUploadMutation)
/* harmony export */ });
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
/* harmony import */ var _data_client_upload__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12721);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_upload__WEBPACK_IMPORTED_MODULE_2__]);
_data_client_upload__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const useUploadMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)((input)=>{
        return _data_client_upload__WEBPACK_IMPORTED_MODULE_2__/* .uploadClient.upload */ .t.upload(input);
    }, {
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.SETTINGS */ .P.SETTINGS);
        }
    });
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1326:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "e": () => (/* binding */ getErrorMessage)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var js_cookie__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69915);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([js_cookie__WEBPACK_IMPORTED_MODULE_1__]);
js_cookie__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


function getErrorMessage(error) {
    let processedError = {
        message: '',
        validation: []
    };
    if (error.graphQLErrors) {
        for (const graphQLError of error.graphQLErrors){
            if (graphQLError.extensions && graphQLError.extensions.category === 'validation') {
                processedError['message'] = graphQLError.message;
                processedError['validation'] = graphQLError.extensions.validation;
                return processedError;
            } else if (graphQLError.extensions && graphQLError.extensions.category === 'authorization') {
                js_cookie__WEBPACK_IMPORTED_MODULE_1__["default"].remove('auth_token');
                js_cookie__WEBPACK_IMPORTED_MODULE_1__["default"].remove('auth_permissions');
                next_router__WEBPACK_IMPORTED_MODULE_0___default().push('/');
            }
        }
    }
    processedError['message'] = error.message;
    return processedError;
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 34896:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Hb": () => (/* reexport */ product),
  "GZ": () => (/* reexport */ zip)
});

// UNUSED EXPORTS: avatarPlaceholder, couponPlaceholder, logoPlaceholder

;// CONCATENATED MODULE: ./src/assets/placeholders/product.svg
/* harmony default export */ const product = ({"src":"/_next/static/media/product.ba64d04a.svg","height":210,"width":270});
;// CONCATENATED MODULE: ./src/assets/placeholders/coupon.svg
/* harmony default export */ const coupon = ({"src":"/_next/static/media/coupon.5015b440.svg","height":240,"width":320});
;// CONCATENATED MODULE: ./src/assets/placeholders/avatar.svg
/* harmony default export */ const avatar = ({"src":"/_next/static/media/avatar.c9441dc8.svg","height":120,"width":120});
;// CONCATENATED MODULE: ./src/assets/placeholders/logo.svg
/* harmony default export */ const logo = ({"src":"/_next/static/media/logo.0679544b.svg","height":18,"width":109});
;// CONCATENATED MODULE: ./src/assets/placeholders/zip.png
/* harmony default export */ const zip = ({"src":"/_next/static/media/zip.9dcc52b5.png","height":512,"width":512,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAMAAADz0U65AAAAY1BMVEX3yYP+///dsofl6fXnvIb1yIrvwYTov4j1yIhMaXHLvc7RqoLqf5W1qrrOt6fS1uq9y9nVorG8ppyioLbJsqPh292UlrPZ0N/cq7q8j6X8j5zaxrPNtqW7nIOIiKrNm4iek6OR66+FAAAAG3RSTlMr/vj+tfX6+bUA/Cv7/v74/v7x/vH++P7+/v4PHiyvAAAACXBIWXMAAAsTAAALEwEAmpwYAAAARUlEQVQImR3LRxKAIBAAwUHSgmDOmP7/SqvsexNq470QYLjn8bIgZ6v04gTXaKU6b3Fl7be9spgS05EegSnm/Fbwd0P4AGY8AtL5sWsSAAAAAElFTkSuQmCC"});
;// CONCATENATED MODULE: ./src/utils/placeholders.tsx







/***/ })

};
;