"use strict";
exports.id = 9301;
exports.ids = [9301];
exports.modules = {

/***/ 81258:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);


const Card = ({ className , ...props })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('p-5 md:p-8 bg-light shadow rounded', className),
        ...props
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Card);


/***/ }),

/***/ 40771:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ ImportCsv)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_icons_upload_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19525);
/* harmony import */ var react_dropzone__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56358);
/* harmony import */ var react_dropzone__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_dropzone__WEBPACK_IMPORTED_MODULE_2__);



function ImportCsv({ onDrop , loading , title  }) {
    const { getRootProps , getInputProps  } = (0,react_dropzone__WEBPACK_IMPORTED_MODULE_2__.useDropzone)({
        accept: '.csv',
        multiple: false,
        onDrop
    });
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("section", {
        className: "upload",
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
            ...getRootProps({
                className: 'border-dashed border-2 border-border-base h-36 rounded flex flex-col justify-center items-center cursor-pointer focus:border-accent-400 focus:outline-none p-5'
            }),
            children: [
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                    ...getInputProps()
                }),
                loading && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "ms-2 h-[30px] w-[30px] animate-spin rounded-full border-2 border-t-2 border-transparent",
                    style: {
                        borderTopColor: 'rgb(var(--color-accent))'
                    }
                }),
                !loading && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_upload_icon__WEBPACK_IMPORTED_MODULE_1__/* .UploadIcon */ .r, {
                    className: "text-muted-light"
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                    className: "mt-4 text-center text-sm text-body",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                        className: "font-semibold text-accent",
                        children: title
                    })
                })
            ]
        })
    }));
};


/***/ }),

/***/ 12540:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "r": () => (/* binding */ importClient)
/* harmony export */ });
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_0__]);
_http_client__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const importClient = {
    importCsv: async (url, variables)=>{
        let formData = new FormData();
        formData.append('csv', variables === null || variables === void 0 ? void 0 : variables.csv);
        formData.append('shop_id', variables === null || variables === void 0 ? void 0 : variables.shop_id);
        const options = {
            headers: {
                'Content-Type': 'multipart/form-data'
            }
        };
        const response = await _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.post */ .eN.post(url, formData, options);
        return response.data;
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 40454:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "JK": () => (/* binding */ useImportAttributesMutation),
/* harmony export */   "Lq": () => (/* binding */ useImportProductsMutation),
/* harmony export */   "o$": () => (/* binding */ useImportVariationOptionsMutation)
/* harmony export */ });
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _data_client_import__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(12540);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_import__WEBPACK_IMPORTED_MODULE_4__]);
_data_client_import__WEBPACK_IMPORTED_MODULE_4__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];





const useImportAttributesMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)('common');
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)((input)=>{
        return _data_client_import__WEBPACK_IMPORTED_MODULE_4__/* .importClient.importCsv */ .r.importCsv(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.IMPORT_ATTRIBUTES */ .P.IMPORT_ATTRIBUTES, input);
    }, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:attribute-imported-successfully'));
        },
        onError: (error)=>{
            var ref;
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.error(t(`common:${error === null || error === void 0 ? void 0 : (ref = error.response) === null || ref === void 0 ? void 0 : ref.data.message}`));
        },
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.ATTRIBUTES */ .P.ATTRIBUTES);
        }
    });
};
const useImportProductsMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)('common');
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)((input)=>{
        return _data_client_import__WEBPACK_IMPORTED_MODULE_4__/* .importClient.importCsv */ .r.importCsv(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.IMPORT_PRODUCTS */ .P.IMPORT_PRODUCTS, input);
    }, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:product-imported-successfully'));
        },
        onError: (error)=>{
            var ref;
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.error(t(`common:${error === null || error === void 0 ? void 0 : (ref = error.response) === null || ref === void 0 ? void 0 : ref.data.message}`));
        },
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.PRODUCTS */ .P.PRODUCTS);
        }
    });
};
const useImportVariationOptionsMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)('common');
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)((input)=>{
        return _data_client_import__WEBPACK_IMPORTED_MODULE_4__/* .importClient.importCsv */ .r.importCsv(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.IMPORT_VARIATION_OPTIONS */ .P.IMPORT_VARIATION_OPTIONS, input);
    }, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:variation-options-imported-successfully'));
        },
        onError: (error)=>{
            var ref;
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.error(t(`common:${error === null || error === void 0 ? void 0 : (ref = error.response) === null || ref === void 0 ? void 0 : ref.data.message}`));
        },
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.PRODUCTS */ .P.PRODUCTS);
        }
    });
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;