"use strict";
exports.id = 9569;
exports.ids = [9569];
exports.modules = {

/***/ 97914:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "s": () => (/* binding */ shippingAddressClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5034);
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const shippingAddressClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_1__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SHIPPING_ADDRESS */ .P.SHIPPING_ADDRESS),
    get ({ slug , language  }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SHIPPING_ADDRESS */ .P.SHIPPING_ADDRESS}/${slug}`, {
            language,
            with: 'type;shop;categories;tags;variations.attribute.values;variation_options;author;manufacturer;digital_file'
        });
    },
    // delete({ slug, language }: GetParams) {
    //   return HttpClient.get<Carousel>(
    //     `${API_ENDPOINTS.CAROUSELS}/delete/${slug}`,
    //     {
    //       language,
    //       with: 'type;shop;categories;tags;variations.attribute.values;variation_options;author;manufacturer;digital_file',
    //     }
    //   );
    // },
    paginated: ({ ...params })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SHIPPING_ADDRESS */ .P.SHIPPING_ADDRESS, {
            searchJoin: 'and',
            with: 'shop;type',
            ...params
        });
    },
    popular ({ ...params }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.POPULAR_PRODUCTS */ .P.POPULAR_PRODUCTS, {
            searchJoin: 'and',
            with: 'type;shop',
            ...params
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 29569:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "eu": () => (/* binding */ useCreateShippingAddressMutation),
/* harmony export */   "I": () => (/* binding */ useUpdateShippingAddressMutation),
/* harmony export */   "LU": () => (/* binding */ useDeleteShippingAddressMutation),
/* harmony export */   "rQ": () => (/* binding */ useSingleShippingAddressQuery),
/* harmony export */   "ki": () => (/* binding */ useShippingAddressQuery)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85057);
/* harmony import */ var _client_shipping_address__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(97914);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63354);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(28379);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_shipping_address__WEBPACK_IMPORTED_MODULE_5__]);
_client_shipping_address__WEBPACK_IMPORTED_MODULE_5__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];








const useCreateShippingAddressMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useQueryClient)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_0__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useMutation)(_client_shipping_address__WEBPACK_IMPORTED_MODULE_5__/* .shippingAddressClient.create */ .s.create, {
        onSuccess: async ()=>{
            // const generateRedirectUrl = router.query.shop
            //   ? `/${router.query.shop}${Routes.shippingAddress.list}`
            //   : Routes.shippingAddress.list;
            // await Router.push(generateRedirectUrl, undefined, {
            //   locale: Config.defaultLanguage,
            // });
            router.push(_config_routes__WEBPACK_IMPORTED_MODULE_7__/* .Routes["shipping-address"].list */ .Z["shipping-address"].list);
            react_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.SHIPPING_ADDRESS */ .P.SHIPPING_ADDRESS);
        }
    });
};
const useUpdateShippingAddressMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useQueryClient)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_0__.useRouter)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useMutation)(_client_shipping_address__WEBPACK_IMPORTED_MODULE_5__/* .shippingAddressClient.update */ .s.update, {
        onSuccess: async (data)=>{
            router.push('/shipping-address');
            // const generateRedirectUrl = router.query.shop
            //   ? `/${router.query.shop}${Routes.shippingAddress.list}`
            //   : Routes.shippingAddress.list;
            // await router.push(`${generateRedirectUrl}/${data?.id}/edit`, undefined, {
            //   locale: Config.defaultLanguage,
            // });
            react_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.CAROUSELS */ .P.CAROUSELS);
        }
    });
};
const useDeleteShippingAddressMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useMutation)(_client_shipping_address__WEBPACK_IMPORTED_MODULE_5__/* .shippingAddressClient["delete"] */ .s["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.SHIPPING_ADDRESS */ .P.SHIPPING_ADDRESS);
        }
    });
};
const useSingleShippingAddressQuery = ({ slug , language  })=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.SHIPPING_ADDRESS */ .P.SHIPPING_ADDRESS,
        {
            slug,
            language
        }
    ], ()=>_client_shipping_address__WEBPACK_IMPORTED_MODULE_5__/* .shippingAddressClient.get */ .s.get({
            slug,
            language
        })
    );
    return {
        shippingAddress: data,
        error,
        isLoading
    };
};
const useShippingAddressQuery = (params, options = {})=>{
    var ref;
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_3__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_4__/* .API_ENDPOINTS.SHIPPING_ADDRESS */ .P.SHIPPING_ADDRESS,
        params
    ], ({ queryKey , pageParam  })=>_client_shipping_address__WEBPACK_IMPORTED_MODULE_5__/* .shippingAddressClient.paginated */ .s.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true,
        ...options
    });
    var ref1;
    return {
        addresses: (ref1 = data === null || data === void 0 ? void 0 : (ref = data.data) === null || ref === void 0 ? void 0 : ref.data) !== null && ref1 !== void 0 ? ref1 : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__/* .mapPaginatorData */ .Q)(data),
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;