"use strict";
exports.id = 9809;
exports.ids = [9809];
exports.modules = {

/***/ 85057:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "P": () => (/* binding */ API_ENDPOINTS)
/* harmony export */ });
const API_ENDPOINTS = {
    ATTACHMENTS: 'attachments',
    ANALYTICS: 'analytics',
    ATTRIBUTES: 'attributes',
    ATTRIBUTE_VALUES: 'attribute-values',
    ORDER_STATUS: 'order-status',
    ORDERS: 'orders',
    USERS: 'users',
    REGISTER: 'register',
    MENUS: 'menu',
    PRODUCTS: 'products',
    BANNERS: 'banner',
    CAROUSELS: 'carousel',
    SHIPPING_ADDRESS: 'shipping-address',
    SIXADBANNERS: 'six-ad-banner',
    SECTION: 'section',
    ADD_BANNER: 'banner/store',
    ADD_CAROUSEL: 'carousel/store',
    POPULAR_PRODUCTS: 'popular-products',
    COUPONS: 'coupons',
    VERIFY_COUPONS: 'coupons/verify',
    CUSTOMERS: 'customers',
    TAXES: 'taxes',
    SHIPPINGS: 'shippings',
    SETTINGS: 'settings',
    CATEGORIES: 'categories',
    TAGS: 'tags',
    TYPES: 'types',
    PROFILE_UPDATE: 'profile-update',
    LOGOUT: 'logout',
    ME: 'me',
    TOKEN: 'token',
    BLOCK_USER: 'users/block-user',
    UNBLOCK_USER: 'users/unblock-user',
    CHANGE_PASSWORD: 'change-password',
    FORGET_PASSWORD: 'forget-password',
    VERIFY_FORGET_PASSWORD_TOKEN: 'verify-forget-password-token',
    RESET_PASSWORD: 'reset-password',
    DOWNLOAD_INVOICE: 'download/invoice',
    APPROVE_SHOP: 'approve-shop',
    DISAPPROVE_SHOP: 'disapprove-shop',
    SHOPS: 'shops',
    MY_SHOPS: 'my-shops',
    WITHDRAWS: 'withdraws',
    APPROVE_WITHDRAW: 'approve-withdraw',
    ADD_WALLET_POINTS: 'add-points',
    REFUNDS: 'refunds',
    STAFFS: 'staffs',
    ADD_STAFF: 'staffs',
    REMOVE_STAFF: 'staffs',
    IMPORT_PRODUCTS: 'import-products/',
    IMPORT_ATTRIBUTES: 'import-attributes/',
    IMPORT_VARIATION_OPTIONS: 'import-variation-options/',
    MAKE_ADMIN: 'users/make-admin',
    AUTHORS: 'authors',
    MANUFACTURERS: 'manufacturers',
    CHECKOUT: 'orders/checkout/verify',
    QUESTIONS: 'questions',
    REVIEWS: 'reviews',
    ABUSIVE_REPORTS_DECLINE: 'abusive_reports/reject',
    ABUSIVE_REPORTS: 'abusive_reports',
    ORDER_EXPORT: 'export-order-url',
    ORDER_CREATE: 'order/create',
    ORDER_INVOICE_DOWNLOAD: 'download-invoice-url',
    CONVERSIONS: '/conversations',
    MESSAGE: '/messages/conversations',
    MESSAGE_SEEN: '/messages/seen',
    ADMIN_LIST: '/admin/list',
    STORE_NOTICES: 'store-notices',
    STORE_NOTICES_IS_READ: 'store-notices/read',
    STORE_NOTICE_GET_STORE_NOTICE_TYPE: 'store-notices/getStoreNoticeType',
    STORE_NOTICES_USER_OR_SHOP_LIST: 'store-notices/getUsersToNotify'
};


/***/ }),

/***/ 67904:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "eN": () => (/* binding */ HttpClient)
/* harmony export */ });
/* unused harmony exports getFormErrors, getFieldErrors */
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(99648);
/* harmony import */ var js_cookie__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69915);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var tiny_invariant__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(24281);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([axios__WEBPACK_IMPORTED_MODULE_0__, js_cookie__WEBPACK_IMPORTED_MODULE_1__, tiny_invariant__WEBPACK_IMPORTED_MODULE_3__]);
([axios__WEBPACK_IMPORTED_MODULE_0__, js_cookie__WEBPACK_IMPORTED_MODULE_1__, tiny_invariant__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




(0,tiny_invariant__WEBPACK_IMPORTED_MODULE_3__["default"])("https://chawkbazar.creatudevelopers.com.np", 'NEXT_PUBLIC_REST_API_ENDPOINT is not defined, please define it in your .env file');
const Axios = axios__WEBPACK_IMPORTED_MODULE_0__["default"].create({
    baseURL: "https://chawkbazar.creatudevelopers.com.np",
    timeout: 50000,
    headers: {
        'Content-Type': 'application/json'
    }
});
var _NEXT_PUBLIC_AUTH_TOKEN_KEY;
// Change request data/error
const AUTH_TOKEN_KEY = (_NEXT_PUBLIC_AUTH_TOKEN_KEY = "AUTH_CRED") !== null && _NEXT_PUBLIC_AUTH_TOKEN_KEY !== void 0 ? _NEXT_PUBLIC_AUTH_TOKEN_KEY : 'authToken';
Axios.interceptors.request.use((config)=>{
    const cookies = js_cookie__WEBPACK_IMPORTED_MODULE_1__["default"].get(AUTH_TOKEN_KEY);
    let token = '';
    if (cookies) {
        token = JSON.parse(cookies)['token'];
    }
    config.headers = {
        ...config.headers,
        Authorization: `Bearer ${token}`
    };
    return config;
});
// Change response data/error here
Axios.interceptors.response.use((response)=>response
, (error)=>{
    if (error.response && error.response.status === 401 || error.response && error.response.status === 403 || error.response && error.response.data.message === 'CHAWKBAZAR_ERROR.NOT_AUTHORIZED') {
        js_cookie__WEBPACK_IMPORTED_MODULE_1__["default"].remove(AUTH_TOKEN_KEY);
        next_router__WEBPACK_IMPORTED_MODULE_2___default().reload();
    }
    return Promise.reject(error);
});
function formatBooleanSearchParam(key, value) {
    return value ? `${key}:1` : `${key}:`;
}
class HttpClient {
    static async get(url, params) {
        const response = await Axios.get(url, {
            params
        });
        return response.data;
    }
    static async post(url, data, options) {
        const response = await Axios.post(url, data, options);
        return response.data;
    }
    static async put(url, data) {
        const response = await Axios.put(url, data);
        return response.data;
    }
    static async delete(url) {
        const response = await Axios.delete(url);
        return response.data;
    }
    static formatSearchParams(params) {
        return Object.entries(params).filter(([, value])=>Boolean(value)
        ).map(([k, v])=>[
                'type',
                'categories',
                'tags',
                'author',
                'manufacturer'
            ].includes(k) ? `${k}.slug:${v}` : [
                'is_approved'
            ].includes(k) ? formatBooleanSearchParam(k, v) : `${k}:${v}`
        ).join(';');
    }
}
function getFormErrors(error) {
    if (axios.isAxiosError(error)) {
        var ref;
        return (ref = error.response) === null || ref === void 0 ? void 0 : ref.data.message;
    }
    return null;
}
function getFieldErrors(error) {
    if (axios.isAxiosError(error)) {
        var ref;
        return (ref = error.response) === null || ref === void 0 ? void 0 : ref.data.errors;
    }
    return null;
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 63354:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Q": () => (/* binding */ mapPaginatorData)
/* harmony export */ });
/* harmony import */ var camelcase_keys__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33104);
/* harmony import */ var camelcase_keys__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(camelcase_keys__WEBPACK_IMPORTED_MODULE_0__);

const mapPaginatorData = (obj)=>{
    if (!obj) return null;
    const { data , ...formattedValues } = camelcase_keys__WEBPACK_IMPORTED_MODULE_0___default()(obj);
    return {
        ...formattedValues,
        hasMorePages: formattedValues.lastPage !== formattedValues.currentPage
    };
};


/***/ })

};
;