"use strict";
exports.id = 993;
exports.ids = [993];
exports.modules = {

/***/ 16896:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ CreateOrUpdateTaxForm)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(145);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45641);
/* harmony import */ var _components_ui_button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(39258);
/* harmony import */ var _components_ui_description__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(87594);
/* harmony import */ var _components_common_card__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(81258);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _data_tax__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(35827);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(61908);
/* harmony import */ var _tax_validation_schema__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(2807);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_hook_form__WEBPACK_IMPORTED_MODULE_2__, _data_tax__WEBPACK_IMPORTED_MODULE_7__, _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_9__]);
([react_hook_form__WEBPACK_IMPORTED_MODULE_2__, _data_tax__WEBPACK_IMPORTED_MODULE_7__, _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_9__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);











const defaultValues = {
    name: '',
    rate: 0,
    country: '',
    state: '',
    zip: '',
    city: ''
};
function CreateOrUpdateTaxForm({ initialValues  }) {
    var ref, ref1, ref2, ref3, ref4, ref5;
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_6__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_8__.useTranslation)();
    const { register , handleSubmit , formState: { errors  } ,  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_2__.useForm)({
        shouldUnregister: true,
        resolver: (0,_hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_9__.yupResolver)(_tax_validation_schema__WEBPACK_IMPORTED_MODULE_10__/* .taxValidationSchema */ .p),
        defaultValues: initialValues !== null && initialValues !== void 0 ? initialValues : defaultValues
    });
    const { mutate: createTaxClass , isLoading: creating  } = (0,_data_tax__WEBPACK_IMPORTED_MODULE_7__/* .useCreateTaxClassMutation */ .wo)();
    const { mutate: updateTaxClass , isLoading: updating  } = (0,_data_tax__WEBPACK_IMPORTED_MODULE_7__/* .useUpdateTaxClassMutation */ .y2)();
    const onSubmit = async (values)=>{
        if (initialValues) {
            updateTaxClass({
                id: initialValues.id,
                ...values
            });
        } else {
            createTaxClass({
                ...values
            });
        }
    };
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("form", {
        onSubmit: handleSubmit(onSubmit),
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "my-5 flex flex-wrap sm:my-8",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                        title: t('form:form-title-information'),
                        details: `${initialValues ? t('form:item-description-update') : t('form:item-description-add')} ${t('form:tax-form-info-help-text')}`,
                        className: "w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pe-4 md:w-1/3 md:pe-5 "
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_common_card__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                        className: "w-full sm:w-8/12 md:w-2/3",
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-tax-name'),
                                ...register('name', {
                                    required: 'Name is required'
                                }),
                                error: t((ref = errors.name) === null || ref === void 0 ? void 0 : ref.message),
                                variant: "outline",
                                className: "mb-5"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-tax-rate'),
                                ...register('rate'),
                                type: "number",
                                error: t((ref1 = errors.rate) === null || ref1 === void 0 ? void 0 : ref1.message),
                                variant: "outline",
                                className: "mb-5"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-country'),
                                ...register('country'),
                                error: t((ref2 = errors.country) === null || ref2 === void 0 ? void 0 : ref2.message),
                                variant: "outline",
                                className: "mb-5"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-city'),
                                ...register('city'),
                                error: t((ref3 = errors.city) === null || ref3 === void 0 ? void 0 : ref3.message),
                                variant: "outline",
                                className: "mb-5"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-state'),
                                ...register('state'),
                                error: t((ref4 = errors.state) === null || ref4 === void 0 ? void 0 : ref4.message),
                                variant: "outline",
                                className: "mb-5"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-zip'),
                                ...register('zip'),
                                error: t((ref5 = errors.zip) === null || ref5 === void 0 ? void 0 : ref5.message),
                                variant: "outline",
                                className: "mb-5"
                            })
                        ]
                    })
                ]
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "mb-4 text-end",
                children: [
                    initialValues && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                        variant: "outline",
                        onClick: router.back,
                        className: "me-4",
                        type: "button",
                        children: t('form:button-label-back')
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_ui_button__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                        loading: creating || updating,
                        children: [
                            initialValues ? t('form:button-label-update') : t('form:button-label-add'),
                            ' ',
                            t('form:button-label-tax')
                        ]
                    })
                ]
            })
        ]
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 2807:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "p": () => (/* binding */ taxValidationSchema)
/* harmony export */ });
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_0__);

const taxValidationSchema = yup__WEBPACK_IMPORTED_MODULE_0__.object().shape({
    name: yup__WEBPACK_IMPORTED_MODULE_0__.string().required('form:error-name-required'),
    rate: yup__WEBPACK_IMPORTED_MODULE_0__.number().typeError('form:error-rate-must-number').positive('form:error-rate-must-positive').integer('form:error-rate-must-integer').required('form:error-rate-required')
});


/***/ }),

/***/ 5034:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "h": () => (/* binding */ crudFactory)
/* harmony export */ });
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_0__]);
_http_client__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

function crudFactory(endpoint) {
    return {
        all (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        paginated (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        get ({ slug , language  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(`${endpoint}/${slug}`, {
                language
            });
        },
        create (data) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.post */ .eN.post(endpoint, data);
        },
        update ({ id , ...input }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.put */ .eN.put(`${endpoint}/${id}`, input);
        },
        delete ({ id  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient["delete"] */ .eN["delete"](`${endpoint}/${id}`);
        }
    };
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;