"use strict";
(() => {
var exports = {};
exports.id = 1363;
exports.ids = [1363,1384];
exports.modules = {

/***/ 30913:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_ui_table__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(40447);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(53139);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(99996);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(28379);
/* harmony import */ var _components_ui_lang_action_action__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(32361);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_ui_lang_action_action__WEBPACK_IMPORTED_MODULE_8__]);
_components_ui_lang_action_action__WEBPACK_IMPORTED_MODULE_8__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];









const AttributeList = ({ attributes , onSort , onOrder  })=>{
    var ref;
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_4__.useRouter)();
    const alignLeft = router.locale === 'ar' || router.locale === 'he' ? 'right' : 'left';
    const alignRight = router.locale === 'ar' || router.locale === 'he' ? 'left' : 'right';
    const { 0: sortingObj , 1: setSortingObj  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)({
        sort: _types__WEBPACK_IMPORTED_MODULE_3__/* .SortOrder.Desc */ .As.Desc,
        column: null
    });
    const onHeaderClick = (column)=>({
            onClick: ()=>{
                onSort((currentSortDirection)=>currentSortDirection === _types__WEBPACK_IMPORTED_MODULE_3__/* .SortOrder.Desc */ .As.Desc ? _types__WEBPACK_IMPORTED_MODULE_3__/* .SortOrder.Asc */ .As.Asc : _types__WEBPACK_IMPORTED_MODULE_3__/* .SortOrder.Desc */ .As.Desc
                );
                onOrder(column);
                setSortingObj({
                    sort: sortingObj.sort === _types__WEBPACK_IMPORTED_MODULE_3__/* .SortOrder.Desc */ .As.Desc ? _types__WEBPACK_IMPORTED_MODULE_3__/* .SortOrder.Asc */ .As.Asc : _types__WEBPACK_IMPORTED_MODULE_3__/* .SortOrder.Desc */ .As.Desc,
                    column: column
                });
            }
        })
    ;
    let columns = [
        {
            title: t('table:table-item-id'),
            dataIndex: 'id',
            key: 'id',
            align: 'center',
            width: 60
        },
        {
            // title: t("table:table-item-title"),
            title: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                title: t('table:table-item-title'),
                ascending: sortingObj.sort === _types__WEBPACK_IMPORTED_MODULE_3__/* .SortOrder.Asc */ .As.Asc && sortingObj.column === 'name',
                isActive: sortingObj.column === 'name'
            }),
            className: 'cursor-pointer',
            dataIndex: 'name',
            key: 'name',
            align: alignLeft,
            onHeaderCell: ()=>onHeaderClick('name')
            ,
            render: (name)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "whitespace-nowrap",
                    children: name
                })
        },
        {
            title: t('table:table-item-shop'),
            dataIndex: 'shop',
            key: 'shop',
            width: 180,
            align: 'center',
            ellipsis: true,
            render: (shop)=>{
                /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "truncate whitespace-nowrap",
                    children: shop === null || shop === void 0 ? void 0 : shop.name
                });
            }
        },
        {
            title: t('table:table-item-values'),
            dataIndex: 'values',
            key: 'values',
            align: alignLeft,
            render: (values)=>{
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "whitespace-nowrap",
                    children: values === null || values === void 0 ? void 0 : values.map((singleValues, index)=>{
                        return index > 0 ? `, ${singleValues.value}` : `${singleValues.value}`;
                    })
                }));
            }
        },
        {
            title: t('table:table-item-actions'),
            dataIndex: 'slug',
            key: 'actions',
            align: alignRight,
            render: (slug, record)=>{
                /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_lang_action_action__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                    slug: slug,
                    record: record,
                    deleteModalView: "DELETE_ATTRIBUTE",
                    routes: _config_routes__WEBPACK_IMPORTED_MODULE_7__/* .Routes */ .Z === null || _config_routes__WEBPACK_IMPORTED_MODULE_7__/* .Routes */ .Z === void 0 ? void 0 : _config_routes__WEBPACK_IMPORTED_MODULE_7__/* .Routes.attribute */ .Z.attribute
                });
            }
        }, 
    ];
    if (router === null || router === void 0 ? void 0 : (ref = router.query) === null || ref === void 0 ? void 0 : ref.shop) {
        columns = columns === null || columns === void 0 ? void 0 : columns.filter((column)=>{
            return (column === null || column === void 0 ? void 0 : column.key) !== 'shop';
        });
    }
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        className: "mb-8 overflow-hidden rounded shadow",
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_table__WEBPACK_IMPORTED_MODULE_2__/* .Table */ .i, {
            // @ts-ignore
            columns: columns,
            emptyText: t('table:empty-table-data'),
            data: attributes,
            rowKey: "id",
            scroll: {
                x: 380
            }
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AttributeList);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 11347:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_": () => (/* binding */ ChevronDown)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const ChevronDown = ({ color ='currentColor' , width ='14px' , height ='10px' , ...props })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        width: width,
        height: height,
        ...props,
        fill: "none",
        xmlns: "http://www.w3.org/2000/svg",
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            d: "M13.4 1.845a.91.91 0 0 0-1.613-.6L7.015 6.817l-4.771-5.57A.91.91 0 1 0 .866 2.428l5.457 6.378a.91.91 0 0 0 1.385 0l5.462-6.378a.91.91 0 0 0 .23-.583Z",
            fill: color
        })
    }));
};


/***/ }),

/***/ 90393:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "p": () => (/* binding */ PlusIcon)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const PlusIcon = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        fill: "none",
        viewBox: "0 0 24 24",
        stroke: "currentColor",
        ...props,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            strokeLinecap: "round",
            strokeLinejoin: "round",
            d: "M12 6v6m0 0v6m0-6h6m-6 0H6"
        })
    })
;


/***/ }),

/***/ 77067:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "X": () => (/* binding */ ToggleIcon),
/* harmony export */   "t": () => (/* binding */ ToggleIconVertical)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const ToggleIcon = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        ...props,
        viewBox: "0 0 20 20",
        fill: "none",
        xmlns: "http://www.w3.org/2000/svg",
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            d: "M19.268 8.232a2.5 2.5 0 1 1-3.536 3.536 2.5 2.5 0 0 1 3.536-3.536ZM11.768 8.232a2.5 2.5 0 1 1-3.536 3.536 2.5 2.5 0 0 1 3.536-3.536ZM4.268 8.232a2.5 2.5 0 1 1-3.536 3.536 2.5 2.5 0 0 1 3.536-3.536Z",
            fill: "currentColor"
        })
    })
;
const ToggleIconVertical = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        ...props,
        fill: "none",
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            fill: "currentColor",
            d: "M3 4.5a2.257 2.257 0 0 0 2.25-2.25A2.257 2.257 0 0 0 3 0 2.257 2.257 0 0 0 .75 2.25 2.257 2.257 0 0 0 3 4.5Zm0 2.25A2.257 2.257 0 0 0 .75 9 2.257 2.257 0 0 0 3 11.25 2.257 2.257 0 0 0 5.25 9 2.257 2.257 0 0 0 3 6.75Zm0 6.75a2.257 2.257 0 0 0-2.25 2.25A2.257 2.257 0 0 0 3 18a2.257 2.257 0 0 0 2.25-2.25A2.257 2.257 0 0 0 3 13.5Z"
        })
    })
;


/***/ }),

/***/ 32361:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ LanguageSwitcher)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_common_action_buttons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(53758);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(29249);
/* harmony import */ var _language_switcher__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(74675);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_config__WEBPACK_IMPORTED_MODULE_2__, _language_switcher__WEBPACK_IMPORTED_MODULE_3__]);
([_config__WEBPACK_IMPORTED_MODULE_2__, _language_switcher__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





function LanguageSwitcher({ record , slug , deleteModalView , routes , className  }) {
    const { enableMultiLang  } = _config__WEBPACK_IMPORTED_MODULE_2__/* .Config */ .D;
    const { query: { shop  } ,  } = (0,next_router__WEBPACK_IMPORTED_MODULE_4__.useRouter)();
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: enableMultiLang ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_language_switcher__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
            slug: slug,
            record: record,
            deleteModalView: deleteModalView,
            routes: routes,
            className: className
        }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_action_buttons__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
            id: record === null || record === void 0 ? void 0 : record.id,
            editUrl: routes.editWithoutLang(slug, shop),
            deleteModalView: deleteModalView
        })
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 881:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61185);
/* harmony import */ var _components_icons_chevronDownIcon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11347);
/* harmony import */ var _components_ui_link__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31434);
/* harmony import */ var _components_icons_plus_icon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(90393);
/* harmony import */ var _components_icons_edit__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(83955);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_headlessui_react__WEBPACK_IMPORTED_MODULE_3__]);
_headlessui_react__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];








const LanguageListbox = ({ title , items , translate , slug , id , routes  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_1__.useTranslation)('common');
    const { locale , query: { shop  } ,  } = (0,next_router__WEBPACK_IMPORTED_MODULE_2__.useRouter)();
    const currentSelectedItem = locale ? items === null || items === void 0 ? void 0 : items.find((o)=>{
        return (o === null || o === void 0 ? void 0 : o.value) === locale;
    }) : items[2];
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Disclosure, {
        children: ({ open  })=>{
            /*#__PURE__*/ return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                children: [
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Disclosure.Button, {
                        className: "text-left font-medium text-black w-full p-4 border-b border-solid border-[#E5E5EB] bg-white flex items-center justify-between",
                        children: [
                            title,
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                className: "text-[#8A8F9C]",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_chevronDownIcon__WEBPACK_IMPORTED_MODULE_4__/* .ChevronDown */ ._, {
                                    className: `${open ? 'rotate-180 transform origin-center' : ''} h-4 w-4`
                                })
                            })
                        ]
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Disclosure.Panel, {
                        className: "py-2",
                        children: items === null || items === void 0 ? void 0 : items.map((option, index)=>{
                            /*#__PURE__*/ return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                className: `flex items-center cursor-pointer relative px-4 py-2 transition-all hover:bg-white ${(currentSelectedItem === null || currentSelectedItem === void 0 ? void 0 : currentSelectedItem.id) === (option === null || option === void 0 ? void 0 : option.id) ? 'bg-white' : ''}`,
                                children: [
                                    option === null || option === void 0 ? void 0 : option.icon,
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                        className: "ltr:ml-3 rtl:mr-3",
                                        children: t(option === null || option === void 0 ? void 0 : option.name)
                                    }),
                                    translate === 'true' ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                        className: "ltr:ml-auto rtl:mr-auto cursor-pointer text-base transition duration-200 hover:text-heading",
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_link__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                                href: routes.edit(slug, option === null || option === void 0 ? void 0 : option.id, shop),
                                                locale: false,
                                                className: "absolute top-0 left-0 w-full h-full"
                                            }, option === null || option === void 0 ? void 0 : option.id),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_edit__WEBPACK_IMPORTED_MODULE_7__/* .EditIcon */ .d, {
                                                width: 16
                                            })
                                        ]
                                    }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                                        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                            className: "ltr:ml-auto rtl:mr-auto cursor-pointer text-base transition duration-200 hover:text-heading",
                                            children: [
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_link__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                                    href: routes.translate(slug, option === null || option === void 0 ? void 0 : option.id, shop),
                                                    locale: false,
                                                    className: "absolute top-0 left-0 w-full h-full"
                                                }, option === null || option === void 0 ? void 0 : option.id),
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_plus_icon__WEBPACK_IMPORTED_MODULE_6__/* .PlusIcon */ .p, {
                                                    width: 24
                                                })
                                            ]
                                        })
                                    })
                                ]
                            }, `language-${index}`);
                        })
                    })
                ]
            });
        }
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LanguageListbox);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 74675:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_locals__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(10601);
/* harmony import */ var _floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(91017);
/* harmony import */ var _components_common_action_buttons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(53758);
/* harmony import */ var _lang_list_box__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(881);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(29249);
/* harmony import */ var _components_ui_popover__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(85073);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__, _lang_list_box__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_8__, _components_ui_popover__WEBPACK_IMPORTED_MODULE_9__]);
([_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__, _lang_list_box__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_8__, _components_ui_popover__WEBPACK_IMPORTED_MODULE_9__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);










const LanguageSwitcher = ({ record , slug , deleteModalView , routes , className =''  })=>{
    var ref3, ref1, ref2;
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_3__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)('common');
    const { locales , locale  } = router;
    let filterItem = (ref3 = [
        ..._utils_locals__WEBPACK_IMPORTED_MODULE_4__/* .languageMenu */ .X
    ]) === null || ref3 === void 0 ? void 0 : ref3.filter((element)=>{
        return locales === null || locales === void 0 ? void 0 : locales.includes(element === null || element === void 0 ? void 0 : element.id);
    });
    let options = (ref1 = [
        ...filterItem
    ]) === null || ref1 === void 0 ? void 0 : ref1.filter((filter)=>{
        var ref;
        return !(record === null || record === void 0 ? void 0 : (ref = record.translated_languages) === null || ref === void 0 ? void 0 : ref.find((translated)=>{
            return translated === (filter === null || filter === void 0 ? void 0 : filter.value);
        }));
    });
    let filterTranslatedItem = (ref2 = [
        ..._utils_locals__WEBPACK_IMPORTED_MODULE_4__/* .languageMenu */ .X
    ]) === null || ref2 === void 0 ? void 0 : ref2.filter((element)=>{
        var ref;
        return record === null || record === void 0 ? void 0 : (ref = record.translated_languages) === null || ref === void 0 ? void 0 : ref.includes(element === null || element === void 0 ? void 0 : element.id);
    }).filter((item)=>{
        return !(locale === null || locale === void 0 ? void 0 : locale.includes(item === null || item === void 0 ? void 0 : item.id));
    });
    const { x , y , reference , floating , strategy , update , refs  } = (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.useFloating)({
        strategy: 'fixed',
        placement: 'bottom',
        middleware: [
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.offset)(20),
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.flip)(),
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.shift)()
        ]
    });
    // This one is for recalculating the position of the floating element if no space is left on the given placement
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (!refs.reference.current || !refs.floating.current) {
            return;
        }
        return (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.autoUpdate)(refs.reference.current, refs.floating.current, update);
    }, [
        refs.reference,
        refs.floating,
        update
    ]);
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: `flex w-full items-center justify-end gap-5 ${className}`,
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_action_buttons__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                id: record === null || record === void 0 ? void 0 : record.id,
                editUrl: routes.editWithoutLang(slug),
                deleteModalView: deleteModalView
            }),
            _config__WEBPACK_IMPORTED_MODULE_8__/* .Config.defaultLanguage */ .D.defaultLanguage === router.locale && // <Popover className="relative inline-block">
            //   <Popover.Button
            //     className="p-2 text-base opacity-80 transition duration-200 hover:text-heading"
            //     ref={reference}
            //   >
            //     <ToggleIcon width={20} />
            //   </Popover.Button>
            //   <div
            //     ref={floating}
            //     style={{
            //       position: strategy,
            //       top: y ?? '',
            //       left: x ?? '',
            //       zIndex: 1,
            //     }}
            //   >
            //     <Popover.Panel className="w-[18rem] max-w-[20rem] overflow-hidden rounded bg-[#F7F8F9] px-4 shadow-translatePanel sm:px-0">
            //       {options?.length ? (
            //         <LanguageListbox
            //           title={t('text-non-translated-title')}
            //           items={options}
            //           translate="false"
            //           slug={slug}
            //           id={record?.id}
            //           routes={routes}
            //         />
            //       ) : (
            //         ''
            //       )}
            //       {filterTranslatedItem?.length ? (
            //         <LanguageListbox
            //           title={t('text-translated-title')}
            //           items={filterTranslatedItem}
            //           translate="true"
            //           slug={slug}
            //           id={record?.id}
            //           routes={routes}
            //         />
            //       ) : (
            //         ''
            //       )}
            //     </Popover.Panel>
            //   </div>
            // </Popover>
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_ui_popover__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
                children: [
                    (options === null || options === void 0 ? void 0 : options.length) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_lang_list_box__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                        title: t('text-non-translated-title'),
                        items: options,
                        translate: "false",
                        slug: slug,
                        id: record === null || record === void 0 ? void 0 : record.id,
                        routes: routes
                    }) : '',
                    (filterTranslatedItem === null || filterTranslatedItem === void 0 ? void 0 : filterTranslatedItem.length) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_lang_list_box__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                        title: t('text-translated-title'),
                        items: filterTranslatedItem,
                        translate: "true",
                        slug: slug,
                        id: record === null || record === void 0 ? void 0 : record.id,
                        routes: routes
                    }) : ''
                ]
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LanguageSwitcher);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 85073:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61185);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_icons_toggle_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(77067);
/* harmony import */ var _floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(91017);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_headlessui_react__WEBPACK_IMPORTED_MODULE_2__, _floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__]);
([_headlessui_react__WEBPACK_IMPORTED_MODULE_2__, _floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






const PopOver = ({ children , popOverButtonClass , popOverPanelClass , iconStyle ='horizontal'  })=>{
    const { x , y , reference , floating , strategy , update , refs  } = (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.useFloating)({
        strategy: 'fixed',
        placement: 'bottom',
        middleware: [
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.offset)(0),
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.flip)(),
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.shift)()
        ]
    });
    // This one is for recalculating the position of the floating element if no space is left on the given placement
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (!refs.reference.current || !refs.floating.current) {
            return;
        }
        return (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.autoUpdate)(refs.reference.current, refs.floating.current, update);
    }, [
        refs.reference,
        refs.floating,
        update
    ]);
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Popover, {
        className: "relative inline-block",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Popover.Button, {
                className: classnames__WEBPACK_IMPORTED_MODULE_3___default()('p-2 text-base opacity-80 transition duration-200 hover:text-heading', popOverButtonClass),
                ref: reference,
                children: iconStyle === 'horizontal' ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_toggle_icon__WEBPACK_IMPORTED_MODULE_4__/* .ToggleIcon */ .X, {
                    width: 20
                }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_toggle_icon__WEBPACK_IMPORTED_MODULE_4__/* .ToggleIconVertical */ .t, {
                    height: 18,
                    width: 6
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                ref: floating,
                style: {
                    position: strategy,
                    top: y !== null && y !== void 0 ? y : '',
                    left: x !== null && x !== void 0 ? x : '',
                    zIndex: 1
                },
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Popover.Panel, {
                    className: classnames__WEBPACK_IMPORTED_MODULE_3___default()('w-[18rem] max-w-[20rem] overflow-hidden rounded bg-[#F7F8F9] px-4 shadow-translatePanel sm:px-0', popOverPanelClass),
                    children: children
                })
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PopOver);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 51384:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "gL": () => (/* binding */ useCreateAttributeMutation),
/* harmony export */   "uT": () => (/* binding */ useUpdateAttributeMutation),
/* harmony export */   "Oi": () => (/* binding */ useDeleteAttributeMutation),
/* harmony export */   "I1": () => (/* binding */ useAttributeQuery),
/* harmony export */   "OO": () => (/* binding */ useAttributesQuery)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28379);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85057);
/* harmony import */ var _data_client_attribute__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(48893);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(29249);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_attribute__WEBPACK_IMPORTED_MODULE_6__, _config__WEBPACK_IMPORTED_MODULE_7__]);
([_data_client_attribute__WEBPACK_IMPORTED_MODULE_6__, _config__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);








const useCreateAttributeMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_attribute__WEBPACK_IMPORTED_MODULE_6__/* .attributeClient.create */ .b.create, {
        onSuccess: ()=>{
            next_router__WEBPACK_IMPORTED_MODULE_0___default().push(_config_routes__WEBPACK_IMPORTED_MODULE_4__/* .Routes.attribute.list */ .Z.attribute.list, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_7__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.ATTRIBUTES */ .P.ATTRIBUTES);
        }
    });
};
const useUpdateAttributeMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_attribute__WEBPACK_IMPORTED_MODULE_6__/* .attributeClient.update */ .b.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.ATTRIBUTES */ .P.ATTRIBUTES);
        }
    });
};
const useDeleteAttributeMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_attribute__WEBPACK_IMPORTED_MODULE_6__/* .attributeClient["delete"] */ .b["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.ATTRIBUTES */ .P.ATTRIBUTES);
        }
    });
};
const useAttributeQuery = ({ slug , language  })=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.ATTRIBUTES */ .P.ATTRIBUTES,
        {
            slug,
            language
        }
    ], ()=>_data_client_attribute__WEBPACK_IMPORTED_MODULE_6__/* .attributeClient.get */ .b.get({
            slug,
            language
        })
    );
};
const useAttributesQuery = (params, options = {})=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.ATTRIBUTES */ .P.ATTRIBUTES,
        params
    ], ({ queryKey , pageParam  })=>_data_client_attribute__WEBPACK_IMPORTED_MODULE_6__/* .attributeClient.all */ .b.all(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true,
        ...options
    });
    return {
        attributes: data !== null && data !== void 0 ? data : [],
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 48893:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "b": () => (/* binding */ attributeClient)
/* harmony export */ });
/* harmony import */ var _data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5034);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
/* harmony import */ var _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const attributeClient = {
    ...(0,_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__/* .crudFactory */ .h)(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.ATTRIBUTES */ .P.ATTRIBUTES),
    paginated: ({ type , name , shop_id , ...params })=>{
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.ATTRIBUTES */ .P.ATTRIBUTES, {
            searchJoin: 'and',
            ...params,
            search: _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                type,
                name,
                shop_id
            })
        });
    },
    all: ({ type , name , shop_id , ...params })=>{
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.ATTRIBUTES */ .P.ATTRIBUTES, {
            searchJoin: 'and',
            ...params,
            search: _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                type,
                name,
                shop_id
            })
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5034:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "h": () => (/* binding */ crudFactory)
/* harmony export */ });
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_0__]);
_http_client__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

function crudFactory(endpoint) {
    return {
        all (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        paginated (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        get ({ slug , language  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(`${endpoint}/${slug}`, {
                language
            });
        },
        create (data) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.post */ .eN.post(endpoint, data);
        },
        update ({ id , ...input }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.put */ .eN.put(`${endpoint}/${id}`, input);
        },
        delete ({ id  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient["delete"] */ .eN["delete"](`${endpoint}/${id}`);
        }
    };
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 68705:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AttributePage),
/* harmony export */   "getStaticProps": () => (/* binding */ getStaticProps)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_common_card__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(81258);
/* harmony import */ var _components_layouts_admin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(40792);
/* harmony import */ var _components_attribute_attribute_list__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(30913);
/* harmony import */ var _components_ui_error_message__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(30110);
/* harmony import */ var _components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(47898);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(25460);
/* harmony import */ var next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(53139);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _utils_auth_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(49239);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _data_attributes__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(51384);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_layouts_admin__WEBPACK_IMPORTED_MODULE_2__, _components_attribute_attribute_list__WEBPACK_IMPORTED_MODULE_3__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_10__, _data_attributes__WEBPACK_IMPORTED_MODULE_12__]);
([_components_layouts_admin__WEBPACK_IMPORTED_MODULE_2__, _components_attribute_attribute_list__WEBPACK_IMPORTED_MODULE_3__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_10__, _data_attributes__WEBPACK_IMPORTED_MODULE_12__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);













function AttributePage() {
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_6__.useTranslation)();
    const { 0: orderBy , 1: setOrder  } = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)('created_at');
    const { 0: sortedBy , 1: setColumn  } = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)(_types__WEBPACK_IMPORTED_MODULE_8__/* .SortOrder.Desc */ .As.Desc);
    const { locale  } = (0,next_router__WEBPACK_IMPORTED_MODULE_11__.useRouter)();
    const { attributes , loading , error  } = (0,_data_attributes__WEBPACK_IMPORTED_MODULE_12__/* .useAttributesQuery */ .OO)({
        orderBy,
        sortedBy,
        language: locale
    });
    if (loading) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        text: t('common:text-loading')
    }));
    if (error) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_error_message__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
        message: error.message
    }));
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_card__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                className: "mb-8 flex flex-col items-center justify-between md:flex-row",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                    className: "mb-4 md:mb-0 md:w-1/4",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h1", {
                        className: "text-xl font-semibold text-heading",
                        children: t('common:sidebar-nav-item-attributes')
                    })
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_attribute_attribute_list__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                attributes: attributes,
                onOrder: setOrder,
                onSort: setColumn
            })
        ]
    }));
};
AttributePage.authenticate = {
    permissions: _utils_auth_utils__WEBPACK_IMPORTED_MODULE_10__/* .adminOnly */ .M$
};
AttributePage.Layout = _components_layouts_admin__WEBPACK_IMPORTED_MODULE_2__["default"];
const getStaticProps = async ({ locale  })=>({
        props: {
            ...await (0,next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_7__.serverSideTranslations)(locale, [
                'table',
                'common',
                'form'
            ])
        }
    })
;

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9677:
/***/ ((module) => {

module.exports = require("@reach/portal");

/***/ }),

/***/ 25782:
/***/ ((module) => {

module.exports = require("body-scroll-lock");

/***/ }),

/***/ 33104:
/***/ ((module) => {

module.exports = require("camelcase-keys");

/***/ }),

/***/ 59003:
/***/ ((module) => {

module.exports = require("classnames");

/***/ }),

/***/ 84802:
/***/ ((module) => {

module.exports = require("cookie");

/***/ }),

/***/ 11377:
/***/ ((module) => {

module.exports = require("next-i18next");

/***/ }),

/***/ 25460:
/***/ ((module) => {

module.exports = require("next-i18next/serverSideTranslations");

/***/ }),

/***/ 60562:
/***/ ((module) => {

module.exports = require("next/dist/server/denormalize-page-path.js");

/***/ }),

/***/ 78028:
/***/ ((module) => {

module.exports = require("next/dist/server/image-config.js");

/***/ }),

/***/ 94957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 3539:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/detect-domain-locale.js");

/***/ }),

/***/ 34014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 50744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 78524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 78020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 24964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 29565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 64365:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-middleware-regex.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 91292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 80979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 36052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 84226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 95052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 59232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 71853:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 153:
/***/ ((module) => {

module.exports = require("overlayscrollbars-react");

/***/ }),

/***/ 73345:
/***/ ((module) => {

module.exports = require("rc-table");

/***/ }),

/***/ 16689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 61175:
/***/ ((module) => {

module.exports = require("react-query");

/***/ }),

/***/ 1187:
/***/ ((module) => {

module.exports = require("react-toastify");

/***/ }),

/***/ 57139:
/***/ ((module) => {

module.exports = require("react-use/lib/useLocalStorage");

/***/ }),

/***/ 20997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 91017:
/***/ ((module) => {

module.exports = import("@floating-ui/react-dom-interactions");;

/***/ }),

/***/ 61185:
/***/ ((module) => {

module.exports = import("@headlessui/react");;

/***/ }),

/***/ 99648:
/***/ ((module) => {

module.exports = import("axios");;

/***/ }),

/***/ 66197:
/***/ ((module) => {

module.exports = import("framer-motion");;

/***/ }),

/***/ 82451:
/***/ ((module) => {

module.exports = import("jotai");;

/***/ }),

/***/ 2752:
/***/ ((module) => {

module.exports = import("jotai/utils");;

/***/ }),

/***/ 69915:
/***/ ((module) => {

module.exports = import("js-cookie");;

/***/ }),

/***/ 24281:
/***/ ((module) => {

module.exports = import("tiny-invariant");;

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [1842,16,9894,8579,3406,3691,9809,7070,601,7721,6411,9239,3605,9249,5839,8760,4602,9831,4014,7898,792,3139,4144,8243,3955,1044,2774,6229], () => (__webpack_exec__(68705)));
module.exports = __webpack_exports__;

})();