"use strict";
(() => {
var exports = {};
exports.id = 3161;
exports.ids = [3161,6229];
exports.modules = {

/***/ 28669:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_pagination__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61849);
/* harmony import */ var _components_ui_table__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(40447);
/* harmony import */ var _utils_get_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(69847);
/* harmony import */ var _components_icons_category__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(55450);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(53139);
/* harmony import */ var next_image__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(38579);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _utils_locals__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(10601);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(99996);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(28379);
/* harmony import */ var _components_ui_lang_action_action__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(32361);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_ui_lang_action_action__WEBPACK_IMPORTED_MODULE_12__]);
_components_ui_lang_action_action__WEBPACK_IMPORTED_MODULE_12__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];













const CategoryList = ({ categories , paginatorInfo , onPagination , onSort , onOrder  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_7__.useTranslation)();
    const rowExpandable = (record)=>{
        var ref;
        return (ref = record.children) === null || ref === void 0 ? void 0 : ref.length;
    };
    const { alignLeft , alignRight  } = (0,_utils_locals__WEBPACK_IMPORTED_MODULE_8__/* .useIsRTL */ .S)();
    const { 0: sortingObj , 1: setSortingObj  } = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)({
        sort: _types__WEBPACK_IMPORTED_MODULE_5__/* .SortOrder.Desc */ .As.Desc,
        column: null
    });
    const onHeaderClick = (column)=>({
            onClick: ()=>{
                onSort((currentSortDirection)=>currentSortDirection === _types__WEBPACK_IMPORTED_MODULE_5__/* .SortOrder.Desc */ .As.Desc ? _types__WEBPACK_IMPORTED_MODULE_5__/* .SortOrder.Asc */ .As.Asc : _types__WEBPACK_IMPORTED_MODULE_5__/* .SortOrder.Desc */ .As.Desc
                );
                onOrder(column);
                setSortingObj({
                    sort: sortingObj.sort === _types__WEBPACK_IMPORTED_MODULE_5__/* .SortOrder.Desc */ .As.Desc ? _types__WEBPACK_IMPORTED_MODULE_5__/* .SortOrder.Asc */ .As.Asc : _types__WEBPACK_IMPORTED_MODULE_5__/* .SortOrder.Desc */ .As.Desc,
                    column: column
                });
            }
        })
    ;
    const columns = [
        {
            title: t('table:table-item-id'),
            dataIndex: 'id',
            key: 'id',
            align: alignLeft,
            width: 60
        },
        {
            title: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z, {
                title: t('table:table-item-title'),
                ascending: sortingObj.sort === _types__WEBPACK_IMPORTED_MODULE_5__/* .SortOrder.Asc */ .As.Asc && sortingObj.column === 'name',
                isActive: sortingObj.column === 'name'
            }),
            className: 'cursor-pointer',
            dataIndex: 'name',
            key: 'name',
            align: alignLeft,
            width: 90,
            onHeaderCell: ()=>onHeaderClick('name')
        },
        {
            title: t('table:table-item-details'),
            dataIndex: 'details',
            key: 'details',
            ellipsis: true,
            align: alignLeft,
            width: 200
        },
        {
            title: t('table:table-item-image'),
            dataIndex: 'image',
            key: 'image',
            align: 'center',
            width: 100,
            render: (image1)=>{
                if (!(image1 === null || image1 === void 0 ? void 0 : image1.length)) return null;
                var ref;
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                    className: "flex flex-row items-center justify-center gap-x-2",
                    children: image1 === null || image1 === void 0 ? void 0 : image1.map((image, index)=>{
                        /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(next_image__WEBPACK_IMPORTED_MODULE_6__["default"], {
                            src: (ref = image === null || image === void 0 ? void 0 : image.original) !== null && ref !== void 0 ? ref : '/',
                            alt: `brand-image-${image.id}`,
                            layout: "fixed",
                            width: 40,
                            height: 40,
                            className: "overflow-hidden rounded-lg bg-gray-300 object-contain"
                        }, `brand-image-${index}`);
                    })
                }));
            }
        },
        {
            title: t('table:table-item-banner-image'),
            dataIndex: 'banner_image',
            key: 'banner_image',
            align: 'center',
            width: 140,
            render: (banner_image)=>{
                if (!(banner_image === null || banner_image === void 0 ? void 0 : banner_image.length)) return null;
                var ref;
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                    className: "flex flex-row items-center justify-center gap-x-2",
                    children: banner_image && banner_image.map((image, index)=>{
                        /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(next_image__WEBPACK_IMPORTED_MODULE_6__["default"], {
                            src: (ref = image === null || image === void 0 ? void 0 : image.original) !== null && ref !== void 0 ? ref : '/',
                            alt: `brand-image-${image.id}`,
                            layout: "fixed",
                            width: 40,
                            height: 40,
                            className: "overflow-hidden rounded-lg bg-gray-300 object-contain"
                        }, `brand-image-${index}`);
                    })
                }));
            }
        },
        {
            title: t('table:table-item-icon'),
            dataIndex: 'icon',
            key: 'icon',
            align: 'center',
            width: 120,
            render: (icon)=>{
                if (!icon) return null;
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "flex items-center justify-center",
                    children: (0,_utils_get_icon__WEBPACK_IMPORTED_MODULE_3__/* .getIcon */ .q)({
                        iconList: _components_icons_category__WEBPACK_IMPORTED_MODULE_4__,
                        iconName: icon,
                        className: 'w-5 h-5 max-h-full max-w-full'
                    })
                }));
            }
        },
        {
            title: t('table:table-item-slug'),
            dataIndex: 'slug',
            key: 'slug',
            align: alignLeft,
            ellipsis: true,
            width: 50,
            render: (slug)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                    className: "overflow-hidden truncate whitespace-nowrap",
                    title: slug,
                    children: slug
                })
        },
        // {
        //   title: t('table:table-item-group'),
        //   dataIndex: 'type',
        //   key: 'type',
        //   align: 'center',
        //   width: 120,
        //   render: (type: any) => (
        //     <div
        //       className="overflow-hidden truncate whitespace-nowrap"
        //       title={type?.name}
        //     >
        //       {type?.name}
        //     </div>
        //   ),
        // },
        {
            title: t('table:table-item-actions'),
            dataIndex: 'slug',
            key: 'actions',
            align: alignRight,
            width: 90,
            render: (slug, record)=>{
                /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_lang_action_action__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Z, {
                    slug: slug,
                    record: record,
                    deleteModalView: "DELETE_CATEGORY",
                    routes: _config_routes__WEBPACK_IMPORTED_MODULE_11__/* .Routes */ .Z === null || _config_routes__WEBPACK_IMPORTED_MODULE_11__/* .Routes */ .Z === void 0 ? void 0 : _config_routes__WEBPACK_IMPORTED_MODULE_11__/* .Routes.category */ .Z.category
                });
            }
        }, 
    ];
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "mb-6 overflow-hidden rounded shadow",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_table__WEBPACK_IMPORTED_MODULE_2__/* .Table */ .i, {
                    //@ts-ignore
                    columns: columns,
                    emptyText: t('table:empty-table-data'),
                    data: categories,
                    rowKey: "id",
                    scroll: {
                        x: 1000
                    },
                    expandable: {
                        expandedRowRender: ()=>''
                        ,
                        rowExpandable: rowExpandable
                    }
                })
            }),
            !!(paginatorInfo === null || paginatorInfo === void 0 ? void 0 : paginatorInfo.total) && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "flex items-center justify-end",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_pagination__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                    total: paginatorInfo.total,
                    current: paginatorInfo.currentPage,
                    pageSize: paginatorInfo.perPage,
                    onChange: onPagination
                })
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CategoryList);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 34423:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ TypeFilter)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_select_select__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26798);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _data_type__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(98077);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_type__WEBPACK_IMPORTED_MODULE_5__]);
_data_type__WEBPACK_IMPORTED_MODULE_5__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







function TypeFilter({ onTypeFilter , className  }) {
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const { locale  } = (0,next_router__WEBPACK_IMPORTED_MODULE_6__.useRouter)();
    const { types , loading  } = (0,_data_type__WEBPACK_IMPORTED_MODULE_5__/* .useTypesQuery */ .qs)({
        language: locale
    });
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        className: classnames__WEBPACK_IMPORTED_MODULE_4___default()('flex w-full', className),
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
            className: "w-full",
            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_select_select__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                options: types,
                isLoading: loading,
                getOptionLabel: (option)=>option.name
                ,
                getOptionValue: (option)=>option.slug
                ,
                placeholder: t('common:filter-by-group-placeholder'),
                onChange: onTypeFilter
            })
        })
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 81258:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);


const Card = ({ className , ...props })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('p-5 md:p-8 bg-light shadow rounded', className),
        ...props
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Card);


/***/ }),

/***/ 75737:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_icons_close_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29581);
/* harmony import */ var _components_icons_search_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(44066);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(45641);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_hook_form__WEBPACK_IMPORTED_MODULE_5__]);
react_hook_form__WEBPACK_IMPORTED_MODULE_5__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







const classes = {
    root: 'ps-10 pe-4 h-12 flex items-center w-full rounded appearance-none transition duration-300 ease-in-out text-heading text-sm focus:outline-none focus:ring-0',
    normal: 'bg-gray-100 border border-border-base focus:shadow focus:bg-light focus:border-accent',
    solid: 'bg-gray-100 border border-border-100 focus:bg-light focus:border-accent',
    outline: 'border border-border-base focus:border-accent',
    shadow: 'focus:shadow'
};
const Search = ({ className , onSearch , variant ='outline' , shadow =false , inputClassName , ...rest })=>{
    const { register , handleSubmit , watch , reset , formState: { errors  } ,  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_5__.useForm)({
        defaultValues: {
            searchText: ''
        }
    });
    const searchText = watch('searchText');
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_6__.useTranslation)();
    (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(()=>{
        if (!searchText) {
            onSearch({
                searchText: ''
            });
        }
    }, [
        searchText
    ]);
    const rootClassName = classnames__WEBPACK_IMPORTED_MODULE_3___default()(classes.root, {
        [classes.normal]: variant === 'normal',
        [classes.solid]: variant === 'solid',
        [classes.outline]: variant === 'outline'
    }, {
        [classes.shadow]: shadow
    }, inputClassName);
    function clear() {
        reset();
        onSearch({
            searchText: ''
        });
    }
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("form", {
        noValidate: true,
        role: "search",
        className: classnames__WEBPACK_IMPORTED_MODULE_3___default()('relative flex w-full items-center', className),
        onSubmit: handleSubmit(onSearch),
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
                htmlFor: "search",
                className: "sr-only",
                children: t('form:input-label-search')
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                className: "start-1 absolute p-2 text-body outline-none focus:outline-none active:outline-none",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_search_icon__WEBPACK_IMPORTED_MODULE_2__/* .SearchIcon */ .W, {
                    className: "h-5 w-5"
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                type: "text",
                id: "search",
                ...register('searchText'),
                className: rootClassName,
                placeholder: t('form:input-placeholder-search'),
                "aria-label": "Search",
                autoComplete: "off",
                ...rest
            }),
            errors.searchText && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                children: errors.searchText.message
            }),
            !!searchText && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                type: "button",
                onClick: clear,
                className: "end-1 absolute p-2 text-body outline-none focus:outline-none active:outline-none",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_close_icon__WEBPACK_IMPORTED_MODULE_1__/* .CloseIcon */ .T, {
                    className: "h-5 w-5"
                })
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Search);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 11347:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_": () => (/* binding */ ChevronDown)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const ChevronDown = ({ color ='currentColor' , width ='14px' , height ='10px' , ...props })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        width: width,
        height: height,
        ...props,
        fill: "none",
        xmlns: "http://www.w3.org/2000/svg",
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            d: "M13.4 1.845a.91.91 0 0 0-1.613-.6L7.015 6.817l-4.771-5.57A.91.91 0 1 0 .866 2.428l5.457 6.378a.91.91 0 0 0 1.385 0l5.462-6.378a.91.91 0 0 0 .23-.583Z",
            fill: color
        })
    }));
};


/***/ }),

/***/ 90393:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "p": () => (/* binding */ PlusIcon)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const PlusIcon = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        fill: "none",
        viewBox: "0 0 24 24",
        stroke: "currentColor",
        ...props,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            strokeLinecap: "round",
            strokeLinejoin: "round",
            d: "M12 6v6m0 0v6m0-6h6m-6 0H6"
        })
    })
;


/***/ }),

/***/ 44066:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "W": () => (/* binding */ SearchIcon)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SearchIcon = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        stroke: "currentColor",
        ...props,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeWidth: 2,
            d: "M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"
        })
    })
;


/***/ }),

/***/ 77067:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "X": () => (/* binding */ ToggleIcon),
/* harmony export */   "t": () => (/* binding */ ToggleIconVertical)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const ToggleIcon = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        ...props,
        viewBox: "0 0 20 20",
        fill: "none",
        xmlns: "http://www.w3.org/2000/svg",
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            d: "M19.268 8.232a2.5 2.5 0 1 1-3.536 3.536 2.5 2.5 0 0 1 3.536-3.536ZM11.768 8.232a2.5 2.5 0 1 1-3.536 3.536 2.5 2.5 0 0 1 3.536-3.536ZM4.268 8.232a2.5 2.5 0 1 1-3.536 3.536 2.5 2.5 0 0 1 3.536-3.536Z",
            fill: "currentColor"
        })
    })
;
const ToggleIconVertical = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        ...props,
        fill: "none",
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            fill: "currentColor",
            d: "M3 4.5a2.257 2.257 0 0 0 2.25-2.25A2.257 2.257 0 0 0 3 0 2.257 2.257 0 0 0 .75 2.25 2.257 2.257 0 0 0 3 4.5Zm0 2.25A2.257 2.257 0 0 0 .75 9 2.257 2.257 0 0 0 3 11.25 2.257 2.257 0 0 0 5.25 9 2.257 2.257 0 0 0 3 6.75Zm0 6.75a2.257 2.257 0 0 0-2.25 2.25A2.257 2.257 0 0 0 3 18a2.257 2.257 0 0 0 2.25-2.25A2.257 2.257 0 0 0 3 13.5Z"
        })
    })
;


/***/ }),

/***/ 32361:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ LanguageSwitcher)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_common_action_buttons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(53758);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(29249);
/* harmony import */ var _language_switcher__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(74675);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_config__WEBPACK_IMPORTED_MODULE_2__, _language_switcher__WEBPACK_IMPORTED_MODULE_3__]);
([_config__WEBPACK_IMPORTED_MODULE_2__, _language_switcher__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





function LanguageSwitcher({ record , slug , deleteModalView , routes , className  }) {
    const { enableMultiLang  } = _config__WEBPACK_IMPORTED_MODULE_2__/* .Config */ .D;
    const { query: { shop  } ,  } = (0,next_router__WEBPACK_IMPORTED_MODULE_4__.useRouter)();
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: enableMultiLang ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_language_switcher__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
            slug: slug,
            record: record,
            deleteModalView: deleteModalView,
            routes: routes,
            className: className
        }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_action_buttons__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
            id: record === null || record === void 0 ? void 0 : record.id,
            editUrl: routes.editWithoutLang(slug, shop),
            deleteModalView: deleteModalView
        })
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 881:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61185);
/* harmony import */ var _components_icons_chevronDownIcon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11347);
/* harmony import */ var _components_ui_link__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31434);
/* harmony import */ var _components_icons_plus_icon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(90393);
/* harmony import */ var _components_icons_edit__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(83955);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_headlessui_react__WEBPACK_IMPORTED_MODULE_3__]);
_headlessui_react__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];








const LanguageListbox = ({ title , items , translate , slug , id , routes  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_1__.useTranslation)('common');
    const { locale , query: { shop  } ,  } = (0,next_router__WEBPACK_IMPORTED_MODULE_2__.useRouter)();
    const currentSelectedItem = locale ? items === null || items === void 0 ? void 0 : items.find((o)=>{
        return (o === null || o === void 0 ? void 0 : o.value) === locale;
    }) : items[2];
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Disclosure, {
        children: ({ open  })=>{
            /*#__PURE__*/ return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                children: [
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Disclosure.Button, {
                        className: "text-left font-medium text-black w-full p-4 border-b border-solid border-[#E5E5EB] bg-white flex items-center justify-between",
                        children: [
                            title,
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                className: "text-[#8A8F9C]",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_chevronDownIcon__WEBPACK_IMPORTED_MODULE_4__/* .ChevronDown */ ._, {
                                    className: `${open ? 'rotate-180 transform origin-center' : ''} h-4 w-4`
                                })
                            })
                        ]
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Disclosure.Panel, {
                        className: "py-2",
                        children: items === null || items === void 0 ? void 0 : items.map((option, index)=>{
                            /*#__PURE__*/ return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                className: `flex items-center cursor-pointer relative px-4 py-2 transition-all hover:bg-white ${(currentSelectedItem === null || currentSelectedItem === void 0 ? void 0 : currentSelectedItem.id) === (option === null || option === void 0 ? void 0 : option.id) ? 'bg-white' : ''}`,
                                children: [
                                    option === null || option === void 0 ? void 0 : option.icon,
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                        className: "ltr:ml-3 rtl:mr-3",
                                        children: t(option === null || option === void 0 ? void 0 : option.name)
                                    }),
                                    translate === 'true' ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                        className: "ltr:ml-auto rtl:mr-auto cursor-pointer text-base transition duration-200 hover:text-heading",
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_link__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                                href: routes.edit(slug, option === null || option === void 0 ? void 0 : option.id, shop),
                                                locale: false,
                                                className: "absolute top-0 left-0 w-full h-full"
                                            }, option === null || option === void 0 ? void 0 : option.id),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_edit__WEBPACK_IMPORTED_MODULE_7__/* .EditIcon */ .d, {
                                                width: 16
                                            })
                                        ]
                                    }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                                        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                            className: "ltr:ml-auto rtl:mr-auto cursor-pointer text-base transition duration-200 hover:text-heading",
                                            children: [
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_link__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                                    href: routes.translate(slug, option === null || option === void 0 ? void 0 : option.id, shop),
                                                    locale: false,
                                                    className: "absolute top-0 left-0 w-full h-full"
                                                }, option === null || option === void 0 ? void 0 : option.id),
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_plus_icon__WEBPACK_IMPORTED_MODULE_6__/* .PlusIcon */ .p, {
                                                    width: 24
                                                })
                                            ]
                                        })
                                    })
                                ]
                            }, `language-${index}`);
                        })
                    })
                ]
            });
        }
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LanguageListbox);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 74675:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_locals__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(10601);
/* harmony import */ var _floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(91017);
/* harmony import */ var _components_common_action_buttons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(53758);
/* harmony import */ var _lang_list_box__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(881);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(29249);
/* harmony import */ var _components_ui_popover__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(85073);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__, _lang_list_box__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_8__, _components_ui_popover__WEBPACK_IMPORTED_MODULE_9__]);
([_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__, _lang_list_box__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_8__, _components_ui_popover__WEBPACK_IMPORTED_MODULE_9__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);










const LanguageSwitcher = ({ record , slug , deleteModalView , routes , className =''  })=>{
    var ref3, ref1, ref2;
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_3__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)('common');
    const { locales , locale  } = router;
    let filterItem = (ref3 = [
        ..._utils_locals__WEBPACK_IMPORTED_MODULE_4__/* .languageMenu */ .X
    ]) === null || ref3 === void 0 ? void 0 : ref3.filter((element)=>{
        return locales === null || locales === void 0 ? void 0 : locales.includes(element === null || element === void 0 ? void 0 : element.id);
    });
    let options = (ref1 = [
        ...filterItem
    ]) === null || ref1 === void 0 ? void 0 : ref1.filter((filter)=>{
        var ref;
        return !(record === null || record === void 0 ? void 0 : (ref = record.translated_languages) === null || ref === void 0 ? void 0 : ref.find((translated)=>{
            return translated === (filter === null || filter === void 0 ? void 0 : filter.value);
        }));
    });
    let filterTranslatedItem = (ref2 = [
        ..._utils_locals__WEBPACK_IMPORTED_MODULE_4__/* .languageMenu */ .X
    ]) === null || ref2 === void 0 ? void 0 : ref2.filter((element)=>{
        var ref;
        return record === null || record === void 0 ? void 0 : (ref = record.translated_languages) === null || ref === void 0 ? void 0 : ref.includes(element === null || element === void 0 ? void 0 : element.id);
    }).filter((item)=>{
        return !(locale === null || locale === void 0 ? void 0 : locale.includes(item === null || item === void 0 ? void 0 : item.id));
    });
    const { x , y , reference , floating , strategy , update , refs  } = (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.useFloating)({
        strategy: 'fixed',
        placement: 'bottom',
        middleware: [
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.offset)(20),
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.flip)(),
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.shift)()
        ]
    });
    // This one is for recalculating the position of the floating element if no space is left on the given placement
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (!refs.reference.current || !refs.floating.current) {
            return;
        }
        return (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.autoUpdate)(refs.reference.current, refs.floating.current, update);
    }, [
        refs.reference,
        refs.floating,
        update
    ]);
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: `flex w-full items-center justify-end gap-5 ${className}`,
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_action_buttons__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                id: record === null || record === void 0 ? void 0 : record.id,
                editUrl: routes.editWithoutLang(slug),
                deleteModalView: deleteModalView
            }),
            _config__WEBPACK_IMPORTED_MODULE_8__/* .Config.defaultLanguage */ .D.defaultLanguage === router.locale && // <Popover className="relative inline-block">
            //   <Popover.Button
            //     className="p-2 text-base opacity-80 transition duration-200 hover:text-heading"
            //     ref={reference}
            //   >
            //     <ToggleIcon width={20} />
            //   </Popover.Button>
            //   <div
            //     ref={floating}
            //     style={{
            //       position: strategy,
            //       top: y ?? '',
            //       left: x ?? '',
            //       zIndex: 1,
            //     }}
            //   >
            //     <Popover.Panel className="w-[18rem] max-w-[20rem] overflow-hidden rounded bg-[#F7F8F9] px-4 shadow-translatePanel sm:px-0">
            //       {options?.length ? (
            //         <LanguageListbox
            //           title={t('text-non-translated-title')}
            //           items={options}
            //           translate="false"
            //           slug={slug}
            //           id={record?.id}
            //           routes={routes}
            //         />
            //       ) : (
            //         ''
            //       )}
            //       {filterTranslatedItem?.length ? (
            //         <LanguageListbox
            //           title={t('text-translated-title')}
            //           items={filterTranslatedItem}
            //           translate="true"
            //           slug={slug}
            //           id={record?.id}
            //           routes={routes}
            //         />
            //       ) : (
            //         ''
            //       )}
            //     </Popover.Panel>
            //   </div>
            // </Popover>
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_ui_popover__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
                children: [
                    (options === null || options === void 0 ? void 0 : options.length) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_lang_list_box__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                        title: t('text-non-translated-title'),
                        items: options,
                        translate: "false",
                        slug: slug,
                        id: record === null || record === void 0 ? void 0 : record.id,
                        routes: routes
                    }) : '',
                    (filterTranslatedItem === null || filterTranslatedItem === void 0 ? void 0 : filterTranslatedItem.length) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_lang_list_box__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                        title: t('text-translated-title'),
                        items: filterTranslatedItem,
                        translate: "true",
                        slug: slug,
                        id: record === null || record === void 0 ? void 0 : record.id,
                        routes: routes
                    }) : ''
                ]
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LanguageSwitcher);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 61849:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ pagination)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
// EXTERNAL MODULE: external "rc-pagination"
var external_rc_pagination_ = __webpack_require__(73006);
var external_rc_pagination_default = /*#__PURE__*/__webpack_require__.n(external_rc_pagination_);
;// CONCATENATED MODULE: ./src/components/icons/arrow-next.tsx

const ArrowNext = ({ ...props })=>{
    return(/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 512 512",
        width: "20",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            d: "M294.1 256L167 129c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.3 34 0L345 239c9.1 9.1 9.3 23.7.7 33.1L201.1 417c-4.7 4.7-10.9 7-17 7s-12.3-2.3-17-7c-9.4-9.4-9.4-24.6 0-33.9l127-127.1z",
            fill: "currentColor",
            stroke: "currentColor"
        })
    }));
};

;// CONCATENATED MODULE: ./src/components/icons/arrow-prev.tsx

const ArrowPrev = ({ ...props })=>{
    return(/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 512 512",
        width: "20",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            d: "M217.9 256L345 129c9.4-9.4 9.4-24.6 0-33.9-9.4-9.4-24.6-9.3-34 0L167 239c-9.1 9.1-9.3 23.7-.7 33.1L310.9 417c4.7 4.7 10.9 7 17 7s12.3-2.3 17-7c9.4-9.4 9.4-24.6 0-33.9L217.9 256z",
            fill: "currentColor",
            stroke: "currentColor"
        })
    }));
};

;// CONCATENATED MODULE: ./src/components/ui/pagination.tsx





const Pagination = (props)=>{
    return(/*#__PURE__*/ jsx_runtime_.jsx((external_rc_pagination_default()), {
        nextIcon: /*#__PURE__*/ jsx_runtime_.jsx(ArrowNext, {}),
        prevIcon: /*#__PURE__*/ jsx_runtime_.jsx(ArrowPrev, {}),
        ...props
    }));
};
/* harmony default export */ const pagination = (Pagination);


/***/ }),

/***/ 85073:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61185);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_icons_toggle_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(77067);
/* harmony import */ var _floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(91017);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_headlessui_react__WEBPACK_IMPORTED_MODULE_2__, _floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__]);
([_headlessui_react__WEBPACK_IMPORTED_MODULE_2__, _floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






const PopOver = ({ children , popOverButtonClass , popOverPanelClass , iconStyle ='horizontal'  })=>{
    const { x , y , reference , floating , strategy , update , refs  } = (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.useFloating)({
        strategy: 'fixed',
        placement: 'bottom',
        middleware: [
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.offset)(0),
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.flip)(),
            (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.shift)()
        ]
    });
    // This one is for recalculating the position of the floating element if no space is left on the given placement
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (!refs.reference.current || !refs.floating.current) {
            return;
        }
        return (0,_floating_ui_react_dom_interactions__WEBPACK_IMPORTED_MODULE_5__.autoUpdate)(refs.reference.current, refs.floating.current, update);
    }, [
        refs.reference,
        refs.floating,
        update
    ]);
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Popover, {
        className: "relative inline-block",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Popover.Button, {
                className: classnames__WEBPACK_IMPORTED_MODULE_3___default()('p-2 text-base opacity-80 transition duration-200 hover:text-heading', popOverButtonClass),
                ref: reference,
                children: iconStyle === 'horizontal' ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_toggle_icon__WEBPACK_IMPORTED_MODULE_4__/* .ToggleIcon */ .X, {
                    width: 20
                }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_toggle_icon__WEBPACK_IMPORTED_MODULE_4__/* .ToggleIconVertical */ .t, {
                    height: 18,
                    width: 6
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                ref: floating,
                style: {
                    position: strategy,
                    top: y !== null && y !== void 0 ? y : '',
                    left: x !== null && x !== void 0 ? x : '',
                    zIndex: 1
                },
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Popover.Panel, {
                    className: classnames__WEBPACK_IMPORTED_MODULE_3___default()('w-[18rem] max-w-[20rem] overflow-hidden rounded bg-[#F7F8F9] px-4 shadow-translatePanel sm:px-0', popOverPanelClass),
                    children: children
                })
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PopOver);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 26798:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* unused harmony export Select */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_locals__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10601);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_select__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61929);
/* harmony import */ var react_select__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_select__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _select_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(76302);





const Select = /*#__PURE__*/ react__WEBPACK_IMPORTED_MODULE_2___default().forwardRef((props, ref)=>{
    const { isRTL  } = (0,_utils_locals__WEBPACK_IMPORTED_MODULE_1__/* .useIsRTL */ .S)();
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((react_select__WEBPACK_IMPORTED_MODULE_3___default()), {
        ref: ref,
        styles: _select_styles__WEBPACK_IMPORTED_MODULE_4__/* .selectStyles */ .X,
        isRtl: isRTL,
        ...props
    }));
});
Select.displayName = 'Select';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Select);


/***/ }),

/***/ 99996:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ title_with_sort)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
// EXTERNAL MODULE: external "classnames"
var external_classnames_ = __webpack_require__(59003);
var external_classnames_default = /*#__PURE__*/__webpack_require__.n(external_classnames_);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(16689);
;// CONCATENATED MODULE: ./src/components/icons/triangle-arrow-down.tsx


const TriangleArrowDown = (props)=>/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 123.959 123.958",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            d: "M117.979 28.017h-112c-5.3 0-8 6.4-4.2 10.2l56 56c2.3 2.3 6.1 2.3 8.401 0l56-56c3.799-3.8 1.099-10.2-4.201-10.2z",
            fill: "currentColor"
        })
    })
;

;// CONCATENATED MODULE: ./src/components/icons/triangle-arrow-up.tsx

const TriangleArrowUp = (props)=>/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 123.959 123.959",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            d: "M66.18 29.742c-2.301-2.3-6.101-2.3-8.401 0l-56 56c-3.8 3.801-1.1 10.2 4.2 10.2h112c5.3 0 8-6.399 4.2-10.2l-55.999-56z",
            fill: "currentColor"
        })
    })
;

;// CONCATENATED MODULE: ./src/components/ui/title-with-sort.tsx




const TitleWithSort = ({ title , ascending , isActive =true  })=>{
    return(/*#__PURE__*/ (0,jsx_runtime_.jsxs)("span", {
        className: "inline-flex items-center",
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx("span", {
                children: title
            }),
            ascending ? /*#__PURE__*/ jsx_runtime_.jsx(TriangleArrowUp, {
                width: "9",
                className: external_classnames_default()('ms-1.5 flex-shrink-0 text-gray-300', {
                    '!text-heading': isActive
                })
            }) : /*#__PURE__*/ jsx_runtime_.jsx(TriangleArrowDown, {
                width: "9",
                className: external_classnames_default()('ms-1.5 flex-shrink-0 text-gray-300', {
                    '!text-heading': isActive
                })
            })
        ]
    }));
};
/* harmony default export */ const title_with_sort = (TitleWithSort);


/***/ }),

/***/ 8580:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "m7": () => (/* binding */ useCreateCategoryMutation),
/* harmony export */   "l8": () => (/* binding */ useDeleteCategoryMutation),
/* harmony export */   "pi": () => (/* binding */ useUpdateCategoryMutation),
/* harmony export */   "Im": () => (/* binding */ useCategoryQuery),
/* harmony export */   "Ei": () => (/* binding */ useCategoriesQuery)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28379);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85057);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63354);
/* harmony import */ var _client_category__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(76105);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(29249);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_category__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_8__]);
([_client_category__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const useCreateCategoryMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_category__WEBPACK_IMPORTED_MODULE_7__/* .categoryClient.create */ .X.create, {
        onSuccess: ()=>{
            next_router__WEBPACK_IMPORTED_MODULE_0___default().push(_config_routes__WEBPACK_IMPORTED_MODULE_4__/* .Routes.category.list */ .Z.category.list, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_8__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES);
        }
    });
};
const useDeleteCategoryMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_category__WEBPACK_IMPORTED_MODULE_7__/* .categoryClient["delete"] */ .X["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES);
        }
    });
};
const useUpdateCategoryMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_client_category__WEBPACK_IMPORTED_MODULE_7__/* .categoryClient.update */ .X.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES);
        }
    });
};
const useCategoryQuery = ({ slug , language  })=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES,
        {
            slug,
            language
        }
    ], ()=>_client_category__WEBPACK_IMPORTED_MODULE_7__/* .categoryClient.get */ .X.get({
            slug,
            language
        })
    );
    return {
        category: data,
        error,
        isLoading
    };
};
const useCategoriesQuery = (options)=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES,
        options
    ], ({ queryKey , pageParam  })=>_client_category__WEBPACK_IMPORTED_MODULE_7__/* .categoryClient.paginated */ .X.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    var ref;
    return {
        categories: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__/* .mapPaginatorData */ .Q)(data),
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 76105:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "X": () => (/* binding */ categoryClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5034);
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const categoryClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_1__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES),
    paginated: ({ type , name , ...params })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.CATEGORIES */ .P.CATEGORIES, {
            searchJoin: 'and',
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                type,
                name
            })
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4372:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "A": () => (/* binding */ typeClient)
/* harmony export */ });
/* harmony import */ var _data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5034);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
/* harmony import */ var _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const typeClient = {
    ...(0,_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__/* .crudFactory */ .h)(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.TYPES */ .P.TYPES),
    all: ({ name , ...params })=>{
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.TYPES */ .P.TYPES, {
            searchJoin: 'and',
            ...params,
            search: _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                name
            })
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 98077:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "jT": () => (/* binding */ useCreateTypeMutation),
/* harmony export */   "e7": () => (/* binding */ useDeleteTypeMutation),
/* harmony export */   "oy": () => (/* binding */ useUpdateTypeMutation),
/* harmony export */   "F2": () => (/* binding */ useTypeQuery),
/* harmony export */   "qs": () => (/* binding */ useTypesQuery)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28379);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85057);
/* harmony import */ var _data_client_type__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4372);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(29249);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(63354);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_type__WEBPACK_IMPORTED_MODULE_6__, _config__WEBPACK_IMPORTED_MODULE_7__]);
([_data_client_type__WEBPACK_IMPORTED_MODULE_6__, _config__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const useCreateTypeMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient.create */ .A.create, {
        onSuccess: ()=>{
            next_router__WEBPACK_IMPORTED_MODULE_0___default().push(_config_routes__WEBPACK_IMPORTED_MODULE_4__/* .Routes.type.list */ .Z.type.list, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_7__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES);
        }
    });
};
const useDeleteTypeMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient["delete"] */ .A["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES);
        }
    });
};
const useUpdateTypeMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient.update */ .A.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES);
        }
    });
};
const useTypeQuery = ({ slug , language  })=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES,
        {
            slug,
            language
        }
    ], ()=>_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient.get */ .A.get({
            slug,
            language
        })
    );
    return {
        type: data,
        error,
        isLoading
    };
};
const useTypesQuery = (options)=>{
    const { data , isLoading , error  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES,
        options
    ], ({ queryKey , pageParam  })=>_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient.paginated */ .A.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    var ref;
    return {
        types: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_8__/* .mapPaginatorData */ .Q)(data),
        loading: isLoading,
        error
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 69632:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Categories),
/* harmony export */   "getStaticProps": () => (/* binding */ getStaticProps)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_category_category_list__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28669);
/* harmony import */ var _components_common_card__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(81258);
/* harmony import */ var _components_layouts_admin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(40792);
/* harmony import */ var _components_common_search__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(75737);
/* harmony import */ var _components_ui_link_button__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2171);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _components_ui_error_message__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(30110);
/* harmony import */ var _components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(47898);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(53139);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(25460);
/* harmony import */ var next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(28379);
/* harmony import */ var _components_category_type_filter__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(34423);
/* harmony import */ var _utils_auth_utils__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(49239);
/* harmony import */ var _data_category__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(8580);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(29249);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_category_category_list__WEBPACK_IMPORTED_MODULE_1__, _components_layouts_admin__WEBPACK_IMPORTED_MODULE_3__, _components_common_search__WEBPACK_IMPORTED_MODULE_4__, _components_category_type_filter__WEBPACK_IMPORTED_MODULE_13__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_14__, _data_category__WEBPACK_IMPORTED_MODULE_15__, _config__WEBPACK_IMPORTED_MODULE_17__]);
([_components_category_category_list__WEBPACK_IMPORTED_MODULE_1__, _components_layouts_admin__WEBPACK_IMPORTED_MODULE_3__, _components_common_search__WEBPACK_IMPORTED_MODULE_4__, _components_category_type_filter__WEBPACK_IMPORTED_MODULE_13__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_14__, _data_category__WEBPACK_IMPORTED_MODULE_15__, _config__WEBPACK_IMPORTED_MODULE_17__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);


















function Categories() {
    const { locale  } = (0,next_router__WEBPACK_IMPORTED_MODULE_16__.useRouter)();
    const { 0: searchTerm , 1: setSearchTerm  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)('');
    const { 0: type , 1: setType  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)('');
    const { 0: page , 1: setPage  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(1);
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_10__.useTranslation)();
    const { 0: orderBy , 1: setOrder  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)('created_at');
    const { 0: sortedBy , 1: setColumn  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(_types__WEBPACK_IMPORTED_MODULE_9__/* .SortOrder.Desc */ .As.Desc);
    const { categories , paginatorInfo , loading , error  } = (0,_data_category__WEBPACK_IMPORTED_MODULE_15__/* .useCategoriesQuery */ .Ei)({
        limit: 20,
        page,
        type,
        name: searchTerm,
        orderBy,
        sortedBy,
        parent: null,
        language: locale
    });
    if (loading) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
        text: t('common:text-loading')
    }));
    if (error) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_error_message__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
        message: error.message
    }));
    function handleSearch({ searchText  }) {
        setSearchTerm(searchText);
        setPage(1);
    }
    function handlePagination(current) {
        setPage(current);
    }
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_card__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                className: "mb-8 flex flex-col",
                children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                    className: "flex w-full flex-col items-center md:flex-row",
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                            className: "mb-4 md:mb-0 md:w-1/4",
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h1", {
                                className: "text-xl font-semibold text-heading",
                                children: t('form:input-label-categories')
                            })
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                            className: "ms-auto flex w-full flex-col items-center space-y-4 md:flex-row md:space-y-0 xl:w-3/4",
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_search__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                                    onSearch: handleSearch
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_category_type_filter__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z, {
                                    className: "md:ms-6",
                                    onTypeFilter: ({ slug  })=>{
                                        setType(slug);
                                        setPage(1);
                                    }
                                }),
                                locale === _config__WEBPACK_IMPORTED_MODULE_17__/* .Config.defaultLanguage */ .D.defaultLanguage && /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_ui_link_button__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                    href: `${_config_routes__WEBPACK_IMPORTED_MODULE_12__/* .Routes.category.create */ .Z.category.create}`,
                                    className: "md:ms-6 h-12 w-full md:w-auto",
                                    children: [
                                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                            className: "block md:hidden xl:block",
                                            children: [
                                                "+ ",
                                                t('form:button-label-add-categories')
                                            ]
                                        }),
                                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                            className: "hidden md:block xl:hidden",
                                            children: [
                                                "+ ",
                                                t('form:button-label-add')
                                            ]
                                        })
                                    ]
                                })
                            ]
                        })
                    ]
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_category_category_list__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                categories: categories,
                paginatorInfo: paginatorInfo,
                onPagination: handlePagination,
                onOrder: setOrder,
                onSort: setColumn
            })
        ]
    }));
};
Categories.authenticate = {
    permissions: _utils_auth_utils__WEBPACK_IMPORTED_MODULE_14__/* .adminOnly */ .M$
};
Categories.Layout = _components_layouts_admin__WEBPACK_IMPORTED_MODULE_3__["default"];
const getStaticProps = async ({ locale  })=>({
        props: {
            ...await (0,next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_11__.serverSideTranslations)(locale, [
                'form',
                'common',
                'table'
            ])
        }
    })
;

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9677:
/***/ ((module) => {

module.exports = require("@reach/portal");

/***/ }),

/***/ 25782:
/***/ ((module) => {

module.exports = require("body-scroll-lock");

/***/ }),

/***/ 33104:
/***/ ((module) => {

module.exports = require("camelcase-keys");

/***/ }),

/***/ 59003:
/***/ ((module) => {

module.exports = require("classnames");

/***/ }),

/***/ 84802:
/***/ ((module) => {

module.exports = require("cookie");

/***/ }),

/***/ 11377:
/***/ ((module) => {

module.exports = require("next-i18next");

/***/ }),

/***/ 25460:
/***/ ((module) => {

module.exports = require("next-i18next/serverSideTranslations");

/***/ }),

/***/ 60562:
/***/ ((module) => {

module.exports = require("next/dist/server/denormalize-page-path.js");

/***/ }),

/***/ 78028:
/***/ ((module) => {

module.exports = require("next/dist/server/image-config.js");

/***/ }),

/***/ 94957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 3539:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/detect-domain-locale.js");

/***/ }),

/***/ 34014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 50744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 78524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 78020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 24964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 29565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 64365:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-middleware-regex.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 91292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 80979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 36052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 84226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 95052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 59232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 71853:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 153:
/***/ ((module) => {

module.exports = require("overlayscrollbars-react");

/***/ }),

/***/ 73006:
/***/ ((module) => {

module.exports = require("rc-pagination");

/***/ }),

/***/ 73345:
/***/ ((module) => {

module.exports = require("rc-table");

/***/ }),

/***/ 16689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 61175:
/***/ ((module) => {

module.exports = require("react-query");

/***/ }),

/***/ 61929:
/***/ ((module) => {

module.exports = require("react-select");

/***/ }),

/***/ 1187:
/***/ ((module) => {

module.exports = require("react-toastify");

/***/ }),

/***/ 57139:
/***/ ((module) => {

module.exports = require("react-use/lib/useLocalStorage");

/***/ }),

/***/ 20997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 91017:
/***/ ((module) => {

module.exports = import("@floating-ui/react-dom-interactions");;

/***/ }),

/***/ 61185:
/***/ ((module) => {

module.exports = import("@headlessui/react");;

/***/ }),

/***/ 99648:
/***/ ((module) => {

module.exports = import("axios");;

/***/ }),

/***/ 66197:
/***/ ((module) => {

module.exports = import("framer-motion");;

/***/ }),

/***/ 82451:
/***/ ((module) => {

module.exports = import("jotai");;

/***/ }),

/***/ 2752:
/***/ ((module) => {

module.exports = import("jotai/utils");;

/***/ }),

/***/ 69915:
/***/ ((module) => {

module.exports = import("js-cookie");;

/***/ }),

/***/ 45641:
/***/ ((module) => {

module.exports = import("react-hook-form");;

/***/ }),

/***/ 24281:
/***/ ((module) => {

module.exports = import("tiny-invariant");;

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [1842,16,9894,8579,3406,3691,9809,7070,601,7721,6411,9239,3605,9249,5839,8760,4602,9831,4014,7898,792,3139,4144,8243,3955,6302,1044,2774,4451], () => (__webpack_exec__(69632)));
module.exports = __webpack_exports__;

})();