"use strict";
(() => {
var exports = {};
exports.id = 9258;
exports.ids = [9258,678,4896,7725];
exports.modules = {

/***/ 20286:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Uploader)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_icons_upload_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19525);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_dropzone__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56358);
/* harmony import */ var react_dropzone__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_dropzone__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_icons_close_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29581);
/* harmony import */ var _components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(47898);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _data_upload__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(34421);
/* harmony import */ var next_image__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(38579);
/* harmony import */ var _utils_placeholders__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(34896);
/* harmony import */ var _utils_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(30957);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_upload__WEBPACK_IMPORTED_MODULE_7__]);
_data_upload__WEBPACK_IMPORTED_MODULE_7__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];











const getPreviewImage = (value)=>{
    let images = [];
    if (value) {
        images = Array.isArray(value) ? value : [
            {
                ...value
            }
        ];
    }
    return images;
};
function Uploader({ onChange , value , multiple , acceptFile , helperText  }) {
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_6__.useTranslation)();
    const { 0: files , 1: setFiles  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(getPreviewImage(value));
    const { mutate: upload , isLoading: loading  } = (0,_data_upload__WEBPACK_IMPORTED_MODULE_7__/* .useUploadMutation */ .g)();
    const { 0: error1 , 1: setError  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(null);
    const { getRootProps , getInputProps  } = (0,react_dropzone__WEBPACK_IMPORTED_MODULE_3__.useDropzone)({
        ...!acceptFile ? {
            accept: 'image/*'
        } : {
            accept: _utils_constants__WEBPACK_IMPORTED_MODULE_10__/* .ACCEPTED_FILE_TYPES */ ._0
        },
        multiple,
        onDrop: async (acceptedFiles)=>{
            if (acceptedFiles.length) {
                upload(acceptedFiles, {
                    onSuccess: (data)=>{
                        // Process Digital File Name section
                        data && (data === null || data === void 0 ? void 0 : data.map((file, idx)=>{
                            var ref, ref1;
                            const splitArray = file === null || file === void 0 ? void 0 : (ref = file.original) === null || ref === void 0 ? void 0 : ref.split('/');
                            let fileSplitName = (ref1 = splitArray[(splitArray === null || splitArray === void 0 ? void 0 : splitArray.length) - 1]) === null || ref1 === void 0 ? void 0 : ref1.split('.');
                            const fileType = fileSplitName === null || fileSplitName === void 0 ? void 0 : fileSplitName.pop(); // it will pop the last item from the fileSplitName arr which is the file ext
                            const filename = fileSplitName === null || fileSplitName === void 0 ? void 0 : fileSplitName.join('.'); // it will join the array with dot, which restore the original filename
                            data[idx]['file_name'] = filename + '.' + fileType;
                        }));
                        let mergedData;
                        if (multiple) {
                            mergedData = files.concat(data);
                            setFiles(files.concat(data));
                        } else {
                            mergedData = data[0];
                            setFiles(data);
                        }
                        if (onChange) {
                            onChange(mergedData);
                        }
                    }
                });
            }
        },
        onDropRejected: (fileRejections)=>{
            fileRejections.forEach((file)=>{
                var ref;
                file === null || file === void 0 ? void 0 : (ref = file.errors) === null || ref === void 0 ? void 0 : ref.forEach((error)=>{
                    if ((error === null || error === void 0 ? void 0 : error.code) === 'file-too-large') {
                        setError(t('error-file-too-large'));
                    } else if ((error === null || error === void 0 ? void 0 : error.code) === 'file-invalid-type') {
                        setError(t('error-invalid-file-type'));
                    }
                });
            });
        }
    });
    const handleDelete = (image)=>{
        const images = files.filter((file)=>file.thumbnail !== image
        );
        setFiles(images);
        if (onChange) {
            onChange(images);
        }
    };
    const thumbs = files === null || files === void 0 ? void 0 : files.map((file, idx)=>{
        const imgTypes = [
            'tif',
            'tiff',
            'bmp',
            'jpg',
            'jpeg',
            'gif',
            'png',
            'eps',
            'raw', 
        ];
        // let filename, fileType, isImage;
        if (file && file.id) {
            var ref;
            console.log('File is', file);
            // const processedFile = processFileWithName(file);
            const splitArray = file === null || file === void 0 ? void 0 : (ref = file.file_name) === null || ref === void 0 ? void 0 : ref.split('.');
            const fileType = splitArray === null || splitArray === void 0 ? void 0 : splitArray.pop(); // it will pop the last item from the fileSplitName arr which is the file ext
            const filename = splitArray === null || splitArray === void 0 ? void 0 : splitArray.join('.'); // it will join the array with dot, which restore the original filename
            const isImage = (file === null || file === void 0 ? void 0 : file.thumbnail) && imgTypes.includes(fileType); // check if the original filename has the img ext
            // Old Code *******
            // const splitArray = file?.original?.split('/');
            // let fileSplitName = splitArray[splitArray?.length - 1]?.split('.'); // it will create an array of words of filename
            // const fileType = fileSplitName.pop(); // it will pop the last item from the fileSplitName arr which is the file ext
            // const filename = fileSplitName.join('.'); // it will join the array with dot, which restore the original filename
            // const isImage = file?.thumbnail && imgTypes.includes(fileType); // check if the original filename has the img ext
            return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: `relative mt-2 inline-flex flex-col overflow-hidden rounded me-2 ${isImage ? 'border border-border-200' : ''}`,
                children: [
                    isImage ? // <div className="flex h-16 w-16 min-w-0 items-center justify-center overflow-hidden">
                    //   <Image
                    //     src={file.thumbnail}
                    //     width={56}
                    //     height={56}
                    //     alt="uploaded image"
                    //   />
                    // </div>
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("figure", {
                        className: "relative h-16 w-28",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(next_image__WEBPACK_IMPORTED_MODULE_8__["default"], {
                            src: file.thumbnail,
                            alt: filename,
                            layout: "fill",
                            objectFit: "contain"
                        })
                    }) : /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                        className: "flex flex-col items-center",
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                className: "flex h-14 w-14 min-w-0 items-center justify-center overflow-hidden",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(next_image__WEBPACK_IMPORTED_MODULE_8__["default"], {
                                    src: _utils_placeholders__WEBPACK_IMPORTED_MODULE_9__/* .zipPlaceholder */ .GZ,
                                    width: 56,
                                    height: 56,
                                    alt: "upload placeholder"
                                })
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("p", {
                                className: "flex cursor-default items-baseline p-1 text-xs text-body",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                        className: "inline-block max-w-[64px] overflow-hidden overflow-ellipsis whitespace-nowrap",
                                        title: `${filename}.${fileType}`,
                                        children: filename
                                    }),
                                    ".",
                                    fileType
                                ]
                            })
                        ]
                    }),
                    multiple ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                        className: "absolute top-1 flex h-4 w-4 items-center justify-center rounded-full bg-red-600 text-xs text-light shadow-xl outline-none end-1",
                        onClick: ()=>handleDelete(file.thumbnail)
                        ,
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_close_icon__WEBPACK_IMPORTED_MODULE_4__/* .CloseIcon */ .T, {
                            width: 10,
                            height: 10
                        })
                    }) : null
                ]
            }, idx));
        }
    });
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(()=>()=>{
            // Reset error after upload new file
            setError(null);
            // Make sure to revoke the data uris to avoid memory leaks
            files.forEach((file)=>URL.revokeObjectURL(file.thumbnail)
            );
        }
    , [
        files
    ]);
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("section", {
        className: "upload",
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                ...getRootProps({
                    className: 'border-dashed border-2 border-border-base h-36 rounded flex flex-col justify-center items-center cursor-pointer focus:border-accent-400 focus:outline-none'
                }),
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                        ...getInputProps()
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_upload_icon__WEBPACK_IMPORTED_MODULE_1__/* .UploadIcon */ .r, {
                        className: "text-muted-light"
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                        className: "mt-4 text-center text-sm text-body",
                        children: helperText ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                            className: "font-semibold text-gray-500",
                            children: helperText
                        }) : /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                    className: "font-semibold text-accent",
                                    children: t('text-upload-highlight')
                                }),
                                ' ',
                                t('text-upload-message'),
                                " ",
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("br", {}),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                    className: "text-xs text-body",
                                    children: t('text-img-format')
                                })
                            ]
                        })
                    }),
                    error1 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                        className: "mt-4 text-center text-sm text-body text-red-600",
                        children: error1
                    })
                ]
            }),
            (!!thumbs.length || loading) && /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("aside", {
                className: "mt-2 flex flex-wrap",
                children: [
                    !!thumbs.length && thumbs,
                    loading && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "mt-2 flex h-16 items-center ms-2",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                            simple: true,
                            className: "h-6 w-6"
                        })
                    })
                ]
            })
        ]
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 64131:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "FacebookIcon": () => (/* reexport */ FacebookIcon),
  "InstagramIcon": () => (/* reexport */ InstagramIcon),
  "TwitterIcon": () => (/* reexport */ TwitterIcon),
  "YouTubeIcon": () => (/* reexport */ YouTubeIcon)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
;// CONCATENATED MODULE: ./src/components/icons/social/facebook.tsx

const FacebookIcon = (props)=>/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 12 12",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            "data-name": "_ionicons_svg_logo-facebook (6)",
            d: "M11.338 0H.662A.663.663 0 000 .663v10.674a.663.663 0 00.662.662H6V7.25H4.566V5.5H6V4.206a2.28 2.28 0 012.459-2.394c.662 0 1.375.05 1.541.072V3.5H8.9c-.753 0-.9.356-.9.881V5.5h1.794L9.56 7.25H8V12h3.338a.663.663 0 00.662-.663V.662A.663.663 0 0011.338 0z",
            fill: "currentColor"
        })
    })
;

;// CONCATENATED MODULE: ./src/components/icons/social/instagram.tsx

const InstagramIcon = (props)=>/*#__PURE__*/ (0,jsx_runtime_.jsxs)("svg", {
        "data-name": "Group 96",
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 12 12",
        ...props,
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                "data-name": "Path 1",
                d: "M8.5 1A2.507 2.507 0 0111 3.5v5A2.507 2.507 0 018.5 11h-5A2.507 2.507 0 011 8.5v-5A2.507 2.507 0 013.5 1h5m0-1h-5A3.51 3.51 0 000 3.5v5A3.51 3.51 0 003.5 12h5A3.51 3.51 0 0012 8.5v-5A3.51 3.51 0 008.5 0z",
                fill: "currentColor"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                "data-name": "Path 2",
                d: "M9.25 3.5a.75.75 0 11.75-.75.748.748 0 01-.75.75zM6 4a2 2 0 11-2 2 2 2 0 012-2m0-1a3 3 0 103 3 3 3 0 00-3-3z",
                fill: "currentColor"
            })
        ]
    })
;

;// CONCATENATED MODULE: ./src/components/icons/social/twitter.tsx

const TwitterIcon = (props)=>/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 14.747 12",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            "data-name": "_ionicons_svg_logo-twitter (5)",
            d: "M14.747 1.422a6.117 6.117 0 01-1.737.478A3.036 3.036 0 0014.341.225a6.012 6.012 0 01-1.922.734 3.025 3.025 0 00-5.234 2.069 2.962 2.962 0 00.078.691A8.574 8.574 0 011.026.553a3.032 3.032 0 00.941 4.044 2.955 2.955 0 01-1.375-.378v.037A3.028 3.028 0 003.02 7.225a3.046 3.046 0 01-.8.106 2.854 2.854 0 01-.569-.056 3.03 3.03 0 002.828 2.1 6.066 6.066 0 01-3.759 1.3 6.135 6.135 0 01-.722-.044A8.457 8.457 0 004.631 12a8.557 8.557 0 008.616-8.619c0-.131 0-.262-.009-.391a6.159 6.159 0 001.509-1.568z",
            fill: "currentColor"
        })
    })
;

;// CONCATENATED MODULE: ./src/components/icons/social/youtube.tsx

const YouTubeIcon = (props)=>/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 15.997 12",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            d: "M15.893 2.65A2.429 2.429 0 0013.581.113c-1.731-.081-3.5-.112-5.3-.112h-.563c-1.8 0-3.569.031-5.3.112A2.434 2.434 0 00.106 2.656C.028 3.768-.006 4.881-.003 5.993s.031 2.225.106 3.34a2.437 2.437 0 002.309 2.547c1.822.085 3.688.12 5.584.12s3.759-.031 5.581-.119a2.438 2.438 0 002.312-2.547c.075-1.116.109-2.228.106-3.344s-.027-2.225-.102-3.34zM6.468 9.059v-6.14l4.531 3.069z",
            fill: "currentColor"
        })
    })
;

;// CONCATENATED MODULE: ./src/components/icons/social/index.tsx






/***/ }),

/***/ 15218:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ CreateOrUpdateManufacturerForm)
/* harmony export */ });
/* unused harmony export updatedIcons */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(145);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45641);
/* harmony import */ var _components_ui_button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(39258);
/* harmony import */ var _components_ui_text_area__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(83375);
/* harmony import */ var _components_ui_label__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(63815);
/* harmony import */ var _utils_form_error__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(1326);
/* harmony import */ var _components_ui_description__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(87594);
/* harmony import */ var _components_common_card__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(81258);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _components_ui_file_input__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(77725);
/* harmony import */ var _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(61908);
/* harmony import */ var _manufacturer_validation_schema__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(9490);
/* harmony import */ var _utils_get_icon__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(69847);
/* harmony import */ var _components_ui_select_input__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(55530);
/* harmony import */ var _components_icons_social__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(64131);
/* harmony import */ var _components_product_product_group_input__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(33540);
/* harmony import */ var _data_shop__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(10678);
/* harmony import */ var _data_manufacturer__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(26486);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_hook_form__WEBPACK_IMPORTED_MODULE_2__, _utils_form_error__WEBPACK_IMPORTED_MODULE_6__, _components_ui_file_input__WEBPACK_IMPORTED_MODULE_11__, _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_12__, _components_ui_select_input__WEBPACK_IMPORTED_MODULE_15__, _components_product_product_group_input__WEBPACK_IMPORTED_MODULE_17__, _data_shop__WEBPACK_IMPORTED_MODULE_18__, _data_manufacturer__WEBPACK_IMPORTED_MODULE_19__]);
([react_hook_form__WEBPACK_IMPORTED_MODULE_2__, _utils_form_error__WEBPACK_IMPORTED_MODULE_6__, _components_ui_file_input__WEBPACK_IMPORTED_MODULE_11__, _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_12__, _components_ui_select_input__WEBPACK_IMPORTED_MODULE_15__, _components_product_product_group_input__WEBPACK_IMPORTED_MODULE_17__, _data_shop__WEBPACK_IMPORTED_MODULE_18__, _data_manufacturer__WEBPACK_IMPORTED_MODULE_19__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




















const socialIcon = [
    {
        value: 'FacebookIcon',
        label: 'Facebook'
    },
    {
        value: 'InstagramIcon',
        label: 'Instagram'
    },
    {
        value: 'TwitterIcon',
        label: 'Twitter'
    },
    {
        value: 'YouTubeIcon',
        label: 'Youtube'
    }, 
];
const updatedIcons = socialIcon.map((item)=>{
    item.label = /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "flex items-center text-body space-s-4",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                className: "flex h-4 w-4 items-center justify-center",
                children: (0,_utils_get_icon__WEBPACK_IMPORTED_MODULE_14__/* .getIcon */ .q)({
                    iconList: _components_icons_social__WEBPACK_IMPORTED_MODULE_16__,
                    iconName: item.value,
                    className: 'w-4 h-4'
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                children: item.label
            })
        ]
    });
    return item;
});
function CreateOrUpdateManufacturerForm({ initialValues  }) {
    var ref4, ref1, ref2, ref3;
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_9__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_10__.useTranslation)();
    const { query: { shop  } ,  } = router;
    const { data: shopData  } = (0,_data_shop__WEBPACK_IMPORTED_MODULE_18__/* .useShopQuery */ .DZ)({
        slug: shop
    }, {
        enabled: !!router.query.shop
    });
    const shopId = shopData === null || shopData === void 0 ? void 0 : shopData.id;
    const isNewTranslation = (router === null || router === void 0 ? void 0 : (ref4 = router.query) === null || ref4 === void 0 ? void 0 : ref4.action) === 'translate';
    const { register , handleSubmit , control , setError , formState: { errors  } ,  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_2__.useForm)({
        shouldUnregister: true,
        resolver: (0,_hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_12__.yupResolver)(_manufacturer_validation_schema__WEBPACK_IMPORTED_MODULE_13__/* .manufacturerValidationSchema */ .t),
        ...Boolean(initialValues) && {
            defaultValues: {
                ...initialValues,
                socials: (initialValues === null || initialValues === void 0 ? void 0 : initialValues.socials) ? initialValues === null || initialValues === void 0 ? void 0 : initialValues.socials.map((social)=>{
                    return {
                        icon: updatedIcons === null || updatedIcons === void 0 ? void 0 : updatedIcons.find((icon)=>{
                            return (icon === null || icon === void 0 ? void 0 : icon.value) === (social === null || social === void 0 ? void 0 : social.icon);
                        }),
                        url: social === null || social === void 0 ? void 0 : social.url
                    };
                }) : [],
                ...isNewTranslation && {
                    type: null
                }
            }
        }
    });
    const { mutate: createManufacturer , isLoading: creating  } = (0,_data_manufacturer__WEBPACK_IMPORTED_MODULE_19__/* .useCreateManufacturerMutation */ .M5)();
    const { mutate: updateManufacturer , isLoading: updating  } = (0,_data_manufacturer__WEBPACK_IMPORTED_MODULE_19__/* .useUpdateManufacturerMutation */ .pN)();
    const { fields , append , remove  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_2__.useFieldArray)({
        control,
        name: 'socials'
    });
    const onSubmit = async (values)=>{
        const { name , description , is_approved , website , type , socials , image , cover_image ,  } = values;
        const input = {
            language: router.locale,
            name,
            description,
            is_approved,
            website,
            socials: socials ? socials === null || socials === void 0 ? void 0 : socials.map((social)=>{
                var ref;
                return {
                    icon: social === null || social === void 0 ? void 0 : (ref = social.icon) === null || ref === void 0 ? void 0 : ref.value,
                    url: social === null || social === void 0 ? void 0 : social.url
                };
            }) : [],
            image: {
                thumbnail: image === null || image === void 0 ? void 0 : image.thumbnail,
                original: image === null || image === void 0 ? void 0 : image.original,
                id: image === null || image === void 0 ? void 0 : image.id
            },
            cover_image: {
                thumbnail: cover_image === null || cover_image === void 0 ? void 0 : cover_image.thumbnail,
                original: cover_image === null || cover_image === void 0 ? void 0 : cover_image.original,
                id: cover_image === null || cover_image === void 0 ? void 0 : cover_image.id
            },
            type_id: type === null || type === void 0 ? void 0 : type.id
        };
        try {
            if (!initialValues || !initialValues.translated_languages.includes(router.locale)) {
                createManufacturer({
                    ...input,
                    shop_id: shopId,
                    ...(initialValues === null || initialValues === void 0 ? void 0 : initialValues.slug) && {
                        slug: initialValues.slug
                    }
                });
            } else {
                updateManufacturer({
                    ...input,
                    id: initialValues.id,
                    shop_id: shopId
                });
            }
        } catch (error) {
            const serverErrors = (0,_utils_form_error__WEBPACK_IMPORTED_MODULE_6__/* .getErrorMessage */ .e)(error);
            Object.keys(serverErrors === null || serverErrors === void 0 ? void 0 : serverErrors.validation).forEach((field)=>{
                setError(field.split('.')[1], {
                    type: 'manual',
                    message: serverErrors === null || serverErrors === void 0 ? void 0 : serverErrors.validation[field][0]
                });
            });
        }
    };
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("form", {
        onSubmit: handleSubmit(onSubmit),
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "my-5 flex flex-wrap border-b border-dashed border-border-base pb-8 sm:my-8",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                        title: t('form:input-label-logo'),
                        details: t('form:manufacturer-image-helper-text'),
                        className: "w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pe-4 md:w-1/3 md:pe-5"
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_card__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                        className: "w-full sm:w-8/12 md:w-2/3",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_file_input__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z, {
                            name: "image",
                            control: control,
                            multiple: false
                        })
                    })
                ]
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "my-5 flex flex-wrap border-b border-dashed border-border-base pb-8 sm:my-8",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                        title: t('form:input-label-cover-image'),
                        details: t('form:manufacturer-cover-image-helper-text'),
                        className: "w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pe-4 md:w-1/3 md:pe-5"
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_card__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                        className: "w-full sm:w-8/12 md:w-2/3",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_file_input__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z, {
                            name: "cover_image",
                            control: control,
                            multiple: false
                        })
                    })
                ]
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "my-5 flex flex-wrap sm:my-8",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                        title: t('form:input-label-description'),
                        details: `${initialValues ? t('form:item-description-edit') : t('form:item-description-add')} ${t('form:manufacturer-form-description-details')}`,
                        className: "w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pe-4 md:w-1/3 md:pe-5 "
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_common_card__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                        className: "w-full sm:w-8/12 md:w-2/3",
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-name'),
                                ...register('name'),
                                error: t((ref1 = errors.name) === null || ref1 === void 0 ? void 0 : ref1.message),
                                variant: "outline",
                                className: "mb-5"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-website'),
                                ...register('website'),
                                error: t((ref2 = errors.website) === null || ref2 === void 0 ? void 0 : ref2.message),
                                variant: "outline",
                                className: "mb-5"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_text_area__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                                label: t('form:input-label-description'),
                                ...register('description'),
                                variant: "outline",
                                className: "mb-5"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_product_product_group_input__WEBPACK_IMPORTED_MODULE_17__/* ["default"] */ .Z, {
                                control: control,
                                error: t(errors === null || errors === void 0 ? void 0 : (ref3 = errors.type) === null || ref3 === void 0 ? void 0 : ref3.message)
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                children: fields.map((item, index)=>{
                                    /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                        className: "border-b border-dashed border-border-200 py-5 first:mt-5 first:border-t last:border-b-0 md:py-8 md:first:mt-10",
                                        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                            className: "grid grid-cols-1 gap-5 sm:grid-cols-5",
                                            children: [
                                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                    className: "sm:col-span-2",
                                                    children: [
                                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                                            children: t('form:input-label-select-platform')
                                                        }),
                                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_select_input__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
                                                            name: `socials.${index}.icon`,
                                                            control: control,
                                                            options: updatedIcons,
                                                            isClearable: true,
                                                            defaultValue: item === null || item === void 0 ? void 0 : item.icon
                                                        })
                                                    ]
                                                }),
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                                    className: "sm:col-span-2",
                                                    label: t('form:input-label-social-url'),
                                                    variant: "outline",
                                                    ...register(`socials.${index}.url`),
                                                    defaultValue: item.url
                                                }),
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                                                    onClick: ()=>{
                                                        remove(index);
                                                    },
                                                    type: "button",
                                                    className: "text-sm text-red-500 transition-colors duration-200 hover:text-red-700 focus:outline-none sm:col-span-1 sm:mt-4",
                                                    children: t('form:button-label-remove')
                                                })
                                            ]
                                        })
                                    }, item.id);
                                })
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                                type: "button",
                                onClick: ()=>append({
                                        icon: '',
                                        url: ''
                                    })
                                ,
                                className: "w-full sm:w-auto",
                                children: t('form:button-label-add-social')
                            })
                        ]
                    })
                ]
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "mb-4 text-end",
                children: [
                    initialValues && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                        variant: "outline",
                        onClick: router.back,
                        className: "me-4",
                        type: "button",
                        children: t('form:button-label-back')
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                        loading: updating || creating,
                        children: initialValues ? t('form:button-label-update-manufacturer-publication') : t('form:button-label-add-manufacturer-publication')
                    })
                ]
            })
        ]
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9490:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "t": () => (/* binding */ manufacturerValidationSchema)
/* harmony export */ });
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_0__);

const manufacturerValidationSchema = yup__WEBPACK_IMPORTED_MODULE_0__.object().shape({
    name: yup__WEBPACK_IMPORTED_MODULE_0__.string().required('form:error-manufacturer-name-required'),
    type: yup__WEBPACK_IMPORTED_MODULE_0__.object().nullable().required('form:error-type-required')
});


/***/ }),

/***/ 33540:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55530);
/* harmony import */ var _components_ui_label__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(63815);
/* harmony import */ var _components_ui_form_validation_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56965);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _data_type__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(98077);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__, _data_type__WEBPACK_IMPORTED_MODULE_5__]);
([_components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__, _data_type__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);







const ProductGroupInput = ({ control , error  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_4__.useTranslation)();
    const { locale  } = (0,next_router__WEBPACK_IMPORTED_MODULE_6__.useRouter)();
    const { types , loading  } = (0,_data_type__WEBPACK_IMPORTED_MODULE_5__/* .useTypesQuery */ .qs)({
        limit: 200,
        language: locale
    });
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "mb-5",
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_ui_label__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                children: [
                    t('form:input-label-group'),
                    "*"
                ]
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_select_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                name: "type",
                control: control,
                getOptionLabel: (option)=>option.name
                ,
                getOptionValue: (option)=>option.id
                ,
                options: types,
                isLoading: loading
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_form_validation_error__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                message: t(error)
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProductGroupInput);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 77725:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_common_uploader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20286);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45641);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_common_uploader__WEBPACK_IMPORTED_MODULE_1__, react_hook_form__WEBPACK_IMPORTED_MODULE_2__]);
([_components_common_uploader__WEBPACK_IMPORTED_MODULE_1__, react_hook_form__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const FileInput = ({ control , name , multiple =true , acceptFile =false , helperText , defaultValue =[]  })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_hook_form__WEBPACK_IMPORTED_MODULE_2__.Controller, {
        control: control,
        name: name,
        defaultValue: defaultValue,
        render: ({ field: { ref , ...rest }  })=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_uploader__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                ...rest,
                multiple: multiple,
                acceptFile: acceptFile,
                helperText: helperText
            })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FileInput);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 56965:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const ValidationError = ({ message  })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
        className: "my-2 text-xs text-start text-red-500",
        children: message
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ValidationError);


/***/ }),

/***/ 63815:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);


const Label = ({ className , ...rest })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
        className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('block text-body-dark font-semibold text-sm leading-none mb-3', className),
        ...rest
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Label);


/***/ }),

/***/ 5034:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "h": () => (/* binding */ crudFactory)
/* harmony export */ });
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_0__]);
_http_client__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

function crudFactory(endpoint) {
    return {
        all (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        paginated (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        get ({ slug , language  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(`${endpoint}/${slug}`, {
                language
            });
        },
        create (data) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.post */ .eN.post(endpoint, data);
        },
        update ({ id , ...input }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.put */ .eN.put(`${endpoint}/${id}`, input);
        },
        delete ({ id  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient["delete"] */ .eN["delete"](`${endpoint}/${id}`);
        }
    };
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 18728:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "P": () => (/* binding */ manufacturerClient)
/* harmony export */ });
/* harmony import */ var _data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5034);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
/* harmony import */ var _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const manufacturerClient = {
    ...(0,_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__/* .crudFactory */ .h)(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.MANUFACTURERS */ .P.MANUFACTURERS),
    paginated: ({ name , shop_id , ...params })=>{
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.MANUFACTURERS */ .P.MANUFACTURERS, {
            searchJoin: 'and',
            ...params,
            search: _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                name,
                shop_id
            })
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5683:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "b": () => (/* binding */ shopClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67904);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5034);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_1__, _curd_factory__WEBPACK_IMPORTED_MODULE_2__]);
([_http_client__WEBPACK_IMPORTED_MODULE_1__, _curd_factory__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const shopClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_2__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS),
    get ({ slug  }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.get */ .eN.get(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS}/${slug}`);
    },
    paginated: ({ name , ...params })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS, {
            searchJoin: 'and',
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                name
            })
        });
    },
    approve: (variables)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.APPROVE_SHOP */ .P.APPROVE_SHOP, variables);
    },
    disapprove: (variables)=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_1__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.DISAPPROVE_SHOP */ .P.DISAPPROVE_SHOP, variables);
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4372:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "A": () => (/* binding */ typeClient)
/* harmony export */ });
/* harmony import */ var _data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5034);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
/* harmony import */ var _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const typeClient = {
    ...(0,_data_client_curd_factory__WEBPACK_IMPORTED_MODULE_0__/* .crudFactory */ .h)(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.TYPES */ .P.TYPES),
    all: ({ name , ...params })=>{
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.TYPES */ .P.TYPES, {
            searchJoin: 'and',
            ...params,
            search: _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                name
            })
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 12721:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "t": () => (/* binding */ uploadClient)
/* harmony export */ });
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67904);
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_0__]);
_http_client__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const uploadClient = {
    upload: async (variables)=>{
        let formData = new FormData();
        variables.forEach((attachment)=>{
            formData.append('attachment[]', attachment);
        });
        const options = {
            headers: {
                'Content-Type': 'multipart/form-data'
            }
        };
        return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.ATTACHMENTS */ .P.ATTACHMENTS, formData, options);
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 26486:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "M5": () => (/* binding */ useCreateManufacturerMutation),
/* harmony export */   "ty": () => (/* binding */ useDeleteManufacturerMutation),
/* harmony export */   "pN": () => (/* binding */ useUpdateManufacturerMutation),
/* harmony export */   "a7": () => (/* binding */ useManufacturerQuery),
/* harmony export */   "ML": () => (/* binding */ useManufacturersQuery)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28379);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85057);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63354);
/* harmony import */ var _data_client_manufacturer__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(18728);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(29249);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_manufacturer__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_8__]);
([_data_client_manufacturer__WEBPACK_IMPORTED_MODULE_7__, _config__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const useCreateManufacturerMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_0__.useRouter)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_manufacturer__WEBPACK_IMPORTED_MODULE_7__/* .manufacturerClient.create */ .P.create, {
        onSuccess: async ()=>{
            const generateRedirectUrl = router.query.shop ? `/${router.query.shop}${_config_routes__WEBPACK_IMPORTED_MODULE_4__/* .Routes.manufacturer.list */ .Z.manufacturer.list}` : _config_routes__WEBPACK_IMPORTED_MODULE_4__/* .Routes.manufacturer.list */ .Z.manufacturer.list;
            await next_router__WEBPACK_IMPORTED_MODULE_0___default().push(generateRedirectUrl, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_8__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.MANUFACTURERS */ .P.MANUFACTURERS);
        }
    });
};
const useDeleteManufacturerMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_manufacturer__WEBPACK_IMPORTED_MODULE_7__/* .manufacturerClient["delete"] */ .P["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.MANUFACTURERS */ .P.MANUFACTURERS);
        }
    });
};
const useUpdateManufacturerMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_manufacturer__WEBPACK_IMPORTED_MODULE_7__/* .manufacturerClient.update */ .P.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.MANUFACTURERS */ .P.MANUFACTURERS);
        }
    });
};
const useManufacturerQuery = ({ slug , language  })=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.MANUFACTURERS */ .P.MANUFACTURERS,
        {
            slug,
            language
        }
    ], ()=>_data_client_manufacturer__WEBPACK_IMPORTED_MODULE_7__/* .manufacturerClient.get */ .P.get({
            slug,
            language
        })
    );
    return {
        manufacturer: data,
        error,
        loading: isLoading
    };
};
const useManufacturersQuery = (options)=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.MANUFACTURERS */ .P.MANUFACTURERS,
        options
    ], ({ queryKey , pageParam  })=>_data_client_manufacturer__WEBPACK_IMPORTED_MODULE_7__/* .manufacturerClient.paginated */ .P.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    var ref;
    return {
        manufacturers: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__/* .mapPaginatorData */ .Q)(data),
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 10678:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "bg": () => (/* binding */ useApproveShopMutation),
/* harmony export */   "mj": () => (/* binding */ useDisApproveShopMutation),
/* harmony export */   "TC": () => (/* binding */ useCreateShopMutation),
/* harmony export */   "D9": () => (/* binding */ useUpdateShopMutation),
/* harmony export */   "DZ": () => (/* binding */ useShopQuery),
/* harmony export */   "uL": () => (/* binding */ useShopsQuery)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28379);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(85057);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _client_shop__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(5683);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63354);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(49239);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_shop__WEBPACK_IMPORTED_MODULE_5__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__]);
([_client_shop__WEBPACK_IMPORTED_MODULE_5__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const useApproveShopMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_shop__WEBPACK_IMPORTED_MODULE_5__/* .shopClient.approve */ .b.approve, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_4__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS);
        }
    });
};
const useDisApproveShopMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_shop__WEBPACK_IMPORTED_MODULE_5__/* .shopClient.disapprove */ .b.disapprove, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_4__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS);
        }
    });
};
const useCreateShopMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_7__.useRouter)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_shop__WEBPACK_IMPORTED_MODULE_5__/* .shopClient.create */ .b.create, {
        onSuccess: ()=>{
            const { permissions  } = (0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__/* .getAuthCredentials */ .WA)();
            if ((0,_utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__/* .hasAccess */ .Ft)(_utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__/* .adminOnly */ .M$, permissions)) {
                return router.push(_config_routes__WEBPACK_IMPORTED_MODULE_1__/* .Routes.adminMyShops */ .Z.adminMyShops);
            }
            router.push(_config_routes__WEBPACK_IMPORTED_MODULE_1__/* .Routes.dashboard */ .Z.dashboard);
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS);
        }
    });
};
const useUpdateShopMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_shop__WEBPACK_IMPORTED_MODULE_5__/* .shopClient.update */ .b.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_4__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS);
        }
    });
};
const useShopQuery = ({ slug  }, options)=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS,
        {
            slug
        }
    ], ()=>_client_shop__WEBPACK_IMPORTED_MODULE_5__/* .shopClient.get */ .b.get({
            slug
        })
    , options);
};
const useShopsQuery = (options)=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHOPS */ .P.SHOPS,
        options
    ], ({ queryKey , pageParam  })=>_client_shop__WEBPACK_IMPORTED_MODULE_5__/* .shopClient.paginated */ .b.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    var ref;
    return {
        shops: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_6__/* .mapPaginatorData */ .Q)(data),
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 98077:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "jT": () => (/* binding */ useCreateTypeMutation),
/* harmony export */   "e7": () => (/* binding */ useDeleteTypeMutation),
/* harmony export */   "oy": () => (/* binding */ useUpdateTypeMutation),
/* harmony export */   "F2": () => (/* binding */ useTypeQuery),
/* harmony export */   "qs": () => (/* binding */ useTypesQuery)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28379);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85057);
/* harmony import */ var _data_client_type__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4372);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(29249);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(63354);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_type__WEBPACK_IMPORTED_MODULE_6__, _config__WEBPACK_IMPORTED_MODULE_7__]);
([_data_client_type__WEBPACK_IMPORTED_MODULE_6__, _config__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const useCreateTypeMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient.create */ .A.create, {
        onSuccess: ()=>{
            next_router__WEBPACK_IMPORTED_MODULE_0___default().push(_config_routes__WEBPACK_IMPORTED_MODULE_4__/* .Routes.type.list */ .Z.type.list, undefined, {
                locale: _config__WEBPACK_IMPORTED_MODULE_7__/* .Config.defaultLanguage */ .D.defaultLanguage
            });
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES);
        }
    });
};
const useDeleteTypeMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient["delete"] */ .A["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES);
        }
    });
};
const useUpdateTypeMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)(_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient.update */ .A.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES);
        }
    });
};
const useTypeQuery = ({ slug , language  })=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES,
        {
            slug,
            language
        }
    ], ()=>_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient.get */ .A.get({
            slug,
            language
        })
    );
    return {
        type: data,
        error,
        isLoading
    };
};
const useTypesQuery = (options)=>{
    const { data , isLoading , error  } = (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_5__/* .API_ENDPOINTS.TYPES */ .P.TYPES,
        options
    ], ({ queryKey , pageParam  })=>_data_client_type__WEBPACK_IMPORTED_MODULE_6__/* .typeClient.paginated */ .A.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    var ref;
    return {
        types: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_8__/* .mapPaginatorData */ .Q)(data),
        loading: isLoading,
        error
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 34421:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "g": () => (/* binding */ useUploadMutation)
/* harmony export */ });
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
/* harmony import */ var _data_client_upload__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12721);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_upload__WEBPACK_IMPORTED_MODULE_2__]);
_data_client_upload__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const useUploadMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)((input)=>{
        return _data_client_upload__WEBPACK_IMPORTED_MODULE_2__/* .uploadClient.upload */ .t.upload(input);
    }, {
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.SETTINGS */ .P.SETTINGS);
        }
    });
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 25007:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CreateManufacturerPage),
/* harmony export */   "getStaticProps": () => (/* binding */ getStaticProps)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_layouts_admin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40792);
/* harmony import */ var _components_manufacturer_manufacturer_form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15218);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(25460);
/* harmony import */ var next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _utils_auth_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(49239);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_layouts_admin__WEBPACK_IMPORTED_MODULE_1__, _components_manufacturer_manufacturer_form__WEBPACK_IMPORTED_MODULE_2__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_5__]);
([_components_layouts_admin__WEBPACK_IMPORTED_MODULE_1__, _components_manufacturer_manufacturer_form__WEBPACK_IMPORTED_MODULE_2__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






function CreateManufacturerPage() {
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "flex border-b border-dashed border-border-base py-5 sm:py-8",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h1", {
                    className: "text-lg font-semibold text-heading",
                    children: t('form:form-title-create-manufacturer')
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_manufacturer_manufacturer_form__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {})
        ]
    }));
};
CreateManufacturerPage.authenticate = {
    permissions: _utils_auth_utils__WEBPACK_IMPORTED_MODULE_5__/* .adminOnly */ .M$
};
CreateManufacturerPage.Layout = _components_layouts_admin__WEBPACK_IMPORTED_MODULE_1__["default"];
const getStaticProps = async ({ locale  })=>({
        props: {
            ...await (0,next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_4__.serverSideTranslations)(locale, [
                'form',
                'common'
            ])
        }
    })
;

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1326:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "e": () => (/* binding */ getErrorMessage)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var js_cookie__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69915);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([js_cookie__WEBPACK_IMPORTED_MODULE_1__]);
js_cookie__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


function getErrorMessage(error) {
    let processedError = {
        message: '',
        validation: []
    };
    if (error.graphQLErrors) {
        for (const graphQLError of error.graphQLErrors){
            if (graphQLError.extensions && graphQLError.extensions.category === 'validation') {
                processedError['message'] = graphQLError.message;
                processedError['validation'] = graphQLError.extensions.validation;
                return processedError;
            } else if (graphQLError.extensions && graphQLError.extensions.category === 'authorization') {
                js_cookie__WEBPACK_IMPORTED_MODULE_1__["default"].remove('auth_token');
                js_cookie__WEBPACK_IMPORTED_MODULE_1__["default"].remove('auth_permissions');
                next_router__WEBPACK_IMPORTED_MODULE_0___default().push('/');
            }
        }
    }
    processedError['message'] = error.message;
    return processedError;
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 34896:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Hb": () => (/* reexport */ product),
  "GZ": () => (/* reexport */ zip)
});

// UNUSED EXPORTS: avatarPlaceholder, couponPlaceholder, logoPlaceholder

;// CONCATENATED MODULE: ./src/assets/placeholders/product.svg
/* harmony default export */ const product = ({"src":"/_next/static/media/product.ba64d04a.svg","height":210,"width":270});
;// CONCATENATED MODULE: ./src/assets/placeholders/coupon.svg
/* harmony default export */ const coupon = ({"src":"/_next/static/media/coupon.5015b440.svg","height":240,"width":320});
;// CONCATENATED MODULE: ./src/assets/placeholders/avatar.svg
/* harmony default export */ const avatar = ({"src":"/_next/static/media/avatar.c9441dc8.svg","height":120,"width":120});
;// CONCATENATED MODULE: ./src/assets/placeholders/logo.svg
/* harmony default export */ const logo = ({"src":"/_next/static/media/logo.0679544b.svg","height":18,"width":109});
;// CONCATENATED MODULE: ./src/assets/placeholders/zip.png
/* harmony default export */ const zip = ({"src":"/_next/static/media/zip.9dcc52b5.png","height":512,"width":512,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAMAAADz0U65AAAAY1BMVEX3yYP+///dsofl6fXnvIb1yIrvwYTov4j1yIhMaXHLvc7RqoLqf5W1qrrOt6fS1uq9y9nVorG8ppyioLbJsqPh292UlrPZ0N/cq7q8j6X8j5zaxrPNtqW7nIOIiKrNm4iek6OR66+FAAAAG3RSTlMr/vj+tfX6+bUA/Cv7/v74/v7x/vH++P7+/v4PHiyvAAAACXBIWXMAAAsTAAALEwEAmpwYAAAARUlEQVQImR3LRxKAIBAAwUHSgmDOmP7/SqvsexNq470QYLjn8bIgZ6v04gTXaKU6b3Fl7be9spgS05EegSnm/Fbwd0P4AGY8AtL5sWsSAAAAAElFTkSuQmCC"});
;// CONCATENATED MODULE: ./src/utils/placeholders.tsx







/***/ }),

/***/ 9677:
/***/ ((module) => {

module.exports = require("@reach/portal");

/***/ }),

/***/ 25782:
/***/ ((module) => {

module.exports = require("body-scroll-lock");

/***/ }),

/***/ 33104:
/***/ ((module) => {

module.exports = require("camelcase-keys");

/***/ }),

/***/ 59003:
/***/ ((module) => {

module.exports = require("classnames");

/***/ }),

/***/ 84802:
/***/ ((module) => {

module.exports = require("cookie");

/***/ }),

/***/ 11377:
/***/ ((module) => {

module.exports = require("next-i18next");

/***/ }),

/***/ 25460:
/***/ ((module) => {

module.exports = require("next-i18next/serverSideTranslations");

/***/ }),

/***/ 60562:
/***/ ((module) => {

module.exports = require("next/dist/server/denormalize-page-path.js");

/***/ }),

/***/ 78028:
/***/ ((module) => {

module.exports = require("next/dist/server/image-config.js");

/***/ }),

/***/ 94957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 3539:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/detect-domain-locale.js");

/***/ }),

/***/ 34014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 50744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 78524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 78020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 24964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 29565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 64365:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-middleware-regex.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 91292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 80979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 36052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 84226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 95052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 59232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 71853:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 153:
/***/ ((module) => {

module.exports = require("overlayscrollbars-react");

/***/ }),

/***/ 16689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 56358:
/***/ ((module) => {

module.exports = require("react-dropzone");

/***/ }),

/***/ 61175:
/***/ ((module) => {

module.exports = require("react-query");

/***/ }),

/***/ 61929:
/***/ ((module) => {

module.exports = require("react-select");

/***/ }),

/***/ 1187:
/***/ ((module) => {

module.exports = require("react-toastify");

/***/ }),

/***/ 57139:
/***/ ((module) => {

module.exports = require("react-use/lib/useLocalStorage");

/***/ }),

/***/ 20997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 75609:
/***/ ((module) => {

module.exports = require("yup");

/***/ }),

/***/ 61185:
/***/ ((module) => {

module.exports = import("@headlessui/react");;

/***/ }),

/***/ 61908:
/***/ ((module) => {

module.exports = import("@hookform/resolvers/yup");;

/***/ }),

/***/ 99648:
/***/ ((module) => {

module.exports = import("axios");;

/***/ }),

/***/ 66197:
/***/ ((module) => {

module.exports = import("framer-motion");;

/***/ }),

/***/ 82451:
/***/ ((module) => {

module.exports = import("jotai");;

/***/ }),

/***/ 2752:
/***/ ((module) => {

module.exports = import("jotai/utils");;

/***/ }),

/***/ 69915:
/***/ ((module) => {

module.exports = import("js-cookie");;

/***/ }),

/***/ 45641:
/***/ ((module) => {

module.exports = import("react-hook-form");;

/***/ }),

/***/ 24281:
/***/ ((module) => {

module.exports = import("tiny-invariant");;

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [1842,16,9894,8579,3406,3691,9809,7070,601,7721,6411,9239,3605,9249,5839,8760,4602,9831,4014,7898,792,1567,145,2357,6302,3375,5530,9525], () => (__webpack_exec__(25007)));
module.exports = __webpack_exports__;

})();