"use strict";
(() => {
var exports = {};
exports.id = 2971;
exports.ids = [2971,468];
exports.modules = {

/***/ 69360:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "R": () => (/* binding */ DislikeIcon)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const DislikeIcon = (props)=>{
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 17.067 16",
        ...props,
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                id: "Path_22674",
                "data-name": "Path 22674",
                d: "M19.244,1h1.778a1.166,1.166,0,0,1,1.244,1.065v7a1.166,1.166,0,0,1-1.244,1.065H19.244A1.166,1.166,0,0,1,18,9.06v-7A1.166,1.166,0,0,1,19.244,1Z",
                transform: "translate(-18 0.188)",
                fill: "currentColor"
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                id: "Path_22675",
                "data-name": "Path 22675",
                d: "M8.093.75a2.84,2.84,0,0,1,2.8,2.361l.8,4.622a2.843,2.843,0,0,1-2.8,3.328H5.533a6.867,6.867,0,0,1,.533,2.844A2.611,2.611,0,0,1,3.755,16.75c-.711,0-1.067-.356-1.067-2.133,0-1.69-1.636-3.049-2.689-3.75V2.058A16.575,16.575,0,0,1,6.955.75Z",
                transform: "translate(5.333 -0.75)",
                fill: "currentColor"
            })
        ]
    }));
};


/***/ }),

/***/ 23228:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "l": () => (/* binding */ LikeIcon)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const LikeIcon = (props)=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 17.067 16",
        ...props,
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("g", {
            id: "like_1_",
            "data-name": "like (1)",
            transform: "translate(0 -0.75)",
            fill: "currentColor",
            children: [
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                    id: "Path_22672",
                    "data-name": "Path 22672",
                    d: "M1.244,17.063H3.022a1.164,1.164,0,0,0,1.244-1.057V9.057A1.164,1.164,0,0,0,3.022,8H1.244A1.164,1.164,0,0,0,0,9.057v6.948A1.164,1.164,0,0,0,1.244,17.063Z",
                    transform: "translate(0 -1.25)"
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                    id: "Path_22673",
                    "data-name": "Path 22673",
                    d: "M11.255.75c-.711,0-1.067.356-1.067,2.133,0,1.69-1.636,3.049-2.689,3.75v8.809a16.575,16.575,0,0,0,6.955,1.308h1.138a2.84,2.84,0,0,0,2.8-2.361l.8-4.622a2.843,2.843,0,0,0-2.8-3.328H13.033a6.867,6.867,0,0,0,.533-2.844A2.611,2.611,0,0,0,11.255.75Z",
                    transform: "translate(-2.167 0)"
                })
            ]
        })
    }));
};


/***/ }),

/***/ 94269:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_common_action_buttons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(53758);


const QuestionCard = ({ record , id  })=>{
    const { question , answer  } = record;
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("h3", {
                className: "text mb-2 text-sm font-semibold text-heading",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                        className: "me-1 inline-block uppercase",
                        children: "Q:"
                    }),
                    question,
                    ' '
                ]
            }),
            answer ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("p", {
                className: "text-sm",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                        className: "me-1 inline-block font-semibold uppercase text-heading",
                        children: "A:"
                    }),
                    answer
                ]
            }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_action_buttons__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                id: id,
                showReplyQuestion: true
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (QuestionCard);


/***/ }),

/***/ 31700:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_pagination__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61849);
/* harmony import */ var _components_ui_table__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(40447);
/* harmony import */ var _components_common_action_buttons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(53758);
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1635);
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(dayjs__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(53139);
/* harmony import */ var next_image__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(38579);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _utils_locals__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(10601);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(14195);
/* harmony import */ var dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(36619);
/* harmony import */ var dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(53291);
/* harmony import */ var dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _settings_site_settings__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(37070);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(99996);
/* harmony import */ var _question_card__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(94269);
/* harmony import */ var _components_icons_like_icon__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(23228);
/* harmony import */ var _components_icons_dislike_icon__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(69360);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_settings_site_settings__WEBPACK_IMPORTED_MODULE_13__]);
_settings_site_settings__WEBPACK_IMPORTED_MODULE_13__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



















const QuestionList = ({ questions , paginatorInfo , onPagination , onSort , onOrder  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_7__.useTranslation)();
    const { alignLeft  } = (0,_utils_locals__WEBPACK_IMPORTED_MODULE_8__/* .useIsRTL */ .S)();
    const { 0: sortingObj , 1: setSortingObj  } = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)({
        sort: _types__WEBPACK_IMPORTED_MODULE_5__/* .SortOrder.Desc */ .As.Desc,
        column: null
    });
    const onHeaderClick = (column)=>({
            onClick: ()=>{
                onSort((currentSortDirection)=>currentSortDirection === _types__WEBPACK_IMPORTED_MODULE_5__/* .SortOrder.Desc */ .As.Desc ? _types__WEBPACK_IMPORTED_MODULE_5__/* .SortOrder.Asc */ .As.Asc : _types__WEBPACK_IMPORTED_MODULE_5__/* .SortOrder.Desc */ .As.Desc
                );
                onOrder(column);
                setSortingObj({
                    sort: sortingObj.sort === _types__WEBPACK_IMPORTED_MODULE_5__/* .SortOrder.Desc */ .As.Desc ? _types__WEBPACK_IMPORTED_MODULE_5__/* .SortOrder.Asc */ .As.Asc : _types__WEBPACK_IMPORTED_MODULE_5__/* .SortOrder.Desc */ .As.Desc,
                    column: column
                });
            }
        })
    ;
    var ref;
    const columns = [
        {
            title: t('table:table-item-image'),
            dataIndex: 'product',
            key: 'product-image',
            align: alignLeft,
            width: 100,
            render: (product)=>{
                var ref1;
                /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(next_image__WEBPACK_IMPORTED_MODULE_6__["default"], {
                    src: (ref = product === null || product === void 0 ? void 0 : (ref1 = product.image) === null || ref1 === void 0 ? void 0 : ref1.thumbnail) !== null && ref !== void 0 ? ref : _settings_site_settings__WEBPACK_IMPORTED_MODULE_13__/* .siteSettings.product.placeholder */ .U.product.placeholder,
                    alt: product === null || product === void 0 ? void 0 : product.name,
                    layout: "fixed",
                    width: 60,
                    height: 60,
                    className: "overflow-hidden rounded"
                });
            }
        },
        {
            title: t('table:table-item-question-answer'),
            className: 'cursor-pointer',
            // dataIndex: "question",
            key: 'question',
            align: alignLeft,
            width: 450,
            render: (record, id)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_question_card__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .Z, {
                    record: record,
                    id: id
                })
        },
        {
            title: t('table:table-item-customer-name'),
            dataIndex: 'user',
            key: 'user',
            align: alignLeft,
            width: 150,
            render: (user)=>{
                /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    children: user === null || user === void 0 ? void 0 : user.name
                });
            }
        },
        {
            title: t('table:table-item-product-name'),
            dataIndex: 'product',
            key: 'product-image',
            align: alignLeft,
            width: 300,
            render: (product)=>{
                /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("a", {
                    href: "http://localhost:3003" + '/products/' + (product === null || product === void 0 ? void 0 : product.slug),
                    className: "transition-colors hover:text-accent",
                    target: "_blank",
                    rel: "noreferrer",
                    children: product === null || product === void 0 ? void 0 : product.name
                });
            }
        },
        {
            title: t('table:table-item-feedbacks'),
            // dataIndex: "product",
            key: 'feedbacks',
            align: alignLeft,
            width: 200,
            render: (record)=>{
                /*#__PURE__*/ return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                    className: "flex items-center space-x-4",
                    children: [
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                            className: "flex items-center text-xs tracking-wider text-gray-400 transition",
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_like_icon__WEBPACK_IMPORTED_MODULE_17__/* .LikeIcon */ .l, {
                                    className: "h-4 w-4 me-1.5"
                                }),
                                record === null || record === void 0 ? void 0 : record.positive_feedbacks_count
                            ]
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                            className: "flex items-center text-xs tracking-wider text-gray-400 transition",
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_dislike_icon__WEBPACK_IMPORTED_MODULE_18__/* .DislikeIcon */ .R, {
                                    className: "h-4 w-4 me-1.5"
                                }),
                                record === null || record === void 0 ? void 0 : record.negative_feedbacks_count
                            ]
                        })
                    ]
                });
            }
        },
        {
            // title: t("table:table-item-date"),
            title: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
                title: t('table:table-item-date'),
                ascending: sortingObj.sort === _types__WEBPACK_IMPORTED_MODULE_5__/* .SortOrder.Asc */ .As.Asc && sortingObj.column === 'created_at',
                isActive: sortingObj.column === 'created_at'
            }),
            className: 'cursor-pointer',
            dataIndex: 'created_at',
            key: 'created_at',
            align: alignLeft,
            onHeaderCell: ()=>onHeaderClick('created_at')
            ,
            render: (date)=>{
                dayjs__WEBPACK_IMPORTED_MODULE_4___default().extend((dayjs_plugin_relativeTime__WEBPACK_IMPORTED_MODULE_10___default()));
                dayjs__WEBPACK_IMPORTED_MODULE_4___default().extend((dayjs_plugin_utc__WEBPACK_IMPORTED_MODULE_11___default()));
                dayjs__WEBPACK_IMPORTED_MODULE_4___default().extend((dayjs_plugin_timezone__WEBPACK_IMPORTED_MODULE_12___default()));
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "whitespace-nowrap",
                    children: dayjs__WEBPACK_IMPORTED_MODULE_4___default().utc(date).tz(dayjs__WEBPACK_IMPORTED_MODULE_4___default().tz.guess()).fromNow()
                }));
            }
        },
        {
            title: t('table:table-item-actions'),
            dataIndex: 'id',
            key: 'actions',
            align: 'right',
            width: 150,
            render: function Render(_, id) {
                const { query: { shop  } ,  } = (0,next_router__WEBPACK_IMPORTED_MODULE_14__.useRouter)();
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_action_buttons__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                    id: id,
                    editModalView: "REPLY_QUESTION",
                    deleteModalView: !shop ? 'DELETE_QUESTION' : false
                }));
            }
        }, 
    ];
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "mb-6 overflow-hidden rounded shadow",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_table__WEBPACK_IMPORTED_MODULE_2__/* .Table */ .i, {
                    //@ts-ignore
                    columns: columns,
                    emptyText: t('table:empty-table-data'),
                    data: questions,
                    rowKey: "id",
                    scroll: {
                        x: 1000
                    }
                })
            }),
            !!(paginatorInfo === null || paginatorInfo === void 0 ? void 0 : paginatorInfo.total) && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "flex items-center justify-end",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_pagination__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                    total: paginatorInfo.total,
                    current: paginatorInfo.currentPage,
                    pageSize: paginatorInfo.perPage,
                    onChange: onPagination
                })
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (QuestionList);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 61849:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ pagination)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
// EXTERNAL MODULE: external "rc-pagination"
var external_rc_pagination_ = __webpack_require__(73006);
var external_rc_pagination_default = /*#__PURE__*/__webpack_require__.n(external_rc_pagination_);
;// CONCATENATED MODULE: ./src/components/icons/arrow-next.tsx

const ArrowNext = ({ ...props })=>{
    return(/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 512 512",
        width: "20",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            d: "M294.1 256L167 129c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.3 34 0L345 239c9.1 9.1 9.3 23.7.7 33.1L201.1 417c-4.7 4.7-10.9 7-17 7s-12.3-2.3-17-7c-9.4-9.4-9.4-24.6 0-33.9l127-127.1z",
            fill: "currentColor",
            stroke: "currentColor"
        })
    }));
};

;// CONCATENATED MODULE: ./src/components/icons/arrow-prev.tsx

const ArrowPrev = ({ ...props })=>{
    return(/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 512 512",
        width: "20",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            d: "M217.9 256L345 129c9.4-9.4 9.4-24.6 0-33.9-9.4-9.4-24.6-9.3-34 0L167 239c-9.1 9.1-9.3 23.7-.7 33.1L310.9 417c4.7 4.7 10.9 7 17 7s12.3-2.3 17-7c9.4-9.4 9.4-24.6 0-33.9L217.9 256z",
            fill: "currentColor",
            stroke: "currentColor"
        })
    }));
};

;// CONCATENATED MODULE: ./src/components/ui/pagination.tsx





const Pagination = (props)=>{
    return(/*#__PURE__*/ jsx_runtime_.jsx((external_rc_pagination_default()), {
        nextIcon: /*#__PURE__*/ jsx_runtime_.jsx(ArrowNext, {}),
        prevIcon: /*#__PURE__*/ jsx_runtime_.jsx(ArrowPrev, {}),
        ...props
    }));
};
/* harmony default export */ const pagination = (Pagination);


/***/ }),

/***/ 5034:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "h": () => (/* binding */ crudFactory)
/* harmony export */ });
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_0__]);
_http_client__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

function crudFactory(endpoint) {
    return {
        all (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        paginated (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        get ({ slug , language  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(`${endpoint}/${slug}`, {
                language
            });
        },
        create (data) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.post */ .eN.post(endpoint, data);
        },
        update ({ id , ...input }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.put */ .eN.put(`${endpoint}/${id}`, input);
        },
        delete ({ id  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient["delete"] */ .eN["delete"](`${endpoint}/${id}`);
        }
    };
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 95208:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "M": () => (/* binding */ questionClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5034);
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const questionClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_1__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.QUESTIONS */ .P.QUESTIONS),
    get ({ id  }) {
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.QUESTIONS */ .P.QUESTIONS}/${id}`);
    },
    paginated: ({ type , shop_id , ...params })=>{
        return _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.QUESTIONS */ .P.QUESTIONS, {
            searchJoin: 'and',
            with: 'product;user',
            ...params,
            search: _http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                type,
                shop_id
            })
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 10468:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Pb": () => (/* binding */ useQuestionsQuery),
/* harmony export */   "bD": () => (/* binding */ useReplyQuestionMutation),
/* harmony export */   "VR": () => (/* binding */ useDeleteQuestionMutation)
/* harmony export */ });
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_data_mappers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(63354);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(85057);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _data_client_question__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(95208);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_question__WEBPACK_IMPORTED_MODULE_5__]);
_data_client_question__WEBPACK_IMPORTED_MODULE_5__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







const useQuestionsQuery = (options)=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_2__/* .API_ENDPOINTS.QUESTIONS */ .P.QUESTIONS,
        options
    ], ({ queryKey , pageParam  })=>_data_client_question__WEBPACK_IMPORTED_MODULE_5__/* .questionClient.paginated */ .M.paginated(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    var ref;
    return {
        questions: (ref = data === null || data === void 0 ? void 0 : data.data) !== null && ref !== void 0 ? ref : [],
        paginatorInfo: (0,_utils_data_mappers__WEBPACK_IMPORTED_MODULE_1__/* .mapPaginatorData */ .Q)(data),
        error,
        loading: isLoading
    };
};
const useReplyQuestionMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_4__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)(_data_client_question__WEBPACK_IMPORTED_MODULE_5__/* .questionClient.update */ .M.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_3__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_2__/* .API_ENDPOINTS.QUESTIONS */ .P.QUESTIONS);
        }
    });
};
const useDeleteQuestionMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_4__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)(_data_client_question__WEBPACK_IMPORTED_MODULE_5__/* .questionClient["delete"] */ .M["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_3__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_2__/* .API_ENDPOINTS.QUESTIONS */ .P.QUESTIONS);
        }
    });
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 74758:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Questions),
/* harmony export */   "getStaticProps": () => (/* binding */ getStaticProps)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_question_question_list__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31700);
/* harmony import */ var _components_common_card__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(81258);
/* harmony import */ var _components_layouts_admin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(40792);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _components_ui_error_message__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(30110);
/* harmony import */ var _components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(47898);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(53139);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(25460);
/* harmony import */ var next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _data_question__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(10468);
/* harmony import */ var _utils_auth_utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(49239);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_question_question_list__WEBPACK_IMPORTED_MODULE_1__, _components_layouts_admin__WEBPACK_IMPORTED_MODULE_3__, _data_question__WEBPACK_IMPORTED_MODULE_10__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_11__]);
([_components_question_question_list__WEBPACK_IMPORTED_MODULE_1__, _components_layouts_admin__WEBPACK_IMPORTED_MODULE_3__, _data_question__WEBPACK_IMPORTED_MODULE_10__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_11__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);












function Questions() {
    const { 0: page , 1: setPage  } = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(1);
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_8__.useTranslation)();
    const { 0: orderBy , 1: setOrder  } = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)('created_at');
    const { 0: sortedBy , 1: setColumn  } = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(_types__WEBPACK_IMPORTED_MODULE_7__/* .SortOrder.Desc */ .As.Desc);
    const { questions , paginatorInfo , loading , error  } = (0,_data_question__WEBPACK_IMPORTED_MODULE_10__/* .useQuestionsQuery */ .Pb)({
        limit: 15,
        page,
        answer: 'null',
        orderBy,
        sortedBy
    });
    if (loading) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
        text: t('common:text-loading')
    }));
    if (error) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_error_message__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        message: error.message
    }));
    function handlePagination(current) {
        setPage(current);
    }
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_card__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                className: "flex flex-col mb-8",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                    className: "flex flex-col items-center w-full md:flex-row",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h1", {
                        className: "text-xl font-semibold text-heading",
                        children: t('common:sidebar-nav-item-questions')
                    })
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_question_question_list__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                questions: questions,
                paginatorInfo: paginatorInfo,
                onPagination: handlePagination,
                onOrder: setOrder,
                onSort: setColumn
            })
        ]
    }));
};
Questions.authenticate = {
    permissions: _utils_auth_utils__WEBPACK_IMPORTED_MODULE_11__/* .adminOnly */ .M$
};
Questions.Layout = _components_layouts_admin__WEBPACK_IMPORTED_MODULE_3__["default"];
const getStaticProps = async ({ locale  })=>({
        props: {
            ...await (0,next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_9__.serverSideTranslations)(locale, [
                'form',
                'common',
                'table'
            ])
        }
    })
;

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9677:
/***/ ((module) => {

module.exports = require("@reach/portal");

/***/ }),

/***/ 25782:
/***/ ((module) => {

module.exports = require("body-scroll-lock");

/***/ }),

/***/ 33104:
/***/ ((module) => {

module.exports = require("camelcase-keys");

/***/ }),

/***/ 59003:
/***/ ((module) => {

module.exports = require("classnames");

/***/ }),

/***/ 84802:
/***/ ((module) => {

module.exports = require("cookie");

/***/ }),

/***/ 1635:
/***/ ((module) => {

module.exports = require("dayjs");

/***/ }),

/***/ 14195:
/***/ ((module) => {

module.exports = require("dayjs/plugin/relativeTime");

/***/ }),

/***/ 53291:
/***/ ((module) => {

module.exports = require("dayjs/plugin/timezone");

/***/ }),

/***/ 36619:
/***/ ((module) => {

module.exports = require("dayjs/plugin/utc");

/***/ }),

/***/ 11377:
/***/ ((module) => {

module.exports = require("next-i18next");

/***/ }),

/***/ 25460:
/***/ ((module) => {

module.exports = require("next-i18next/serverSideTranslations");

/***/ }),

/***/ 60562:
/***/ ((module) => {

module.exports = require("next/dist/server/denormalize-page-path.js");

/***/ }),

/***/ 78028:
/***/ ((module) => {

module.exports = require("next/dist/server/image-config.js");

/***/ }),

/***/ 94957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 3539:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/detect-domain-locale.js");

/***/ }),

/***/ 34014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 50744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 78524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 78020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 24964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 29565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 64365:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-middleware-regex.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 91292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 80979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 36052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 84226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 95052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 59232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 71853:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 153:
/***/ ((module) => {

module.exports = require("overlayscrollbars-react");

/***/ }),

/***/ 73006:
/***/ ((module) => {

module.exports = require("rc-pagination");

/***/ }),

/***/ 73345:
/***/ ((module) => {

module.exports = require("rc-table");

/***/ }),

/***/ 16689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 61175:
/***/ ((module) => {

module.exports = require("react-query");

/***/ }),

/***/ 1187:
/***/ ((module) => {

module.exports = require("react-toastify");

/***/ }),

/***/ 57139:
/***/ ((module) => {

module.exports = require("react-use/lib/useLocalStorage");

/***/ }),

/***/ 20997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 61185:
/***/ ((module) => {

module.exports = import("@headlessui/react");;

/***/ }),

/***/ 99648:
/***/ ((module) => {

module.exports = import("axios");;

/***/ }),

/***/ 66197:
/***/ ((module) => {

module.exports = import("framer-motion");;

/***/ }),

/***/ 82451:
/***/ ((module) => {

module.exports = import("jotai");;

/***/ }),

/***/ 2752:
/***/ ((module) => {

module.exports = import("jotai/utils");;

/***/ }),

/***/ 69915:
/***/ ((module) => {

module.exports = import("js-cookie");;

/***/ }),

/***/ 24281:
/***/ ((module) => {

module.exports = import("tiny-invariant");;

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [1842,16,9894,8579,3406,3691,9809,7070,601,7721,6411,9239,3605,9249,5839,8760,4602,9831,4014,7898,792,3139,4144,8243,3955,1044,2774,6229], () => (__webpack_exec__(74758)));
module.exports = __webpack_exports__;

})();