"use strict";
(() => {
var exports = {};
exports.id = 662;
exports.ids = [662,4896,8788,7725,263,5827,642];
exports.modules = {

/***/ 20286:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Uploader)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_icons_upload_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19525);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_dropzone__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56358);
/* harmony import */ var react_dropzone__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_dropzone__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_icons_close_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29581);
/* harmony import */ var _components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(47898);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _data_upload__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(34421);
/* harmony import */ var next_image__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(38579);
/* harmony import */ var _utils_placeholders__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(34896);
/* harmony import */ var _utils_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(30957);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_upload__WEBPACK_IMPORTED_MODULE_7__]);
_data_upload__WEBPACK_IMPORTED_MODULE_7__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];











const getPreviewImage = (value)=>{
    let images = [];
    if (value) {
        images = Array.isArray(value) ? value : [
            {
                ...value
            }
        ];
    }
    return images;
};
function Uploader({ onChange , value , multiple , acceptFile , helperText  }) {
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_6__.useTranslation)();
    const { 0: files , 1: setFiles  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(getPreviewImage(value));
    const { mutate: upload , isLoading: loading  } = (0,_data_upload__WEBPACK_IMPORTED_MODULE_7__/* .useUploadMutation */ .g)();
    const { 0: error1 , 1: setError  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(null);
    const { getRootProps , getInputProps  } = (0,react_dropzone__WEBPACK_IMPORTED_MODULE_3__.useDropzone)({
        ...!acceptFile ? {
            accept: 'image/*'
        } : {
            accept: _utils_constants__WEBPACK_IMPORTED_MODULE_10__/* .ACCEPTED_FILE_TYPES */ ._0
        },
        multiple,
        onDrop: async (acceptedFiles)=>{
            if (acceptedFiles.length) {
                upload(acceptedFiles, {
                    onSuccess: (data)=>{
                        // Process Digital File Name section
                        data && (data === null || data === void 0 ? void 0 : data.map((file, idx)=>{
                            var ref, ref1;
                            const splitArray = file === null || file === void 0 ? void 0 : (ref = file.original) === null || ref === void 0 ? void 0 : ref.split('/');
                            let fileSplitName = (ref1 = splitArray[(splitArray === null || splitArray === void 0 ? void 0 : splitArray.length) - 1]) === null || ref1 === void 0 ? void 0 : ref1.split('.');
                            const fileType = fileSplitName === null || fileSplitName === void 0 ? void 0 : fileSplitName.pop(); // it will pop the last item from the fileSplitName arr which is the file ext
                            const filename = fileSplitName === null || fileSplitName === void 0 ? void 0 : fileSplitName.join('.'); // it will join the array with dot, which restore the original filename
                            data[idx]['file_name'] = filename + '.' + fileType;
                        }));
                        let mergedData;
                        if (multiple) {
                            mergedData = files.concat(data);
                            setFiles(files.concat(data));
                        } else {
                            mergedData = data[0];
                            setFiles(data);
                        }
                        if (onChange) {
                            onChange(mergedData);
                        }
                    }
                });
            }
        },
        onDropRejected: (fileRejections)=>{
            fileRejections.forEach((file)=>{
                var ref;
                file === null || file === void 0 ? void 0 : (ref = file.errors) === null || ref === void 0 ? void 0 : ref.forEach((error)=>{
                    if ((error === null || error === void 0 ? void 0 : error.code) === 'file-too-large') {
                        setError(t('error-file-too-large'));
                    } else if ((error === null || error === void 0 ? void 0 : error.code) === 'file-invalid-type') {
                        setError(t('error-invalid-file-type'));
                    }
                });
            });
        }
    });
    const handleDelete = (image)=>{
        const images = files.filter((file)=>file.thumbnail !== image
        );
        setFiles(images);
        if (onChange) {
            onChange(images);
        }
    };
    const thumbs = files === null || files === void 0 ? void 0 : files.map((file, idx)=>{
        const imgTypes = [
            'tif',
            'tiff',
            'bmp',
            'jpg',
            'jpeg',
            'gif',
            'png',
            'eps',
            'raw', 
        ];
        // let filename, fileType, isImage;
        if (file && file.id) {
            var ref;
            console.log('File is', file);
            // const processedFile = processFileWithName(file);
            const splitArray = file === null || file === void 0 ? void 0 : (ref = file.file_name) === null || ref === void 0 ? void 0 : ref.split('.');
            const fileType = splitArray === null || splitArray === void 0 ? void 0 : splitArray.pop(); // it will pop the last item from the fileSplitName arr which is the file ext
            const filename = splitArray === null || splitArray === void 0 ? void 0 : splitArray.join('.'); // it will join the array with dot, which restore the original filename
            const isImage = (file === null || file === void 0 ? void 0 : file.thumbnail) && imgTypes.includes(fileType); // check if the original filename has the img ext
            // Old Code *******
            // const splitArray = file?.original?.split('/');
            // let fileSplitName = splitArray[splitArray?.length - 1]?.split('.'); // it will create an array of words of filename
            // const fileType = fileSplitName.pop(); // it will pop the last item from the fileSplitName arr which is the file ext
            // const filename = fileSplitName.join('.'); // it will join the array with dot, which restore the original filename
            // const isImage = file?.thumbnail && imgTypes.includes(fileType); // check if the original filename has the img ext
            return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: `relative mt-2 inline-flex flex-col overflow-hidden rounded me-2 ${isImage ? 'border border-border-200' : ''}`,
                children: [
                    isImage ? // <div className="flex h-16 w-16 min-w-0 items-center justify-center overflow-hidden">
                    //   <Image
                    //     src={file.thumbnail}
                    //     width={56}
                    //     height={56}
                    //     alt="uploaded image"
                    //   />
                    // </div>
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("figure", {
                        className: "relative h-16 w-28",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(next_image__WEBPACK_IMPORTED_MODULE_8__["default"], {
                            src: file.thumbnail,
                            alt: filename,
                            layout: "fill",
                            objectFit: "contain"
                        })
                    }) : /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                        className: "flex flex-col items-center",
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                className: "flex h-14 w-14 min-w-0 items-center justify-center overflow-hidden",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(next_image__WEBPACK_IMPORTED_MODULE_8__["default"], {
                                    src: _utils_placeholders__WEBPACK_IMPORTED_MODULE_9__/* .zipPlaceholder */ .GZ,
                                    width: 56,
                                    height: 56,
                                    alt: "upload placeholder"
                                })
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("p", {
                                className: "flex cursor-default items-baseline p-1 text-xs text-body",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                        className: "inline-block max-w-[64px] overflow-hidden overflow-ellipsis whitespace-nowrap",
                                        title: `${filename}.${fileType}`,
                                        children: filename
                                    }),
                                    ".",
                                    fileType
                                ]
                            })
                        ]
                    }),
                    multiple ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                        className: "absolute top-1 flex h-4 w-4 items-center justify-center rounded-full bg-red-600 text-xs text-light shadow-xl outline-none end-1",
                        onClick: ()=>handleDelete(file.thumbnail)
                        ,
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_close_icon__WEBPACK_IMPORTED_MODULE_4__/* .CloseIcon */ .T, {
                            width: 10,
                            height: 10
                        })
                    }) : null
                ]
            }, idx));
        }
    });
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(()=>()=>{
            // Reset error after upload new file
            setError(null);
            // Make sure to revoke the data uris to avoid memory leaks
            files.forEach((file)=>URL.revokeObjectURL(file.thumbnail)
            );
        }
    , [
        files
    ]);
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("section", {
        className: "upload",
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                ...getRootProps({
                    className: 'border-dashed border-2 border-border-base h-36 rounded flex flex-col justify-center items-center cursor-pointer focus:border-accent-400 focus:outline-none'
                }),
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                        ...getInputProps()
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_upload_icon__WEBPACK_IMPORTED_MODULE_1__/* .UploadIcon */ .r, {
                        className: "text-muted-light"
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                        className: "mt-4 text-center text-sm text-body",
                        children: helperText ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                            className: "font-semibold text-gray-500",
                            children: helperText
                        }) : /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                    className: "font-semibold text-accent",
                                    children: t('text-upload-highlight')
                                }),
                                ' ',
                                t('text-upload-message'),
                                " ",
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("br", {}),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                    className: "text-xs text-body",
                                    children: t('text-img-format')
                                })
                            ]
                        })
                    }),
                    error1 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                        className: "mt-4 text-center text-sm text-body text-red-600",
                        children: error1
                    })
                ]
            }),
            (!!thumbs.length || loading) && /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("aside", {
                className: "mt-2 flex flex-wrap",
                children: [
                    !!thumbs.length && thumbs,
                    loading && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "mt-2 flex h-16 items-center ms-2",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                            simple: true,
                            className: "h-6 w-6"
                        })
                    })
                ]
            })
        ]
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 10058:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ GooglePlacesAutocomplete)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _react_google_maps_api__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(82433);
/* harmony import */ var _react_google_maps_api__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_react_google_maps_api__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(47898);
/* harmony import */ var _components_icons_map_pin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(93617);






const libraries = [
    'places'
];
function GooglePlacesAutocomplete({ onChange , data , disabled =false , icon =false  }) {
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const { isLoaded , loadError  } = (0,_react_google_maps_api__WEBPACK_IMPORTED_MODULE_1__.useJsApiLoader)({
        id: 'google_map_autocomplete',
        googleMapsApiKey: "",
        libraries
    });
    const [autocomplete, setAutocomplete] = react__WEBPACK_IMPORTED_MODULE_2___default().useState(null);
    const onLoad = react__WEBPACK_IMPORTED_MODULE_2___default().useCallback(function callback(autocompleteInstance) {
        setAutocomplete(autocompleteInstance);
    }, []);
    const onUnmount = react__WEBPACK_IMPORTED_MODULE_2___default().useCallback(function callback() {
        setAutocomplete(null);
    }, []);
    const onPlaceChanged = ()=>{
        const place = autocomplete.getPlace();
        if (!place.geometry || !place.geometry.location) {
            return;
        }
        const location = {
            lat: place.geometry.location.lat(),
            lng: place.geometry.location.lng(),
            formattedAddress: place.formatted_address
        };
        for (const component of place.address_components){
            // @ts-ignore remove once typings fixed
            const componentType = component.types[0];
            switch(componentType){
                case 'postal_code':
                    {
                        location['zip'] = component.long_name;
                        break;
                    }
                case 'postal_code_suffix':
                    {
                        location['zip'] = `${location === null || location === void 0 ? void 0 : location.zip}-${component.long_name}`;
                        break;
                    }
                case 'state_name':
                    location['street_address'] = component.long_name;
                    break;
                case 'route':
                    location['street_address'] = component.long_name;
                    break;
                case 'sublocality_level_1':
                    location['street_address'] = component.long_name;
                    break;
                case 'locality':
                    location['city'] = component.long_name;
                    break;
                case 'administrative_area_level_1':
                    {
                        location['state'] = component.short_name;
                        break;
                    }
                case 'country':
                    location['country'] = component.long_name;
                    break;
            }
        }
        if (onChange) {
            onChange(location);
        }
    };
    if (loadError) {
        return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
            children: t('common:text-map-cant-load')
        }));
    }
    return isLoaded ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "relative",
        children: [
            icon && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "absolute top-0 left-0 flex items-center justify-center w-10 h-12 text-gray-400",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_map_pin__WEBPACK_IMPORTED_MODULE_5__/* .MapPin */ .$, {
                    className: "w-[18px]"
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_react_google_maps_api__WEBPACK_IMPORTED_MODULE_1__.Autocomplete, {
                onLoad: onLoad,
                onPlaceChanged: onPlaceChanged,
                onUnmount: onUnmount,
                fields: [
                    'address_components',
                    'geometry.location',
                    'formatted_address', 
                ],
                types: [
                    'address'
                ],
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                    type: "text",
                    placeholder: t('form:placeholder-search-location'),
                    defaultValue: data === null || data === void 0 ? void 0 : data.formattedAddress,
                    className: `flex h-12 w-full appearance-none items-center rounded border border-border-base text-sm text-heading transition duration-300 ease-in-out  focus:border-accent focus:outline-none focus:ring-0 ${disabled ? 'cursor-not-allowed border-[#D4D8DD] bg-[#EEF1F4]' : ''} ${icon ? 'pe-4 ps-9' : 'px-4'}`,
                    disabled: disabled
                })
            })
        ]
    }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
        simple: true,
        className: "w-6 h-6"
    });
};


/***/ }),

/***/ 93617:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "$": () => (/* binding */ MapPin)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MapPin = ({ ...props })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 512 512",
        ...props,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            d: "M256 0C161.896 0 85.333 76.563 85.333 170.667c0 28.25 7.063 56.26 20.49 81.104L246.667 506.5c1.875 3.396 5.448 5.5 9.333 5.5s7.458-2.104 9.333-5.5l140.896-254.813c13.375-24.76 20.438-52.771 20.438-81.021C426.667 76.563 350.104 0 256 0zm0 256c-47.052 0-85.333-38.281-85.333-85.333S208.948 85.334 256 85.334s85.333 38.281 85.333 85.333S303.052 256 256 256z",
            fill: "currentColor"
        })
    }));
};


/***/ }),

/***/ 64131:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "FacebookIcon": () => (/* reexport */ FacebookIcon),
  "InstagramIcon": () => (/* reexport */ InstagramIcon),
  "TwitterIcon": () => (/* reexport */ TwitterIcon),
  "YouTubeIcon": () => (/* reexport */ YouTubeIcon)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
;// CONCATENATED MODULE: ./src/components/icons/social/facebook.tsx

const FacebookIcon = (props)=>/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 12 12",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            "data-name": "_ionicons_svg_logo-facebook (6)",
            d: "M11.338 0H.662A.663.663 0 000 .663v10.674a.663.663 0 00.662.662H6V7.25H4.566V5.5H6V4.206a2.28 2.28 0 012.459-2.394c.662 0 1.375.05 1.541.072V3.5H8.9c-.753 0-.9.356-.9.881V5.5h1.794L9.56 7.25H8V12h3.338a.663.663 0 00.662-.663V.662A.663.663 0 0011.338 0z",
            fill: "currentColor"
        })
    })
;

;// CONCATENATED MODULE: ./src/components/icons/social/instagram.tsx

const InstagramIcon = (props)=>/*#__PURE__*/ (0,jsx_runtime_.jsxs)("svg", {
        "data-name": "Group 96",
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 12 12",
        ...props,
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                "data-name": "Path 1",
                d: "M8.5 1A2.507 2.507 0 0111 3.5v5A2.507 2.507 0 018.5 11h-5A2.507 2.507 0 011 8.5v-5A2.507 2.507 0 013.5 1h5m0-1h-5A3.51 3.51 0 000 3.5v5A3.51 3.51 0 003.5 12h5A3.51 3.51 0 0012 8.5v-5A3.51 3.51 0 008.5 0z",
                fill: "currentColor"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("path", {
                "data-name": "Path 2",
                d: "M9.25 3.5a.75.75 0 11.75-.75.748.748 0 01-.75.75zM6 4a2 2 0 11-2 2 2 2 0 012-2m0-1a3 3 0 103 3 3 3 0 00-3-3z",
                fill: "currentColor"
            })
        ]
    })
;

;// CONCATENATED MODULE: ./src/components/icons/social/twitter.tsx

const TwitterIcon = (props)=>/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 14.747 12",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            "data-name": "_ionicons_svg_logo-twitter (5)",
            d: "M14.747 1.422a6.117 6.117 0 01-1.737.478A3.036 3.036 0 0014.341.225a6.012 6.012 0 01-1.922.734 3.025 3.025 0 00-5.234 2.069 2.962 2.962 0 00.078.691A8.574 8.574 0 011.026.553a3.032 3.032 0 00.941 4.044 2.955 2.955 0 01-1.375-.378v.037A3.028 3.028 0 003.02 7.225a3.046 3.046 0 01-.8.106 2.854 2.854 0 01-.569-.056 3.03 3.03 0 002.828 2.1 6.066 6.066 0 01-3.759 1.3 6.135 6.135 0 01-.722-.044A8.457 8.457 0 004.631 12a8.557 8.557 0 008.616-8.619c0-.131 0-.262-.009-.391a6.159 6.159 0 001.509-1.568z",
            fill: "currentColor"
        })
    })
;

;// CONCATENATED MODULE: ./src/components/icons/social/youtube.tsx

const YouTubeIcon = (props)=>/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 15.997 12",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            d: "M15.893 2.65A2.429 2.429 0 0013.581.113c-1.731-.081-3.5-.112-5.3-.112h-.563c-1.8 0-3.569.031-5.3.112A2.434 2.434 0 00.106 2.656C.028 3.768-.006 4.881-.003 5.993s.031 2.225.106 3.34a2.437 2.437 0 002.309 2.547c1.822.085 3.688.12 5.584.12s3.759-.031 5.581-.119a2.438 2.438 0 002.312-2.547c.075-1.116.109-2.228.106-3.344s-.027-2.225-.102-3.34zM6.468 9.059v-6.14l4.531 3.069z",
            fill: "currentColor"
        })
    })
;

;// CONCATENATED MODULE: ./src/components/icons/social/index.tsx






/***/ }),

/***/ 48975:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "w": () => (/* binding */ CURRENCY)
/* harmony export */ });
const CURRENCY = [
    {
        symbol: '$',
        name: 'US Dollar',
        symbol_native: '$',
        decimal_digits: 2,
        rounding: 0,
        code: 'USD',
        name_plural: 'US dollars'
    },
    {
        symbol: 'CA$',
        name: 'Canadian Dollar',
        symbol_native: '$',
        decimal_digits: 2,
        rounding: 0,
        code: 'CAD',
        name_plural: 'Canadian dollars'
    },
    {
        symbol: '€',
        name: 'Euro',
        symbol_native: '€',
        decimal_digits: 2,
        rounding: 0,
        code: 'EUR',
        name_plural: 'euros'
    },
    {
        symbol: 'AED',
        name: 'United Arab Emirates Dirham',
        symbol_native: 'د.إ.‏',
        decimal_digits: 2,
        rounding: 0,
        code: 'AED',
        name_plural: 'UAE dirhams'
    },
    {
        symbol: 'Af',
        name: 'Afghan Afghani',
        symbol_native: '؋',
        decimal_digits: 0,
        rounding: 0,
        code: 'AFN',
        name_plural: 'Afghan Afghanis'
    },
    {
        symbol: 'ALL',
        name: 'Albanian Lek',
        symbol_native: 'Lek',
        decimal_digits: 0,
        rounding: 0,
        code: 'ALL',
        name_plural: 'Albanian lek\xeb'
    },
    {
        symbol: 'AMD',
        name: 'Armenian Dram',
        symbol_native: 'դր.',
        decimal_digits: 0,
        rounding: 0,
        code: 'AMD',
        name_plural: 'Armenian drams'
    },
    {
        symbol: 'AR$',
        name: 'Argentine Peso',
        symbol_native: '$',
        decimal_digits: 2,
        rounding: 0,
        code: 'ARS',
        name_plural: 'Argentine pesos'
    },
    {
        symbol: 'AU$',
        name: 'Australian Dollar',
        symbol_native: '$',
        decimal_digits: 2,
        rounding: 0,
        code: 'AUD',
        name_plural: 'Australian dollars'
    },
    {
        symbol: 'man.',
        name: 'Azerbaijani Manat',
        symbol_native: 'ман.',
        decimal_digits: 2,
        rounding: 0,
        code: 'AZN',
        name_plural: 'Azerbaijani manats'
    },
    {
        symbol: 'KM',
        name: 'Bosnia-Herzegovina Convertible Mark',
        symbol_native: 'KM',
        decimal_digits: 2,
        rounding: 0,
        code: 'BAM',
        name_plural: 'Bosnia-Herzegovina convertible marks'
    },
    {
        symbol: 'Tk',
        name: 'Bangladeshi Taka',
        symbol_native: '৳',
        decimal_digits: 2,
        rounding: 0,
        code: 'BDT',
        name_plural: 'Bangladeshi takas'
    },
    {
        symbol: 'BGN',
        name: 'Bulgarian Lev',
        symbol_native: 'лв.',
        decimal_digits: 2,
        rounding: 0,
        code: 'BGN',
        name_plural: 'Bulgarian leva'
    },
    {
        symbol: 'BD',
        name: 'Bahraini Dinar',
        symbol_native: 'د.ب.‏',
        decimal_digits: 3,
        rounding: 0,
        code: 'BHD',
        name_plural: 'Bahraini dinars'
    },
    {
        symbol: 'FBu',
        name: 'Burundian Franc',
        symbol_native: 'FBu',
        decimal_digits: 0,
        rounding: 0,
        code: 'BIF',
        name_plural: 'Burundian francs'
    },
    {
        symbol: 'BN$',
        name: 'Brunei Dollar',
        symbol_native: '$',
        decimal_digits: 2,
        rounding: 0,
        code: 'BND',
        name_plural: 'Brunei dollars'
    },
    {
        symbol: 'Bs',
        name: 'Bolivian Boliviano',
        symbol_native: 'Bs',
        decimal_digits: 2,
        rounding: 0,
        code: 'BOB',
        name_plural: 'Bolivian bolivianos'
    },
    {
        symbol: 'R$',
        name: 'Brazilian Real',
        symbol_native: 'R$',
        decimal_digits: 2,
        rounding: 0,
        code: 'BRL',
        name_plural: 'Brazilian reals'
    },
    {
        symbol: 'BWP',
        name: 'Botswanan Pula',
        symbol_native: 'P',
        decimal_digits: 2,
        rounding: 0,
        code: 'BWP',
        name_plural: 'Botswanan pulas'
    },
    {
        symbol: 'Br',
        name: 'Belarusian Ruble',
        symbol_native: 'руб.',
        decimal_digits: 2,
        rounding: 0,
        code: 'BYN',
        name_plural: 'Belarusian rubles'
    },
    {
        symbol: 'BZ$',
        name: 'Belize Dollar',
        symbol_native: '$',
        decimal_digits: 2,
        rounding: 0,
        code: 'BZD',
        name_plural: 'Belize dollars'
    },
    {
        symbol: 'CDF',
        name: 'Congolese Franc',
        symbol_native: 'FrCD',
        decimal_digits: 2,
        rounding: 0,
        code: 'CDF',
        name_plural: 'Congolese francs'
    },
    {
        symbol: 'CHF',
        name: 'Swiss Franc',
        symbol_native: 'CHF',
        decimal_digits: 2,
        rounding: 0.05,
        code: 'CHF',
        name_plural: 'Swiss francs'
    },
    {
        symbol: 'CL$',
        name: 'Chilean Peso',
        symbol_native: '$',
        decimal_digits: 0,
        rounding: 0,
        code: 'CLP',
        name_plural: 'Chilean pesos'
    },
    {
        symbol: 'CN\xa5',
        name: 'Chinese Yuan',
        symbol_native: 'CN\xa5',
        decimal_digits: 2,
        rounding: 0,
        code: 'CNY',
        name_plural: 'Chinese yuan'
    },
    {
        symbol: 'CO$',
        name: 'Colombian Peso',
        symbol_native: '$',
        decimal_digits: 0,
        rounding: 0,
        code: 'COP',
        name_plural: 'Colombian pesos'
    },
    {
        symbol: '₡',
        name: 'Costa Rican Col\xf3n',
        symbol_native: '₡',
        decimal_digits: 0,
        rounding: 0,
        code: 'CRC',
        name_plural: 'Costa Rican col\xf3ns'
    },
    {
        symbol: 'CV$',
        name: 'Cape Verdean Escudo',
        symbol_native: 'CV$',
        decimal_digits: 2,
        rounding: 0,
        code: 'CVE',
        name_plural: 'Cape Verdean escudos'
    },
    {
        symbol: 'Kč',
        name: 'Czech Republic Koruna',
        symbol_native: 'Kč',
        decimal_digits: 2,
        rounding: 0,
        code: 'CZK',
        name_plural: 'Czech Republic korunas'
    },
    {
        symbol: 'Fdj',
        name: 'Djiboutian Franc',
        symbol_native: 'Fdj',
        decimal_digits: 0,
        rounding: 0,
        code: 'DJF',
        name_plural: 'Djiboutian francs'
    },
    {
        symbol: 'Dkr',
        name: 'Danish Krone',
        symbol_native: 'kr',
        decimal_digits: 2,
        rounding: 0,
        code: 'DKK',
        name_plural: 'Danish kroner'
    },
    {
        symbol: 'RD$',
        name: 'Dominican Peso',
        symbol_native: 'RD$',
        decimal_digits: 2,
        rounding: 0,
        code: 'DOP',
        name_plural: 'Dominican pesos'
    },
    {
        symbol: 'DA',
        name: 'Algerian Dinar',
        symbol_native: 'د.ج.‏',
        decimal_digits: 2,
        rounding: 0,
        code: 'DZD',
        name_plural: 'Algerian dinars'
    },
    {
        symbol: 'Ekr',
        name: 'Estonian Kroon',
        symbol_native: 'kr',
        decimal_digits: 2,
        rounding: 0,
        code: 'EEK',
        name_plural: 'Estonian kroons'
    },
    {
        symbol: 'EGP',
        name: 'Egyptian Pound',
        symbol_native: 'ج.م.‏',
        decimal_digits: 2,
        rounding: 0,
        code: 'EGP',
        name_plural: 'Egyptian pounds'
    },
    {
        symbol: 'Nfk',
        name: 'Eritrean Nakfa',
        symbol_native: 'Nfk',
        decimal_digits: 2,
        rounding: 0,
        code: 'ERN',
        name_plural: 'Eritrean nakfas'
    },
    {
        symbol: 'Br',
        name: 'Ethiopian Birr',
        symbol_native: 'Br',
        decimal_digits: 2,
        rounding: 0,
        code: 'ETB',
        name_plural: 'Ethiopian birrs'
    },
    {
        symbol: '\xa3',
        name: 'British Pound Sterling',
        symbol_native: '\xa3',
        decimal_digits: 2,
        rounding: 0,
        code: 'GBP',
        name_plural: 'British pounds sterling'
    },
    {
        symbol: 'GEL',
        name: 'Georgian Lari',
        symbol_native: 'GEL',
        decimal_digits: 2,
        rounding: 0,
        code: 'GEL',
        name_plural: 'Georgian laris'
    },
    {
        symbol: 'GH₵',
        name: 'Ghanaian Cedi',
        symbol_native: 'GH₵',
        decimal_digits: 2,
        rounding: 0,
        code: 'GHS',
        name_plural: 'Ghanaian cedis'
    },
    {
        symbol: 'FG',
        name: 'Guinean Franc',
        symbol_native: 'FG',
        decimal_digits: 0,
        rounding: 0,
        code: 'GNF',
        name_plural: 'Guinean francs'
    },
    {
        symbol: 'GTQ',
        name: 'Guatemalan Quetzal',
        symbol_native: 'Q',
        decimal_digits: 2,
        rounding: 0,
        code: 'GTQ',
        name_plural: 'Guatemalan quetzals'
    },
    {
        symbol: 'HK$',
        name: 'Hong Kong Dollar',
        symbol_native: '$',
        decimal_digits: 2,
        rounding: 0,
        code: 'HKD',
        name_plural: 'Hong Kong dollars'
    },
    {
        symbol: 'HNL',
        name: 'Honduran Lempira',
        symbol_native: 'L',
        decimal_digits: 2,
        rounding: 0,
        code: 'HNL',
        name_plural: 'Honduran lempiras'
    },
    {
        symbol: 'kn',
        name: 'Croatian Kuna',
        symbol_native: 'kn',
        decimal_digits: 2,
        rounding: 0,
        code: 'HRK',
        name_plural: 'Croatian kunas'
    },
    {
        symbol: 'Ft',
        name: 'Hungarian Forint',
        symbol_native: 'Ft',
        decimal_digits: 0,
        rounding: 0,
        code: 'HUF',
        name_plural: 'Hungarian forints'
    },
    {
        symbol: 'Rp',
        name: 'Indonesian Rupiah',
        symbol_native: 'Rp',
        decimal_digits: 0,
        rounding: 0,
        code: 'IDR',
        name_plural: 'Indonesian rupiahs'
    },
    {
        symbol: '₪',
        name: 'Israeli New Sheqel',
        symbol_native: '₪',
        decimal_digits: 2,
        rounding: 0,
        code: 'ILS',
        name_plural: 'Israeli new sheqels'
    },
    {
        symbol: 'Rs',
        name: 'Indian Rupee',
        symbol_native: 'টকা',
        decimal_digits: 2,
        rounding: 0,
        code: 'INR',
        name_plural: 'Indian rupees'
    },
    {
        symbol: 'IQD',
        name: 'Iraqi Dinar',
        symbol_native: 'د.ع.‏',
        decimal_digits: 0,
        rounding: 0,
        code: 'IQD',
        name_plural: 'Iraqi dinars'
    },
    {
        symbol: 'IRR',
        name: 'Iranian Rial',
        symbol_native: '﷼',
        decimal_digits: 0,
        rounding: 0,
        code: 'IRR',
        name_plural: 'Iranian rials'
    },
    {
        symbol: 'Ikr',
        name: 'Icelandic Kr\xf3na',
        symbol_native: 'kr',
        decimal_digits: 0,
        rounding: 0,
        code: 'ISK',
        name_plural: 'Icelandic kr\xf3nur'
    },
    {
        symbol: 'J$',
        name: 'Jamaican Dollar',
        symbol_native: '$',
        decimal_digits: 2,
        rounding: 0,
        code: 'JMD',
        name_plural: 'Jamaican dollars'
    },
    {
        symbol: 'JD',
        name: 'Jordanian Dinar',
        symbol_native: 'د.أ.‏',
        decimal_digits: 3,
        rounding: 0,
        code: 'JOD',
        name_plural: 'Jordanian dinars'
    },
    {
        symbol: '\xa5',
        name: 'Japanese Yen',
        symbol_native: '￥',
        decimal_digits: 0,
        rounding: 0,
        code: 'JPY',
        name_plural: 'Japanese yen'
    },
    {
        symbol: 'Ksh',
        name: 'Kenyan Shilling',
        symbol_native: 'Ksh',
        decimal_digits: 2,
        rounding: 0,
        code: 'KES',
        name_plural: 'Kenyan shillings'
    },
    {
        symbol: 'KHR',
        name: 'Cambodian Riel',
        symbol_native: '៛',
        decimal_digits: 2,
        rounding: 0,
        code: 'KHR',
        name_plural: 'Cambodian riels'
    },
    {
        symbol: 'CF',
        name: 'Comorian Franc',
        symbol_native: 'FC',
        decimal_digits: 0,
        rounding: 0,
        code: 'KMF',
        name_plural: 'Comorian francs'
    },
    {
        symbol: '₩',
        name: 'South Korean Won',
        symbol_native: '₩',
        decimal_digits: 0,
        rounding: 0,
        code: 'KRW',
        name_plural: 'South Korean won'
    },
    {
        symbol: 'KD',
        name: 'Kuwaiti Dinar',
        symbol_native: 'د.ك.‏',
        decimal_digits: 3,
        rounding: 0,
        code: 'KWD',
        name_plural: 'Kuwaiti dinars'
    },
    {
        symbol: 'KZT',
        name: 'Kazakhstani Tenge',
        symbol_native: 'тңг.',
        decimal_digits: 2,
        rounding: 0,
        code: 'KZT',
        name_plural: 'Kazakhstani tenges'
    },
    {
        symbol: 'LB\xa3',
        name: 'Lebanese Pound',
        symbol_native: 'ل.ل.‏',
        decimal_digits: 0,
        rounding: 0,
        code: 'LBP',
        name_plural: 'Lebanese pounds'
    },
    {
        symbol: 'SLRs',
        name: 'Sri Lankan Rupee',
        symbol_native: 'SL Re',
        decimal_digits: 2,
        rounding: 0,
        code: 'LKR',
        name_plural: 'Sri Lankan rupees'
    },
    {
        symbol: 'Lt',
        name: 'Lithuanian Litas',
        symbol_native: 'Lt',
        decimal_digits: 2,
        rounding: 0,
        code: 'LTL',
        name_plural: 'Lithuanian litai'
    },
    {
        symbol: 'Ls',
        name: 'Latvian Lats',
        symbol_native: 'Ls',
        decimal_digits: 2,
        rounding: 0,
        code: 'LVL',
        name_plural: 'Latvian lati'
    },
    {
        symbol: 'LD',
        name: 'Libyan Dinar',
        symbol_native: 'د.ل.‏',
        decimal_digits: 3,
        rounding: 0,
        code: 'LYD',
        name_plural: 'Libyan dinars'
    },
    {
        symbol: 'MAD',
        name: 'Moroccan Dirham',
        symbol_native: 'د.م.‏',
        decimal_digits: 2,
        rounding: 0,
        code: 'MAD',
        name_plural: 'Moroccan dirhams'
    },
    {
        symbol: 'MDL',
        name: 'Moldovan Leu',
        symbol_native: 'MDL',
        decimal_digits: 2,
        rounding: 0,
        code: 'MDL',
        name_plural: 'Moldovan lei'
    },
    {
        symbol: 'MGA',
        name: 'Malagasy Ariary',
        symbol_native: 'MGA',
        decimal_digits: 0,
        rounding: 0,
        code: 'MGA',
        name_plural: 'Malagasy Ariaries'
    },
    {
        symbol: 'MKD',
        name: 'Macedonian Denar',
        symbol_native: 'MKD',
        decimal_digits: 2,
        rounding: 0,
        code: 'MKD',
        name_plural: 'Macedonian denari'
    },
    {
        symbol: 'MMK',
        name: 'Myanma Kyat',
        symbol_native: 'K',
        decimal_digits: 0,
        rounding: 0,
        code: 'MMK',
        name_plural: 'Myanma kyats'
    },
    {
        symbol: 'MOP$',
        name: 'Macanese Pataca',
        symbol_native: 'MOP$',
        decimal_digits: 2,
        rounding: 0,
        code: 'MOP',
        name_plural: 'Macanese patacas'
    },
    {
        symbol: 'MURs',
        name: 'Mauritian Rupee',
        symbol_native: 'MURs',
        decimal_digits: 0,
        rounding: 0,
        code: 'MUR',
        name_plural: 'Mauritian rupees'
    },
    {
        symbol: 'MX$',
        name: 'Mexican Peso',
        symbol_native: '$',
        decimal_digits: 2,
        rounding: 0,
        code: 'MXN',
        name_plural: 'Mexican pesos'
    },
    {
        symbol: 'RM',
        name: 'Malaysian Ringgit',
        symbol_native: 'RM',
        decimal_digits: 2,
        rounding: 0,
        code: 'MYR',
        name_plural: 'Malaysian ringgits'
    },
    {
        symbol: 'MTn',
        name: 'Mozambican Metical',
        symbol_native: 'MTn',
        decimal_digits: 2,
        rounding: 0,
        code: 'MZN',
        name_plural: 'Mozambican meticals'
    },
    {
        symbol: 'N$',
        name: 'Namibian Dollar',
        symbol_native: 'N$',
        decimal_digits: 2,
        rounding: 0,
        code: 'NAD',
        name_plural: 'Namibian dollars'
    },
    {
        symbol: '₦',
        name: 'Nigerian Naira',
        symbol_native: '₦',
        decimal_digits: 2,
        rounding: 0,
        code: 'NGN',
        name_plural: 'Nigerian nairas'
    },
    {
        symbol: 'C$',
        name: 'Nicaraguan C\xf3rdoba',
        symbol_native: 'C$',
        decimal_digits: 2,
        rounding: 0,
        code: 'NIO',
        name_plural: 'Nicaraguan c\xf3rdobas'
    },
    {
        symbol: 'Nkr',
        name: 'Norwegian Krone',
        symbol_native: 'kr',
        decimal_digits: 2,
        rounding: 0,
        code: 'NOK',
        name_plural: 'Norwegian kroner'
    },
    {
        symbol: 'NPRs',
        name: 'Nepalese Rupee',
        symbol_native: 'नेरू',
        decimal_digits: 2,
        rounding: 0,
        code: 'NPR',
        name_plural: 'Nepalese rupees'
    },
    {
        symbol: 'NZ$',
        name: 'New Zealand Dollar',
        symbol_native: '$',
        decimal_digits: 2,
        rounding: 0,
        code: 'NZD',
        name_plural: 'New Zealand dollars'
    },
    {
        symbol: 'OMR',
        name: 'Omani Rial',
        symbol_native: 'ر.ع.‏',
        decimal_digits: 3,
        rounding: 0,
        code: 'OMR',
        name_plural: 'Omani rials'
    },
    {
        symbol: 'B/.',
        name: 'Panamanian Balboa',
        symbol_native: 'B/.',
        decimal_digits: 2,
        rounding: 0,
        code: 'PAB',
        name_plural: 'Panamanian balboas'
    },
    {
        symbol: 'S/.',
        name: 'Peruvian Nuevo Sol',
        symbol_native: 'S/.',
        decimal_digits: 2,
        rounding: 0,
        code: 'PEN',
        name_plural: 'Peruvian nuevos soles'
    },
    {
        symbol: '₱',
        name: 'Philippine Peso',
        symbol_native: '₱',
        decimal_digits: 2,
        rounding: 0,
        code: 'PHP',
        name_plural: 'Philippine pesos'
    },
    {
        symbol: 'PKRs',
        name: 'Pakistani Rupee',
        symbol_native: '₨',
        decimal_digits: 0,
        rounding: 0,
        code: 'PKR',
        name_plural: 'Pakistani rupees'
    },
    {
        symbol: 'zł',
        name: 'Polish Zloty',
        symbol_native: 'zł',
        decimal_digits: 2,
        rounding: 0,
        code: 'PLN',
        name_plural: 'Polish zlotys'
    },
    {
        symbol: '₲',
        name: 'Paraguayan Guarani',
        symbol_native: '₲',
        decimal_digits: 0,
        rounding: 0,
        code: 'PYG',
        name_plural: 'Paraguayan guaranis'
    },
    {
        symbol: 'QR',
        name: 'Qatari Rial',
        symbol_native: 'ر.ق.‏',
        decimal_digits: 2,
        rounding: 0,
        code: 'QAR',
        name_plural: 'Qatari rials'
    },
    {
        symbol: 'RON',
        name: 'Romanian Leu',
        symbol_native: 'RON',
        decimal_digits: 2,
        rounding: 0,
        code: 'RON',
        name_plural: 'Romanian lei'
    },
    {
        symbol: 'din.',
        name: 'Serbian Dinar',
        symbol_native: 'дин.',
        decimal_digits: 0,
        rounding: 0,
        code: 'RSD',
        name_plural: 'Serbian dinars'
    },
    {
        symbol: 'RUB',
        name: 'Russian Ruble',
        symbol_native: '₽.',
        decimal_digits: 2,
        rounding: 0,
        code: 'RUB',
        name_plural: 'Russian rubles'
    },
    {
        symbol: 'RWF',
        name: 'Rwandan Franc',
        symbol_native: 'FR',
        decimal_digits: 0,
        rounding: 0,
        code: 'RWF',
        name_plural: 'Rwandan francs'
    },
    {
        symbol: 'SR',
        name: 'Saudi Riyal',
        symbol_native: 'ر.س.‏',
        decimal_digits: 2,
        rounding: 0,
        code: 'SAR',
        name_plural: 'Saudi riyals'
    },
    {
        symbol: 'SDG',
        name: 'Sudanese Pound',
        symbol_native: 'SDG',
        decimal_digits: 2,
        rounding: 0,
        code: 'SDG',
        name_plural: 'Sudanese pounds'
    },
    {
        symbol: 'Skr',
        name: 'Swedish Krona',
        symbol_native: 'kr',
        decimal_digits: 2,
        rounding: 0,
        code: 'SEK',
        name_plural: 'Swedish kronor'
    },
    {
        symbol: 'S$',
        name: 'Singapore Dollar',
        symbol_native: '$',
        decimal_digits: 2,
        rounding: 0,
        code: 'SGD',
        name_plural: 'Singapore dollars'
    },
    {
        symbol: 'Ssh',
        name: 'Somali Shilling',
        symbol_native: 'Ssh',
        decimal_digits: 0,
        rounding: 0,
        code: 'SOS',
        name_plural: 'Somali shillings'
    },
    {
        symbol: 'SY\xa3',
        name: 'Syrian Pound',
        symbol_native: 'ل.س.‏',
        decimal_digits: 0,
        rounding: 0,
        code: 'SYP',
        name_plural: 'Syrian pounds'
    },
    {
        symbol: '฿',
        name: 'Thai Baht',
        symbol_native: '฿',
        decimal_digits: 2,
        rounding: 0,
        code: 'THB',
        name_plural: 'Thai baht'
    },
    {
        symbol: 'DT',
        name: 'Tunisian Dinar',
        symbol_native: 'د.ت.‏',
        decimal_digits: 3,
        rounding: 0,
        code: 'TND',
        name_plural: 'Tunisian dinars'
    },
    {
        symbol: 'T$',
        name: 'Tongan Paʻanga',
        symbol_native: 'T$',
        decimal_digits: 2,
        rounding: 0,
        code: 'TOP',
        name_plural: 'Tongan paʻanga'
    },
    {
        symbol: 'TL',
        name: 'Turkish Lira',
        symbol_native: 'TL',
        decimal_digits: 2,
        rounding: 0,
        code: 'TRY',
        name_plural: 'Turkish Lira'
    },
    {
        symbol: 'TT$',
        name: 'Trinidad and Tobago Dollar',
        symbol_native: '$',
        decimal_digits: 2,
        rounding: 0,
        code: 'TTD',
        name_plural: 'Trinidad and Tobago dollars'
    },
    {
        symbol: 'NT$',
        name: 'New Taiwan Dollar',
        symbol_native: 'NT$',
        decimal_digits: 2,
        rounding: 0,
        code: 'TWD',
        name_plural: 'New Taiwan dollars'
    },
    {
        symbol: 'TSh',
        name: 'Tanzanian Shilling',
        symbol_native: 'TSh',
        decimal_digits: 0,
        rounding: 0,
        code: 'TZS',
        name_plural: 'Tanzanian shillings'
    },
    {
        symbol: '₴',
        name: 'Ukrainian Hryvnia',
        symbol_native: '₴',
        decimal_digits: 2,
        rounding: 0,
        code: 'UAH',
        name_plural: 'Ukrainian hryvnias'
    },
    {
        symbol: 'USh',
        name: 'Ugandan Shilling',
        symbol_native: 'USh',
        decimal_digits: 0,
        rounding: 0,
        code: 'UGX',
        name_plural: 'Ugandan shillings'
    },
    {
        symbol: '$U',
        name: 'Uruguayan Peso',
        symbol_native: '$',
        decimal_digits: 2,
        rounding: 0,
        code: 'UYU',
        name_plural: 'Uruguayan pesos'
    },
    {
        symbol: 'UZS',
        name: 'Uzbekistan Som',
        symbol_native: 'UZS',
        decimal_digits: 0,
        rounding: 0,
        code: 'UZS',
        name_plural: 'Uzbekistan som'
    },
    {
        symbol: 'Bs.F.',
        name: 'Venezuelan Bol\xedvar',
        symbol_native: 'Bs.F.',
        decimal_digits: 2,
        rounding: 0,
        code: 'VEF',
        name_plural: 'Venezuelan bol\xedvars'
    },
    {
        symbol: '₫',
        name: 'Vietnamese Dong',
        symbol_native: '₫',
        decimal_digits: 0,
        rounding: 0,
        code: 'VND',
        name_plural: 'Vietnamese dong'
    },
    {
        symbol: 'FCFA',
        name: 'CFA Franc BEAC',
        symbol_native: 'FCFA',
        decimal_digits: 0,
        rounding: 0,
        code: 'XAF',
        name_plural: 'CFA francs BEAC'
    },
    {
        symbol: 'CFA',
        name: 'CFA Franc BCEAO',
        symbol_native: 'CFA',
        decimal_digits: 0,
        rounding: 0,
        code: 'XOF',
        name_plural: 'CFA francs BCEAO'
    },
    {
        symbol: 'YR',
        name: 'Yemeni Rial',
        symbol_native: 'ر.ي.‏',
        decimal_digits: 0,
        rounding: 0,
        code: 'YER',
        name_plural: 'Yemeni rials'
    },
    {
        symbol: 'R',
        name: 'South African Rand',
        symbol_native: 'R',
        decimal_digits: 2,
        rounding: 0,
        code: 'ZAR',
        name_plural: 'South African rand'
    },
    {
        symbol: 'ZK',
        name: 'Zambian Kwacha',
        symbol_native: 'ZK',
        decimal_digits: 0,
        rounding: 0,
        code: 'ZMK',
        name_plural: 'Zambian kwachas'
    },
    {
        symbol: 'ZWL$',
        name: 'Zimbabwean Dollar',
        symbol_native: 'ZWL$',
        decimal_digits: 0,
        rounding: 0,
        code: 'ZWL',
        name_plural: 'Zimbabwean Dollar'
    }, 
];


/***/ }),

/***/ 52493:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "B": () => (/* binding */ PAYMENT_GATEWAY)
/* harmony export */ });
const PAYMENT_GATEWAY = [
    {
        name: 'stripe',
        title: 'Stripe'
    },
    {
        name: 'paypal',
        title: 'Paypal'
    }, 
];


/***/ }),

/***/ 22965:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ SettingsForm)
/* harmony export */ });
/* unused harmony export updatedIcons */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(145);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45641);
/* harmony import */ var _components_ui_button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(39258);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _components_ui_description__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(87594);
/* harmony import */ var _components_common_card__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(81258);
/* harmony import */ var _components_ui_label__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(63815);
/* harmony import */ var _currency__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(48975);
/* harmony import */ var _settings_site_settings__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(37070);
/* harmony import */ var _components_ui_form_validation_error__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(56965);
/* harmony import */ var _data_settings__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(50642);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(61908);
/* harmony import */ var _settings_validation_schema__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(562);
/* harmony import */ var _components_ui_file_input__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(77725);
/* harmony import */ var _components_ui_select_input__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(55530);
/* harmony import */ var _components_ui_text_area__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(83375);
/* harmony import */ var _components_ui_alert__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(58788);
/* harmony import */ var _utils_get_icon__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(69847);
/* harmony import */ var _components_icons_social__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(64131);
/* harmony import */ var _components_form_google_places_autocomplete__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(10058);
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(63901);
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(lodash_omit__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var _components_ui_switch_input__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(99313);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(29249);
/* harmony import */ var _components_settings_payment__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(52493);
/* harmony import */ var _components_ui_copy_content_copy_content__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(56693);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_hook_form__WEBPACK_IMPORTED_MODULE_2__, _settings_site_settings__WEBPACK_IMPORTED_MODULE_9__, _data_settings__WEBPACK_IMPORTED_MODULE_11__, _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_13__, _components_ui_file_input__WEBPACK_IMPORTED_MODULE_15__, _components_ui_select_input__WEBPACK_IMPORTED_MODULE_16__, _components_ui_switch_input__WEBPACK_IMPORTED_MODULE_23__, _config__WEBPACK_IMPORTED_MODULE_25__]);
([react_hook_form__WEBPACK_IMPORTED_MODULE_2__, _settings_site_settings__WEBPACK_IMPORTED_MODULE_9__, _data_settings__WEBPACK_IMPORTED_MODULE_11__, _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_13__, _components_ui_file_input__WEBPACK_IMPORTED_MODULE_15__, _components_ui_select_input__WEBPACK_IMPORTED_MODULE_16__, _components_ui_switch_input__WEBPACK_IMPORTED_MODULE_23__, _config__WEBPACK_IMPORTED_MODULE_25__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




























const socialIcon = [
    {
        value: 'FacebookIcon',
        label: 'Facebook'
    },
    {
        value: 'InstagramIcon',
        label: 'Instagram'
    },
    {
        value: 'TwitterIcon',
        label: 'Twitter'
    },
    {
        value: 'YouTubeIcon',
        label: 'Youtube'
    }, 
];
const updatedIcons = socialIcon.map((item)=>{
    item.label = /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "flex items-center text-body space-s-4",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                className: "flex items-center justify-center w-4 h-4",
                children: (0,_utils_get_icon__WEBPACK_IMPORTED_MODULE_19__/* .getIcon */ .q)({
                    iconList: _components_icons_social__WEBPACK_IMPORTED_MODULE_20__,
                    iconName: item.value,
                    className: 'w-4 h-4'
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                children: item.label
            })
        ]
    });
    return item;
});
// TODO: Split Settings
function SettingsForm({ settings , taxClasses , shippingClasses  }) {
    var ref23, ref1, ref2, ref3, ref4, ref5, ref6, ref7, /*@ts-ignore*/ ref8, ref9, ref10, ref11, ref12, ref13;
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_12__.useTranslation)();
    const { locale  } = (0,next_router__WEBPACK_IMPORTED_MODULE_24__.useRouter)();
    const { 0: isCopied , 1: setIsCopied  } = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(false);
    const { mutate: updateSettingsMutation , isLoading: loading  } = (0,_data_settings__WEBPACK_IMPORTED_MODULE_11__/* .useUpdateSettingsMutation */ .B)();
    const { language , options  } = settings !== null && settings !== void 0 ? settings : {};
    var ref14;
    const { register , handleSubmit , control , getValues , watch , formState: { errors  } ,  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_2__.useForm)({
        shouldUnregister: true,
        resolver: (0,_hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_13__.yupResolver)(_settings_validation_schema__WEBPACK_IMPORTED_MODULE_14__/* .settingsValidationSchema */ .Q),
        defaultValues: {
            ...options,
            contactDetails: {
                ...options === null || options === void 0 ? void 0 : options.contactDetails,
                socials: (options === null || options === void 0 ? void 0 : (ref23 = options.contactDetails) === null || ref23 === void 0 ? void 0 : ref23.socials) ? options === null || options === void 0 ? void 0 : (ref1 = options.contactDetails) === null || ref1 === void 0 ? void 0 : ref1.socials.map((social)=>{
                    return {
                        icon: updatedIcons === null || updatedIcons === void 0 ? void 0 : updatedIcons.find((icon)=>{
                            return (icon === null || icon === void 0 ? void 0 : icon.value) === (social === null || social === void 0 ? void 0 : social.icon);
                        }),
                        url: social === null || social === void 0 ? void 0 : social.url
                    };
                }) : []
            },
            deliveryTime: (options === null || options === void 0 ? void 0 : options.deliveryTime) ? options === null || options === void 0 ? void 0 : options.deliveryTime : [],
            logo: (ref14 = options === null || options === void 0 ? void 0 : options.logo) !== null && ref14 !== void 0 ? ref14 : '',
            currency: (options === null || options === void 0 ? void 0 : options.currency) ? _currency__WEBPACK_IMPORTED_MODULE_8__/* .CURRENCY.find */ .w.find((item)=>{
                return item.code == (options === null || options === void 0 ? void 0 : options.currency);
            }) : '',
            paymentGateway: (options === null || options === void 0 ? void 0 : options.paymentGateway) ? _components_settings_payment__WEBPACK_IMPORTED_MODULE_26__/* .PAYMENT_GATEWAY.find */ .B.find((item)=>{
                return item.name == (options === null || options === void 0 ? void 0 : options.paymentGateway);
            }) : _components_settings_payment__WEBPACK_IMPORTED_MODULE_26__/* .PAYMENT_GATEWAY[0] */ .B[0],
            // @ts-ignore
            taxClass: !!(taxClasses === null || taxClasses === void 0 ? void 0 : taxClasses.length) ? taxClasses === null || taxClasses === void 0 ? void 0 : taxClasses.find((tax)=>{
                return tax.id == (options === null || options === void 0 ? void 0 : options.taxClass);
            }) : '',
            // @ts-ignore
            shippingClass: !!(shippingClasses === null || shippingClasses === void 0 ? void 0 : shippingClasses.length) ? shippingClasses === null || shippingClasses === void 0 ? void 0 : shippingClasses.find((shipping)=>{
                return shipping.id == (options === null || options === void 0 ? void 0 : options.shippingClass);
            }) : ''
        }
    });
    const enableFreeShipping = watch('freeShipping');
    const { fields , append , remove  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_2__.useFieldArray)({
        control,
        name: 'deliveryTime'
    });
    const { fields: socialFields , append: socialAppend , remove: socialRemove ,  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_2__.useFieldArray)({
        control,
        name: 'contactDetails.socials'
    });
    const isNotDefaultSettingsPage = _config__WEBPACK_IMPORTED_MODULE_25__/* .Config.defaultLanguage */ .D.defaultLanguage !== locale;
    async function onSubmit(values) {
        var ref24, ref15, ref16, ref17, ref18, ref19, ref20, ref21, ref22;
        const contactDetails = {
            ...values === null || values === void 0 ? void 0 : values.contactDetails,
            location: {
                ...lodash_omit__WEBPACK_IMPORTED_MODULE_22___default()(values === null || values === void 0 ? void 0 : (ref24 = values.contactDetails) === null || ref24 === void 0 ? void 0 : ref24.location, '__typename')
            },
            socials: (values === null || values === void 0 ? void 0 : (ref15 = values.contactDetails) === null || ref15 === void 0 ? void 0 : ref15.socials) ? values === null || values === void 0 ? void 0 : (ref16 = values.contactDetails) === null || ref16 === void 0 ? void 0 : (ref17 = ref16.socials) === null || ref17 === void 0 ? void 0 : ref17.map((social)=>{
                var ref;
                return {
                    icon: social === null || social === void 0 ? void 0 : (ref = social.icon) === null || ref === void 0 ? void 0 : ref.value,
                    url: social === null || social === void 0 ? void 0 : social.url
                };
            }) : []
        };
        // TODO : ts type check korte hobe on activatedGateway
        updateSettingsMutation({
            language: locale,
            options: {
                ...values,
                signupPoints: Number(values.signupPoints),
                currencyToWalletRatio: Number(values.currencyToWalletRatio),
                minimumOrderAmount: Number(values.minimumOrderAmount),
                freeShippingAmount: Number(values.freeShippingAmount),
                currency: (ref18 = values.currency) === null || ref18 === void 0 ? void 0 : ref18.code,
                paymentGateway: (ref19 = values.paymentGateway) === null || ref19 === void 0 ? void 0 : ref19.name,
                taxClass: values === null || values === void 0 ? void 0 : (ref20 = values.taxClass) === null || ref20 === void 0 ? void 0 : ref20.id,
                shippingClass: values === null || values === void 0 ? void 0 : (ref21 = values.shippingClass) === null || ref21 === void 0 ? void 0 : ref21.id,
                logo: values === null || values === void 0 ? void 0 : values.logo,
                contactDetails,
                //@ts-ignore
                seo: {
                    ...values === null || values === void 0 ? void 0 : values.seo,
                    ogImage: values === null || values === void 0 ? void 0 : (ref22 = values.seo) === null || ref22 === void 0 ? void 0 : ref22.ogImage
                }
            }
        });
    }
    const paymentGateway = watch('paymentGateway');
    const logoInformation = /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
        children: [
            t('form:logo-help-text'),
            " ",
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("br", {}),
            t('form:logo-dimension-help-text'),
            " \xa0",
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                className: "font-bold",
                children: [
                    _settings_site_settings__WEBPACK_IMPORTED_MODULE_9__/* .siteSettings.logo.width */ .U.logo.width,
                    "x",
                    _settings_site_settings__WEBPACK_IMPORTED_MODULE_9__/* .siteSettings.logo.height */ .U.logo.height,
                    " ",
                    t('common:pixel')
                ]
            })
        ]
    });
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("form", {
        onSubmit: handleSubmit(onSubmit),
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "flex flex-wrap pb-8 my-5 border-b border-dashed border-border-base sm:my-8",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                        title: t('form:input-label-logo'),
                        details: logoInformation,
                        className: "w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pe-4 md:w-1/3 md:pe-5"
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_card__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                        className: "w-full sm:w-8/12 md:w-2/3",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_file_input__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
                            name: "logo",
                            control: control,
                            multiple: false
                        })
                    })
                ]
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "flex flex-wrap pb-8 my-5 border-b border-dashed border-border-base sm:my-8",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                        title: t('form:form-title-information'),
                        details: t('form:site-info-help-text'),
                        className: "w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pe-4 md:w-1/3 md:pe-5"
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_common_card__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                        className: "w-full sm:w-8/12 md:w-2/3",
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-site-title'),
                                ...register('siteTitle'),
                                error: t((ref2 = errors.siteTitle) === null || ref2 === void 0 ? void 0 : ref2.message),
                                variant: "outline",
                                className: "mb-5"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-site-subtitle'),
                                ...register('siteSubtitle'),
                                error: t((ref3 = errors.siteSubtitle) === null || ref3 === void 0 ? void 0 : ref3.message),
                                variant: "outline",
                                className: "mb-5"
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                className: "mb-5",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                                        children: t('form:input-label-currency')
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_select_input__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .Z, {
                                        name: "currency",
                                        control: control,
                                        getOptionLabel: (option)=>option.name
                                        ,
                                        getOptionValue: (option)=>option.code
                                        ,
                                        options: _currency__WEBPACK_IMPORTED_MODULE_8__/* .CURRENCY */ .w,
                                        disabled: isNotDefaultSettingsPage
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_form_validation_error__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z, {
                                        message: t((ref4 = errors.currency) === null || ref4 === void 0 ? void 0 : ref4.message)
                                    })
                                ]
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: `${t('form:input-label-min-order-amount')}`,
                                ...register('minimumOrderAmount'),
                                type: "number",
                                error: t((ref5 = errors.minimumOrderAmount) === null || ref5 === void 0 ? void 0 : ref5.message),
                                variant: "outline",
                                className: "mb-5",
                                disabled: isNotDefaultSettingsPage
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                className: "mb-5",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                                        children: t('form:input-label-tax-class')
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_select_input__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .Z, {
                                        name: "taxClass",
                                        control: control,
                                        getOptionLabel: (option)=>option.name
                                        ,
                                        getOptionValue: (option)=>option.id
                                        ,
                                        options: taxClasses,
                                        disabled: isNotDefaultSettingsPage
                                    })
                                ]
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                className: "mb-5",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                                        children: t('form:input-label-shipping-class')
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_select_input__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .Z, {
                                        name: "shippingClass",
                                        control: control,
                                        getOptionLabel: (option)=>option.name
                                        ,
                                        getOptionValue: (option)=>option.id
                                        ,
                                        options: shippingClasses,
                                        disabled: isNotDefaultSettingsPage
                                    })
                                ]
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                className: "flex items-center gap-x-4",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_switch_input__WEBPACK_IMPORTED_MODULE_23__/* ["default"] */ .Z, {
                                        name: "freeShipping",
                                        control: control,
                                        checked: enableFreeShipping,
                                        disabled: isNotDefaultSettingsPage
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                                        className: "mb-0",
                                        children: t('form:input-label-enable-free-shipping')
                                    })
                                ]
                            }),
                            enableFreeShipping && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:free-shipping-input-label-amount'),
                                ...register('freeShippingAmount'),
                                error: t((ref6 = errors.freeShippingAmount) === null || ref6 === void 0 ? void 0 : ref6.message),
                                variant: "outline",
                                type: "number",
                                className: "mt-5",
                                disabled: isNotDefaultSettingsPage
                            })
                        ]
                    })
                ]
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "flex flex-wrap pb-8 my-5 border-b border-dashed border-border-base sm:my-8",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                        title: t('Payment'),
                        details: t('Configure Payment Option'),
                        className: "w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pe-4 md:w-1/3 md:pe-5"
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_common_card__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                        className: "w-full sm:w-8/12 md:w-2/3",
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                className: "mb-5",
                                children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                    className: "flex items-center gap-x-4",
                                    children: [
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_switch_input__WEBPACK_IMPORTED_MODULE_23__/* ["default"] */ .Z, {
                                            name: "useCashOnDelivery",
                                            control: control,
                                            disabled: isNotDefaultSettingsPage
                                        }),
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                                            className: "mb-0",
                                            children: t('Enable Cash On Delivery')
                                        })
                                    ]
                                })
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                className: "mb-5",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                                        children: t('Select Payment Gateway')
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_select_input__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .Z, {
                                        name: "paymentGateway",
                                        control: control,
                                        getOptionLabel: (option)=>option.title
                                        ,
                                        getOptionValue: (option)=>option.name
                                        ,
                                        options: _components_settings_payment__WEBPACK_IMPORTED_MODULE_26__/* .PAYMENT_GATEWAY */ .B,
                                        disabled: isNotDefaultSettingsPage
                                    })
                                ]
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                className: "mb-0",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_copy_content_copy_content__WEBPACK_IMPORTED_MODULE_27__/* ["default"] */ .Z, {
                                    label: t('text-webhook-url'),
                                    variant: "outline",
                                    value: `${"https://chawkbazar.creatudevelopers.com.np"}/webhooks/${paymentGateway === null || paymentGateway === void 0 ? void 0 : (ref7 = paymentGateway.name) === null || ref7 === void 0 ? void 0 : ref7.toLowerCase()}`,
                                    name: "webhook"
                                })
                            })
                        ]
                    })
                ]
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "flex flex-wrap pb-8 my-5 border-b border-dashed border-border-base sm:my-8",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                        title: "SEO",
                        details: t('form:tax-form-seo-info-help-text'),
                        className: "w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pr-4 md:w-1/3 md:pr-5"
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_common_card__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                        className: "w-full sm:w-8/12 md:w-2/3",
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-meta-title'),
                                ...register('seo.metaTitle'),
                                variant: "outline",
                                className: "mb-5"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_text_area__WEBPACK_IMPORTED_MODULE_17__/* ["default"] */ .Z, {
                                label: t('form:input-label-meta-description'),
                                ...register('seo.metaDescription'),
                                variant: "outline",
                                className: "mb-5"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-meta-tags'),
                                ...register('seo.metaTags'),
                                variant: "outline",
                                className: "mb-5"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-canonical-url'),
                                ...register('seo.canonicalUrl'),
                                variant: "outline",
                                className: "mb-5"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-og-title'),
                                ...register('seo.ogTitle'),
                                variant: "outline",
                                className: "mb-5"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_text_area__WEBPACK_IMPORTED_MODULE_17__/* ["default"] */ .Z, {
                                label: t('form:input-label-og-description'),
                                ...register('seo.ogDescription'),
                                variant: "outline",
                                className: "mb-5"
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                className: "mb-5",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                                        children: t('form:input-label-og-image')
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_file_input__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
                                        name: "seo.ogImage",
                                        control: control,
                                        multiple: false
                                    })
                                ]
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-twitter-handle'),
                                ...register('seo.twitterHandle'),
                                variant: "outline",
                                className: "mb-5",
                                placeholder: "your twitter username (exp: @username)"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-twitter-card-type'),
                                ...register('seo.twitterCardType'),
                                variant: "outline",
                                className: "mb-5",
                                placeholder: "one of summary, summary_large_image, app, or player"
                            })
                        ]
                    })
                ]
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "flex flex-wrap my-5 sm:my-8",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                        title: t('form:text-delivery-schedule'),
                        details: t('form:delivery-schedule-help-text'),
                        className: "w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pr-4 md:w-1/3 md:pr-5"
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_common_card__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                        className: "w-full sm:w-8/12 md:w-2/3",
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                children: fields.map((item, index)=>{
                                    var ref, ref25, ref26;
                                    /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                        className: "py-5 border-b border-dashed border-border-200 first:pt-0 last:border-0 md:py-8",
                                        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                            className: "grid grid-cols-1 gap-5 sm:grid-cols-5",
                                            children: [
                                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                    className: "grid grid-cols-1 gap-5 sm:col-span-4",
                                                    children: [
                                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                                            label: t('form:input-delivery-time-title'),
                                                            variant: "outline",
                                                            ...register(`deliveryTime.${index}.title`),
                                                            defaultValue: item === null || item === void 0 ? void 0 : item.title,
                                                            // @ts-ignore
                                                            error: t(errors === null || errors === void 0 ? void 0 : (ref = errors.deliveryTime) === null || ref === void 0 ? void 0 : (ref25 = ref[index]) === null || ref25 === void 0 ? void 0 : (ref26 = ref25.title) === null || ref26 === void 0 ? void 0 : ref26.message)
                                                        }),
                                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_text_area__WEBPACK_IMPORTED_MODULE_17__/* ["default"] */ .Z, {
                                                            label: t('form:input-delivery-time-description'),
                                                            variant: "outline",
                                                            ...register(`deliveryTime.${index}.description`),
                                                            defaultValue: item.description
                                                        })
                                                    ]
                                                }),
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                                                    onClick: ()=>{
                                                        remove(index);
                                                    },
                                                    type: "button",
                                                    className: "text-sm text-red-500 transition-colors duration-200 hover:text-red-700 focus:outline-none sm:col-span-1 sm:mt-4",
                                                    children: t('form:button-label-remove')
                                                })
                                            ]
                                        })
                                    }, item.id);
                                })
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                                type: "button",
                                onClick: ()=>append({
                                        title: '',
                                        description: ''
                                    })
                                ,
                                className: "w-full sm:w-auto",
                                children: t('form:button-label-add-delivery-time')
                            }),
                            (errors === null || errors === void 0 ? void 0 : (ref8 = errors.deliveryTime) === null || ref8 === void 0 ? void 0 : ref8.message) ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_alert__WEBPACK_IMPORTED_MODULE_18__/* ["default"] */ .Z, {
                                // @ts-ignore
                                message: t(errors === null || errors === void 0 ? void 0 : (ref9 = errors.deliveryTime) === null || ref9 === void 0 ? void 0 : ref9.message),
                                variant: "error",
                                className: "mt-5"
                            }) : null
                        ]
                    })
                ]
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "flex flex-wrap pb-8 my-5 border-b border-gray-300 border-dashed sm:my-8",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_description__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                        title: t('form:shop-settings'),
                        details: t('form:shop-settings-helper-text'),
                        className: "w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pe-4 md:w-1/3 md:pe-5"
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_common_card__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                        className: "w-full sm:w-8/12 md:w-2/3",
                        children: [
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                className: "mb-5",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                                        children: t('form:input-label-autocomplete')
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_hook_form__WEBPACK_IMPORTED_MODULE_2__.Controller, {
                                        control: control,
                                        name: "contactDetails.location",
                                        render: ({ field: { onChange  }  })=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_form_google_places_autocomplete__WEBPACK_IMPORTED_MODULE_21__/* ["default"] */ .Z, {
                                                onChange: onChange,
                                                data: getValues('contactDetails.location'),
                                                disabled: isNotDefaultSettingsPage
                                            })
                                    })
                                ]
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-contact'),
                                ...register('contactDetails.contact'),
                                variant: "outline",
                                className: "mb-5",
                                error: t((ref10 = errors.contactDetails) === null || ref10 === void 0 ? void 0 : (ref11 = ref10.contact) === null || ref11 === void 0 ? void 0 : ref11.message),
                                disabled: isNotDefaultSettingsPage
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                label: t('form:input-label-website'),
                                ...register('contactDetails.website'),
                                variant: "outline",
                                className: "mb-5",
                                error: t((ref12 = errors.contactDetails) === null || ref12 === void 0 ? void 0 : (ref13 = ref12.website) === null || ref13 === void 0 ? void 0 : ref13.message),
                                disabled: isNotDefaultSettingsPage
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                children: socialFields.map((item, index)=>{
                                    /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                        className: "py-5 border-b border-dashed border-border-200 first:mt-5 first:border-t last:border-b-0 md:py-8 md:first:mt-10",
                                        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                            className: "grid grid-cols-1 gap-5 sm:grid-cols-5",
                                            children: [
                                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                    className: "sm:col-span-2",
                                                    children: [
                                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_label__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                                                            className: "whitespace-nowrap",
                                                            children: t('form:input-label-select-platform')
                                                        }),
                                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_select_input__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .Z, {
                                                            name: `contactDetails.socials.${index}.icon`,
                                                            control: control,
                                                            options: updatedIcons,
                                                            isClearable: true,
                                                            defaultValue: item === null || item === void 0 ? void 0 : item.icon,
                                                            disabled: isNotDefaultSettingsPage
                                                        })
                                                    ]
                                                }),
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                                    className: "sm:col-span-2",
                                                    label: t('form:input-label-social-url'),
                                                    variant: "outline",
                                                    ...register(`contactDetails.socials.${index}.url`),
                                                    defaultValue: item.url,
                                                    disabled: isNotDefaultSettingsPage
                                                }),
                                                !isNotDefaultSettingsPage && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                                                    onClick: ()=>{
                                                        socialRemove(index);
                                                    },
                                                    type: "button",
                                                    className: "text-sm text-red-500 transition-colors duration-200 hover:text-red-700 focus:outline-none sm:col-span-1 sm:mt-4",
                                                    disabled: isNotDefaultSettingsPage,
                                                    children: t('form:button-label-remove')
                                                })
                                            ]
                                        })
                                    }, item.id);
                                })
                            }),
                            !isNotDefaultSettingsPage && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                                type: "button",
                                onClick: ()=>socialAppend({
                                        icon: '',
                                        url: ''
                                    })
                                ,
                                className: "w-full sm:w-auto",
                                disabled: isNotDefaultSettingsPage,
                                children: t('form:button-label-add-social')
                            })
                        ]
                    })
                ]
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "mb-4 text-end",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_button__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                    loading: loading,
                    disabled: loading,
                    children: t('form:button-label-save-settings')
                })
            })
        ]
    }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 562:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Q": () => (/* binding */ settingsValidationSchema)
/* harmony export */ });
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_0__);

const settingsValidationSchema = yup__WEBPACK_IMPORTED_MODULE_0__.object().shape({
    currency: yup__WEBPACK_IMPORTED_MODULE_0__.object().nullable().required('form:error-currency-required'),
    // maximumQuestionLimit: yup
    //   .number()
    //   .positive()
    //   .required('form:error-maximum-question-limit')
    //   .typeError('form:error-maximum-question-limit'),
    minimumOrderAmount: yup__WEBPACK_IMPORTED_MODULE_0__.number().transform((value)=>isNaN(value) ? undefined : value
    ).moreThan(-1, 'form:error-sale-price-must-positive'),
    freeShippingAmount: yup__WEBPACK_IMPORTED_MODULE_0__.number().moreThan(-1, 'form:error-free-shipping-amount-must-positive').typeError('form:error-amount-number'),
    deliveryTime: yup__WEBPACK_IMPORTED_MODULE_0__.array().min(1, 'add-at-least-one-delivery-time').of(yup__WEBPACK_IMPORTED_MODULE_0__.object().shape({
        title: yup__WEBPACK_IMPORTED_MODULE_0__.string().required('form:error-title-required')
    }))
});


/***/ }),

/***/ 58788:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_icons_close_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(29581);



const variantClasses = {
    info: 'bg-blue-100 text-blue-600',
    warning: 'bg-yellow-100 text-yellow-600',
    error: 'bg-red-100 text-red-500',
    success: 'bg-green-100 text-accent',
    infoOutline: 'border border-blue-200 text-blue-600',
    warningOutline: 'border border-yellow-200 text-yellow-600',
    errorOutline: 'border border-red-200 text-red-600',
    successOutline: 'border border-green-200 text-green-600'
};
const Alert = ({ message ='' , closeable =false , variant ='info' , className , onClose ,  })=>{
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('relative flex items-center justify-between rounded py-4 px-5 shadow-sm', variantClasses[variant], className),
        role: "alert",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                className: "text-sm",
                children: message
            }),
            closeable && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                "data-dismiss": "alert",
                "aria-label": "Close",
                onClick: onClose,
                title: "Close alert",
                className: "-me-0.5 end-2 absolute top-1/2 -mt-3 flex h-6 w-6 flex-shrink-0 items-center justify-center rounded-full text-red-500 transition-colors duration-200 hover:bg-gray-300 hover:bg-opacity-25 focus:bg-gray-300 focus:bg-opacity-25 focus:outline-none",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    "aria-hidden": "true",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_close_icon__WEBPACK_IMPORTED_MODULE_2__/* .CloseIcon */ .T, {
                        className: "h-3 w-3"
                    })
                })
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Alert);


/***/ }),

/***/ 83002:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);



const Badge = (props)=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    const { className , color: colorOverride , textColor: textColorOverride , text , textKey , animate =false ,  } = props;
    const classes = {
        root: 'px-3 py-1 rounded-full text-xs whitespace-nowrap relative',
        animate: 'animate-pulse',
        default: 'bg-accent',
        text: 'text-light'
    };
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
            className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(classes.root, {
                [classes.default]: !colorOverride,
                [classes.text]: !textColorOverride,
                [classes.animate]: animate
            }, colorOverride, textColorOverride, className),
            children: textKey ? t(textKey) : text
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Badge);


/***/ }),

/***/ 56693:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(145);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_ui_badge_badge__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(83002);




const CopyContent = ({ label , variant , className , name , value , ...rest })=>{
    const { 0: isCopied , 1: setIsCopied  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
    async function copyTextToClipboard(text) {
        if ('clipboard' in navigator) {
            return await navigator.clipboard.writeText(text);
        } else {
            return document.execCommand('copy', true, text);
        }
    }
    async function handleWebhookCopyClick() {
        await copyTextToClipboard(value);
        setIsCopied(true);
    }
    setTimeout(()=>{
        setIsCopied(false);
    }, 5000);
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
                htmlFor: name,
                className: "mb-3 block text-sm font-semibold leading-none text-body-dark",
                children: label
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "relative",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_input__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        label: label,
                        variant: variant,
                        className: className,
                        name: name,
                        value: value,
                        readOnly: true,
                        showLabel: false,
                        disabled: true,
                        inputClassName: "pr-11",
                        ...rest
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                        className: "absolute top-px right-px w-10 rounded-tr rounded-br border-0 border-l border-solid border-border-base bg-white",
                        style: {
                            height: 'calc(100% - 2px)'
                        },
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                                onClick: handleWebhookCopyClick,
                                type: "button",
                                className: "flex h-full w-full",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                    className: "m-auto",
                                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
                                        stroke: "currentColor",
                                        fill: "currentColor",
                                        strokeWidth: "0",
                                        viewBox: "0 0 1024 1024",
                                        height: "1em",
                                        width: "1em",
                                        xmlns: "http://www.w3.org/2000/svg",
                                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                            d: "M779.3 196.6c-94.2-94.2-247.6-94.2-341.7 0l-261 260.8c-1.7 1.7-2.6 4-2.6 6.4s.9 4.7 2.6 6.4l36.9 36.9a9 9 0 0 0 12.7 0l261-260.8c32.4-32.4 75.5-50.2 121.3-50.2s88.9 17.8 121.2 50.2c32.4 32.4 50.2 75.5 50.2 121.2 0 45.8-17.8 88.8-50.2 121.2l-266 265.9-43.1 43.1c-40.3 40.3-105.8 40.3-146.1 0-19.5-19.5-30.2-45.4-30.2-73s10.7-53.5 30.2-73l263.9-263.8c6.7-6.6 15.5-10.3 24.9-10.3h.1c9.4 0 18.1 3.7 24.7 10.3 6.7 6.7 10.3 15.5 10.3 24.9 0 9.3-3.7 18.1-10.3 24.7L372.4 653c-1.7 1.7-2.6 4-2.6 6.4s.9 4.7 2.6 6.4l36.9 36.9a9 9 0 0 0 12.7 0l215.6-215.6c19.9-19.9 30.8-46.3 30.8-74.4s-11-54.6-30.8-74.4c-41.1-41.1-107.9-41-149 0L463 364 224.8 602.1A172.22 172.22 0 0 0 174 724.8c0 46.3 18.1 89.8 50.8 122.5 33.9 33.8 78.3 50.7 122.7 50.7 44.4 0 88.8-16.9 122.6-50.7l309.2-309C824.8 492.7 850 432 850 367.5c.1-64.6-25.1-125.3-70.7-170.9z"
                                        })
                                    })
                                })
                            }),
                            isCopied ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                className: "absolute -top-9 right-0 z-10",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_badge_badge__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                                    text: "Copied!",
                                    className: "inline-flex"
                                })
                            }) : ''
                        ]
                    })
                ]
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CopyContent);


/***/ }),

/***/ 30110:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* unused harmony export Error */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_1__);


const Error = ({ message  })=>{
    const { t  } = useTranslation('common');
    return(/*#__PURE__*/ _jsx("p", {
        className: "my-2 text-xs text-start text-red-500",
        children: t(message)
    }));
};
const ErrorMessage = ({ message  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_1__.useTranslation)('common');
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
        className: "bg-red-400 p-5 mt-16 mx-auto max-w-sm min-w-min text-center text-lg text-light font-semibold rounded",
        children: t(message)
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ErrorMessage);


/***/ }),

/***/ 77725:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_common_uploader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20286);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45641);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_common_uploader__WEBPACK_IMPORTED_MODULE_1__, react_hook_form__WEBPACK_IMPORTED_MODULE_2__]);
([_components_common_uploader__WEBPACK_IMPORTED_MODULE_1__, react_hook_form__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const FileInput = ({ control , name , multiple =true , acceptFile =false , helperText , defaultValue =[]  })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_hook_form__WEBPACK_IMPORTED_MODULE_2__.Controller, {
        control: control,
        name: name,
        defaultValue: defaultValue,
        render: ({ field: { ref , ...rest }  })=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_uploader__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                ...rest,
                multiple: multiple,
                acceptFile: acceptFile,
                helperText: helperText
            })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FileInput);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 56965:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const ValidationError = ({ message  })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
        className: "my-2 text-xs text-start text-red-500",
        children: message
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ValidationError);


/***/ }),

/***/ 63815:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);


const Label = ({ className , ...rest })=>{
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
        className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('block text-body-dark font-semibold text-sm leading-none mb-3', className),
        ...rest
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Label);


/***/ }),

/***/ 99313:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(45641);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61185);
/* harmony import */ var _form_validation_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56965);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_hook_form__WEBPACK_IMPORTED_MODULE_1__, _headlessui_react__WEBPACK_IMPORTED_MODULE_2__]);
([react_hook_form__WEBPACK_IMPORTED_MODULE_1__, _headlessui_react__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





const SwitchInput = ({ control , label , name , errors , disabled , ...rest })=>{
    var ref;
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_4__.useTranslation)();
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        children: [
            label && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                children: label
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_hook_form__WEBPACK_IMPORTED_MODULE_1__.Controller, {
                name: name,
                control: control,
                ...rest,
                render: ({ field: { onChange , value  }  })=>/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Switch, {
                        checked: value,
                        onChange: onChange,
                        disabled: disabled,
                        className: `${value ? 'bg-accent' : 'bg-gray-300'} relative inline-flex h-6 w-11 items-center rounded-full focus:outline-none ${disabled ? 'cursor-not-allowed bg-[#EEF1F4]' : ''}`,
                        dir: "ltr",
                        children: [
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                className: "sr-only",
                                children: [
                                    "Enable ",
                                    label
                                ]
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                className: `${value ? 'translate-x-6' : 'translate-x-1'} inline-block h-4 w-4 transform rounded-full bg-light transition-transform`
                            })
                        ]
                    })
            }),
            errors ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_form_validation_error__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                message: t(errors === null || errors === void 0 ? void 0 : (ref = errors[name]) === null || ref === void 0 ? void 0 : ref.message)
            }) : ''
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SwitchInput);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5034:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "h": () => (/* binding */ crudFactory)
/* harmony export */ });
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_0__]);
_http_client__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

function crudFactory(endpoint) {
    return {
        all (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        paginated (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        get ({ slug , language  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(`${endpoint}/${slug}`, {
                language
            });
        },
        create (data) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.post */ .eN.post(endpoint, data);
        },
        update ({ id , ...input }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.put */ .eN.put(`${endpoint}/${id}`, input);
        },
        delete ({ id  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient["delete"] */ .eN["delete"](`${endpoint}/${id}`);
        }
    };
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 77305:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "z": () => (/* binding */ settingsClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5034);
/* harmony import */ var _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const settingsClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_1__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SETTINGS */ .P.SETTINGS),
    all ({ language  }) {
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SETTINGS */ .P.SETTINGS, {
            language
        });
    },
    update: ({ ...data })=>{
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SETTINGS */ .P.SETTINGS, {
            ...data
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 61258:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "$": () => (/* binding */ shippingClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5034);
/* harmony import */ var _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const shippingClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_1__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SHIPPINGS */ .P.SHIPPINGS),
    get ({ id  }) {
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SHIPPINGS */ .P.SHIPPINGS}/${id}`);
    },
    paginated: ({ name , ...params })=>{
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SHIPPINGS */ .P.SHIPPINGS, {
            searchJoin: 'and',
            ...params,
            search: _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                name
            })
        });
    },
    all: ({ name , ...params })=>{
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.SHIPPINGS */ .P.SHIPPINGS, {
            searchJoin: 'and',
            ...params,
            search: _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                name
            })
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7870:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "V": () => (/* binding */ taxClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5034);
/* harmony import */ var _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const taxClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_1__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.TAXES */ .P.TAXES),
    get ({ id  }) {
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.TAXES */ .P.TAXES}/${id}`);
    },
    paginated: ({ name , ...params })=>{
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.TAXES */ .P.TAXES, {
            searchJoin: 'and',
            ...params,
            search: _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                name
            })
        });
    },
    all: ({ name , ...params })=>{
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.TAXES */ .P.TAXES, {
            searchJoin: 'and',
            ...params,
            search: _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                name
            })
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 12721:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "t": () => (/* binding */ uploadClient)
/* harmony export */ });
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67904);
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_0__]);
_http_client__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const uploadClient = {
    upload: async (variables)=>{
        let formData = new FormData();
        variables.forEach((attachment)=>{
            formData.append('attachment[]', attachment);
        });
        const options = {
            headers: {
                'Content-Type': 'multipart/form-data'
            }
        };
        return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.post */ .eN.post(_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.ATTACHMENTS */ .P.ATTACHMENTS, formData, options);
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 50642:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "B": () => (/* binding */ useUpdateSettingsMutation),
/* harmony export */   "n": () => (/* binding */ useSettingsQuery)
/* harmony export */ });
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(85057);
/* harmony import */ var _client_settings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(77305);
/* harmony import */ var _contexts_settings_context__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(92303);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_settings__WEBPACK_IMPORTED_MODULE_4__]);
_client_settings__WEBPACK_IMPORTED_MODULE_4__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






const useUpdateSettingsMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQueryClient)();
    const { updateSettings  } = (0,_contexts_settings_context__WEBPACK_IMPORTED_MODULE_5__/* .useSettings */ .rV)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)(_client_settings__WEBPACK_IMPORTED_MODULE_4__/* .settingsClient.update */ .z.update, {
        onError: (error)=>{
            console.log(error);
        },
        onSuccess: (data)=>{
            updateSettings(data === null || data === void 0 ? void 0 : data.options);
            react_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SETTINGS */ .P.SETTINGS);
        }
    });
};
const useSettingsQuery = ({ language  })=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQuery)([
        _client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SETTINGS */ .P.SETTINGS,
        {
            language
        }
    ], ()=>_client_settings__WEBPACK_IMPORTED_MODULE_4__/* .settingsClient.all */ .z.all({
            language
        })
    );
    return {
        settings: data !== null && data !== void 0 ? data : {},
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 60263:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Zj": () => (/* binding */ useCreateShippingMutation),
/* harmony export */   "_L": () => (/* binding */ useDeleteShippingClassMutation),
/* harmony export */   "eI": () => (/* binding */ useUpdateShippingMutation),
/* harmony export */   "f1": () => (/* binding */ useShippingQuery),
/* harmony export */   "ET": () => (/* binding */ useShippingClassesQuery)
/* harmony export */ });
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28379);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(85057);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _client_shipping__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(61258);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_shipping__WEBPACK_IMPORTED_MODULE_6__]);
_client_shipping__WEBPACK_IMPORTED_MODULE_6__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







const useCreateShippingMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_1__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_4__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_shipping__WEBPACK_IMPORTED_MODULE_6__/* .shippingClient.create */ .$.create, {
        onSuccess: ()=>{
            router.push(_config_routes__WEBPACK_IMPORTED_MODULE_0__/* .Routes.shipping.list */ .Z.shipping.list);
            react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHIPPINGS */ .P.SHIPPINGS);
        }
    });
};
const useDeleteShippingClassMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_4__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_shipping__WEBPACK_IMPORTED_MODULE_6__/* .shippingClient["delete"] */ .$["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHIPPINGS */ .P.SHIPPINGS);
        }
    });
};
const useUpdateShippingMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_4__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_shipping__WEBPACK_IMPORTED_MODULE_6__/* .shippingClient.update */ .$.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHIPPINGS */ .P.SHIPPINGS);
        }
    });
};
const useShippingQuery = (id)=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHIPPINGS */ .P.SHIPPINGS,
        id
    ], ()=>_client_shipping__WEBPACK_IMPORTED_MODULE_6__/* .shippingClient.get */ .$.get({
            id
        })
    );
};
const useShippingClassesQuery = (options = {})=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.SHIPPINGS */ .P.SHIPPINGS,
        options
    ], ({ queryKey , pageParam  })=>_client_shipping__WEBPACK_IMPORTED_MODULE_6__/* .shippingClient.all */ .$.all(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    return {
        shippingClasses: data !== null && data !== void 0 ? data : [],
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 35827:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "wo": () => (/* binding */ useCreateTaxClassMutation),
/* harmony export */   "MA": () => (/* binding */ useDeleteTaxMutation),
/* harmony export */   "y2": () => (/* binding */ useUpdateTaxClassMutation),
/* harmony export */   "io": () => (/* binding */ useTaxQuery),
/* harmony export */   "sQ": () => (/* binding */ useTaxesQuery)
/* harmony export */ });
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28379);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(85057);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _client_tax__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(7870);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_tax__WEBPACK_IMPORTED_MODULE_6__]);
_client_tax__WEBPACK_IMPORTED_MODULE_6__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







const useCreateTaxClassMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_1__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_tax__WEBPACK_IMPORTED_MODULE_6__/* .taxClient.create */ .V.create, {
        onSuccess: ()=>{
            router.push(_config_routes__WEBPACK_IMPORTED_MODULE_0__/* .Routes.tax.list */ .Z.tax.list);
            react_toastify__WEBPACK_IMPORTED_MODULE_4__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.TAXES */ .P.TAXES);
        }
    });
};
const useDeleteTaxMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_tax__WEBPACK_IMPORTED_MODULE_6__/* .taxClient["delete"] */ .V["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_4__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.TAXES */ .P.TAXES);
        }
    });
};
const useUpdateTaxClassMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_tax__WEBPACK_IMPORTED_MODULE_6__/* .taxClient.update */ .V.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_4__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.TAXES */ .P.TAXES);
        }
    });
};
const useTaxQuery = (id)=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.TAXES */ .P.TAXES,
        id
    ], ()=>_client_tax__WEBPACK_IMPORTED_MODULE_6__/* .taxClient.get */ .V.get({
            id
        })
    );
};
const useTaxesQuery = (options = {})=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.TAXES */ .P.TAXES,
        options
    ], ({ queryKey , pageParam  })=>_client_tax__WEBPACK_IMPORTED_MODULE_6__/* .taxClient.all */ .V.all(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    return {
        taxes: data !== null && data !== void 0 ? data : [],
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 34421:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "g": () => (/* binding */ useUploadMutation)
/* harmony export */ });
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85057);
/* harmony import */ var _data_client_upload__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12721);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_data_client_upload__WEBPACK_IMPORTED_MODULE_2__]);
_data_client_upload__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const useUploadMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useMutation)((input)=>{
        return _data_client_upload__WEBPACK_IMPORTED_MODULE_2__/* .uploadClient.upload */ .t.upload(input);
    }, {
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_1__/* .API_ENDPOINTS.SETTINGS */ .P.SETTINGS);
        }
    });
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 48811:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Settings),
/* harmony export */   "getStaticProps": () => (/* binding */ getStaticProps)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_layouts_admin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40792);
/* harmony import */ var _components_settings_settings_form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(22965);
/* harmony import */ var _components_ui_error_message__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(30110);
/* harmony import */ var _components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(47898);
/* harmony import */ var _data_settings__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(50642);
/* harmony import */ var _data_shipping__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(60263);
/* harmony import */ var _data_tax__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(35827);
/* harmony import */ var _utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(49239);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(25460);
/* harmony import */ var next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_11__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_layouts_admin__WEBPACK_IMPORTED_MODULE_1__, _components_settings_settings_form__WEBPACK_IMPORTED_MODULE_2__, _data_settings__WEBPACK_IMPORTED_MODULE_5__, _data_shipping__WEBPACK_IMPORTED_MODULE_6__, _data_tax__WEBPACK_IMPORTED_MODULE_7__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__]);
([_components_layouts_admin__WEBPACK_IMPORTED_MODULE_1__, _components_settings_settings_form__WEBPACK_IMPORTED_MODULE_2__, _data_settings__WEBPACK_IMPORTED_MODULE_5__, _data_shipping__WEBPACK_IMPORTED_MODULE_6__, _data_tax__WEBPACK_IMPORTED_MODULE_7__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);












function Settings() {
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_9__.useTranslation)();
    const { locale  } = (0,next_router__WEBPACK_IMPORTED_MODULE_11__.useRouter)();
    const { taxes , loading: taxLoading  } = (0,_data_tax__WEBPACK_IMPORTED_MODULE_7__/* .useTaxesQuery */ .sQ)({
        limit: 999
    });
    const { shippingClasses , loading: shippingLoading  } = (0,_data_shipping__WEBPACK_IMPORTED_MODULE_6__/* .useShippingClassesQuery */ .ET)();
    const { settings , loading , error  } = (0,_data_settings__WEBPACK_IMPORTED_MODULE_5__/* .useSettingsQuery */ .n)({
        language: locale
    });
    if (loading || shippingLoading || taxLoading) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
        text: t('common:text-loading')
    }));
    if (error) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_error_message__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        message: error.message
    }));
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "flex border-b border-dashed border-border-base py-5 sm:py-8",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h1", {
                    className: "text-lg font-semibold text-heading",
                    children: t('form:form-title-settings')
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_settings_settings_form__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                // TODO: fix it
                // @ts-ignore
                settings: settings,
                taxClasses: taxes,
                shippingClasses: shippingClasses
            })
        ]
    }));
};
Settings.authenticate = {
    permissions: _utils_auth_utils__WEBPACK_IMPORTED_MODULE_8__/* .adminOnly */ .M$
};
Settings.Layout = _components_layouts_admin__WEBPACK_IMPORTED_MODULE_1__["default"];
const getStaticProps = async ({ locale  })=>({
        props: {
            ...await (0,next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_10__.serverSideTranslations)(locale, [
                'form',
                'common'
            ])
        }
    })
;

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 34896:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Hb": () => (/* reexport */ product),
  "GZ": () => (/* reexport */ zip)
});

// UNUSED EXPORTS: avatarPlaceholder, couponPlaceholder, logoPlaceholder

;// CONCATENATED MODULE: ./src/assets/placeholders/product.svg
/* harmony default export */ const product = ({"src":"/_next/static/media/product.ba64d04a.svg","height":210,"width":270});
;// CONCATENATED MODULE: ./src/assets/placeholders/coupon.svg
/* harmony default export */ const coupon = ({"src":"/_next/static/media/coupon.5015b440.svg","height":240,"width":320});
;// CONCATENATED MODULE: ./src/assets/placeholders/avatar.svg
/* harmony default export */ const avatar = ({"src":"/_next/static/media/avatar.c9441dc8.svg","height":120,"width":120});
;// CONCATENATED MODULE: ./src/assets/placeholders/logo.svg
/* harmony default export */ const logo = ({"src":"/_next/static/media/logo.0679544b.svg","height":18,"width":109});
;// CONCATENATED MODULE: ./src/assets/placeholders/zip.png
/* harmony default export */ const zip = ({"src":"/_next/static/media/zip.9dcc52b5.png","height":512,"width":512,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAMAAADz0U65AAAAY1BMVEX3yYP+///dsofl6fXnvIb1yIrvwYTov4j1yIhMaXHLvc7RqoLqf5W1qrrOt6fS1uq9y9nVorG8ppyioLbJsqPh292UlrPZ0N/cq7q8j6X8j5zaxrPNtqW7nIOIiKrNm4iek6OR66+FAAAAG3RSTlMr/vj+tfX6+bUA/Cv7/v74/v7x/vH++P7+/v4PHiyvAAAACXBIWXMAAAsTAAALEwEAmpwYAAAARUlEQVQImR3LRxKAIBAAwUHSgmDOmP7/SqvsexNq470QYLjn8bIgZ6v04gTXaKU6b3Fl7be9spgS05EegSnm/Fbwd0P4AGY8AtL5sWsSAAAAAElFTkSuQmCC"});
;// CONCATENATED MODULE: ./src/utils/placeholders.tsx







/***/ }),

/***/ 9677:
/***/ ((module) => {

module.exports = require("@reach/portal");

/***/ }),

/***/ 82433:
/***/ ((module) => {

module.exports = require("@react-google-maps/api");

/***/ }),

/***/ 25782:
/***/ ((module) => {

module.exports = require("body-scroll-lock");

/***/ }),

/***/ 33104:
/***/ ((module) => {

module.exports = require("camelcase-keys");

/***/ }),

/***/ 59003:
/***/ ((module) => {

module.exports = require("classnames");

/***/ }),

/***/ 84802:
/***/ ((module) => {

module.exports = require("cookie");

/***/ }),

/***/ 63901:
/***/ ((module) => {

module.exports = require("lodash/omit");

/***/ }),

/***/ 11377:
/***/ ((module) => {

module.exports = require("next-i18next");

/***/ }),

/***/ 25460:
/***/ ((module) => {

module.exports = require("next-i18next/serverSideTranslations");

/***/ }),

/***/ 60562:
/***/ ((module) => {

module.exports = require("next/dist/server/denormalize-page-path.js");

/***/ }),

/***/ 78028:
/***/ ((module) => {

module.exports = require("next/dist/server/image-config.js");

/***/ }),

/***/ 94957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 3539:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/detect-domain-locale.js");

/***/ }),

/***/ 34014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 50744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 78524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 78020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 24964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 29565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 64365:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-middleware-regex.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 91292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 80979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 36052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 84226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 95052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 59232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 71853:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 153:
/***/ ((module) => {

module.exports = require("overlayscrollbars-react");

/***/ }),

/***/ 16689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 56358:
/***/ ((module) => {

module.exports = require("react-dropzone");

/***/ }),

/***/ 61175:
/***/ ((module) => {

module.exports = require("react-query");

/***/ }),

/***/ 61929:
/***/ ((module) => {

module.exports = require("react-select");

/***/ }),

/***/ 1187:
/***/ ((module) => {

module.exports = require("react-toastify");

/***/ }),

/***/ 57139:
/***/ ((module) => {

module.exports = require("react-use/lib/useLocalStorage");

/***/ }),

/***/ 20997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 75609:
/***/ ((module) => {

module.exports = require("yup");

/***/ }),

/***/ 61185:
/***/ ((module) => {

module.exports = import("@headlessui/react");;

/***/ }),

/***/ 61908:
/***/ ((module) => {

module.exports = import("@hookform/resolvers/yup");;

/***/ }),

/***/ 99648:
/***/ ((module) => {

module.exports = import("axios");;

/***/ }),

/***/ 66197:
/***/ ((module) => {

module.exports = import("framer-motion");;

/***/ }),

/***/ 82451:
/***/ ((module) => {

module.exports = import("jotai");;

/***/ }),

/***/ 2752:
/***/ ((module) => {

module.exports = import("jotai/utils");;

/***/ }),

/***/ 69915:
/***/ ((module) => {

module.exports = import("js-cookie");;

/***/ }),

/***/ 45641:
/***/ ((module) => {

module.exports = import("react-hook-form");;

/***/ }),

/***/ 24281:
/***/ ((module) => {

module.exports = import("tiny-invariant");;

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [1842,16,9894,8579,3406,3691,9809,7070,601,7721,6411,9239,3605,9249,5839,8760,4602,9831,4014,7898,792,1567,145,2357,6302,3375,5530,9525], () => (__webpack_exec__(48811)));
module.exports = __webpack_exports__;

})();