"use strict";
(() => {
var exports = {};
exports.id = 2423;
exports.ids = [2423,5827];
exports.modules = {

/***/ 75737:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_icons_close_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29581);
/* harmony import */ var _components_icons_search_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(44066);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(45641);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_hook_form__WEBPACK_IMPORTED_MODULE_5__]);
react_hook_form__WEBPACK_IMPORTED_MODULE_5__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







const classes = {
    root: 'ps-10 pe-4 h-12 flex items-center w-full rounded appearance-none transition duration-300 ease-in-out text-heading text-sm focus:outline-none focus:ring-0',
    normal: 'bg-gray-100 border border-border-base focus:shadow focus:bg-light focus:border-accent',
    solid: 'bg-gray-100 border border-border-100 focus:bg-light focus:border-accent',
    outline: 'border border-border-base focus:border-accent',
    shadow: 'focus:shadow'
};
const Search = ({ className , onSearch , variant ='outline' , shadow =false , inputClassName , ...rest })=>{
    const { register , handleSubmit , watch , reset , formState: { errors  } ,  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_5__.useForm)({
        defaultValues: {
            searchText: ''
        }
    });
    const searchText = watch('searchText');
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_6__.useTranslation)();
    (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(()=>{
        if (!searchText) {
            onSearch({
                searchText: ''
            });
        }
    }, [
        searchText
    ]);
    const rootClassName = classnames__WEBPACK_IMPORTED_MODULE_3___default()(classes.root, {
        [classes.normal]: variant === 'normal',
        [classes.solid]: variant === 'solid',
        [classes.outline]: variant === 'outline'
    }, {
        [classes.shadow]: shadow
    }, inputClassName);
    function clear() {
        reset();
        onSearch({
            searchText: ''
        });
    }
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("form", {
        noValidate: true,
        role: "search",
        className: classnames__WEBPACK_IMPORTED_MODULE_3___default()('relative flex w-full items-center', className),
        onSubmit: handleSubmit(onSearch),
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
                htmlFor: "search",
                className: "sr-only",
                children: t('form:input-label-search')
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                className: "start-1 absolute p-2 text-body outline-none focus:outline-none active:outline-none",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_search_icon__WEBPACK_IMPORTED_MODULE_2__/* .SearchIcon */ .W, {
                    className: "h-5 w-5"
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                type: "text",
                id: "search",
                ...register('searchText'),
                className: rootClassName,
                placeholder: t('form:input-placeholder-search'),
                "aria-label": "Search",
                autoComplete: "off",
                ...rest
            }),
            errors.searchText && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                children: errors.searchText.message
            }),
            !!searchText && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                type: "button",
                onClick: clear,
                className: "end-1 absolute p-2 text-body outline-none focus:outline-none active:outline-none",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_close_icon__WEBPACK_IMPORTED_MODULE_1__/* .CloseIcon */ .T, {
                    className: "h-5 w-5"
                })
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Search);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 44066:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "W": () => (/* binding */ SearchIcon)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SearchIcon = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        stroke: "currentColor",
        ...props,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeWidth: 2,
            d: "M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"
        })
    })
;


/***/ }),

/***/ 36601:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_table__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40447);
/* harmony import */ var _components_common_action_buttons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53758);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(53139);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28379);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _utils_locals__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(10601);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(99996);









const TaxList = ({ taxes , onSort , onOrder  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    const { alignLeft  } = (0,_utils_locals__WEBPACK_IMPORTED_MODULE_6__/* .useIsRTL */ .S)();
    const { 0: sortingObj , 1: setSortingObj  } = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)({
        sort: _types__WEBPACK_IMPORTED_MODULE_3__/* .SortOrder.Desc */ .As.Desc,
        column: null
    });
    const onHeaderClick = (column)=>({
            onClick: ()=>{
                onSort((currentSortDirection)=>currentSortDirection === _types__WEBPACK_IMPORTED_MODULE_3__/* .SortOrder.Desc */ .As.Desc ? _types__WEBPACK_IMPORTED_MODULE_3__/* .SortOrder.Asc */ .As.Asc : _types__WEBPACK_IMPORTED_MODULE_3__/* .SortOrder.Desc */ .As.Desc
                );
                onOrder(column);
                setSortingObj({
                    sort: sortingObj.sort === _types__WEBPACK_IMPORTED_MODULE_3__/* .SortOrder.Desc */ .As.Desc ? _types__WEBPACK_IMPORTED_MODULE_3__/* .SortOrder.Asc */ .As.Asc : _types__WEBPACK_IMPORTED_MODULE_3__/* .SortOrder.Desc */ .As.Desc,
                    column: column
                });
            }
        })
    ;
    const columns = [
        {
            title: t('table:table-item-id'),
            dataIndex: 'id',
            key: 'id',
            align: 'center',
            width: 62
        },
        {
            title: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                title: t('table:table-item-title'),
                ascending: sortingObj.sort === _types__WEBPACK_IMPORTED_MODULE_3__/* .SortOrder.Asc */ .As.Asc && sortingObj.column === 'name',
                isActive: sortingObj.column === 'name'
            }),
            className: 'cursor-pointer',
            dataIndex: 'name',
            key: 'name',
            align: alignLeft,
            width: 150,
            onHeaderCell: ()=>onHeaderClick('name')
        },
        {
            title: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                title: `${t('table:table-item-rate')} (%)`,
                ascending: sortingObj.sort === _types__WEBPACK_IMPORTED_MODULE_3__/* .SortOrder.Asc */ .As.Asc && sortingObj.column === 'rate',
                isActive: sortingObj.column === 'rate'
            }),
            className: 'cursor-pointer',
            dataIndex: 'rate',
            key: 'rate',
            align: 'center',
            onHeaderCell: ()=>onHeaderClick('rate')
        },
        {
            title: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                title: t('table:table-item-country'),
                ascending: sortingObj.sort === _types__WEBPACK_IMPORTED_MODULE_3__/* .SortOrder.Asc */ .As.Asc && sortingObj.column === 'country',
                isActive: sortingObj.column === 'country'
            }),
            className: 'cursor-pointer',
            dataIndex: 'country',
            key: 'country',
            align: 'center',
            onHeaderCell: ()=>onHeaderClick('country')
        },
        {
            title: t('table:table-item-city'),
            dataIndex: 'city',
            key: 'city',
            align: 'center'
        },
        {
            title: t('table:table-item-state'),
            dataIndex: 'state',
            key: 'state',
            align: 'center'
        },
        {
            title: t('table:table-item-zip'),
            dataIndex: 'zip',
            key: 'zip',
            align: 'center'
        },
        {
            title: t('table:table-item-actions'),
            dataIndex: 'id',
            key: 'actions',
            align: 'right',
            render: (id)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_action_buttons__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                    id: id,
                    editUrl: `${_config_routes__WEBPACK_IMPORTED_MODULE_4__/* .Routes.tax.list */ .Z.tax.list}/edit/${id}`,
                    deleteModalView: "DELETE_TAX"
                })
            ,
            width: 200
        }, 
    ];
    return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        className: "mb-8 overflow-hidden rounded shadow",
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_table__WEBPACK_IMPORTED_MODULE_1__/* .Table */ .i, {
            columns: columns,
            emptyText: t('table:empty-table-data'),
            data: taxes,
            rowKey: "id",
            scroll: {
                x: 900
            }
        })
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TaxList);


/***/ }),

/***/ 5034:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "h": () => (/* binding */ crudFactory)
/* harmony export */ });
/* harmony import */ var _http_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http_client__WEBPACK_IMPORTED_MODULE_0__]);
_http_client__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

function crudFactory(endpoint) {
    return {
        all (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        paginated (params) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(endpoint, params);
        },
        get ({ slug , language  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.get */ .eN.get(`${endpoint}/${slug}`, {
                language
            });
        },
        create (data) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.post */ .eN.post(endpoint, data);
        },
        update ({ id , ...input }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient.put */ .eN.put(`${endpoint}/${id}`, input);
        },
        delete ({ id  }) {
            return _http_client__WEBPACK_IMPORTED_MODULE_0__/* .HttpClient["delete"] */ .eN["delete"](`${endpoint}/${id}`);
        }
    };
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7870:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "V": () => (/* binding */ taxClient)
/* harmony export */ });
/* harmony import */ var _api_endpoints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85057);
/* harmony import */ var _curd_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5034);
/* harmony import */ var _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67904);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__]);
([_curd_factory__WEBPACK_IMPORTED_MODULE_1__, _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const taxClient = {
    ...(0,_curd_factory__WEBPACK_IMPORTED_MODULE_1__/* .crudFactory */ .h)(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.TAXES */ .P.TAXES),
    get ({ id  }) {
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(`${_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.TAXES */ .P.TAXES}/${id}`);
    },
    paginated: ({ name , ...params })=>{
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.TAXES */ .P.TAXES, {
            searchJoin: 'and',
            ...params,
            search: _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                name
            })
        });
    },
    all: ({ name , ...params })=>{
        return _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.get */ .eN.get(_api_endpoints__WEBPACK_IMPORTED_MODULE_0__/* .API_ENDPOINTS.TAXES */ .P.TAXES, {
            searchJoin: 'and',
            ...params,
            search: _data_client_http_client__WEBPACK_IMPORTED_MODULE_2__/* .HttpClient.formatSearchParams */ .eN.formatSearchParams({
                name
            })
        });
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 35827:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "wo": () => (/* binding */ useCreateTaxClassMutation),
/* harmony export */   "MA": () => (/* binding */ useDeleteTaxMutation),
/* harmony export */   "y2": () => (/* binding */ useUpdateTaxClassMutation),
/* harmony export */   "io": () => (/* binding */ useTaxQuery),
/* harmony export */   "sQ": () => (/* binding */ useTaxesQuery)
/* harmony export */ });
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28379);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(85057);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _client_tax__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(7870);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_client_tax__WEBPACK_IMPORTED_MODULE_6__]);
_client_tax__WEBPACK_IMPORTED_MODULE_6__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







const useCreateTaxClassMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_1__.useRouter)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_tax__WEBPACK_IMPORTED_MODULE_6__/* .taxClient.create */ .V.create, {
        onSuccess: ()=>{
            router.push(_config_routes__WEBPACK_IMPORTED_MODULE_0__/* .Routes.tax.list */ .Z.tax.list);
            react_toastify__WEBPACK_IMPORTED_MODULE_4__.toast.success(t('common:successfully-created'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.TAXES */ .P.TAXES);
        }
    });
};
const useDeleteTaxMutation = ()=>{
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_tax__WEBPACK_IMPORTED_MODULE_6__/* .taxClient["delete"] */ .V["delete"], {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_4__.toast.success(t('common:successfully-deleted'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.TAXES */ .P.TAXES);
        }
    });
};
const useUpdateTaxClassMutation = ()=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    const queryClient = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQueryClient)();
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useMutation)(_client_tax__WEBPACK_IMPORTED_MODULE_6__/* .taxClient.update */ .V.update, {
        onSuccess: ()=>{
            react_toastify__WEBPACK_IMPORTED_MODULE_4__.toast.success(t('common:successfully-updated'));
        },
        // Always refetch after error or success:
        onSettled: ()=>{
            queryClient.invalidateQueries(_data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.TAXES */ .P.TAXES);
        }
    });
};
const useTaxQuery = (id)=>{
    return (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.TAXES */ .P.TAXES,
        id
    ], ()=>_client_tax__WEBPACK_IMPORTED_MODULE_6__/* .taxClient.get */ .V.get({
            id
        })
    );
};
const useTaxesQuery = (options = {})=>{
    const { data , error , isLoading  } = (0,react_query__WEBPACK_IMPORTED_MODULE_2__.useQuery)([
        _data_client_api_endpoints__WEBPACK_IMPORTED_MODULE_3__/* .API_ENDPOINTS.TAXES */ .P.TAXES,
        options
    ], ({ queryKey , pageParam  })=>_client_tax__WEBPACK_IMPORTED_MODULE_6__/* .taxClient.all */ .V.all(Object.assign({}, queryKey[1], pageParam))
    , {
        keepPreviousData: true
    });
    return {
        taxes: data !== null && data !== void 0 ? data : [],
        error,
        loading: isLoading
    };
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 17281:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TaxesPage),
/* harmony export */   "getStaticProps": () => (/* binding */ getStaticProps)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_common_card__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(81258);
/* harmony import */ var _components_layouts_admin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(40792);
/* harmony import */ var _components_common_search__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(75737);
/* harmony import */ var _components_tax_tax_list__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(36601);
/* harmony import */ var _components_ui_error_message__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(30110);
/* harmony import */ var _components_ui_link_button__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(2171);
/* harmony import */ var _components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(47898);
/* harmony import */ var _data_tax__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(35827);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(25460);
/* harmony import */ var next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(28379);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(53139);
/* harmony import */ var _utils_auth_utils__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(49239);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_layouts_admin__WEBPACK_IMPORTED_MODULE_2__, _components_common_search__WEBPACK_IMPORTED_MODULE_3__, _data_tax__WEBPACK_IMPORTED_MODULE_8__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_14__]);
([_components_layouts_admin__WEBPACK_IMPORTED_MODULE_2__, _components_common_search__WEBPACK_IMPORTED_MODULE_3__, _data_tax__WEBPACK_IMPORTED_MODULE_8__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_14__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);















function TaxesPage() {
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_10__.useTranslation)();
    const { 0: searchTerm , 1: setSearch  } = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)('');
    const { 0: orderBy , 1: setOrder  } = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)('created_at');
    const { 0: sortedBy , 1: setColumn  } = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)(_types__WEBPACK_IMPORTED_MODULE_13__/* .SortOrder.Desc */ .As.Desc);
    const { taxes , loading , error  } = (0,_data_tax__WEBPACK_IMPORTED_MODULE_8__/* .useTaxesQuery */ .sQ)({
        name: searchTerm,
        orderBy,
        sortedBy
    });
    if (loading) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
        text: t('common:text-loading')
    }));
    if (error) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_error_message__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        message: error.message
    }));
    function handleSearch({ searchText  }) {
        setSearch(searchText);
    }
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_common_card__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                className: "mb-8 flex flex-col items-center xl:flex-row",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "mb-4 md:mb-0 md:w-1/4",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h1", {
                            className: "text-xl font-semibold text-heading",
                            children: t('form:input-label-taxes')
                        })
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                        className: "flex w-full flex-col items-center space-y-4 ms-auto md:flex-row md:space-y-0 xl:w-1/2",
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_search__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                                onSearch: handleSearch
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_link_button__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                                href: `${_config_routes__WEBPACK_IMPORTED_MODULE_12__/* .Routes.tax.create */ .Z.tax.create}`,
                                className: "h-12 w-full md:w-auto md:ms-6",
                                children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                    children: [
                                        "+ ",
                                        t('form:button-label-add-tax')
                                    ]
                                })
                            })
                        ]
                    })
                ]
            }),
            !loading ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_tax_tax_list__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                taxes: taxes,
                onOrder: setOrder,
                onSort: setColumn
            }) : null
        ]
    }));
};
TaxesPage.authenticate = {
    permissions: _utils_auth_utils__WEBPACK_IMPORTED_MODULE_14__/* .adminOnly */ .M$
};
TaxesPage.Layout = _components_layouts_admin__WEBPACK_IMPORTED_MODULE_2__["default"];
const getStaticProps = async ({ locale  })=>({
        props: {
            ...await (0,next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_11__.serverSideTranslations)(locale, [
                'table',
                'common',
                'form'
            ])
        }
    })
;

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9677:
/***/ ((module) => {

module.exports = require("@reach/portal");

/***/ }),

/***/ 25782:
/***/ ((module) => {

module.exports = require("body-scroll-lock");

/***/ }),

/***/ 33104:
/***/ ((module) => {

module.exports = require("camelcase-keys");

/***/ }),

/***/ 59003:
/***/ ((module) => {

module.exports = require("classnames");

/***/ }),

/***/ 84802:
/***/ ((module) => {

module.exports = require("cookie");

/***/ }),

/***/ 11377:
/***/ ((module) => {

module.exports = require("next-i18next");

/***/ }),

/***/ 25460:
/***/ ((module) => {

module.exports = require("next-i18next/serverSideTranslations");

/***/ }),

/***/ 60562:
/***/ ((module) => {

module.exports = require("next/dist/server/denormalize-page-path.js");

/***/ }),

/***/ 78028:
/***/ ((module) => {

module.exports = require("next/dist/server/image-config.js");

/***/ }),

/***/ 94957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 3539:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/detect-domain-locale.js");

/***/ }),

/***/ 34014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 50744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 78524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 78020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 24964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 29565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 64365:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-middleware-regex.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 91292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 80979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 36052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 84226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 95052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 59232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 71853:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 153:
/***/ ((module) => {

module.exports = require("overlayscrollbars-react");

/***/ }),

/***/ 73345:
/***/ ((module) => {

module.exports = require("rc-table");

/***/ }),

/***/ 16689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 61175:
/***/ ((module) => {

module.exports = require("react-query");

/***/ }),

/***/ 1187:
/***/ ((module) => {

module.exports = require("react-toastify");

/***/ }),

/***/ 57139:
/***/ ((module) => {

module.exports = require("react-use/lib/useLocalStorage");

/***/ }),

/***/ 20997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 61185:
/***/ ((module) => {

module.exports = import("@headlessui/react");;

/***/ }),

/***/ 99648:
/***/ ((module) => {

module.exports = import("axios");;

/***/ }),

/***/ 66197:
/***/ ((module) => {

module.exports = import("framer-motion");;

/***/ }),

/***/ 82451:
/***/ ((module) => {

module.exports = import("jotai");;

/***/ }),

/***/ 2752:
/***/ ((module) => {

module.exports = import("jotai/utils");;

/***/ }),

/***/ 69915:
/***/ ((module) => {

module.exports = import("js-cookie");;

/***/ }),

/***/ 45641:
/***/ ((module) => {

module.exports = import("react-hook-form");;

/***/ }),

/***/ 24281:
/***/ ((module) => {

module.exports = import("tiny-invariant");;

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [1842,16,9894,8579,3406,3691,9809,7070,601,7721,6411,9239,3605,9249,5839,8760,4602,9831,4014,7898,792,3139,4144,8243,3955,1044,2774,6229], () => (__webpack_exec__(17281)));
module.exports = __webpack_exports__;

})();