"use strict";
(() => {
var exports = {};
exports.id = 2892;
exports.ids = [2892];
exports.modules = {

/***/ 75737:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_icons_close_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29581);
/* harmony import */ var _components_icons_search_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(44066);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(59003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(45641);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_hook_form__WEBPACK_IMPORTED_MODULE_5__]);
react_hook_form__WEBPACK_IMPORTED_MODULE_5__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







const classes = {
    root: 'ps-10 pe-4 h-12 flex items-center w-full rounded appearance-none transition duration-300 ease-in-out text-heading text-sm focus:outline-none focus:ring-0',
    normal: 'bg-gray-100 border border-border-base focus:shadow focus:bg-light focus:border-accent',
    solid: 'bg-gray-100 border border-border-100 focus:bg-light focus:border-accent',
    outline: 'border border-border-base focus:border-accent',
    shadow: 'focus:shadow'
};
const Search = ({ className , onSearch , variant ='outline' , shadow =false , inputClassName , ...rest })=>{
    const { register , handleSubmit , watch , reset , formState: { errors  } ,  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_5__.useForm)({
        defaultValues: {
            searchText: ''
        }
    });
    const searchText = watch('searchText');
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_6__.useTranslation)();
    (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(()=>{
        if (!searchText) {
            onSearch({
                searchText: ''
            });
        }
    }, [
        searchText
    ]);
    const rootClassName = classnames__WEBPACK_IMPORTED_MODULE_3___default()(classes.root, {
        [classes.normal]: variant === 'normal',
        [classes.solid]: variant === 'solid',
        [classes.outline]: variant === 'outline'
    }, {
        [classes.shadow]: shadow
    }, inputClassName);
    function clear() {
        reset();
        onSearch({
            searchText: ''
        });
    }
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("form", {
        noValidate: true,
        role: "search",
        className: classnames__WEBPACK_IMPORTED_MODULE_3___default()('relative flex w-full items-center', className),
        onSubmit: handleSubmit(onSearch),
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
                htmlFor: "search",
                className: "sr-only",
                children: t('form:input-label-search')
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                className: "start-1 absolute p-2 text-body outline-none focus:outline-none active:outline-none",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_search_icon__WEBPACK_IMPORTED_MODULE_2__/* .SearchIcon */ .W, {
                    className: "h-5 w-5"
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                type: "text",
                id: "search",
                ...register('searchText'),
                className: rootClassName,
                placeholder: t('form:input-placeholder-search'),
                "aria-label": "Search",
                autoComplete: "off",
                ...rest
            }),
            errors.searchText && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                children: errors.searchText.message
            }),
            !!searchText && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                type: "button",
                onClick: clear,
                className: "end-1 absolute p-2 text-body outline-none focus:outline-none active:outline-none",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_icons_close_icon__WEBPACK_IMPORTED_MODULE_1__/* .CloseIcon */ .T, {
                    className: "h-5 w-5"
                })
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Search);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 44066:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "W": () => (/* binding */ SearchIcon)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SearchIcon = (props)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        stroke: "currentColor",
        ...props,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeWidth: 2,
            d: "M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"
        })
    })
;


/***/ }),

/***/ 61849:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ pagination)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
// EXTERNAL MODULE: external "rc-pagination"
var external_rc_pagination_ = __webpack_require__(73006);
var external_rc_pagination_default = /*#__PURE__*/__webpack_require__.n(external_rc_pagination_);
;// CONCATENATED MODULE: ./src/components/icons/arrow-next.tsx

const ArrowNext = ({ ...props })=>{
    return(/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 512 512",
        width: "20",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            d: "M294.1 256L167 129c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.3 34 0L345 239c9.1 9.1 9.3 23.7.7 33.1L201.1 417c-4.7 4.7-10.9 7-17 7s-12.3-2.3-17-7c-9.4-9.4-9.4-24.6 0-33.9l127-127.1z",
            fill: "currentColor",
            stroke: "currentColor"
        })
    }));
};

;// CONCATENATED MODULE: ./src/components/icons/arrow-prev.tsx

const ArrowPrev = ({ ...props })=>{
    return(/*#__PURE__*/ jsx_runtime_.jsx("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 512 512",
        width: "20",
        ...props,
        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
            d: "M217.9 256L345 129c9.4-9.4 9.4-24.6 0-33.9-9.4-9.4-24.6-9.3-34 0L167 239c-9.1 9.1-9.3 23.7-.7 33.1L310.9 417c4.7 4.7 10.9 7 17 7s12.3-2.3 17-7c9.4-9.4 9.4-24.6 0-33.9L217.9 256z",
            fill: "currentColor",
            stroke: "currentColor"
        })
    }));
};

;// CONCATENATED MODULE: ./src/components/ui/pagination.tsx





const Pagination = (props)=>{
    return(/*#__PURE__*/ jsx_runtime_.jsx((external_rc_pagination_default()), {
        nextIcon: /*#__PURE__*/ jsx_runtime_.jsx(ArrowNext, {}),
        prevIcon: /*#__PURE__*/ jsx_runtime_.jsx(ArrowPrev, {}),
        ...props
    }));
};
/* harmony default export */ const pagination = (Pagination);


/***/ }),

/***/ 95530:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ui_pagination__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61849);
/* harmony import */ var next_image__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(38579);
/* harmony import */ var _components_ui_table__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(40447);
/* harmony import */ var _components_common_action_buttons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(53758);
/* harmony import */ var _settings_site_settings__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(37070);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(53139);
/* harmony import */ var _data_user__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(93691);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _utils_locals__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(10601);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(99996);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_settings_site_settings__WEBPACK_IMPORTED_MODULE_5__, _data_user__WEBPACK_IMPORTED_MODULE_7__]);
([_settings_site_settings__WEBPACK_IMPORTED_MODULE_5__, _data_user__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);












const CustomerList = ({ customers , paginatorInfo , onPagination , onSort , onOrder  })=>{
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_8__.useTranslation)();
    const { alignLeft  } = (0,_utils_locals__WEBPACK_IMPORTED_MODULE_9__/* .useIsRTL */ .S)();
    const { 0: sortingObj , 1: setSortingObj  } = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)({
        sort: _types__WEBPACK_IMPORTED_MODULE_6__/* .SortOrder.Desc */ .As.Desc,
        column: null
    });
    const onHeaderClick = (column)=>({
            onClick: ()=>{
                onSort((currentSortDirection)=>currentSortDirection === _types__WEBPACK_IMPORTED_MODULE_6__/* .SortOrder.Desc */ .As.Desc ? _types__WEBPACK_IMPORTED_MODULE_6__/* .SortOrder.Asc */ .As.Asc : _types__WEBPACK_IMPORTED_MODULE_6__/* .SortOrder.Desc */ .As.Desc
                );
                onOrder(column);
                setSortingObj({
                    sort: sortingObj.sort === _types__WEBPACK_IMPORTED_MODULE_6__/* .SortOrder.Desc */ .As.Desc ? _types__WEBPACK_IMPORTED_MODULE_6__/* .SortOrder.Asc */ .As.Asc : _types__WEBPACK_IMPORTED_MODULE_6__/* .SortOrder.Desc */ .As.Desc,
                    column: column
                });
            }
        })
    ;
    var ref;
    const columns = [
        {
            title: t('table:table-item-avatar'),
            dataIndex: 'profile',
            key: 'profile',
            align: 'center',
            width: 74,
            render: (profile, record)=>{
                var ref1;
                /*#__PURE__*/ return react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(next_image__WEBPACK_IMPORTED_MODULE_2__["default"], {
                    src: (ref = profile === null || profile === void 0 ? void 0 : (ref1 = profile.avatar) === null || ref1 === void 0 ? void 0 : ref1.thumbnail) !== null && ref !== void 0 ? ref : _settings_site_settings__WEBPACK_IMPORTED_MODULE_5__/* .siteSettings.avatar.placeholder */ .U.avatar.placeholder,
                    alt: record === null || record === void 0 ? void 0 : record.name,
                    layout: "fixed",
                    width: 42,
                    height: 42,
                    className: "overflow-hidden rounded"
                });
            }
        },
        {
            title: t('table:table-item-title'),
            dataIndex: 'name',
            key: 'name',
            align: alignLeft
        },
        {
            title: t('table:table-item-email'),
            dataIndex: 'email',
            key: 'email',
            align: alignLeft
        },
        {
            title: t('table:table-item-permissions'),
            dataIndex: 'permissions',
            key: 'permissions',
            align: 'center',
            render: (permissions, record)=>{
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                    children: permissions === null || permissions === void 0 ? void 0 : permissions.map(({ name  })=>name
                    ).join(', ')
                }));
            }
        },
        {
            title: t('table:table-item-available_wallet_points'),
            dataIndex: [
                'wallet',
                'available_points'
            ],
            key: 'available_wallet_points',
            align: 'center'
        },
        {
            title: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_title_with_sort__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z, {
                title: t('table:table-item-status'),
                ascending: sortingObj.sort === _types__WEBPACK_IMPORTED_MODULE_6__/* .SortOrder.Asc */ .As.Asc && sortingObj.column === 'is_active',
                isActive: sortingObj.column === 'is_active'
            }),
            className: 'cursor-pointer',
            dataIndex: 'is_active',
            key: 'is_active',
            align: 'center',
            onHeaderCell: ()=>onHeaderClick('is_active')
            ,
            render: (is_active)=>is_active ? 'Active' : 'Inactive'
        },
        {
            title: t('table:table-item-actions'),
            dataIndex: 'id',
            key: 'actions',
            align: 'right',
            render: function Render(id, { is_active  }) {
                const { data  } = (0,_data_user__WEBPACK_IMPORTED_MODULE_7__/* .useMeQuery */ .UE)();
                return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                    children: (data === null || data === void 0 ? void 0 : data.id) != id && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_action_buttons__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                        id: id,
                        userStatus: true,
                        isUserActive: is_active,
                        showAddWalletPoints: true,
                        showMakeAdminButton: true
                    })
                }));
            }
        }, 
    ];
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "mb-6 overflow-hidden rounded shadow",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_table__WEBPACK_IMPORTED_MODULE_3__/* .Table */ .i, {
                    // @ts-ignore
                    columns: columns,
                    emptyText: t('table:empty-table-data'),
                    data: customers,
                    rowKey: "id",
                    scroll: {
                        x: 800
                    }
                })
            }),
            !!(paginatorInfo === null || paginatorInfo === void 0 ? void 0 : paginatorInfo.total) && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "flex items-center justify-end",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_pagination__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                    total: paginatorInfo.total,
                    current: paginatorInfo.currentPage,
                    pageSize: paginatorInfo.perPage,
                    onChange: onPagination
                })
            })
        ]
    }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CustomerList);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 74741:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Customers),
/* harmony export */   "getStaticProps": () => (/* binding */ getStaticProps)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_common_card__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(81258);
/* harmony import */ var _components_layouts_admin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(40792);
/* harmony import */ var _components_common_search__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(75737);
/* harmony import */ var _components_user_user_list__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(95530);
/* harmony import */ var _components_ui_link_button__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2171);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _components_ui_error_message__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(30110);
/* harmony import */ var _components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(47898);
/* harmony import */ var _data_user__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(93691);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(11377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(25460);
/* harmony import */ var next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(28379);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(53139);
/* harmony import */ var _utils_auth_utils__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(49239);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_layouts_admin__WEBPACK_IMPORTED_MODULE_2__, _components_common_search__WEBPACK_IMPORTED_MODULE_3__, _components_user_user_list__WEBPACK_IMPORTED_MODULE_4__, _data_user__WEBPACK_IMPORTED_MODULE_9__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_14__]);
([_components_layouts_admin__WEBPACK_IMPORTED_MODULE_2__, _components_common_search__WEBPACK_IMPORTED_MODULE_3__, _components_user_user_list__WEBPACK_IMPORTED_MODULE_4__, _data_user__WEBPACK_IMPORTED_MODULE_9__, _utils_auth_utils__WEBPACK_IMPORTED_MODULE_14__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);















function Customers() {
    const { 0: searchTerm , 1: setSearchTerm  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)('');
    const { 0: page , 1: setPage  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(1);
    const { t  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_10__.useTranslation)();
    const { 0: orderBy , 1: setOrder  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)('created_at');
    const { 0: sortedBy , 1: setColumn  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(_types__WEBPACK_IMPORTED_MODULE_13__/* .SortOrder.Desc */ .As.Desc);
    const { users , paginatorInfo , loading , error  } = (0,_data_user__WEBPACK_IMPORTED_MODULE_9__/* .useUsersQuery */ .xY)({
        limit: 20,
        page,
        name: searchTerm,
        orderBy,
        sortedBy
    });
    if (loading) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_loader_loader__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
        text: t('common:text-loading')
    }));
    if (error) return(/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_error_message__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
        message: error.message
    }));
    function handleSearch({ searchText  }) {
        setSearchTerm(searchText);
        setPage(1);
    }
    function handlePagination(current) {
        setPage(current);
    }
    return(/*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_common_card__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                className: "mb-8 flex flex-col items-center md:flex-row",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                        className: "mb-4 md:mb-0 md:w-1/4",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h1", {
                            className: "text-lg font-semibold text-heading",
                            children: t('form:input-label-customers')
                        })
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                        className: "ms-auto flex w-full items-center md:w-3/4",
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_common_search__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                                onSearch: handleSearch
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_ui_link_button__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                href: `${_config_routes__WEBPACK_IMPORTED_MODULE_12__/* .Routes.user.create */ .Z.user.create}`,
                                className: "ms-4 md:ms-6 h-12",
                                children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                                    children: [
                                        "+ ",
                                        t('form:button-label-add-customer')
                                    ]
                                })
                            })
                        ]
                    })
                ]
            }),
            loading ? null : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_user_user_list__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                customers: users,
                paginatorInfo: paginatorInfo,
                onPagination: handlePagination,
                onOrder: setOrder,
                onSort: setColumn
            })
        ]
    }));
};
Customers.authenticate = {
    permissions: _utils_auth_utils__WEBPACK_IMPORTED_MODULE_14__/* .adminOnly */ .M$
};
Customers.Layout = _components_layouts_admin__WEBPACK_IMPORTED_MODULE_2__["default"];
const getStaticProps = async ({ locale  })=>({
        props: {
            ...await (0,next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_11__.serverSideTranslations)(locale, [
                'table',
                'common',
                'form'
            ])
        }
    })
;

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9677:
/***/ ((module) => {

module.exports = require("@reach/portal");

/***/ }),

/***/ 25782:
/***/ ((module) => {

module.exports = require("body-scroll-lock");

/***/ }),

/***/ 33104:
/***/ ((module) => {

module.exports = require("camelcase-keys");

/***/ }),

/***/ 59003:
/***/ ((module) => {

module.exports = require("classnames");

/***/ }),

/***/ 84802:
/***/ ((module) => {

module.exports = require("cookie");

/***/ }),

/***/ 11377:
/***/ ((module) => {

module.exports = require("next-i18next");

/***/ }),

/***/ 25460:
/***/ ((module) => {

module.exports = require("next-i18next/serverSideTranslations");

/***/ }),

/***/ 60562:
/***/ ((module) => {

module.exports = require("next/dist/server/denormalize-page-path.js");

/***/ }),

/***/ 78028:
/***/ ((module) => {

module.exports = require("next/dist/server/image-config.js");

/***/ }),

/***/ 94957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 3539:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/detect-domain-locale.js");

/***/ }),

/***/ 34014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 50744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 78524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 78020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 24964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 29565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 64365:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-middleware-regex.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 91292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 80979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 36052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 84226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 95052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 59232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 71853:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 153:
/***/ ((module) => {

module.exports = require("overlayscrollbars-react");

/***/ }),

/***/ 73006:
/***/ ((module) => {

module.exports = require("rc-pagination");

/***/ }),

/***/ 73345:
/***/ ((module) => {

module.exports = require("rc-table");

/***/ }),

/***/ 16689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 61175:
/***/ ((module) => {

module.exports = require("react-query");

/***/ }),

/***/ 1187:
/***/ ((module) => {

module.exports = require("react-toastify");

/***/ }),

/***/ 57139:
/***/ ((module) => {

module.exports = require("react-use/lib/useLocalStorage");

/***/ }),

/***/ 20997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 61185:
/***/ ((module) => {

module.exports = import("@headlessui/react");;

/***/ }),

/***/ 99648:
/***/ ((module) => {

module.exports = import("axios");;

/***/ }),

/***/ 66197:
/***/ ((module) => {

module.exports = import("framer-motion");;

/***/ }),

/***/ 82451:
/***/ ((module) => {

module.exports = import("jotai");;

/***/ }),

/***/ 2752:
/***/ ((module) => {

module.exports = import("jotai/utils");;

/***/ }),

/***/ 69915:
/***/ ((module) => {

module.exports = import("js-cookie");;

/***/ }),

/***/ 45641:
/***/ ((module) => {

module.exports = import("react-hook-form");;

/***/ }),

/***/ 24281:
/***/ ((module) => {

module.exports = import("tiny-invariant");;

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [1842,16,9894,8579,3406,3691,9809,7070,601,7721,6411,9239,3605,9249,5839,8760,4602,9831,4014,7898,792,3139,4144,8243,3955,1044,2774,6229], () => (__webpack_exec__(74741)));
module.exports = __webpack_exports__;

})();