/** @type {import('next').NextConfig} */
const withPWA = require('next-pwa');
const runtimeCaching = require('next-pwa/cache');
const { i18n } = require('./next-i18next.config');

const nextConfig = {
  reactStrictMode: true,
  i18n,
  pwa: {
    disable: process.env.NODE_ENV === 'development',
    dest: 'public',
    runtimeCaching,
  },
  images: {
    domains: [
      'via.placeholder.com',
      'res.cloudinary.com',
      'chawkbazar.creatudevelopers.com.np',
      's3.amazonaws.com',
      '18.141.64.26',
      '127.0.0.1',
      '127.0.0.1:8000',
      'localhost',
      'picsum.photos',
      'pickbazar-sail.test',
      'pickbazarlaravel.s3.ap-southeast-1.amazonaws.com',
      'lh3.googleusercontent.com',
      'chawkbazarlaravel.s3.ap-southeast-1.amazonaws.com',
      'slidebazaar.com',
      'images.pexels.com',
      'static.vecteezy.com',
    ],
  },
  ...(process.env.APPLICATION_MODE === 'production' && {
    typescript: {
      ignoreBuildErrors: true,
    },
    eslint: {
      ignoreDuringBuilds: true,
    },
  }),
};

module.exports = withPWA(nextConfig);
