import ConfirmationCard from '@/components/common/confirmation-card';
import {
  useModalAction,
  useModalState,
} from '@/components/ui/modal/modal.context';
import { useDeleteCarouselMutation } from '@/data/carousel';
import { getErrorMessage } from '@/utils/form-error';

const CarouselDeleteView = () => {
  const { mutate: deleteCarousel, isLoading: loading } =
    useDeleteCarouselMutation();
  const { data } = useModalState();
  const { closeModal } = useModalAction();

  async function handleDelete() {
    try {
      deleteCarousel({ id: data });
      closeModal();
    } catch (error) {
      closeModal();
      getErrorMessage(error);
    }
  }

  return (
    <ConfirmationCard
      onCancel={closeModal}
      onDelete={handleDelete}
      deleteBtnLoading={loading}
    />
  );
};

export default CarouselDeleteView;
