import Button from '@/components/ui/button';
import { useEffect, useState } from 'react';
import Description from '../ui/description';
import Card from '../common/card';
import Input from '../ui/input';
import axios from 'axios';
import Cookies from 'js-cookie';

// TODO: Split Settings
export default function CoinForm() {
  const AUTH_TOKEN_KEY = process.env.NEXT_PUBLIC_AUTH_TOKEN_KEY ?? 'authToken';
  const cookies = Cookies.get(AUTH_TOKEN_KEY);
  let token = '';
  if (cookies) {
    token = JSON.parse(cookies)['token'];
  }

  const [loading, setLoading] = useState(false);
  const [formValues, setFormValues] = useState({
    coin: '',
    amount: '',
  });

  const [formValues2, setFormValues2] = useState({
    coin: '',
    amount: '',
  });

  const handleChange = (e) => {
    setFormValues({ ...formValues, [e.target.name]: e.target.value });
  };

  const handleChange2 = (e) => {
    setFormValues2({ ...formValues, [e.target.name]: e.target.value });
  };

  const saveSettings = (e) => {
    e.preventDefault();

    setLoading(true);
    axios({
      method: 'PUT',
      url: `${process.env.NEXT_PUBLIC_REST_API_ENDPOINT}/amount-to-coin`,
      data: formValues,
      headers: {
        Authorization: `Bearer ${token}`,
      },
    })
      .then((res) => {
        alert('Updated');
        setLoading(false);
      })
      .catch((e) => {
        alert('Error');
        setLoading(false);
      });
  };

  const saveSettings2 = (e) => {
    e.preventDefault();

    setLoading(true);
    axios({
      method: 'PUT',
      url: `${process.env.NEXT_PUBLIC_REST_API_ENDPOINT}/coin-to-amount`,
      data: formValues2,
      headers: {
        Authorization: `Bearer ${token}`,
      },
    })
      .then((res) => {
        alert('Updated');
        setLoading(false);
      })
      .catch((e) => {
        alert('Error');
        setLoading(false);
      });
  };

  useEffect(() => {
    axios({
      method: 'GET',
      url: `${process.env.NEXT_PUBLIC_REST_API_ENDPOINT}/amount-to-coin`,
      headers: {
        Authorization: `Bearer ${token}`,
      },
    })
      .then((res) => {
        // console.log('Payment gateway', res.data.data);
        setFormValues({ ...res.data.data });
      })
      .catch((e) => {
        console.log(e.message);
      });

    axios({
      method: 'GET',
      url: `${process.env.NEXT_PUBLIC_REST_API_ENDPOINT}/coin-to-amount`,
      headers: {
        Authorization: `Bearer ${token}`,
      },
    })
      .then((res) => {
        // console.log('Payment gateway', res.data.data);
        setFormValues2({ ...res.data.data });
      })
      .catch((e) => {
        console.log(e.message);
      });
  }, []);

  return (
    // <form onSubmit={saveSettings}>
    <>
      <div className="my-5 flex flex-wrap border-b border-dashed border-border-base pb-8 sm:my-8">
        <Description
          title="Amount to Coin"
          details="Amount to Coin conversion"
          className="w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pe-4 md:w-1/3 md:pe-5"
        />

        <Card className="w-full sm:w-8/12 md:w-2/3">
          <Input
            label="Amount"
            // error="Payment Key is required"
            variant="outline"
            className="mb-5"
            name="amount"
            value={formValues.amount}
            onChange={handleChange}
          />

          <Input
            label="Coin"
            // error="Payment Key is required"
            variant="outline"
            className="mb-5"
            name="coin"
            value={formValues.coin}
            onChange={handleChange}
          />

          <div className="mb-4 text-end">
            <Button loading={loading} disabled={loading} onClick={saveSettings}>
              Save
            </Button>
          </div>
        </Card>
      </div>

      <div className="my-5 flex flex-wrap border-b border-dashed border-border-base pb-8 sm:my-8">
        <Description
          title="Coin To Amount"
          details="Coin to Amount conversion"
          className="w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pe-4 md:w-1/3 md:pe-5"
        />

        <Card className="w-full sm:w-8/12 md:w-2/3">
          <Input
            label="Coin"
            // error="Payment Key is required"
            variant="outline"
            className="mb-5"
            name="coin"
            value={formValues2.coin}
            onChange={handleChange2}
          />

          <Input
            label="Amount"
            // error="Payment Key is required"
            variant="outline"
            className="mb-5"
            name="amount"
            value={formValues.amount}
            onChange={handleChange2}
          />

          <div className="mb-4 text-end">
            <Button
              loading={loading}
              disabled={loading}
              onClick={saveSettings2}
            >
              Save
            </Button>
          </div>
        </Card>
      </div>
    </>
  );
}
