import Button from '@/components/ui/button';
import { useEffect, useState } from 'react';
import Description from '../ui/description';
import Card from '../common/card';
import Input from '../ui/input';
import axios from 'axios';
import Cookies from 'js-cookie';

// TODO: Split Settings
export default function PaymentForm() {
  const [loading, setLoading] = useState(false);
  const [formValues, setFormValues] = useState({
    esewa: '',
    khalti: '',
    phonepay: '',
  });

  const handleChange = (e) => {
    setFormValues({ ...formValues, [e.target.name]: e.target.value });
  };

  const saveSettings = (e) => {
    e.preventDefault();
    const AUTH_TOKEN_KEY =
      process.env.NEXT_PUBLIC_AUTH_TOKEN_KEY ?? 'authToken';
    const cookies = Cookies.get(AUTH_TOKEN_KEY);
    let token = '';
    if (cookies) {
      token = JSON.parse(cookies)['token'];
    }

    setLoading(true);
    axios({
      method: 'PUT',
      url: `${process.env.NEXT_PUBLIC_REST_API_ENDPOINT}/payment-gateway-keys/1`,
      data: formValues,
      headers: {
        Authorization: `Bearer ${token}`,
      },
    })
      .then((res) => {
        alert('Updated');
        setLoading(false);
      })
      .catch((e) => {
        alert('Error');
        setLoading(false);
      });
  };

  useEffect(() => {
    axios({
      method: 'GET',
      url: `${process.env.NEXT_PUBLIC_REST_API_ENDPOINT}/payment-gateway-keys`,
    })
      .then((res) => {
        console.log('Payment gateway', res.data.data);
        setFormValues({ ...res.data.data });
      })
      .catch((e) => {
        console.log(e.message);
      });
  }, []);

  return (
    <form onSubmit={saveSettings}>
      <div className="my-5 flex flex-wrap border-b border-dashed border-border-base pb-8 sm:my-8">
        <Description
          title="Payment Keys"
          details="Manage your payment keys"
          className="w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pe-4 md:w-1/3 md:pe-5"
        />

        <Card className="w-full sm:w-8/12 md:w-2/3">
          <Input
            label="Esewa"
            // error="Payment Key is required"
            variant="outline"
            className="mb-5"
            name="esewa"
            value={formValues.esewa}
            onChange={handleChange}
          />

          <Input
            label="Khalti"
            // error="Payment Key is required"
            variant="outline"
            className="mb-5"
            name="khalti"
            value={formValues.khalti}
            onChange={handleChange}
          />

          <Input
            label="Phonepay"
            // error="Payment Key is required"
            variant="outline"
            className="mb-5"
            name="phonepay"
            value={formValues.phonepay}
            onChange={handleChange}
          />
        </Card>
      </div>

      <div className="mb-4 text-end">
        <Button loading={loading} disabled={loading}>
          Save Settings
        </Button>
      </div>
    </form>
  );
}
