import SelectInput from '@/components/ui/select-input';
import Label from '@/components/ui/label';
import { Control, useFormState, useWatch } from 'react-hook-form';
import { useEffect } from 'react';
import { useTranslation } from 'next-i18next';
import { useCategoriesQuery } from '@/data/category';
import { useRouter } from 'next/router';
import { useSectionQuery } from '@/data/section';

interface Props {
  control: Control<any>;
  setValue: any;
}

const ProductSectionInput = ({ control, setValue }: Props) => {
  const { locale } = useRouter();
  const { t } = useTranslation('common');
  const type = useWatch({
    control,
    name: 'type',
  });
  const { dirtyFields } = useFormState({
    control,
  });
  useEffect(() => {
    if (type?.slug && dirtyFields?.type) {
      setValue('categories', []);
    }
  }, [type?.slug]);

  const { sections, loading } = useSectionQuery({
    limit: 999,
    type: type?.slug,
    language: locale,
  });

  return (
    <div className="mb-5">
      <Label>Section</Label>
      <SelectInput
        name="section_id"
        control={control}
        getOptionLabel={(option: any) => option.name}
        getOptionValue={(option: any) => option.id}
        // @ts-ignore
        options={sections}
        isLoading={loading}
      />
    </div>
  );
};

export default ProductSectionInput;
