import ConfirmationCard from '@/components/common/confirmation-card';
import {
  useModalAction,
  useModalState,
} from '@/components/ui/modal/modal.context';

import { useDeleteShippingAddressMutation } from '@/data/shipping-address';
import { getErrorMessage } from '@/utils/form-error';

const ShippingAddressDeleteView = () => {
  const { mutate: deleteAddress, isLoading: loading } =
    useDeleteShippingAddressMutation();
  const { data } = useModalState();
  const { closeModal } = useModalAction();

  async function handleDelete() {
    try {
      deleteAddress({ id: data });
      closeModal();
    } catch (error) {
      closeModal();
      getErrorMessage(error);
    }
  }

  return (
    <ConfirmationCard
      onCancel={closeModal}
      onDelete={handleDelete}
      deleteBtnLoading={loading}
    />
  );
};

export default ShippingAddressDeleteView;
