import Input from '@/components/ui/input';
import {
  Control,
  FieldErrors,
  useForm,
  useFormState,
  useWatch,
} from 'react-hook-form';
import Button from '@/components/ui/button';
import TextArea from '@/components/ui/text-area';
import Label from '@/components/ui/label';
import Card from '@/components/common/card';
import Description from '@/components/ui/description';
import * as categoriesIcon from '@/components/icons/category';
import { getIcon } from '@/utils/get-icon';
import { useRouter } from 'next/router';
import ValidationError from '@/components/ui/form-validation-error';
import { useEffect } from 'react';
import { AttachmentInput, Carousel, ShippingAddress } from '@/types';
import { carouselIcons } from './carousel-icons';
import { useTranslation } from 'next-i18next';
import FileInput from '@/components/ui/file-input';
import SelectInput from '@/components/ui/select-input';
import { yupResolver } from '@hookform/resolvers/yup';
import { shippingAddressValidationSchema } from './shipping-address-validation-schema';
import {
  useCarouselsQuery,
  useCreateCarouselMutation,
  useUpdateCarouselMutation,
} from '@/data/carousel';
import {
  useCreateShippingAddressMutation,
  useUpdateShippingAddressMutation,
} from '@/data/shipping-address';

export const updatedIcons = carouselIcons.map((item: any) => {
  item.label = (
    <div className="flex items-center space-s-5">
      <span className="flex h-5 w-5 items-center justify-center">
        {getIcon({
          iconList: categoriesIcon,
          iconName: item.value,
          className: 'max-h-full max-w-full',
        })}
      </span>
      <span>{item.label}</span>
    </div>
  );
  return item;
});

type FormValues = {
  country: string;
  city: string;
  area: string;
  street: string;
  postal_code: string;
};

const defaultValues = {
  country: '',
  city: '',
  area: '',
  street: '',
  postal_code: '',
};

type IProps = {
  initialValues?: ShippingAddress | undefined;
};
export default function ShippingAddressForm({ initialValues }: IProps) {
  const router = useRouter();
  const { t } = useTranslation();
  const isNewTranslation = router?.query?.action === 'translate';
  const {
    register,
    handleSubmit,
    control,
    setValue,

    formState: { errors },
  } = useForm<FormValues>({
    // shouldUnregister: true,
    //@ts-ignore
    defaultValues: initialValues
      ? {
          ...initialValues,

          ...(isNewTranslation && {
            type: null,
          }),
        }
      : defaultValues,
    resolver: yupResolver(shippingAddressValidationSchema),
  });

  const { mutate: createShippingAddress, isLoading: creating } =
    useCreateShippingAddressMutation();
  const { mutate: updateShippingAddress, isLoading: updating } =
    useUpdateShippingAddressMutation();

  const onSubmit = async (values: FormValues) => {
    let { country, city, area, street, postal_code } = values;
    const input = {
      country,
      city,
      area,
      street,
      postal_code,
    };

    if (!initialValues) {
      createShippingAddress(input);
    } else {
      updateShippingAddress(
        {
          ...input,
          id: initialValues.id!,
        },
        true
      );
    }
  };

  return (
    <form onSubmit={handleSubmit(onSubmit)}>
      {/* <div className="my-5 flex flex-wrap border-b border-dashed border-border-base pb-8 sm:my-8">
        <Description
          title={t('form:input-label-image')}
          details="Upload carousel image here"
          className="w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pe-4 md:w-1/3 md:pe-5"
        />

        <Card className="w-full sm:w-8/12 md:w-2/3">
          <FileInput name="image" control={control} multiple={false} />
        </Card>
      </div> */}

      {/* <div className="my-5 flex flex-wrap border-b border-dashed border-border-base pb-8 sm:my-8">
        <Description
          title={t('form:input-label-carousel-image')}
          details={t('form:category-carousel-image-helper-text')}
          className="w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pe-4 md:w-1/3 md:pe-5"
        />

        <Card className="w-full sm:w-8/12 md:w-2/3">
          <FileInput name="image" control={control} />
        </Card>
      </div> */}

      <div className="my-5 flex flex-wrap sm:my-8">
        <Description
          title={
            initialValues ? 'Edit Shipping Address' : 'New Shipping Address'
          }
          details={`${
            initialValues
              ? 'Edit your shipping address details'
              : 'Add your shipping address details here'
          } `}
          className="w-full px-0 pb-5 sm:w-4/12 sm:py-8 sm:pe-4 md:w-1/3 md:pe-5 "
        />

        <Card className="w-full sm:w-8/12 md:w-2/3">
          <Input
            label="Country"
            {...register('country')}
            error={errors.country?.message!}
            variant="outline"
            className="mb-5"
          />

          <Input
            label="City"
            {...register('city')}
            error={errors.city?.message!}
            variant="outline"
            className="mb-5"
          />

          <Input
            label="Area"
            {...register('area')}
            error={errors.area?.message!}
            variant="outline"
            className="mb-5"
          />

          <Input
            label="Street"
            {...register('street')}
            error={errors.street?.message}
            variant="outline"
            className="mb-5"
          />

          <Input
            label="Postal Code"
            {...register('postal_code')}
            error={errors.postal_code?.message!}
            variant="outline"
            className="mb-5"
          />

          {/* <TextArea
            label={t('form:input-label-details')}
            {...register('details')}
            variant="outline"
            className="mb-5"
          />

          <div className="mb-5">
            <Label>{t('form:input-label-select-icon')}</Label>
            <SelectInput
              name="icon"
              control={control}
              options={updatedIcons}
              isClearable={true}
            />
          </div> */}
        </Card>
      </div>
      <div className="mb-4 text-end">
        {initialValues && (
          <Button
            variant="outline"
            onClick={router.back}
            className="me-4"
            type="button"
          >
            {t('form:button-label-back')}
          </Button>
        )}

        <Button loading={creating || updating}>
          {initialValues ? 'Save Address' : 'Create Address'}
        </Button>
      </div>
    </form>
  );
}
