import Pagination from '@/components/ui/pagination';
import Image from 'next/image';
import { Table } from '@/components/ui/table';
import { siteSettings } from '@/settings/site.settings';
import usePrice from '@/utils/use-price';
import Badge from '@/components/ui/badge/badge';
import { Router, useRouter } from 'next/router';
import { useTranslation } from 'next-i18next';
import {
  SixAdBanner,
  MappedPaginatorInfo,
  ProductType,
  Shop,
  SortOrder,
  Address,
  ShippingAddress,
} from '@/types';
import { useIsRTL } from '@/utils/locals';
import { useState } from 'react';
import TitleWithSort from '@/components/ui/title-with-sort';
import { Routes } from '@/config/routes';
import LanguageSwitcher from '@/components/ui/lang-action/action';

export type IProps = {
  addresses: ShippingAddress[] | undefined;
  paginatorInfo: MappedPaginatorInfo | null;
  onPagination: (current: number) => void;
  onSort: (current: any) => void;
  onOrder: (current: string) => void;
};

type SortingObjType = {
  sort: SortOrder;
  column: string | null;
};

const ShippingAddressList = ({
  addresses,
  paginatorInfo,
  onPagination,
  onSort,
  onOrder,
}: IProps) => {
  // const { data, paginatorInfo } = carousels! ?? {};
  const router = useRouter();
  const { t } = useTranslation();
  const { alignLeft, alignRight } = useIsRTL();

  const [sortingObj, setSortingObj] = useState<SortingObjType>({
    sort: SortOrder.Desc,
    column: null,
  });

  const onHeaderClick = (column: string | null) => ({
    onClick: () => {
      onSort((currentSortDirection: SortOrder) =>
        currentSortDirection === SortOrder.Desc ? SortOrder.Asc : SortOrder.Desc
      );
      onOrder(column!);

      setSortingObj({
        sort:
          sortingObj.sort === SortOrder.Desc ? SortOrder.Asc : SortOrder.Desc,
        column: column,
      });
    },
  });

  let columns = [
    // {
    //   title: t('table:table-item-image'),
    //   dataIndex: 'image',
    //   key: 'image',
    //   align: alignLeft,
    //   width: 74,
    //   render: (image: any, { name }: { name: string }) => (
    //     <Image
    //       src={image ?? siteSettings.product.placeholder}
    //       alt={name}
    //       layout="fixed"
    //       width={42}
    //       height={42}
    //       className="overflow-hidden rounded"
    //     />
    //   ),
    // },
    {
      title: (
        <TitleWithSort
          title="Country"
          ascending={
            sortingObj.sort === SortOrder.Asc && sortingObj.column === 'country'
          }
          isActive={sortingObj.column === 'country'}
        />
      ),
      className: 'cursor-pointer',
      dataIndex: 'country',
      key: 'country',
      align: alignLeft,
      width: 300,
      ellipsis: true,
      onHeaderCell: () => onHeaderClick('country'),
    },
    {
      title: (
        <TitleWithSort
          title="City"
          ascending={
            sortingObj.sort === SortOrder.Asc && sortingObj.column === 'city'
          }
          isActive={sortingObj.column === 'city'}
        />
      ),
      className: 'cursor-pointer',
      dataIndex: 'city',
      key: 'city',
      align: alignLeft,
      width: 300,
      ellipsis: true,
      onHeaderCell: () => onHeaderClick('city'),
    },
    {
      title: (
        <TitleWithSort
          title="Area"
          ascending={
            sortingObj.sort === SortOrder.Asc && sortingObj.column === 'area'
          }
          isActive={sortingObj.column === 'area'}
        />
      ),
      className: 'cursor-pointer',
      dataIndex: 'area',
      key: 'area',
      align: alignLeft,
      width: 300,
      ellipsis: true,
      onHeaderCell: () => onHeaderClick('area'),
    },
    {
      title: (
        <TitleWithSort
          title="Street"
          ascending={
            sortingObj.sort === SortOrder.Asc && sortingObj.column === 'street'
          }
          isActive={sortingObj.column === 'street'}
        />
      ),
      className: 'cursor-pointer',
      dataIndex: 'street',
      key: 'street',
      align: alignLeft,
      width: 300,
      ellipsis: true,
      onHeaderCell: () => onHeaderClick('street'),
    },

    {
      title: (
        <TitleWithSort
          title="Postal Code"
          ascending={
            sortingObj.sort === SortOrder.Asc &&
            sortingObj.column === 'postal_code'
          }
          isActive={sortingObj.column === 'postal_code'}
        />
      ),
      className: 'cursor-pointer',
      dataIndex: 'postal_code',
      key: 'postal_code',
      align: alignLeft,
      width: 300,
      ellipsis: true,
      onHeaderCell: () => onHeaderClick('postal_code'),
    },

    {
      title: t('table:table-item-actions'),
      dataIndex: 'id',
      key: 'actions',
      align: 'right',
      width: 120,
      render: (id: number, record: ShippingAddress) => (
        <LanguageSwitcher
          slug={id}
          record={record}
          deleteModalView="DELETE_SHIPPING_ADDRESS"
          routes={Routes['shipping-address']}
        />
      ),
    },
  ];

  if (router?.query?.shop) {
    columns = columns?.filter((column) => column?.key !== 'shop');
  }

  return (
    <>
      <div className="mb-6 overflow-hidden rounded shadow">
        <Table
          /* @ts-ignore */
          columns={columns}
          emptyText={t('table:empty-table-data')}
          data={addresses}
          rowKey="id"
          scroll={{ x: 900 }}
        />
      </div>

      {!!paginatorInfo?.total && (
        <div className="flex items-center justify-end">
          <Pagination
            total={paginatorInfo.total}
            current={paginatorInfo.currentPage}
            pageSize={paginatorInfo.perPage}
            onChange={onPagination}
            showLessItems
          />
        </div>
      )}
    </>
  );
};

export default ShippingAddressList;
