import {
  Banner,
  CreateBanner,
  BannerPaginator,
  QueryOptions,
  GetParams,
  BannerQueryOptions,
} from '@/types';
import { API_ENDPOINTS } from './api-endpoints';
import { crudFactory } from './curd-factory';
import { HttpClient } from './http-client';

export const bannerClient = {
  ...crudFactory<Banner, QueryOptions, CreateBanner>(API_ENDPOINTS.BANNERS),
  get({ slug, language }: GetParams) {
    return HttpClient.get<Banner>(`${API_ENDPOINTS.BANNERS}/${slug}`, {
      language,
      with: 'type;shop;categories;tags;variations.attribute.values;variation_options;author;manufacturer;digital_file',
    });
  },
  paginated: ({ ...params }: Partial<BannerQueryOptions>) => {
    return HttpClient.get<BannerPaginator>(API_ENDPOINTS.BANNERS, {
      searchJoin: 'and',
      with: 'shop;type',
      ...params,
    });
  },
  popular({ ...params }: Partial<BannerQueryOptions>) {
    return HttpClient.get<Banner[]>(API_ENDPOINTS.POPULAR_PRODUCTS, {
      searchJoin: 'and',
      with: 'type;shop',
      ...params,
    });
  },
};
